  global AskWindows
  set n [Unique]
  set win .ask$n
  set AskWindows [linsert $AskWindows 0 $win]

  LinkWindow $head.ask $win
  LinkWindow $win.head $head

  catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  wm title $win {SimCity Query}
  wm iconname $win {SimCity Query}
  wm geometry $win 350x200+5+5
  wm positionfrom $win user
  wm sizefrom $win user
  wm maxsize $win 1000 1000
  wm minsize $win 100 100
  wm protocol $win delete "DeleteWindow ask AskWindows"

  frame $win.top \
    -relief raised \
    -borderwidth 2
  LinkWindow $win.background $win.top

  label $win.top.title \
    -borderwidth 4 \
    -relief raised \
    -font [Font $win Big]
  LinkWindow $win.title $win.top.title

  text $win.top.text \
    -borderwidth 4 \
    -relief flat \
    -wrap word \
    -state disabled \
    -font [Font $win Big]
  LinkWindow $win.text $win.top.text

  frame $win.top.frame \
    -borderwidth 4 \
    -relief flat
  LinkWindow $win.frame $win.top.frame

  button $win.top.frame.left \
    -font [Font $win Large]\
    -borderwidth 2\
    -padx 6 -pady 12
  LinkWindow $win.left $win.top.frame.left

  button $win.top.frame.middle \
    -font [Font $win Large]\
    -borderwidth 2\
    -padx 6 -pady 12
  LinkWindow $win.middle $win.top.frame.middle

  frame $win.top.frame.rightframe \
    -borderwidth 0 \
    -relief raised
  LinkWindow $win.voteframe $win.top.frame.rightframe

  button $win.top.frame.rightframe.right \
    -font [Font $win Large]\
    -relief raised \
    -borderwidth 2
  LinkWindow $win.vote $win.top.frame.rightframe.right

  pack append $win.top.frame.rightframe\
    $win.top.frame.rightframe.right	{top frame center}

  BindVotingButton $win $win.top.frame.rightframe.right Ask

  pack append $win.top\
    $win.top.title	{top frame center fillx} \
    $win.top.text	{top frame center expand fill} \
    $win.top.frame	{bottom frame center fillx}

  pack append $win\
    $win.top		{left frame center expand fill}

  update idletasks
  return $win
