/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.project;

import com.sun.wbem.solarisprovider.project.ProjectException;
import com.sun.wbem.solarisprovider.project.ProjectObj;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisProjectTable {
    private String table = new String("project");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String nameCol = "name";
    private String idCol = "id";
    private String commentCol = "comment";
    private String userCol = "user";
    private String groupCol = "group";
    private String attributeCol = "keyvalue";
    private String scope;
    public final String DEFAULT_PROJECT_NAME = "default";
    public final String STAFF_PROJECT_NAME = "group.staff";
    public static final String USER_DEF_PROJ_PREFIX = "user.";
    public static final String GROUP_DEF_PROJ_PREFIX = "group.";

    public SolarisProjectTable(String string) {
        this.scope = string;
    }

    public static String[] parseMembersIntoArray(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String formatMembersIntoString(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String formatAttributesIntoString(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(";");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean isProjectMember(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2 == "") {
            return false;
        }
        String[] stringArray = SolarisProjectTable.parseMembersIntoArray(string2, ",");
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private DirectoryTable openProjectTable() throws DirectoryTableException {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(this.table);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw directoryTableInvalidParameterException;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw directoryTableDoesNotExistException;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw directoryTableConnectionException;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProjectObj getProjectRow(ProjectObj projectObj) throws DirectoryTableException, ProjectException {
        DirectoryTable directoryTable = null;
        directoryTable = this.openProjectTable();
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), projectObj.getProjectName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new ProjectException("EXM_PRJ20", projectObj.getProjectName());
                }
                projectObj.setProjectUsers(SolarisProjectTable.parseMembersIntoArray(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.userCol)), ","));
                projectObj.setProjectGroups(SolarisProjectTable.parseMembersIntoArray(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.groupCol)), ","));
                projectObj.setProjectAttributes(SolarisProjectTable.parseMembersIntoArray(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.attributeCol)), ";"));
                projectObj.setProjectID(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.idCol)));
                projectObj.setProjectDescription(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.commentCol)));
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                Object var10_9 = null;
                if (directoryTable == null) return projectObj;
                directoryTable.close();
                return projectObj;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                Object var10_10 = null;
                if (directoryTable == null) return projectObj;
                directoryTable.close();
                return projectObj;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (ProjectException projectException) {
                throw projectException;
            }
            catch (Exception exception) {
                Object var10_11 = null;
                if (directoryTable == null) return projectObj;
                directoryTable.close();
                return projectObj;
            }
            Object var10_8 = null;
            if (directoryTable == null) return projectObj;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return projectObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addProjectRow(ProjectObj projectObj) throws DirectoryTableException, ProjectException {
        DirectoryTable directoryTable = null;
        directoryTable = this.openProjectTable();
        try {
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                if (projectObj.getProjectName() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), projectObj.getProjectName());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                }
                if (directoryRow != null) {
                    throw new ProjectException("EXM_PRJ21", projectObj.getProjectName());
                }
                directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                if (projectObj.getProjectID() != null) {
                    this.validateAddProject(projectObj);
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.idCol), projectObj.getProjectID());
                    directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                }
                if (projectObj.getProjectName() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), projectObj.getProjectName());
                }
                if (projectObj.getProjectID() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.idCol), projectObj.getProjectID());
                }
                if (projectObj.getProjectDescription() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.commentCol), projectObj.getProjectDescription());
                }
                if (projectObj.getProjectAttributes() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.attributeCol), SolarisProjectTable.formatAttributesIntoString(projectObj.getProjectAttributes()));
                }
                if (projectObj.getProjectUsers() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.userCol), SolarisProjectTable.formatMembersIntoString(projectObj.getProjectUsers()));
                }
                if (projectObj.getProjectGroups() != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(this.groupCol), SolarisProjectTable.formatMembersIntoString(projectObj.getProjectGroups()));
                }
                directoryTable.addRow(directoryRow);
            }
            catch (ProjectException projectException) {
                throw projectException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                Object var10_9 = null;
                if (directoryTable == null) return;
                directoryTable.close();
                return;
            }
            Object var10_8 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyProjectRow(ProjectObj projectObj) throws DirectoryTableException, ProjectException {
        DirectoryTable directoryTable;
        block29: {
            block28: {
                directoryTable = null;
                directoryTable = this.openProjectTable();
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        if (projectObj.getProjectName() != null) {
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), projectObj.getProjectName());
                            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                            if (directoryRow == null) {
                                this.addProjectRow(projectObj);
                                Object var10_8 = null;
                                if (directoryTable == null) return;
                                break block28;
                            }
                        }
                        if (projectObj.getProjectName().equals("default")) {
                            if (!projectObj.getProjectID().equals("3")) {
                                throw new ProjectException("EXM_PRJ26");
                            }
                            if (projectObj.getProjectUsers() != null) throw new ProjectException("EXM_PRJ27");
                            if (projectObj.getProjectGroups() != null) throw new ProjectException("EXM_PRJ27");
                            if (projectObj.getProjectDescription() != null) throw new ProjectException("EXM_PRJ27");
                            if (projectObj.getProjectAttributes() != null) {
                                throw new ProjectException("EXM_PRJ27");
                            }
                        }
                        DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol));
                        if (!string.equals(projectObj.getProjectName()) && projectObj.getProjectName() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), projectObj.getProjectName());
                            directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow2);
                            if (directoryRow2 != null) {
                                throw new ProjectException("EXM_PRJ20", projectObj.getProjectName());
                            }
                            directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        }
                        if (projectObj.getProjectID() != null) {
                            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.idCol), projectObj.getProjectID());
                        }
                        if (projectObj.getProjectUsers() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.userCol), SolarisProjectTable.formatMembersIntoString(projectObj.getProjectUsers()));
                        }
                        if (projectObj.getProjectGroups() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.groupCol), SolarisProjectTable.formatMembersIntoString(projectObj.getProjectGroups()));
                        }
                        if (projectObj.getProjectName() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.nameCol), projectObj.getProjectName());
                        }
                        if (projectObj.getProjectDescription() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.commentCol), projectObj.getProjectDescription());
                        }
                        if (projectObj.getProjectID() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.idCol), projectObj.getProjectID());
                        }
                        if (projectObj.getProjectAttributes() != null) {
                            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.attributeCol), SolarisProjectTable.formatAttributesIntoString(projectObj.getProjectAttributes()));
                        }
                        directoryTable.modifyRow(directoryRow, directoryRow2);
                        break block29;
                    }
                    catch (ProjectException projectException) {
                        throw projectException;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                    catch (Exception exception) {
                        Object var10_10 = null;
                        if (directoryTable == null) return;
                        directoryTable.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var10_9 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteProjectRow(ProjectObj projectObj) throws DirectoryTableException, Exception {
        DirectoryTable directoryTable;
        block13: {
            block12: {
                directoryTable = null;
                directoryTable = this.openProjectTable();
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                        directoryRow.putColumn(tableDefinitions.getColumnNumber(this.nameCol), projectObj.getProjectName());
                        directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                        if (directoryRow == null) {
                            Object var9_8 = null;
                            if (directoryTable == null) return;
                            break block12;
                        }
                        directoryTable.deleteRow(directoryRow);
                        break block13;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var9_9 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllProjectRows() throws DirectoryTableException {
        DirectoryTable directoryTable;
        Vector<ProjectObj> vector;
        block13: {
            Vector<ProjectObj> vector2;
            block12: {
                vector = new Vector<ProjectObj>();
                directoryTable = null;
                directoryTable = this.openProjectTable();
                try {
                    try {
                        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                        DirectoryRow directoryRow = directoryTable.getAll();
                        if (directoryRow == null) {
                            vector2 = vector;
                            Object var9_11 = null;
                            if (directoryTable == null) return vector2;
                            break block12;
                        }
                        int n = 1;
                        while (n <= directoryRow.getNumberOfRows()) {
                            ProjectObj projectObj = new ProjectObj(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol), n));
                            projectObj.setProjectName(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.nameCol), n));
                            projectObj.setProjectID(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.idCol), n));
                            projectObj.setProjectDescription(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.commentCol), n));
                            projectObj.setProjectUsers(SolarisProjectTable.parseMembersIntoArray(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.userCol), n), ","));
                            projectObj.setProjectGroups(SolarisProjectTable.parseMembersIntoArray(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.groupCol), n), ","));
                            projectObj.setProjectAttributes(SolarisProjectTable.parseMembersIntoArray(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.attributeCol), n), ";"));
                            vector.addElement(projectObj);
                            ++n;
                        }
                        break block13;
                    }
                    catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                        throw directoryTableInvalidParameterException;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        throw directoryTableAccessException;
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        throw directoryTableConnectionException;
                    }
                    catch (DirectoryTableException directoryTableException) {
                        throw directoryTableException;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return vector2;
        }
        Object var9_12 = null;
        if (directoryTable == null) return vector;
        directoryTable.close();
        return vector;
    }

    private boolean isDuplicateID(String string) {
        boolean bl = false;
        try {
            Vector vector = this.getAllProjectRows();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (!string.equalsIgnoreCase(((ProjectObj)enumeration.nextElement()).getProjectID())) continue;
                return true;
            }
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            return false;
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            return false;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            return false;
        }
        catch (DirectoryTableException directoryTableException) {
            return false;
        }
        return bl;
    }

    private boolean isDefaultProjectName(String string) {
        try {
            return this.isUserGroupProjectName(string) || string.equals("default");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isUserGroupProjectName(String string) {
        try {
            return string.startsWith(USER_DEF_PROJ_PREFIX) || string.startsWith(GROUP_DEF_PROJ_PREFIX);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isValidID(String string) {
        boolean bl = false;
        int n = Integer.MAX_VALUE;
        int n2 = 100;
        try {
            Integer n3 = new Integer(string);
            if (n3 >= n2 && n3 <= n) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return bl;
    }

    private void validateAddProject(ProjectObj projectObj) throws ProjectException {
        try {
            String string = projectObj.getProjectID();
            String string2 = projectObj.getProjectName();
            boolean bl = this.isUserGroupProjectName(string2);
            if (bl) {
                return;
            }
            if (string2.equals("default")) {
                if (!string.equals("3")) {
                    throw new ProjectException("EXM_PRJ26");
                }
                if (projectObj.getProjectUsers() != null || projectObj.getProjectGroups() != null || projectObj.getProjectDescription() != null || projectObj.getProjectAttributes() != null) {
                    throw new ProjectException("EXM_PRJ27");
                }
            }
            Vector vector = this.getAllProjectRows();
            ProjectObj projectObj2 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                projectObj2 = (ProjectObj)enumeration.nextElement();
                if (projectObj2 != null && string.equalsIgnoreCase(projectObj2.getProjectID())) {
                    if (!this.isDefaultProjectName(projectObj2.getProjectName())) {
                        bl2 = true;
                    }
                    bl3 = true;
                }
                if (bl2) break;
            }
            if (!this.isValidID(string)) {
                throw new ProjectException("EXM_PRJ23", string);
            }
            if (bl2) {
                throw new ProjectException("EXM_PRJ22", string);
            }
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            return;
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            return;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            return;
        }
        catch (DirectoryTableException directoryTableException) {
            return;
        }
    }
}

