/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.server;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.QuickVector;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.common.HostAuthException;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostWarningException;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.admin.hostmgr.server.HostMgr;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VPermission;
import com.sun.management.viper.VService;
import com.sun.management.viper.services.Authorization;
import com.sun.management.viper.services.Log;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class HostMgrImpl
extends VService
implements HostMgr {
    private static final String LOCAL_HOST_NAME = "localhost";
    private static final boolean EXPOSE_BAD_NETWORKS = true;
    private static final String MSGRESOURCECLASS = "com.sun.admin.hostmgr.common.resources.LogMessages";
    private int ethersColumnAddr = 0;
    private int ethersColumnName = 0;
    private int ethersColumnComment = 0;
    private int hostsColumnAddr = 0;
    private int hostsColumnCname = 0;
    private int hostsColumnAliases = 0;
    private int hostsColumnComment = 0;
    private int netmasksColumnAddr = 0;
    private int netmasksColumnMask = 0;
    private int netmasksColumnComment = 0;
    private int networksColumnCname = 0;
    private int networksColumnAddr = 0;
    private int networksColumnAliases = 0;
    private int networksColumnComment = 0;
    private DirectoryRow etherListRow = null;
    private DirectoryRow etherMatchRow = null;
    private DirectoryRow hostListRow = null;
    private int chunkSize = 0;
    private boolean isLdap = false;
    private boolean sortAscending = true;
    private int hostListLimit = 1;
    private int hostListIndex = 1;
    private int hostListIncrement = 1;
    private int etherListIndex = 1;
    private TableDefinitions ethersTableDefn = null;
    private String scope = "";
    private Log logsvc = null;
    private Authorization authsvc = null;
    private VPermission perm;
    private VIdentity userIdent;
    private String userName;
    private String clientName;
    private ResourceBundle bundle = null;
    static /* synthetic */ Class class$com$sun$management$viper$services$Log;
    static /* synthetic */ Class class$com$sun$management$viper$services$Authorization;

    public HostMgrImpl() throws RemoteException, AdminException {
        String string = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (Exception exception) {
            string = "";
        }
        this.scope = new String("File:/" + string + "/" + string);
        this.bundle = ResourceBundle.getBundle(MSGRESOURCECLASS, Locale.getDefault());
    }

    public void initializeScope(AdminMgmtScope adminMgmtScope) throws RemoteException, AdminException {
        DirectoryTable directoryTable = null;
        String string = "unknown";
        TableDefinitions tableDefinitions = null;
        TableDefinitions tableDefinitions2 = null;
        TableDefinitions tableDefinitions3 = null;
        TableDefinitions tableDefinitions4 = null;
        Exception exception = null;
        try {
            this.logsvc = (Log)this.inf.getServiceByName((class$com$sun$management$viper$services$Log == null ? (class$com$sun$management$viper$services$Log = HostMgrImpl.class$("com.sun.management.viper.services.Log")) : class$com$sun$management$viper$services$Log).getName());
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        this.scope = adminMgmtScope.toDirectoryTableURL();
        if ("ldap".equals(adminMgmtScope.getMgmtScopeType())) {
            this.isLdap = true;
        }
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            tableDefinitions = directoryTable.getTableDefinitionsInstance();
            string = "ethers";
            tableDefinitions.loadTableDefinitions("ethers");
            this.ethersColumnAddr = tableDefinitions.getColumnNumber("addr");
            this.ethersColumnName = tableDefinitions.getColumnNumber("name");
            this.ethersColumnComment = tableDefinitions.getColumnNumber("comment");
            tableDefinitions2 = directoryTable.getTableDefinitionsInstance();
            string = "hosts";
            tableDefinitions2.loadTableDefinitions("hosts");
            this.hostsColumnAddr = tableDefinitions2.getColumnNumber("addr");
            this.hostsColumnCname = tableDefinitions2.getColumnNumber("cname");
            if (!this.isLdap) {
                this.hostsColumnAliases = tableDefinitions2.getColumnNumber("aliases");
            }
            this.hostsColumnComment = tableDefinitions2.getColumnNumber("comment");
            tableDefinitions3 = directoryTable.getTableDefinitionsInstance();
            string = "netmasks";
            tableDefinitions3.loadTableDefinitions("netmasks");
            this.netmasksColumnAddr = tableDefinitions3.getColumnNumber("addr");
            this.netmasksColumnMask = tableDefinitions3.getColumnNumber("mask");
            this.netmasksColumnComment = tableDefinitions3.getColumnNumber("comment");
            tableDefinitions4 = directoryTable.getTableDefinitionsInstance();
            string = "networks";
            tableDefinitions4.loadTableDefinitions("networks");
            this.networksColumnCname = tableDefinitions4.getColumnNumber("cname");
            this.networksColumnAddr = tableDefinitions4.getColumnNumber("addr");
            this.networksColumnAliases = tableDefinitions4.getColumnNumber("aliases");
            this.networksColumnComment = tableDefinitions4.getColumnNumber("comment");
        }
        catch (DirectoryTableAccessException directoryTableAccessException) {
            this.logDirTableException("LM_3202", string, (Exception)((Object)directoryTableAccessException));
            HostException hostException = new HostException("EXM_HST_SRV30");
            throw new HostException("EXM_HST_SRV28", (Exception)((Object)hostException));
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            this.logDirTableException("LM_3203", string, (Exception)((Object)directoryTableConnectionException));
            HostException hostException = new HostException("EXM_HST_SRV31");
            throw new HostException("EXM_HST_SRV28", (Exception)((Object)hostException));
        }
        catch (DirectoryTableException directoryTableException) {
            this.logDirTableException("LM_3011", string, (Exception)((Object)directoryTableException));
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV28", (Exception)((Object)hostException));
        }
        if (exception != null) {
            throw new HostWarningException("EXM_HST_LOGSVC_ERR", exception.getLocalizedMessage());
        }
        try {
            this.writeLog(100, "LM_3010", "LM_3010", null, null);
        }
        catch (Exception exception3) {
            throw new HostWarningException("EXM_HST_WRITELOG_ERR", exception3.getLocalizedMessage());
        }
    }

    private void writeLog(int n, String string, String string2, String[] stringArray, String string3) throws AdminException {
        if (this.logsvc == null) {
            return;
        }
        this.userIdent = this.inf.getIdentity();
        this.userName = this.userIdent.getName();
        this.clientName = this.userIdent.getAuthenHost();
        if (this.clientName.equalsIgnoreCase(LOCAL_HOST_NAME)) {
            try {
                this.clientName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        int n2 = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = new String[2 + n2];
        stringArray2[0] = this.userName;
        stringArray2[1] = this.clientName;
        int n3 = 0;
        while (n3 < n2) {
            stringArray2[2 + n3] = stringArray[n3];
            ++n3;
        }
        try {
            this.logsvc.writeLog("SOURCE", "application", n, string, string2, stringArray2, MSGRESOURCECLASS, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logDirTableException(String string, String string2, Exception exception) throws AdminException {
        String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DirTableErrorData");
        Object[] objectArray = new Object[]{this.scope, string2, exception.getLocalizedMessage()};
        String string4 = MessageFormat.format(string3, objectArray);
        this.writeLog(400, "LM_3200", string, null, string4);
    }

    private void logException(String string, String string2, Exception exception) throws AdminException {
        String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"MethodErrorData");
        Object[] objectArray = new Object[]{string2, exception.getLocalizedMessage()};
        String string4 = MessageFormat.format(string3, objectArray);
        this.writeLog(400, "LM_3201", string, null, string4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkData getNetwork(NetworkData networkData) throws HostAuthException, RemoteException, AdminException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        NetworkData networkData2 = null;
        String string = "";
        if (networkData.isNetwork()) {
            string = this.getNetmask(networkData);
        }
        if (networkData.getNetworkName().length() == 0) {
            if (string.length() <= 0) return networkData2;
            networkData2 = new NetworkData(networkData.getNetworkAddress());
            networkData2.setNetmask(string);
            return networkData2;
        }
        try {
            block15: {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    String string2 = networkData.convertLongToAddress(networkData.getNetworkAddressLong());
                    directoryFilter.add(this.networksColumnAddr, 1, 5, string2);
                    directoryFilter.add(this.networksColumnAddr, 3, 3, string2 + ".");
                    DirectoryRow directoryRow = directoryTable.getAll((SearchTemplate)directoryFilter);
                    if (directoryRow == null) break block15;
                    int n = 1;
                    while (n <= directoryRow.getNumberOfRows()) {
                        block16: {
                            try {
                                NetworkData.validateIPAddress(directoryRow.getColumn(this.networksColumnAddr, n));
                            }
                            catch (Exception exception) {
                                break block16;
                            }
                            if (networkData.getNetworkName().equals(directoryRow.getColumn(this.networksColumnCname, n)) && networkData.netAddrCompare(networkData2 = new NetworkData(directoryRow.getColumn(this.networksColumnAddr, n))) == 0) {
                                networkData2.setNetworkName(directoryRow.getColumn(this.networksColumnCname, n));
                                networkData2.setAliases(directoryRow.getColumn(this.networksColumnAliases, n));
                                networkData2.setDescription(directoryRow.getColumn(this.networksColumnComment, n));
                                networkData2.setNetmask(string);
                                break;
                            }
                        }
                        ++n;
                    }
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV42");
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    Object var17_14 = null;
                    if (directoryTable == null) return networkData2;
                    directoryTable.close();
                    return networkData2;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "networks", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "networks", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3106", "networks", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3106", "getNetwork", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
            }
            Object var17_13 = null;
            if (directoryTable == null) return networkData2;
            directoryTable.close();
            return networkData2;
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkData getNetworkByAddr(String string) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryTable directoryTable = null;
        NetworkData networkData = new NetworkData();
        try {
            block13: {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.networksColumnAddr, string);
                    DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    if (directoryRow2 == null) {
                        networkData.setNetworkAddress(string);
                        if (networkData.isNetwork()) {
                            networkData.setNetmask(this.getNetmask(networkData));
                            if (networkData.getNetmask().length() == 0) {
                                networkData = null;
                            }
                            break block13;
                        }
                        networkData = null;
                        break block13;
                    }
                    networkData.setNetworkAddress(directoryRow2.getColumn(this.networksColumnAddr));
                    networkData.setNetworkName(directoryRow2.getColumn(this.networksColumnCname));
                    networkData.setAliases(directoryRow2.getColumn(this.networksColumnAliases));
                    networkData.setDescription(directoryRow2.getColumn(this.networksColumnComment));
                    if (!networkData.isNetwork()) break block13;
                    networkData.setNetmask(this.getNetmask(networkData));
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV42");
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    Object var16_8 = null;
                    if (directoryTable == null) return networkData;
                    directoryTable.close();
                    return networkData;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "networks", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "networks", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3106", "networks", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (HostException hostException) {
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3106", "getNetworkByAddr", exception);
                    hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV1", (Exception)((Object)hostException));
                }
            }
            Object var16_7 = null;
            if (directoryTable == null) return networkData;
            directoryTable.close();
            return networkData;
        }
        catch (Throwable throwable) {
            Object var16_9 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listNetworks(ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        DirectoryRow directoryRow;
        QuickVector quickVector;
        block23: {
            this.checkRights("solaris.network.hosts.read");
            if (listProperties == null) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            if (!listProperties.hasCustomBooleanArg1BeenSet()) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            int n = 0;
            long l = 0L;
            DirectoryTable directoryTable = null;
            NetworkData networkData = null;
            quickVector = new QuickVector();
            try {
                Object var19_16;
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    directoryRow = directoryTable.getAll();
                    if (directoryRow != null) {
                        directoryRow.sortByColumn(this.networksColumnAddr, tableDefinitions);
                        n = directoryRow.getNumberOfRows();
                        networkData = new NetworkData();
                    }
                    int n2 = 1;
                    while (n2 <= n) {
                        String string = directoryRow.getColumn(this.networksColumnAddr, n2);
                        try {
                            NetworkData.validateIPAddress(string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        networkData.setNetworkAddress(string);
                        if (networkData.isNetwork() || l != networkData.getNetIdLong()) {
                            if (networkData.isNetwork()) {
                                networkData.setNetworkName(directoryRow.getColumn(this.networksColumnCname, n2));
                                networkData.setAliases(directoryRow.getColumn(this.networksColumnAliases, n2));
                                networkData.setDescription(directoryRow.getColumn(this.networksColumnComment, n2));
                                networkData.setNetmask(this.getNetmask(networkData));
                            } else {
                                networkData.setNetworkAddress(networkData.getNetId());
                            }
                            networkData.setNetmask(this.getNetmask(networkData));
                            l = networkData.getNetIdLong();
                            quickVector.addElement((Object)networkData);
                            networkData = new NetworkData();
                        }
                        ++n2;
                    }
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    var19_16 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    break block23;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "networks", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "networks", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3107", "networks", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                catch (HostException hostException) {
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3107", "listNetworks", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV2", (Exception)((Object)hostException));
                }
                var19_16 = null;
                if (directoryTable == null) break block23;
            }
            catch (Throwable throwable) {
                Object var19_17 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        directoryRow = null;
        if (listProperties.getCustomBooleanArg1()) {
            this.listHostNetworks(quickVector);
        }
        this.listNetmaskNetworks(quickVector);
        if (!listProperties.isSortOrderAscending()) {
            int n = quickVector.size() / 2;
            int n3 = 0;
            while (n3 < n) {
                quickVector.quickSwapElementsAt(n3, quickVector.size() - n3 - 1);
                ++n3;
            }
        }
        return quickVector;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listHostNetworks(QuickVector var1_1) throws RemoteException, AdminException, HostAuthException {
        block21: {
            block20: {
                this.checkRights("solaris.network.hosts.read");
                var4_2 = 0;
                var7_3 = null;
                try {
                    try {
                        var7_3 = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        var11_4 = var7_3.getTableDefinitionsInstance();
                        var11_4.loadTableDefinitions("hosts");
                        var7_3.open(var11_4);
                        var6_5 = var7_3.getAll();
                        if (var6_5 == null) {
                            var19_6 = null;
                            if (var7_3 == null) return;
                            break block20;
                        }
                        var10_10 = var1_1.size() > 0 ? (NetworkData)var1_1.quickElementAt(0) : new NetworkData("255");
                        var12_11 = 1;
                        block11: while (var12_11 <= var6_5.getNumberOfRows()) {
                            block22: {
                                try {
                                    NetworkData.validateIPAddress(var6_5.getColumn(this.hostsColumnAddr, var12_11));
                                }
                                catch (Exception var13_17) {
                                    ** GOTO lbl41
                                }
                                var9_16 = new NetworkData(var6_5.getColumn(this.hostsColumnAddr, var12_11));
                                if (var9_16.netIdCompare(var10_10) == 0) ** GOTO lbl41
                                var4_2 = 0;
                                if (var4_2 >= var1_1.size()) break block22;
                                var3_14 = false;
                                var2_13 = false;
                                var10_10 = (NetworkData)var1_1.quickElementAt(var4_2);
                                if (true) ** GOTO lbl95
                            }
                            var2_13 = true;
lbl34:
                            // 2 sources

                            while (true) {
                                if (var2_13) {
                                    if (!var9_16.isNetwork()) {
                                        var9_16.setNetworkAddress(var9_16.getNetId());
                                    }
                                    var9_16.setNetmask(this.getNetmask(var9_16));
                                    var1_1.insertElementAt((Object)var9_16, var4_2);
                                    var10_10 = var9_16;
                                }
lbl41:
                                // 5 sources

                                ++var12_11;
                                continue block11;
                                break;
                            }
                        }
                        break block21;
                    }
                    catch (DirectoryTableDoesNotExistException var12_12) {
                        var19_8 = null;
                        if (var7_3 == null) return;
                        var7_3.close();
                        return;
                    }
                    catch (DirectoryTableAccessException var13_18) {
                        this.logDirTableException("LM_3202", "hosts", (Exception)var13_18);
                        var8_19 = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_19);
                    }
                    catch (DirectoryTableConnectionException var14_23) {
                        this.logDirTableException("LM_3203", "hosts", (Exception)var14_23);
                        var8_20 = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_20);
                    }
                    catch (DirectoryTableException var15_24) {
                        this.logDirTableException("LM_3107", "hosts", (Exception)var15_24);
                        var8_21 = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_21);
                    }
                    catch (HostException var16_25) {
                        throw new HostException("EXM_HST_SRV2", (Exception)var16_25);
                    }
                    catch (Exception var17_26) {
                        this.logException("LM_3107", "listHostNetworks", var17_26);
                        var8_22 = new HostException("EXM_HST_SRV99", var17_26);
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_22);
                    }
                }
                catch (Throwable var18_27) {
                    var19_9 = null;
                    if (var7_3 == null) throw var18_27;
                    var7_3.close();
                    throw var18_27;
                }
            }
            var7_3.close();
            return;
        }
        var19_7 = null;
        if (var7_3 == null) return;
        var7_3.close();
        return;
        do {
            if ((var5_15 = var9_16.netIdCompare(var10_10)) == 0) {
                var3_14 = true;
                continue;
            }
            if (var5_15 > 0) {
                if (++var4_2 < var1_1.size()) {
                    var10_10 = (NetworkData)var1_1.quickElementAt(var4_2);
                    continue;
                }
                var2_13 = true;
                var3_14 = true;
                continue;
            }
            var2_13 = true;
            var3_14 = true;
lbl95:
            // 5 sources

        } while (!var3_14);
        ** while (true)
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listNetmaskNetworks(QuickVector var1_1) throws RemoteException, AdminException, HostAuthException {
        block21: {
            block20: {
                this.checkRights("solaris.network.hosts.read");
                var4_2 = 0;
                var7_3 = null;
                try {
                    try {
                        var7_3 = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        var11_4 = var7_3.getTableDefinitionsInstance();
                        var11_4.loadTableDefinitions("netmasks");
                        var7_3.open(var11_4);
                        var6_5 = var7_3.getAll();
                        if (var6_5 == null) {
                            var19_6 = null;
                            if (var7_3 == null) return;
                            break block20;
                        }
                        var6_5.sortByColumn(this.netmasksColumnAddr, var11_4);
                        var10_10 = var1_1.size() > 0 ? (NetworkData)var1_1.quickElementAt(0) : new NetworkData("255");
                        var12_11 = 1;
                        block11: while (var12_11 <= var6_5.getNumberOfRows()) {
                            block22: {
                                try {
                                    NetworkData.validateIPAddress(var6_5.getColumn(this.netmasksColumnAddr, var12_11));
                                }
                                catch (Exception var13_17) {
                                    ** GOTO lbl39
                                }
                                var9_16 = new NetworkData(var6_5.getColumn(this.netmasksColumnAddr, var12_11));
                                if (var4_2 >= var1_1.size()) break block22;
                                var3_14 = false;
                                var2_13 = false;
                                if (true) ** GOTO lbl93
                            }
                            var2_13 = true;
lbl32:
                            // 2 sources

                            while (true) {
                                if (var2_13) {
                                    if (!var9_16.isNetwork()) {
                                        var9_16.setNetworkAddress(var9_16.getNetId());
                                    }
                                    var9_16.setNetmask(this.getNetmask(var9_16));
                                    var1_1.insertElementAt((Object)var9_16, var4_2);
                                    var10_10 = var9_16;
                                }
lbl39:
                                // 4 sources

                                ++var12_11;
                                continue block11;
                                break;
                            }
                        }
                        break block21;
                    }
                    catch (DirectoryTableDoesNotExistException var12_12) {
                        var19_8 = null;
                        if (var7_3 == null) return;
                        var7_3.close();
                        return;
                    }
                    catch (DirectoryTableAccessException var13_18) {
                        this.logDirTableException("LM_3202", "netmasks", (Exception)var13_18);
                        var8_19 = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_19);
                    }
                    catch (DirectoryTableConnectionException var14_23) {
                        this.logDirTableException("LM_3203", "netmasks", (Exception)var14_23);
                        var8_20 = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_20);
                    }
                    catch (DirectoryTableException var15_24) {
                        this.logDirTableException("LM_3107", "netmasks", (Exception)var15_24);
                        var8_21 = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_21);
                    }
                    catch (HostException var16_25) {
                        throw new HostException("EXM_HST_SRV2", (Exception)var16_25);
                    }
                    catch (Exception var17_26) {
                        this.logException("LM_3107", "listNetmaskNetworks", var17_26);
                        var8_22 = new HostException("EXM_HST_SRV99", var17_26);
                        throw new HostException("EXM_HST_SRV2", (Exception)var8_22);
                    }
                }
                catch (Throwable var18_27) {
                    var19_9 = null;
                    if (var7_3 == null) throw var18_27;
                    var7_3.close();
                    throw var18_27;
                }
            }
            var7_3.close();
            return;
        }
        var19_7 = null;
        if (var7_3 == null) return;
        var7_3.close();
        return;
        do {
            if ((var5_15 = var9_16.netIdCompare(var10_10)) == 0) {
                var3_14 = true;
                continue;
            }
            if (var5_15 > 0) {
                if (++var4_2 < var1_1.size()) {
                    var10_10 = (NetworkData)var1_1.quickElementAt(var4_2);
                    continue;
                }
                var2_13 = true;
                var3_14 = true;
                continue;
            }
            var2_13 = true;
            var3_14 = true;
lbl93:
            // 5 sources

        } while (!var3_14);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listNetworkSubnets(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        DirectoryRow directoryRow;
        QuickVector quickVector;
        block27: {
            this.checkRights("solaris.network.hosts.read");
            if (networkData == null) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            if (listProperties == null) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            if (!listProperties.hasCustomBooleanArg1BeenSet()) {
                throw new HostException("EXM_HST_SRV2", (Exception)((Object)new HostException("EXM_HST_SRV99")));
            }
            int n = 0;
            DirectoryTable directoryTable = null;
            NetworkData networkData2 = new NetworkData();
            quickVector = new QuickVector();
            String string = networkData.getNetId();
            try {
                Object var21_21;
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    directoryRow = directoryTable.getAll();
                    if (directoryRow != null) {
                        n = directoryRow.getNumberOfRows();
                    }
                    int n2 = 1;
                    while (n2 <= n) {
                        block26: {
                            String string2 = directoryRow.getColumn(this.networksColumnAddr, n2);
                            try {
                                NetworkData.validateIPAddress(string2);
                            }
                            catch (Exception exception) {
                                break block26;
                            }
                            if (string2.startsWith(string + ".")) {
                                networkData2.setNetworkAddress(string2);
                                if (!networkData2.isNetwork()) {
                                    int n3 = quickVector.size();
                                    int n4 = 0;
                                    while (n4 < quickVector.size()) {
                                        NetworkData networkData3 = (NetworkData)quickVector.quickElementAt(n4);
                                        int n5 = networkData3.netAddrCompare(networkData2);
                                        if (n5 == 0) {
                                            n3 = -1;
                                            break;
                                        }
                                        if (n5 > 0) {
                                            n3 = n4;
                                            break;
                                        }
                                        ++n4;
                                    }
                                    if (n3 >= 0) {
                                        networkData2.setNetworkName(directoryRow.getColumn(this.networksColumnCname, n2));
                                        networkData2.setAliases(directoryRow.getColumn(this.networksColumnAliases, n2));
                                        networkData2.setDescription(directoryRow.getColumn(this.networksColumnComment, n2));
                                        networkData2.setNetmaskForSubnet(networkData.getNetmask());
                                        quickVector.insertElementAt((Object)networkData2, n3);
                                        networkData2 = new NetworkData();
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    var21_21 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    break block27;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "networks", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "networks", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3108", "networks", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3108", "listNetworkSubnets", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
                }
                var21_21 = null;
                if (directoryTable == null) break block27;
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        directoryRow = null;
        networkData.setNetmask(this.getNetmask(networkData));
        if (listProperties.getCustomBooleanArg1()) {
            this.listHostSubnets(quickVector, networkData);
        }
        if (!listProperties.isSortOrderAscending()) {
            int n = quickVector.size() / 2;
            int n6 = 0;
            while (n6 < n) {
                quickVector.quickSwapElementsAt(n6, quickVector.size() - n6 - 1);
                ++n6;
            }
        }
        return quickVector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector listHostSubnets(QuickVector quickVector, NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        int n = 0;
        DirectoryTable directoryTable = null;
        NetworkData networkData2 = new NetworkData();
        long l = networkData.getNetmaskLong();
        if (l == 0L) {
            return quickVector;
        }
        String string = networkData.getNetId();
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("hosts");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow != null) {
                    n = directoryRow.getNumberOfRows();
                }
                int n2 = 1;
                while (n2 <= n) {
                    block20: {
                        String string2 = directoryRow.getColumn(this.hostsColumnAddr, n2);
                        try {
                            NetworkData.validateIPAddress(string2);
                        }
                        catch (Exception exception) {
                            break block20;
                        }
                        if (string2.startsWith(string + ".")) {
                            networkData2.setNetworkAddress(string2);
                            long l2 = l & networkData2.getNetworkAddressLong();
                            networkData2.setNetworkAddress(networkData2.convertLongToAddress(l2));
                            if (!networkData2.isNetwork()) {
                                int n3 = quickVector.size();
                                int n4 = 0;
                                while (n4 < quickVector.size()) {
                                    NetworkData networkData3 = (NetworkData)quickVector.quickElementAt(n4);
                                    int n5 = networkData3.netAddrCompare(networkData2);
                                    if (n5 == 0) {
                                        n3 = -1;
                                        break;
                                    }
                                    if (n5 > 0) {
                                        n3 = n4;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (n3 >= 0) {
                                    quickVector.insertElementAt((Object)networkData2, n3);
                                    networkData2.setNetmaskForSubnet(networkData.getNetmask());
                                    networkData2 = new NetworkData();
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                Object var24_21 = null;
                if (directoryTable == null) return quickVector;
                directoryTable.close();
                return quickVector;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException("LM_3108", "hosts", (Exception)((Object)directoryTableException));
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                this.logException("LM_3108", "listHostSubnets", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV3", (Exception)((Object)hostException));
            }
            Object var24_20 = null;
            if (directoryTable == null) return quickVector;
        }
        catch (Throwable throwable) {
            Object var24_22 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return quickVector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listHostsByNetwork(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        Vector<HostData> vector;
        DirectoryTable directoryTable;
        block25: {
            Vector vector2;
            block24: {
                this.checkRights("solaris.network.hosts.read");
                if (listProperties == null) {
                    throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                }
                if (networkData == null) {
                    return this.listHosts(listProperties);
                }
                boolean bl = false;
                directoryTable = null;
                HostData hostData = null;
                vector = null;
                try {
                    try {
                        int n;
                        int n2;
                        int n3;
                        DirectoryFilter directoryFilter;
                        if (!networkData.isNetwork()) {
                            networkData.setNetmask(this.getNetmask(networkData));
                            if (networkData.getNetmask().length() == 0) {
                                throw new HostException("EXM_HST_SRV46");
                            }
                            if (networkData.getNetmaskShiftCount() % 8 != 0) {
                                bl = true;
                            }
                        }
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        if (bl) {
                            directoryFilter = new DirectoryFilter(2);
                            String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong() - 1L);
                            String string2 = networkData.convertLongToAddress(networkData.getNetworkAddressLong() + (long)(1 << networkData.getNetmaskShiftCount()));
                            directoryFilter.add(this.hostsColumnAddr, 1, 8, string);
                            directoryFilter.add(this.hostsColumnAddr, 2, 7, string2);
                        } else {
                            directoryFilter = new DirectoryFilter(1);
                            String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong());
                            directoryFilter.add(this.hostsColumnAddr, 1, 3, string + ".");
                        }
                        DirectoryRow directoryRow = directoryTable.getAll((SearchTemplate)directoryFilter);
                        if (directoryRow == null) {
                            vector2 = new Vector();
                            Object var25_15 = null;
                            if (directoryTable == null) return vector2;
                            break block24;
                        }
                        directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                        vector = new Vector<HostData>(directoryRow.getNumberOfRows());
                        if (listProperties.isSortOrderAscending()) {
                            n3 = 1;
                            n2 = directoryRow.getNumberOfRows() + 1;
                            n = 1;
                        } else {
                            n3 = directoryRow.getNumberOfRows();
                            n2 = 0;
                            n = -1;
                        }
                        while (n3 != n2) {
                            hostData = new HostData();
                            try {
                                HostData.validateIPAddress(directoryRow.getColumn(this.hostsColumnAddr, n3));
                            }
                            catch (Exception exception) {
                                n3 += n;
                                continue;
                            }
                            hostData.setNetworkAddress(directoryRow.getColumn(this.hostsColumnAddr, n3));
                            hostData.setHostName(directoryRow.getColumn(this.hostsColumnCname, n3));
                            if (!this.isLdap) {
                                hostData.setAliases(directoryRow.getColumn(this.hostsColumnAliases, n3));
                            }
                            hostData.setDescription(directoryRow.getColumn(this.hostsColumnComment, n3));
                            hostData.setEthernetAddress(this.getEtherAddrByHost(hostData.getHostName()));
                            vector.addElement(hostData);
                            n3 += n;
                        }
                        break block25;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        Object var25_17 = null;
                        if (directoryTable == null) return vector;
                        directoryTable.close();
                        return vector;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        this.logDirTableException("LM_3009", "hosts", (Exception)((Object)directoryTableException));
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        this.logException("LM_3009", "listHostsByNetwork", exception);
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var25_18 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return vector2;
        }
        Object var25_16 = null;
        if (directoryTable == null) return vector;
        directoryTable.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int listHostsByNetworkPrime(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        DirectoryTable directoryTable;
        DirectoryRow directoryRow;
        block21: {
            int n;
            block20: {
                this.checkRights("solaris.network.hosts.read");
                boolean bl = false;
                directoryRow = null;
                directoryTable = null;
                if (listProperties == null) throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                if (listProperties.getChunkSize() < 1) {
                    throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                }
                if (networkData == null) {
                    throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                }
                this.chunkSize = listProperties.getChunkSize();
                this.sortAscending = listProperties.isSortOrderAscending();
                try {
                    try {
                        DirectoryFilter directoryFilter;
                        if (!networkData.isNetwork()) {
                            networkData.setNetmask(this.getNetmask(networkData));
                            if (networkData.getNetmask().length() == 0) {
                                throw new HostException("EXM_HST_SRV46");
                            }
                            if (networkData.getNetmaskShiftCount() % 8 != 0) {
                                bl = true;
                            }
                        }
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        if (bl) {
                            directoryFilter = new DirectoryFilter(2);
                            String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong() - 1L);
                            String string2 = networkData.convertLongToAddress(networkData.getNetworkAddressLong() + (long)(1 << networkData.getNetmaskShiftCount()));
                            directoryFilter.add(this.hostsColumnAddr, 1, 8, string);
                            directoryFilter.add(this.hostsColumnAddr, 2, 7, string2);
                        } else {
                            directoryFilter = new DirectoryFilter(1);
                            String string = networkData.convertLongToAddress(networkData.getNetworkAddressLong());
                            directoryFilter.add(this.hostsColumnAddr, 1, 3, string + ".");
                        }
                        this.hostListRow = directoryRow = directoryTable.getAll((SearchTemplate)directoryFilter);
                        if (directoryRow == null) {
                            n = 0;
                            Object var19_13 = null;
                            if (directoryTable == null) return n;
                            break block20;
                        }
                        directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                        if (this.sortAscending) {
                            this.hostListIndex = 1;
                            this.hostListLimit = directoryRow.getNumberOfRows() + 1;
                            this.hostListIncrement = 1;
                            break block21;
                        } else {
                            this.hostListIndex = directoryRow.getNumberOfRows();
                            this.hostListLimit = 0;
                            this.hostListIncrement = -1;
                        }
                        break block21;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        Object var19_15 = null;
                        if (directoryTable == null) return directoryRow.getNumberOfRows();
                        directoryTable.close();
                        return directoryRow.getNumberOfRows();
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        this.logDirTableException("LM_3009", "hosts", (Exception)((Object)directoryTableException));
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        this.logException("LM_3009", "listHostsByNetworkPrime", exception);
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var19_16 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return n;
        }
        Object var19_14 = null;
        if (directoryTable == null) return directoryRow.getNumberOfRows();
        directoryTable.close();
        return directoryRow.getNumberOfRows();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listHostsByNetworkNext() throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        int n = this.chunkSize;
        Vector<HostData> vector = new Vector<HostData>(this.chunkSize);
        if (this.hostListIndex == this.hostListLimit) {
            return new Vector();
        }
        try {
            while (n > 0) {
                if (this.hostListIndex == this.hostListLimit) {
                    return vector;
                }
                HostData hostData = new HostData();
                try {
                    HostData.validateIPAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                }
                catch (Exception exception) {
                    this.hostListIndex += this.hostListIncrement;
                    continue;
                }
                hostData.setNetworkAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                hostData.setHostName(this.hostListRow.getColumn(this.hostsColumnCname, this.hostListIndex));
                if (!this.isLdap) {
                    hostData.setAliases(this.hostListRow.getColumn(this.hostsColumnAliases, this.hostListIndex));
                }
                hostData.setDescription(this.hostListRow.getColumn(this.hostsColumnComment, this.hostListIndex));
                hostData.setEthernetAddress(this.getEtherAddrByHost(hostData.getHostName()));
                vector.addElement(hostData);
                --n;
                this.hostListIndex += this.hostListIncrement;
            }
            return vector;
        }
        catch (DirectoryTableException directoryTableException) {
            this.logDirTableException("LM_3009", "hosts", (Exception)((Object)directoryTableException));
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
        }
        catch (Exception exception) {
            this.logException("LM_3009", "listHostsByNetworkNext", exception);
            HostException hostException = new HostException("EXM_HST_SRV99", exception);
            throw new HostException("EXM_HST_SRV4", (Exception)((Object)hostException));
        }
    }

    public void listHostsByNetworkEnd() throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        this.hostListRow = null;
        this.hostListIndex = this.hostListLimit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNetwork(NetworkData networkData, NetworkData networkData2) throws RemoteException, AdminException, HostAuthException {
        block22: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            if (networkData2.getNetworkName().length() == 0) {
                boolean bl;
                if (networkData.getNetworkName().length() > 0) {
                    String string = networkData.getNetmask();
                    networkData.setNetmask("");
                    this.deleteNetwork(networkData);
                    networkData.setNetmask(string);
                }
                if (!(bl = this.setNetmask(networkData, networkData2))) {
                    throw new HostException("EXM_HST_SRV45");
                }
                return;
            }
            boolean bl = this.setNetmask(networkData, networkData2);
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                    directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                    directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                    directoryRow.putColumn(this.networksColumnComment, networkData.getDescription());
                    DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                    directoryRow2.putColumn(this.networksColumnCname, networkData2.getNetworkName());
                    directoryRow2.putColumn(this.networksColumnAddr, networkData2.getNetworkAddress());
                    directoryRow2.putColumn(this.networksColumnAliases, networkData2.getAliases());
                    directoryRow2.putColumn(this.networksColumnComment, networkData2.getDescription());
                    if (networkData.getNetworkName().length() == 0 && networkData2.getNetworkName().length() > 0) {
                        directoryTable.addRow(directoryRow2);
                    } else {
                        directoryTable.modifyRow(directoryRow, directoryRow2);
                    }
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV42");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV40");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "networks", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "networks", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3105", "networks", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3105", "setNetwork", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV5_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV5", (Exception)((Object)hostException));
                }
                Object var16_12 = null;
                if (directoryTable == null) break block22;
            }
            catch (Throwable throwable) {
                Object var16_13 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        String[] stringArray = new String[]{networkData.getNetworkName(), networkData.getNetworkAddress()};
        this.writeLog(100, "LM_3104", "LM_3152", stringArray, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addNetwork(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        block18: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            if (this.getNetwork(networkData) != null) {
                throw new HostException("EXM_HST_SRV6", (Exception)((Object)new HostException("EXM_HST_SRV47")));
            }
            boolean bl = this.addNetmask(networkData);
            if (networkData.getNetworkName().length() == 0) {
                return;
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                    directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                    directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                    directoryRow.putColumn(this.networksColumnComment, networkData.getDescription());
                    directoryTable.addRow(directoryRow);
                }
                catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                    HostException hostException = new HostException("EXM_HST_SRV44");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV40");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "networks", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "networks", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3101", "networks", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3101", "addNetwork", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    if (bl) {
                        throw new HostWarningException("EXM_HST_SRV6_WARN", (Exception)((Object)hostException));
                    }
                    throw new HostException("EXM_HST_SRV6", (Exception)((Object)hostException));
                }
                Object var14_6 = null;
                if (directoryTable == null) break block18;
            }
            catch (Throwable throwable) {
                Object var14_7 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        String[] stringArray = new String[]{networkData.getNetworkName(), networkData.getNetworkAddress()};
        this.writeLog(100, "LM_3100", "LM_3150", stringArray, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteNetwork(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        block11: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            this.deleteNetmask(networkData);
            if (networkData.getNetworkName().equals("")) {
                return;
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("networks");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.networksColumnCname, networkData.getNetworkName());
                    directoryRow.putColumn(this.networksColumnAddr, networkData.getNetworkAddress());
                    directoryRow.putColumn(this.networksColumnAliases, networkData.getAliases());
                    directoryTable.deleteRow(directoryRow);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV42");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV40");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "networks", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "networks", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3103", "networks", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3103", "deleteNetwork", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV7", (Exception)((Object)hostException));
                }
                Object var13_5 = null;
                if (directoryTable == null) break block11;
            }
            catch (Throwable throwable) {
                Object var13_6 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        String[] stringArray = new String[]{networkData.getNetworkName(), networkData.getNetworkAddress()};
        this.writeLog(100, "LM_3102", "LM_3151", stringArray, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getNetmask(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        String string = "";
        try {
            block9: {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("netmasks");
                    directoryTable.open(tableDefinitions);
                    directoryFilter.add(this.netmasksColumnAddr, 1, 5, networkData.getNetId());
                    directoryFilter.add(this.netmasksColumnAddr, 3, 3, networkData.getNetId() + ".");
                    DirectoryRow directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryFilter);
                    if (directoryRow == null) break block9;
                    string = directoryRow.getColumn(this.netmasksColumnMask);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV43");
                    throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    Object var15_8 = null;
                    if (directoryTable == null) return string;
                    directoryTable.close();
                    return string;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "netmasks", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30", (Exception)((Object)directoryTableAccessException));
                    throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "netmasks", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31", (Exception)((Object)directoryTableConnectionException));
                    throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3106", "netmasks", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3106", "getNetmask", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV8", (Exception)((Object)hostException));
                }
            }
            Object var15_7 = null;
            if (directoryTable == null) return string;
            directoryTable.close();
            return string;
        }
        catch (Throwable throwable) {
            Object var15_9 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setNetmask(NetworkData networkData, NetworkData networkData2) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.write");
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        if (networkData2.getNetmask().length() == 0) {
            this.deleteNetmask(networkData);
            return true;
        }
        if (networkData.getNetmask().length() == 0) {
            return this.addNetmask(networkData2);
        }
        if (!networkData.getNetworkAddress().equals(networkData2.getNetworkAddress())) {
            String string;
            try {
                string = this.getNetmask(networkData2);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            if (string != null && string.length() > 0) {
                if (!string.equals(networkData2.getNetmask())) throw new HostException("EXM_HST_SRV45");
                return false;
            }
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                directoryFilter.add(this.netmasksColumnAddr, 1, 5, networkData.getNetId());
                directoryFilter.add(this.netmasksColumnAddr, 3, 3, networkData.getNetId() + ".");
                DirectoryRow directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryFilter);
                if (directoryRow == null) {
                    throw new HostException("EXM_HST_SRV43");
                }
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.netmasksColumnMask, networkData2.getNetmask());
                if (networkData.getNetworkAddress().equals(networkData2.getNetworkAddress())) {
                    directoryRow2.putColumn(this.netmasksColumnAddr, directoryRow.getColumn(this.netmasksColumnAddr));
                } else {
                    directoryRow2.putColumn(this.netmasksColumnAddr, networkData2.getNetworkAddress());
                }
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV43");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException("LM_3202", "netmasks", (Exception)((Object)directoryTableAccessException));
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException("LM_3203", "netmasks", (Exception)((Object)directoryTableConnectionException));
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException("LM_3105", "netmasks", (Exception)((Object)directoryTableException));
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                this.logException("LM_3105", "setNetmask", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV10", (Exception)((Object)hostException));
            }
            Object var17_12 = null;
            if (directoryTable == null) return true;
        }
        catch (Throwable throwable) {
            Object var17_13 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addNetmask(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        String string;
        this.checkRights("solaris.network.hosts.write");
        if (networkData.getNetmask().length() == 0) {
            return false;
        }
        try {
            string = this.getNetmask(networkData);
        }
        catch (HostException hostException) {
            throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
        }
        if (string != null && string.length() > 0) {
            if (!string.equals(networkData.getNetmask())) throw new HostException("EXM_HST_SRV45");
            return false;
        }
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.netmasksColumnMask, networkData.getNetmask());
                directoryRow.putColumn(this.netmasksColumnAddr, networkData.getNetworkAddress());
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                HostException hostException = new HostException("EXM_HST_SRV45");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException("LM_3202", "netmasks", (Exception)((Object)directoryTableAccessException));
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException("LM_3203", "netmasks", (Exception)((Object)directoryTableConnectionException));
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException("LM_3101", "netmasks", (Exception)((Object)directoryTableException));
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                this.logException("LM_3101", "addNetmask", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV11", (Exception)((Object)hostException));
            }
            Object var14_7 = null;
            if (directoryTable == null) return true;
        }
        catch (Throwable throwable) {
            Object var14_8 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteNetmask(NetworkData networkData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.write");
        if (networkData.getNetmask().length() == 0) {
            return;
        }
        DirectoryFilter directoryFilter = new DirectoryFilter(2);
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("netmasks");
                directoryTable.open(tableDefinitions);
                directoryFilter.add(this.netmasksColumnAddr, 1, 5, networkData.getNetId());
                directoryFilter.add(this.netmasksColumnAddr, 3, 3, networkData.getNetId() + ".");
                DirectoryRow directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryFilter);
                if (directoryRow == null) {
                    throw new HostException("EXM_HST_SRV43");
                }
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.netmasksColumnAddr, directoryRow.getColumn(this.netmasksColumnAddr));
                directoryRow2.putColumn(this.netmasksColumnMask, networkData.getNetmask());
                directoryTable.deleteRow(directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV43");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV41");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException("LM_3202", "netmasks", (Exception)((Object)directoryTableAccessException));
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException("LM_3203", "netmasks", (Exception)((Object)directoryTableConnectionException));
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException("LM_3103", "netmasks", (Exception)((Object)directoryTableException));
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                this.logException("LM_3103", "deleteNetmask", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV12", (Exception)((Object)hostException));
            }
            Object var15_7 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var15_8 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HostData getHostByEtherAddr(String string) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        if (string.length() == 0) {
            return null;
        }
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        try {
            block10: {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("ethers");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.ethersColumnAddr, string);
                    DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    if (directoryRow2 == null) break block10;
                    hostData = new HostData(directoryRow2.getColumn(this.ethersColumnName));
                    hostData.setEthernetAddress(string);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    Object var15_8 = null;
                    if (directoryTable == null) return hostData;
                    directoryTable.close();
                    return hostData;
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    Object var15_9 = null;
                    if (directoryTable == null) return hostData;
                    directoryTable.close();
                    return hostData;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "ethers", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "ethers", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3008", "ethers", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3008", "getHostByEtherAddr", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
            }
            Object var15_7 = null;
            if (directoryTable == null) return hostData;
            directoryTable.close();
            return hostData;
        }
        catch (Throwable throwable) {
            Object var15_10 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEtherAddrByHost(String string) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryTable directoryTable = null;
        String string2 = "";
        try {
            block9: {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("ethers");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.ethersColumnName, string);
                    DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    if (directoryRow2 == null) break block9;
                    string2 = directoryRow2.getColumn(this.ethersColumnAddr);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV63");
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    Object var15_8 = null;
                    if (directoryTable == null) return string2;
                    directoryTable.close();
                    return string2;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "ethers", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "ethers", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3008", "ethers", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3008", "getEtherAddrByHost", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV15", (Exception)((Object)hostException));
                }
            }
            Object var15_7 = null;
            if (directoryTable == null) return string2;
            directoryTable.close();
            return string2;
        }
        catch (Throwable throwable) {
            Object var15_9 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DirectoryRow cacheEthersList() throws RemoteException, AdminException {
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                this.ethersTableDefn = directoryTable.getTableDefinitionsInstance();
                this.ethersTableDefn.loadTableDefinitions("ethers");
                directoryTable.open(this.ethersTableDefn);
                this.etherMatchRow = directoryTable.getRowInstance();
                directoryRow = directoryTable.getAll();
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                Object var10_4 = null;
                if (directoryTable == null) return directoryRow;
                directoryTable.close();
                return directoryRow;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException("LM_3202", "ethers", (Exception)((Object)directoryTableAccessException));
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV16", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException("LM_3203", "ethers", (Exception)((Object)directoryTableConnectionException));
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV16", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException("LM_3009", "ethers", (Exception)((Object)directoryTableException));
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV16", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                this.logException("LM_3009", "cacheEthersList", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV16", (Exception)((Object)hostException));
            }
            Object var10_3 = null;
            if (directoryTable == null) return directoryRow;
        }
        catch (Throwable throwable) {
            Object var10_5 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return directoryRow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEthernetAddress(HostData hostData, HostData hostData2) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        if (hostData.getEthernetAddress().equals(hostData2.getEthernetAddress())) {
            return;
        }
        if (hostData2.getEthernetAddress().length() == 0) {
            this.deleteEthernetAddress(hostData);
            return;
        }
        if (hostData.getEthernetAddress().length() == 0) {
            this.addEthernetAddress(hostData2);
            return;
        }
        DirectoryTable directoryTable = null;
        HostData hostData3 = this.getHostByEtherAddr(hostData2.getEthernetAddress());
        if (hostData3 != null && !hostData2.getHostName().equals(hostData3.getHostName())) {
            throw new HostWarningException("EXM_HST_SRV70_WARN");
        }
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.ethersColumnName, hostData2.getHostName());
                directoryRow2.putColumn(this.ethersColumnAddr, hostData2.getEthernetAddress());
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV63");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV61");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException("LM_3202", "ethers", (Exception)((Object)directoryTableAccessException));
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException("LM_3203", "ethers", (Exception)((Object)directoryTableConnectionException));
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException("LM_3005", "ethers", (Exception)((Object)directoryTableException));
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                this.logException("LM_3005", "setEthernetAddress", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostWarningException("EXM_HST_SRV17_WARN", (Exception)((Object)hostException));
            }
            Object var16_8 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var16_9 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addEthernetAddress(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        HostWarningException hostWarningException;
        block16: {
            this.checkRights("solaris.network.hosts.read");
            DirectoryTable directoryTable = null;
            hostWarningException = null;
            if (hostData.getEthernetAddress().length() == 0) {
                return;
            }
            HostData hostData2 = this.getHostByEtherAddr(hostData.getEthernetAddress());
            if (hostData2 != null) {
                if (!hostData.getHostName().equals(hostData2.getHostName())) {
                    throw new HostWarningException("EXM_HST_SRV70_WARN");
                }
                return;
            }
            String string = this.getEtherAddrByHost(hostData.getHostName());
            if (string.length() > 0 && !string.equals(hostData.getEthernetAddress())) {
                hostWarningException = new HostWarningException("EXM_HST_SRV72_WARN");
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("ethers");
                    try {
                        directoryTable.open(tableDefinitions);
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        directoryTable.create(tableDefinitions);
                    }
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                    directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                    directoryTable.addRow(directoryRow);
                }
                catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                    HostException hostException = new HostException("EXM_HST_SRV65");
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "ethers", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "ethers", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3001", "ethers", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3001", "addEthernetAddress", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostWarningException("EXM_HST_SRV18_WARN", (Exception)((Object)hostException));
                }
                Object var15_10 = null;
                if (directoryTable == null) break block16;
            }
            catch (Throwable throwable) {
                Object var15_11 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        if (hostWarningException != null) {
            throw hostWarningException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteEthernetAddress(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.write");
        if (hostData.getEthernetAddress().length() == 0) {
            return;
        }
        DirectoryTable directoryTable = null;
        try {
            try {
                directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                tableDefinitions.loadTableDefinitions("ethers");
                directoryTable.open(tableDefinitions);
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.ethersColumnAddr, hostData.getEthernetAddress());
                directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                HostException hostException = new HostException("EXM_HST_SRV63");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                HostException hostException = new HostException("EXM_HST_SRV61");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException("LM_3202", "ethers", (Exception)((Object)directoryTableAccessException));
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException("LM_3203", "ethers", (Exception)((Object)directoryTableConnectionException));
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException("LM_3003", "ethers", (Exception)((Object)directoryTableException));
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                this.logException("LM_3003", "deleteEthernetAddress", exception);
                HostException hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV19", (Exception)((Object)hostException));
            }
            Object var13_5 = null;
            if (directoryTable == null) return;
        }
        catch (Throwable throwable) {
            Object var13_6 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renameEthernetAddress(HostData hostData, String string) throws RemoteException, AdminException, HostAuthException {
        DirectoryTable directoryTable;
        block13: {
            block12: {
                this.checkRights("solaris.network.hosts.write");
                directoryTable = null;
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("ethers");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        directoryRow.putColumn(this.ethersColumnName, hostData.getHostName());
                        DirectoryRow directoryRow2 = directoryTable.getAll((SearchTemplate)directoryRow);
                        if (directoryRow2 == null) {
                            Object var17_7 = null;
                            if (directoryTable == null) return;
                            break block12;
                        }
                        int n = 1;
                        while (n <= directoryRow2.getNumberOfRows()) {
                            DirectoryRow directoryRow3 = directoryRow2.extractRows(n, n);
                            DirectoryRow directoryRow4 = directoryRow2.extractRows(n, n);
                            directoryRow4.putColumn(this.ethersColumnName, string);
                            directoryTable.modifyRow(directoryRow3, directoryRow4);
                            ++n;
                        }
                        break block13;
                    }
                    catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                        Object var17_9 = null;
                        if (directoryTable == null) return;
                        directoryTable.close();
                        return;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        Object var17_10 = null;
                        if (directoryTable == null) return;
                        directoryTable.close();
                        return;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        this.logDirTableException("LM_3202", "ethers", (Exception)((Object)directoryTableAccessException));
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV27", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        this.logDirTableException("LM_3203", "ethers", (Exception)((Object)directoryTableConnectionException));
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV27", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        this.logDirTableException("LM_3005", "ethers", (Exception)((Object)directoryTableException));
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV27", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        this.logException("LM_3005", "renameEthernetAddress", exception);
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV27", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var17_11 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return;
        }
        Object var17_8 = null;
        if (directoryTable == null) return;
        directoryTable.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HostData getHostByAddress(String string) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        try {
            block9: {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("hosts");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.hostsColumnAddr, string);
                    DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                    if (directoryRow2 == null) break block9;
                    hostData = new HostData();
                    hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr));
                    hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname));
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    Object var15_8 = null;
                    if (directoryTable == null) return hostData;
                    directoryTable.close();
                    return hostData;
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    Object var15_9 = null;
                    if (directoryTable == null) return hostData;
                    directoryTable.close();
                    return hostData;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3008", "hosts", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3008", "getHostByAddress", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                }
            }
            Object var15_7 = null;
            if (directoryTable == null) return hostData;
            directoryTable.close();
            return hostData;
        }
        catch (Throwable throwable) {
            Object var15_10 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HostData getHostByNameAddr(String string, String string2) throws RemoteException, AdminException, HostAuthException {
        HostData hostData;
        DirectoryTable directoryTable;
        block13: {
            HostData hostData2;
            block12: {
                this.checkRights("solaris.network.hosts.read");
                directoryTable = null;
                hostData = null;
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        directoryRow.putColumn(this.hostsColumnCname, string);
                        directoryRow.putColumn(this.hostsColumnAddr, string2);
                        DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                        if (directoryRow2 == null) {
                            hostData2 = hostData;
                            Object var16_10 = null;
                            if (directoryTable == null) return hostData2;
                            break block12;
                        }
                        hostData = new HostData();
                        hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr));
                        hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname));
                        if (!this.isLdap) {
                            hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases));
                        }
                        hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment));
                        hostData.setEthernetAddress(this.getEtherAddrByHost(hostData.getHostName()));
                        break block13;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        Object var16_12 = null;
                        if (directoryTable == null) return hostData;
                        directoryTable.close();
                        return hostData;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        this.logDirTableException("LM_3008", "hosts", (Exception)((Object)directoryTableException));
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        this.logException("LM_3008", "getHostByNameAddr", exception);
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var16_13 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return hostData2;
        }
        Object var16_11 = null;
        if (directoryTable == null) return hostData;
        directoryTable.close();
        return hostData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getHostOtherAddrs(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        Vector<String> vector;
        DirectoryTable directoryTable;
        block13: {
            Vector<String> vector2;
            block12: {
                this.checkRights("solaris.network.hosts.read");
                directoryTable = null;
                vector = new Vector<String>();
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                        DirectoryRow directoryRow2 = directoryTable.getAll((SearchTemplate)directoryRow);
                        if (directoryRow2 == null) {
                            vector2 = vector;
                            Object var15_9 = null;
                            if (directoryTable == null) return vector2;
                            break block12;
                        }
                        String string = hostData.getNetworkAddress();
                        int n = 1;
                        while (n <= directoryRow2.getNumberOfRows()) {
                            if (directoryRow2.getColumn(this.hostsColumnAddr, n).length() > 0 && !string.equals(directoryRow2.getColumn(this.hostsColumnAddr, n))) {
                                vector.addElement(directoryRow2.getColumn(this.hostsColumnAddr, n));
                            }
                            ++n;
                        }
                        break block13;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        Object var15_11 = null;
                        if (directoryTable == null) return vector;
                        directoryTable.close();
                        return vector;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        this.logDirTableException("LM_3008", "hosts", (Exception)((Object)directoryTableException));
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        this.logException("LM_3008", "getHostOtherAddrs", exception);
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var15_12 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return vector2;
        }
        Object var15_10 = null;
        if (directoryTable == null) return vector;
        directoryTable.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getHostsByName(String string) throws RemoteException, AdminException, HostAuthException {
        Vector<HostData> vector;
        DirectoryTable directoryTable;
        block14: {
            Vector<HostData> vector2;
            block13: {
                this.checkRights("solaris.network.hosts.read");
                directoryTable = null;
                vector = new Vector<HostData>();
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        directoryRow.putColumn(this.hostsColumnCname, string);
                        DirectoryRow directoryRow2 = directoryTable.getAll((SearchTemplate)directoryRow);
                        if (directoryRow2 == null) {
                            vector2 = vector;
                            Object var16_9 = null;
                            if (directoryTable == null) return vector2;
                            break block13;
                        }
                        vector = new Vector(directoryRow2.getNumberOfRows());
                        int n = 1;
                        while (n <= directoryRow2.getNumberOfRows()) {
                            HostData hostData = new HostData();
                            hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr, n));
                            hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname, n));
                            if (!this.isLdap) {
                                hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases, n));
                            }
                            hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment, n));
                            hostData.setEthernetAddress(this.getEtherAddrByHost(hostData.getHostName()));
                            vector.addElement(hostData);
                            ++n;
                        }
                        break block14;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        Object var16_11 = null;
                        if (directoryTable == null) return vector;
                        directoryTable.close();
                        return vector;
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        this.logDirTableException("LM_3008", "hosts", (Exception)((Object)directoryTableException));
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        this.logException("LM_3008", "getHostsByName", exception);
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV20", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var16_12 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return vector2;
        }
        Object var16_10 = null;
        if (directoryTable == null) return vector;
        directoryTable.close();
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector listHosts(ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        if (listProperties == null) {
            throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
        }
        int n = 0;
        DirectoryRow directoryRow = null;
        DirectoryTable directoryTable = null;
        HostData hostData = null;
        QuickVector quickVector = null;
        try {
            try {
                int n2;
                int n3;
                int n4;
                DirectoryRow directoryRow2;
                TableDefinitions tableDefinitions2;
                TableDefinitions tableDefinitions;
                block22: {
                    directoryRow = this.cacheEthersList();
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("hosts");
                    tableDefinitions2 = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions2.loadTableDefinitions("ethers");
                    directoryTable.open(tableDefinitions);
                    Vector vector = listProperties.getFilters();
                    if (vector != null && !vector.isEmpty()) {
                        DirectoryFilter directoryFilter = new DirectoryFilter(vector.size());
                        int n5 = 0;
                        while (true) {
                            if (n5 >= vector.size()) {
                                directoryRow2 = directoryTable.getAll((SearchTemplate)directoryFilter);
                                break block22;
                            }
                            FilterItem filterItem = (FilterItem)vector.elementAt(n5);
                            directoryFilter.add(this.mapHostColumnToNum(filterItem.getAttribute()), filterItem.getBooleanOperator(), filterItem.getOperator(), filterItem.getValue());
                            ++n5;
                        }
                    }
                    directoryRow2 = directoryTable.getAll();
                }
                if (directoryRow2 != null) {
                    directoryRow2.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                    quickVector = new QuickVector(directoryRow2.getNumberOfRows());
                    quickVector.setSize(directoryRow2.getNumberOfRows());
                    if (listProperties.isSortOrderAscending()) {
                        n4 = 1;
                        n3 = directoryRow2.getNumberOfRows() + 1;
                        n2 = 1;
                    } else {
                        n4 = directoryRow2.getNumberOfRows();
                        n3 = 0;
                        n2 = -1;
                    }
                } else {
                    quickVector = new QuickVector(0);
                    quickVector.setSize(0);
                    n2 = 0;
                    n3 = 0;
                    n4 = 0;
                }
                while (n4 != n3) {
                    hostData = new HostData();
                    hostData.setNetworkAddress(directoryRow2.getColumn(this.hostsColumnAddr, n4));
                    hostData.setHostName(directoryRow2.getColumn(this.hostsColumnCname, n4));
                    if (!this.isLdap) {
                        hostData.setAliases(directoryRow2.getColumn(this.hostsColumnAliases, n4));
                    }
                    hostData.setDescription(directoryRow2.getColumn(this.hostsColumnComment, n4));
                    if (directoryRow != null) {
                        DirectoryRow directoryRow3 = directoryTable.getRowInstance();
                        directoryRow3.putColumn(this.ethersColumnName, hostData.getHostName());
                        int n6 = directoryRow.getFirstRow((SearchTemplate)directoryRow3, tableDefinitions2);
                        if (n6 > 0) {
                            hostData.setEthernetAddress(directoryRow.getColumn(this.ethersColumnAddr, n6));
                        }
                    }
                    quickVector.quickSetElementAt((Object)hostData, n++);
                    n4 += n2;
                }
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                Object var26_21 = null;
                if (directoryTable == null) return quickVector;
                directoryTable.close();
                return quickVector;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                HostException hostException = new HostException("EXM_HST_SRV30");
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                HostException hostException = new HostException("EXM_HST_SRV31");
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            catch (DirectoryTableException directoryTableException) {
                this.logDirTableException("LM_3009", "hosts", (Exception)((Object)directoryTableException));
                HostException hostException = new HostException("EXM_HST_SRV32");
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            catch (Exception exception) {
                this.logException("LM_3009", "listHosts", exception);
                hostException = new HostException("EXM_HST_SRV99", exception);
                throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
            }
            Object var26_20 = null;
            if (directoryTable == null) return quickVector;
        }
        catch (Throwable throwable) {
            Object var26_22 = null;
            if (directoryTable == null) throw throwable;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        return quickVector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int listHostsPrime(ListProperties listProperties) throws RemoteException, AdminException, HostAuthException {
        DirectoryTable directoryTable;
        DirectoryRow directoryRow;
        block19: {
            int n;
            block18: {
                this.checkRights("solaris.network.hosts.read");
                directoryRow = null;
                directoryTable = null;
                if (listProperties == null) throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                if (listProperties.getChunkSize() < 1) {
                    throw new HostException("EXM_HST_SRV21", (Exception)((Object)new HostException("EXM_HST_SRV99")));
                }
                this.chunkSize = listProperties.getChunkSize();
                this.sortAscending = listProperties.isSortOrderAscending();
                try {
                    try {
                        TableDefinitions tableDefinitions;
                        block17: {
                            this.etherListRow = this.cacheEthersList();
                            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                            tableDefinitions = directoryTable.getTableDefinitionsInstance();
                            tableDefinitions.loadTableDefinitions("hosts");
                            directoryTable.open(tableDefinitions);
                            Vector vector = listProperties.getFilters();
                            if (vector != null && !vector.isEmpty()) {
                                DirectoryFilter directoryFilter = new DirectoryFilter(vector.size());
                                n = 0;
                                while (true) {
                                    if (n >= vector.size()) {
                                        directoryRow = directoryTable.getAll((SearchTemplate)directoryFilter);
                                        break block17;
                                    }
                                    FilterItem filterItem = (FilterItem)vector.elementAt(n);
                                    directoryFilter.add(this.mapHostColumnToNum(filterItem.getAttribute()), filterItem.getBooleanOperator(), filterItem.getOperator(), filterItem.getValue());
                                    ++n;
                                }
                            }
                            directoryRow = directoryTable.getAll();
                        }
                        this.hostListRow = directoryRow;
                        if (directoryRow == null) {
                            n = 0;
                            Object var16_10 = null;
                            if (directoryTable == null) return n;
                            break block18;
                        }
                        directoryRow.sortByColumn(this.mapHostColumnToNum(listProperties.getSortColumn()), tableDefinitions);
                        if (this.sortAscending) {
                            this.hostListIndex = 1;
                            this.hostListLimit = directoryRow.getNumberOfRows() + 1;
                            this.hostListIncrement = 1;
                            break block19;
                        } else {
                            this.hostListIndex = directoryRow.getNumberOfRows();
                            this.hostListLimit = 0;
                            this.hostListIncrement = -1;
                        }
                        break block19;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        Object var16_12 = null;
                        if (directoryTable == null) return directoryRow.getNumberOfRows();
                        directoryTable.close();
                        return directoryRow.getNumberOfRows();
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        this.logDirTableException("LM_3009", "hosts", (Exception)((Object)directoryTableException));
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        this.logException("LM_3009", "listHostsPrime", exception);
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var16_13 = null;
                    if (directoryTable == null) throw throwable;
                    directoryTable.close();
                    throw throwable;
                }
            }
            directoryTable.close();
            return n;
        }
        Object var16_11 = null;
        if (directoryTable == null) return directoryRow.getNumberOfRows();
        directoryTable.close();
        return directoryRow.getNumberOfRows();
    }

    public Vector listHostsNext() throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        int n = this.chunkSize;
        int n2 = 0;
        HostData hostData = null;
        QuickVector quickVector = new QuickVector(this.chunkSize);
        try {
            quickVector.setSize(this.chunkSize);
            while (n > 0 && this.hostListIndex != this.hostListLimit) {
                hostData = new HostData();
                hostData.setNetworkAddress(this.hostListRow.getColumn(this.hostsColumnAddr, this.hostListIndex));
                hostData.setHostName(this.hostListRow.getColumn(this.hostsColumnCname, this.hostListIndex));
                if (!this.isLdap) {
                    hostData.setAliases(this.hostListRow.getColumn(this.hostsColumnAliases, this.hostListIndex));
                }
                hostData.setDescription(this.hostListRow.getColumn(this.hostsColumnComment, this.hostListIndex));
                if (this.etherListRow != null && this.ethersTableDefn != null) {
                    this.etherMatchRow.putColumn(this.ethersColumnName, hostData.getHostName());
                    int n3 = this.etherListRow.getFirstRow((SearchTemplate)this.etherMatchRow, this.ethersTableDefn);
                    if (n3 > 0) {
                        hostData.setEthernetAddress(this.etherListRow.getColumn(this.ethersColumnAddr, n3));
                    }
                }
                quickVector.quickSetElementAt((Object)hostData, n2++);
                --n;
                this.hostListIndex += this.hostListIncrement;
            }
        }
        catch (DirectoryTableException directoryTableException) {
            this.logDirTableException("LM_3009", "hosts", (Exception)((Object)directoryTableException));
            HostException hostException = new HostException("EXM_HST_SRV32");
            throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
        }
        catch (Exception exception) {
            this.logException("LM_3009", "listHostsNext", exception);
            HostException hostException = new HostException("EXM_HST_SRV99", exception);
            throw new HostException("EXM_HST_SRV21", (Exception)((Object)hostException));
        }
        if (n2 < this.chunkSize) {
            quickVector.setSize(n2);
        }
        return quickVector;
    }

    public void listHostsEnd() throws RemoteException, AdminException, HostAuthException {
        this.checkRights("solaris.network.hosts.read");
        this.hostListRow = null;
        this.hostListIndex = this.hostListLimit;
        this.etherListRow = null;
        this.ethersTableDefn = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHost(HostData hostData, HostData hostData2) throws RemoteException, AdminException, HostAuthException {
        String[] stringArray;
        block14: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            if (!hostData.getNetworkAddress().equals(hostData2.getNetworkAddress()) && (stringArray = this.getHostByAddress(hostData2.getNetworkAddress())) != null) {
                if (stringArray.getHostName().equals(hostData2.getHostName())) {
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)new HostException("EXM_HST_SRV64")));
                }
                throw new HostException("EXM_HST_SRV22", (Exception)((Object)new HostException("EXM_HST_SRV69")));
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("hosts");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                    directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                    if (!this.isLdap) {
                        directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                    }
                    directoryRow.putColumn(this.hostsColumnComment, hostData.getDescription());
                    DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                    directoryRow2.putColumn(this.hostsColumnCname, hostData2.getHostName());
                    directoryRow2.putColumn(this.hostsColumnAddr, hostData2.getNetworkAddress());
                    if (!this.isLdap) {
                        directoryRow2.putColumn(this.hostsColumnAliases, hostData2.getAliases());
                    }
                    directoryRow2.putColumn(this.hostsColumnComment, hostData2.getDescription());
                    directoryTable.modifyRow(directoryRow, directoryRow2);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV62");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV60");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3005", "hosts", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3005", "setHost", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV22", (Exception)((Object)hostException));
                }
                Object var15_9 = null;
                if (directoryTable == null) break block14;
            }
            catch (Throwable throwable) {
                Object var15_10 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.setEthernetAddress(hostData, hostData2);
        stringArray = new String[]{hostData.getHostName()};
        this.writeLog(100, "LM_3004", "LM_3052", stringArray, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addHost(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        block13: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            HostData hostData2 = this.getHostByAddress(hostData.getNetworkAddress());
            if (hostData2 != null) {
                if (hostData2.getHostName().equals(hostData.getHostName())) {
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)new HostException("EXM_HST_SRV64")));
                }
                throw new HostException("EXM_HST_SRV23", (Exception)((Object)new HostException("EXM_HST_SRV69")));
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("hosts");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                    directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                    if (!this.isLdap) {
                        directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                    }
                    directoryRow.putColumn(this.hostsColumnComment, hostData.getDescription());
                    directoryTable.addRow(directoryRow);
                }
                catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                    HostException hostException = new HostException("EXM_HST_SRV64");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV60");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3001", "hosts", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3001", "addHost", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV23", (Exception)((Object)hostException));
                }
                Object var14_6 = null;
                if (directoryTable == null) break block13;
            }
            catch (Throwable throwable) {
                Object var14_7 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.addEthernetAddress(hostData);
        String[] stringArray = new String[]{hostData.getHostName(), hostData.getNetworkAddress()};
        this.writeLog(100, "LM_3000", "LM_3050", stringArray, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteHost(HostData hostData) throws RemoteException, AdminException, HostAuthException {
        block12: {
            this.checkRights("solaris.network.hosts.write");
            DirectoryTable directoryTable = null;
            if (hostData.getHostName().equals(LOCAL_HOST_NAME)) {
                HostException hostException = new HostException("EXM_HST_SRV71");
                throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
            }
            try {
                try {
                    directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                    TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions("hosts");
                    directoryTable.open(tableDefinitions);
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    directoryRow.putColumn(this.hostsColumnCname, hostData.getHostName());
                    directoryRow.putColumn(this.hostsColumnAddr, hostData.getNetworkAddress());
                    if (!this.isLdap) {
                        directoryRow.putColumn(this.hostsColumnAliases, hostData.getAliases());
                    }
                    directoryTable.deleteRow(directoryRow);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    HostException hostException = new HostException("EXM_HST_SRV62");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    HostException hostException = new HostException("EXM_HST_SRV60");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                    HostException hostException = new HostException("EXM_HST_SRV30");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                    HostException hostException = new HostException("EXM_HST_SRV31");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (DirectoryTableException directoryTableException) {
                    this.logDirTableException("LM_3003", "hosts", (Exception)((Object)directoryTableException));
                    HostException hostException = new HostException("EXM_HST_SRV32");
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                catch (Exception exception) {
                    this.logException("LM_3003", "deleteHost", exception);
                    HostException hostException = new HostException("EXM_HST_SRV99", exception);
                    throw new HostException("EXM_HST_SRV24", (Exception)((Object)hostException));
                }
                Object var13_12 = null;
                if (directoryTable == null) break block12;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                throw throwable;
            }
            directoryTable.close();
        }
        this.deleteEthernetAddress(hostData);
        String[] stringArray = new String[]{hostData.getHostName(), hostData.getNetworkAddress()};
        this.writeLog(100, "LM_3002", "LM_3051", stringArray, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int renameHost(HostData hostData, String string, Integer n) throws RemoteException, AdminException, HostAuthException {
        DirectoryRow directoryRow;
        DirectoryTable directoryTable;
        block16: {
            int n2;
            block15: {
                this.checkRights("solaris.network.hosts.write");
                int n3 = n;
                directoryTable = null;
                try {
                    try {
                        directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                        tableDefinitions.loadTableDefinitions("hosts");
                        directoryTable.open(tableDefinitions);
                        DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                        directoryRow2.putColumn(this.hostsColumnCname, hostData.getHostName());
                        directoryRow = directoryTable.getAll((SearchTemplate)directoryRow2);
                        if (directoryRow == null) {
                            throw new HostException("EXM_HST_SRV62");
                        }
                        if (n3 == 0 && directoryRow.getNumberOfRows() > 1) {
                            n2 = directoryRow.getNumberOfRows();
                            Object var19_13 = null;
                            if (directoryTable == null) return n2;
                            break block15;
                        }
                        int n4 = 1;
                        while (n4 <= directoryRow.getNumberOfRows()) {
                            if (n3 > 1 || hostData.getNetworkAddress().equals(directoryRow.getColumn(this.hostsColumnAddr, n4))) {
                                DirectoryRow directoryRow3 = directoryRow.extractRows(n4, n4);
                                DirectoryRow directoryRow4 = directoryRow.extractRows(n4, n4);
                                directoryRow4.putColumn(this.hostsColumnCname, string);
                                directoryTable.modifyRow(directoryRow3, directoryRow4);
                            }
                            ++n4;
                        }
                        break block16;
                    }
                    catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                        HostException hostException = new HostException("EXM_HST_SRV60");
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableAccessException directoryTableAccessException) {
                        this.logDirTableException("LM_3202", "hosts", (Exception)((Object)directoryTableAccessException));
                        HostException hostException = new HostException("EXM_HST_SRV30");
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableConnectionException directoryTableConnectionException) {
                        this.logDirTableException("LM_3203", "hosts", (Exception)((Object)directoryTableConnectionException));
                        HostException hostException = new HostException("EXM_HST_SRV31");
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (DirectoryTableException directoryTableException) {
                        this.logDirTableException("LM_3007", "hosts", (Exception)((Object)directoryTableException));
                        HostException hostException = new HostException("EXM_HST_SRV32");
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (HostException hostException) {
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                    catch (Exception exception) {
                        this.logException("LM_3007", "renameHost", exception);
                        HostException hostException = new HostException("EXM_HST_SRV99", exception);
                        throw new HostException("EXM_HST_SRV25", (Exception)((Object)hostException));
                    }
                }
                catch (Throwable throwable) {
                    Object var19_15 = null;
                    if (directoryTable != null) {
                        directoryTable.close();
                    }
                    throw throwable;
                }
            }
            directoryTable.close();
            return n2;
        }
        Object var19_14 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        this.renameEthernetAddress(hostData, string);
        String[] stringArray = new String[]{hostData.getHostName(), string};
        this.writeLog(100, "LM_3006", "LM_3053", stringArray, null);
        return directoryRow.getNumberOfRows();
    }

    private int mapHostColumnToNum(String string) throws RemoteException, AdminException {
        if (string == null || string.length() == 0) {
            throw new HostException("EXM_HST_SRV99");
        }
        if (string.equals("hostListComputerName")) {
            return this.hostsColumnCname;
        }
        if (string.equals("hostListIPAddress")) {
            return this.hostsColumnAddr;
        }
        if (string.equals("hostListAliases")) {
            return this.hostsColumnAliases;
        }
        if (string.equals("hostListComment")) {
            return this.hostsColumnComment;
        }
        if (string.equals("hostListEnetAddress")) {
            throw new HostException("EXM_HST_SRV67");
        }
        throw new HostException("EXM_HST_SRV99");
    }

    private void checkRights(String string) throws HostAuthException {
        if (this.authsvc == null) {
            try {
                this.authsvc = (Authorization)this.inf.getServiceByName((class$com$sun$management$viper$services$Authorization == null ? (class$com$sun$management$viper$services$Authorization = HostMgrImpl.class$("com.sun.management.viper.services.Authorization")) : class$com$sun$management$viper$services$Authorization).getName());
            }
            catch (Exception exception) {
                throw new HostAuthException("EXM_HST_AUTHSVC_ERR", exception.getLocalizedMessage());
            }
        }
        this.userIdent = this.inf.getIdentity();
        this.perm = new VPermission(string);
        try {
            this.authsvc.checkPermission((Principal)this.userIdent, this.perm);
        }
        catch (Exception exception) {
            throw new HostAuthException("EXM_SERVER_NOT_AUTHORIZED");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StopWatch {
        Date startTime;
        Date stopTime;

        StopWatch() {
        }

        public void start() {
            this.startTime = new Date();
        }

        public long stop() {
            this.stopTime = new Date();
            return (this.stopTime.getTime() - this.startTime.getTime()) / 1000L;
        }
    }
}

