/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.replication.AgreementReader;
import com.netscape.admin.dirserv.panel.replication.AgreementResourceObject;
import com.netscape.admin.dirserv.panel.replication.AgreementTable;
import com.netscape.admin.dirserv.panel.replication.AgreementWizard;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.CIRAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationSettingPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.SIRAgreement;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.tree.MutableTreeNode;
import com.sun.java.swing.tree.TreeNode;
import com.sun.java.swing.tree.TreePath;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;

public class ReplicationResourceObject
extends ResourceObject
implements IMenuInfo {
    IDSModel _model;
    JFrame _frame;
    boolean _isLoaded;
    AgreementTable _agreements;
    Vector _dsInstances;
    static ReplicationResourceObject _self;
    ReplicationSettingPanel _panel;
    RemoteImage _groupIcon;
    RemoteImage _groupIconL;
    Vector _types = new Vector();
    private static ResourceSet _resource;
    static final String NEW = "new";
    static final String REFRESH = "refreshagreements";
    private static final int RO_CIR = 1;
    private static final int RO_SIR = 2;

    private ReplicationResourceObject(IDSModel model) {
        this._panel = new ReplicationSettingPanel(model);
        this._dsInstances = new Vector();
        this._isLoaded = false;
        _self = this;
        this._agreements = new AgreementTable();
        this._model = model;
        this.setAllowsChildren(true);
    }

    private ReplicationResourceObject(String sDisplayName, IDSModel model) {
        this(model);
        super.setName(sDisplayName);
    }

    public ReplicationResourceObject(String sDisplayName, RemoteImage icon, RemoteImage largeIcon, IDSModel model) {
        this(sDisplayName, model);
        super.setIcon((Icon)icon);
        this._groupIcon = icon;
        super.setLargeIcon((Icon)largeIcon);
        this._groupIconL = largeIcon;
        this._frame = model.getConsoleInfo().getFrame();
    }

    public Component getCustomPanel() {
        return this._panel;
    }

    public boolean run(IPage viewInstance) {
        Debug.println((String)"ReplicationResourceObject: run()");
        this.reload();
        if (super.getChildCount() != 0) {
            Debug.println((String)("[RO] Class is " + viewInstance.getClass().getName()));
            this.expandPath((ResourcePage)viewInstance);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage viewInstance, IResourceObject[] selectionList) {
        return this.run(viewInstance);
    }

    public void reload() {
        this.cleanTree();
        if (!ReplicationTool.authenticate((IDSModel)this._model)) {
            return;
        }
        AgreementReader reader = new AgreementReader(this, this._agreements);
        reader.readAgreements();
        if (reader.isSuccess()) {
            ResourceObject sir;
            ResourceObject cir;
            if (this._types.size() < 2) {
                cir = new repResourceObject(1, this, _resource.getString("replication-node-CIR", "label"), this._groupIcon, this._groupIconL);
                sir = new repResourceObject(2, this, _resource.getString("replication-node-SIR", "label"), this._groupIcon, this._groupIconL);
                this._types.addElement(cir);
                this._types.addElement(sir);
            } else {
                cir = (ResourceObject)this._types.elementAt(0);
                sir = (ResourceObject)this._types.elementAt(1);
            }
            this._agreements = reader.getAgreements();
            Enumeration e = this._agreements.elements();
            while (e.hasMoreElements()) {
                AgreementResourceObject res;
                Object obj = e.nextElement();
                if (obj instanceof CIRAgreement) {
                    Debug.println((String)"Add CIR Node");
                    res = new AgreementResourceObject(((ReplicationAgreement)obj).getNickname(), (Icon)ReplicationTool.getImage((String)"ds-rep-get-16.gif"), (Icon)ReplicationTool.getImage((String)"ds-rep-get-32.gif"), this);
                    res.setAgreement((ReplicationAgreement)((CIRAgreement)obj));
                    cir.add((MutableTreeNode)res);
                }
                if (obj instanceof SIRAgreement) {
                    Debug.println((String)"Add SIR Node");
                    res = new AgreementResourceObject(((ReplicationAgreement)obj).getNickname(), (Icon)ReplicationTool.getImage((String)"ds-rep-push-16.gif"), (Icon)ReplicationTool.getImage((String)"ds-rep-push-32.gif"), this);
                    res.setAgreement((ReplicationAgreement)((SIRAgreement)obj));
                    sir.add((MutableTreeNode)res);
                    continue;
                }
                Debug.println((String)("Class is " + obj.getClass().getName()));
            }
            this._isLoaded = true;
        } else {
            Debug.println((String)"ReplicationResourceObject: reload() - Loading Aborted");
            this.cleanTree();
            this._isLoaded = false;
        }
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public boolean isLeaf() {
        return false;
    }

    public int getChildCount() {
        if (!this.isLoaded()) {
            this.reload();
        }
        return this.isLoaded() ? 2 : -1;
    }

    public TreeNode getChildAt(int index) {
        if (!this.isLoaded()) {
            this.reload();
        }
        return (TreeNode)this._types.elementAt(index);
    }

    public String[] getMenuCategoryIDs() {
        if (this._model.isModuleDisabled("replication")) {
            return new String[0];
        }
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String category) {
        String section = "replication-node-agreementPopupMenu";
        return new IMenuItem[]{new MenuItemText(NEW, _resource.getString(section, "New"), _resource.getString(section, "New-description")), new MenuItemText(REFRESH, _resource.getString(section, "Refresh"), _resource.getString(section, "Refresh-description"))};
    }

    public void actionMenuSelected(IPage viewInstance, IMenuItem item) {
        Debug.println((String)("ARO: actionMenuSelected() " + viewInstance.toString()));
        if (item.getID().equals(NEW)) {
            if (!ReplicationTool.authenticate((IDSModel)this._model)) {
                return;
            }
            AgreementWizardInfo info = new AgreementWizardInfo();
            Debug.println((String)("RRO: ServerInfo" + this._model.getServerInfo()));
            Debug.println((String)("RRO: ServerInfo" + this._model.getConsoleInfo()));
            info.setServerInfo(this._model.getServerInfo());
            info.setConsoleInfo(this._model.getConsoleInfo());
            info.setParentNode((Object)this);
            info.setWizardType("NEW");
            info.setLDAPSchema(this._model.getSchema());
            AgreementWizard agreementWizard = new AgreementWizard(this._frame, info);
        }
        if (item.getID().equals(REFRESH)) {
            if (!ReplicationTool.authenticate((IDSModel)this._model)) {
                return;
            }
            Debug.println((String)"Refresh Selected");
            this.run(viewInstance);
        }
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged((ResourceObject)this);
    }

    private void expandPath(ResourcePage page) {
        TreePath path = new TreePath((Object[])this.getPath());
        page.expandTreePath(path);
    }

    private void cleanTree() {
        this._agreements.removeAll();
        this._types.removeAllElements();
    }

    static /* synthetic */ int access$1() {
        return 1;
    }

    static {
        _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    }

    class repResourceObject
    extends ResourceObject
    implements IMenuInfo {
        private int _type;
        ReplicationResourceObject _parent;

        repResourceObject(int type, ReplicationResourceObject parent, String s, RemoteImage small, RemoteImage large) {
            super(s, (Icon)small, (Icon)large);
            ReplicationResourceObject.this = ReplicationResourceObject.this;
            this._parent = parent;
            this._type = type;
        }

        public Component getCustomPanel() {
            return new JPanel();
        }

        public String[] getMenuCategoryIDs() {
            if (ReplicationResourceObject.this._model.isModuleDisabled("replication")) {
                return new String[0];
            }
            return new String[]{"OBJECT", "CONTEXT"};
        }

        public IMenuItem[] getMenuItems(String category) {
            String section = "replication-node-agreementPopupMenu";
            return new IMenuItem[]{new MenuItemText(ReplicationResourceObject.NEW, _resource.getString(section, "New"), _resource.getString(section, "New-description")), new MenuItemText(ReplicationResourceObject.REFRESH, _resource.getString(section, "Refresh"), _resource.getString(section, "Refresh-description"))};
        }

        public void actionMenuSelected(IPage viewInstance, IMenuItem item) {
            if (item.getID().equals(ReplicationResourceObject.NEW)) {
                if (!ReplicationTool.authenticate((IDSModel)ReplicationResourceObject.this._model)) {
                    return;
                }
                AgreementWizardInfo info = new AgreementWizardInfo();
                info.setServerInfo(ReplicationResourceObject.this._model.getServerInfo());
                info.setConsoleInfo(ReplicationResourceObject.this._model.getConsoleInfo());
                info.setParentNode((Object)this._parent);
                info.setWizardType("NEW");
                info.setLDAPSchema(ReplicationResourceObject.this._model.getSchema());
                if (this._type == ReplicationResourceObject.access$1()) {
                    info.setAgreementType("CIR");
                } else {
                    info.setAgreementType("SIR");
                }
                AgreementWizard agreementWizard = new AgreementWizard(ReplicationResourceObject.this._frame, info);
            }
            if (item.getID().equals(ReplicationResourceObject.REFRESH)) {
                if (!ReplicationTool.authenticate((IDSModel)ReplicationResourceObject.this._model)) {
                    return;
                }
                Debug.println((String)"Refresh Selected");
                this._parent.run(viewInstance);
            }
        }
    }
}

