/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.IDSResourceSelectionListener;
import com.netscape.admin.dirserv.panel.ContainerPanel;
import com.netscape.admin.dirserv.panel.DSDialog;
import com.netscape.admin.dirserv.panel.DSEntry;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.DSTabbedPanel;
import com.netscape.admin.dirserv.panel.IDSEntry;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JToggleButton;
import com.sun.java.swing.JToolTip;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.DocumentListener;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.text.Document;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPException;

public class BlankPanel
extends JPanel
implements ActionListener,
DocumentListener,
ItemListener,
ChangeListener,
ListSelectionListener,
IDSResourceSelectionListener {
    protected GridBagConstraints _gbc;
    private int _local = -1;
    private DSDialog _dlg;
    private AbstractDialog _abstractDlg;
    private ContainerPanel _parent;
    protected String _helpToken = "framework-menubar-index";
    private IDSModel _dsModel;
    private Hashtable _disabledComponents;
    String _title;
    protected JPanel _myPanel;
    private DSEntrySet _dsEntrySet;
    private boolean _dirtyFlag = false;
    private boolean _validFlag = true;
    protected boolean _isInitialized = false;
    protected boolean _disabled = false;
    static final boolean STRETCH_FIELDS = false;
    private boolean isValidChangeEvent = false;
    private Hashtable _componentMapDSEntryTable = new Hashtable();
    protected boolean _iconExist = false;
    protected static final boolean _verbose = false;
    public static final Color ORIG_COLOR = Color.black;
    public static final Color LABEL_MODIFIED = new Color(102, 102, 153);
    protected static final String _validsyntax = "abcdefghijklmnopqrstuvwxyz0123456789-_";

    public BlankPanel(IDSModel model, boolean scroll) {
        this(model, null, scroll);
    }

    public BlankPanel(IDSModel model) {
        this(model, true);
    }

    public BlankPanel(IDSModel model, String panelName, boolean scroll) {
        this._dsModel = model;
        this.prepareClientPanel(scroll);
        this._dsEntrySet = new DSEntrySet();
        String title = null;
        if (panelName != null) {
            title = DSUtil._resource.getString(panelName, "title");
            this._disabled = this.getModel().isModuleDisabled(panelName);
        }
        if (title == null) {
            title = "Missing Title";
        }
        this.setTitle(title);
    }

    public BlankPanel(IDSModel model, String panelName) {
        this(model, panelName, true);
    }

    private void prepareClientPanel(boolean scroll) {
        this.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this._myPanel = new JPanel();
        this._myPanel.setBorder((Border)new EmptyBorder(this.getBorderInsets()));
        GridBagConstraints gbc = this.getGBC();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        gbc = this.getGBC();
        boolean squish = false;
        if (squish) {
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.3;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            ((Container)((Object)this)).add(Box.createGlue(), gbc);
        }
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        if (scroll) {
            JScrollPane jscroll = new JScrollPane((Component)this._myPanel);
            jscroll.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
            ((Container)((Object)this)).add((Component)jscroll, gbc);
        } else {
            ((Container)((Object)this)).add((Component)this._myPanel, gbc);
        }
        if (squish) {
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.7;
            ((Container)((Object)this)).add(Box.createGlue(), gbc);
        }
    }

    protected void addBottomGlue() {
        GridBagConstraints gbc = this.getGBC();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this._myPanel.add(Box.createGlue(), gbc);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public void actionPerformed(ActionEvent e) {
        this.validateAll();
    }

    public void stateChanged(ChangeEvent e) {
        if (!(e.getSource() instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabs = (JTabbedPane)e.getSource();
        if (tabs.getComponentAt(tabs.getSelectedIndex()) == this) {
            this.select(null, null);
        } else if (this.isDirty()) {
            this.unselect(null, null);
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.validate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.validate(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.validate(e);
    }

    public void itemStateChanged(ItemEvent e) {
        this.validate(e);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.validateAll();
    }

    protected void validate(DocumentEvent e) {
        this.validateAll();
    }

    protected void validate(ItemEvent e) {
        this.validateAll();
    }

    protected void resetAll() {
        Enumeration values = this._componentMapDSEntryTable.elements();
        while (values.hasMoreElements()) {
            Vector v = (Vector)values.nextElement();
            Enumeration entries = v.elements();
            while (entries.hasMoreElements()) {
                DSEntry entry = (DSEntry)entries.nextElement();
                if (entry == null) continue;
                entry.reset();
            }
        }
        this.clearDirtyFlag();
    }

    protected void showAll() {
        Enumeration values = this._componentMapDSEntryTable.elements();
        while (values.hasMoreElements()) {
            Vector v = (Vector)values.nextElement();
            Enumeration entries = v.elements();
            while (entries.hasMoreElements()) {
                DSEntry entry = (DSEntry)entries.nextElement();
                if (entry == null) continue;
                entry.show();
            }
        }
    }

    private void validateAll() {
        int totalResult = 0;
        Enumeration components = this._componentMapDSEntryTable.keys();
        while (components.hasMoreElements()) {
            int thisResult = 0;
            JComponent comp = (JComponent)components.nextElement();
            Vector v = (Vector)this._componentMapDSEntryTable.get(comp);
            Enumeration entries = v.elements();
            while (entries.hasMoreElements()) {
                DSEntry entry = (DSEntry)entries.nextElement();
                if (entry == null) continue;
                int result = entry.doValidate();
                if ((result & 1) == 1) {
                    thisResult |= 1;
                }
                if ((result & 2) != 2) continue;
                thisResult |= 2;
            }
            switch (thisResult) {
                case 2: {
                    this.setColor(comp, (Color)UIManager.get((Object)"Label.modified"));
                    break;
                }
                case 3: {
                    this.setColor(comp, (Color)UIManager.get((Object)"Label.error"));
                    break;
                }
                case 0: {
                    this.resetColor(comp);
                    break;
                }
                case 1: {
                    this.setColor(comp, (Color)UIManager.get((Object)"Label.error"));
                    break;
                }
            }
            if ((thisResult & 1) == 1) {
                totalResult |= 1;
            }
            if ((thisResult & 2) != 2) continue;
            totalResult |= 2;
        }
        switch (totalResult) {
            case 0: {
                this.clearDirtyFlag();
                this.setValidFlag();
                break;
            }
            case 1: {
                this.clearDirtyFlagNoRepaint();
                this.setValidFlag();
                break;
            }
            case 2: {
                this.setDirtyFlag();
                this.setValidFlag();
                break;
            }
            case 3: {
                this.setDirtyFlag();
                this.clearValidFlag();
                break;
            }
        }
    }

    protected void disableAll(Container parent) {
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                this.disableAll((Container)children[i]);
            }
            children[i].setEnabled(false);
            if (children[i] instanceof JComponent) {
                JComponent comp = (JComponent)children[i];
                if (!(comp instanceof JPanel) && !(comp instanceof JLabel)) {
                    UIFactory.setToolTip((String)"general", (String)"disabled-feature", (JComponent)comp);
                } else {
                    comp.setToolTipText(null);
                }
            }
            ++i;
        }
    }

    void setColor(JComponent view, Color c) {
        if (view == null) {
            return;
        }
        Color currColor = view.getForeground();
        if (!c.equals(currColor)) {
            if (view instanceof JCheckBox || view instanceof JRadioButton) {
                JToggleButton button = (JToggleButton)view;
                button.setForeground(c);
                button.repaint();
            } else if (view instanceof JLabel) {
                JLabel l = (JLabel)view;
                l.setForeground(c);
                l.repaint();
            }
        }
    }

    void resetColor(JComponent view) {
        this.setColor(view, ORIG_COLOR);
    }

    protected void prepareDisabledComponents() {
        this._disabledComponents = new Hashtable();
        IDSModel model = this.getModel();
        DSEntrySet entries = this.getDSEntrySet();
        Enumeration keys = this._componentMapDSEntryTable.keys();
        while (keys.hasMoreElements()) {
            JComponent comp = (JComponent)keys.nextElement();
            Vector v = (Vector)this._componentMapDSEntryTable.get(comp);
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                DSEntry entry = (DSEntry)en.nextElement();
                String attrName = entries.getAttributeForEntry((IDSEntry)entry);
                if (attrName == null || !model.isAttributeDisabled(attrName)) continue;
                Debug.println((String)("BlankPanel.preparedisabledComponents: adding " + attrName));
                int i = 0;
                while (i < entry.getViewCount()) {
                    this._disabledComponents.put(entry.getView(i), "true");
                    ++i;
                }
            }
        }
    }

    protected void disableAttributes() {
        Enumeration keys = this._componentMapDSEntryTable.keys();
        while (keys.hasMoreElements()) {
            JComponent comp = (JComponent)keys.nextElement();
            Vector v = (Vector)this._componentMapDSEntryTable.get(comp);
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                DSEntry entry = (DSEntry)en.nextElement();
                int i = 0;
                while (i < entry.getViewCount()) {
                    JComponent c = entry.getView(i);
                    if (this._disabledComponents.containsKey(c)) {
                        c.setEnabled(false);
                        UIFactory.setToolTip((String)"general", (String)"disabled-feature", (JComponent)c);
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isDirty() {
        return this._dirtyFlag;
    }

    public boolean isValid() {
        return this._validFlag;
    }

    public void okCallback() {
        block6: {
            if (!this.isDirty()) break block6;
            boolean status = false;
            try {
                try {
                    this.getModel().setWaitCursor(true);
                    status = this._dsEntrySet.store(this._dsModel);
                    if (!status) {
                        Debug.println((String)"BlankPanel.okCallback: Error saving changes.");
                    }
                }
                catch (LDAPException lde) {
                    status = this.processSaveErrors(lde);
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.getModel().setWaitCursor(false);
                throw throwable;
            }
            this.getModel().setWaitCursor(false);
            if (status) {
                this.clearDirtyFlag();
            }
        }
    }

    protected boolean processSaveErrors(LDAPException lde) {
        JFrame frame = this.getModel().getServerInfo().getFrame();
        if (lde.getLDAPResultCode() == 52) {
            DSUtil.showErrorDialog((Component)frame, (String)"updating-server-unavailable", (String)"");
        } else {
            DSUtil.showLDAPErrorDialog((Component)frame, (LDAPException)lde, (String)"updating-directory-title");
        }
        Debug.println((String)("BlankPanel.processSaveErrors: " + (Object)((Object)lde)));
        return false;
    }

    protected boolean processReadErrors(LDAPException lde) {
        JFrame frame = this.getModel().getServerInfo().getFrame();
        if (lde.getLDAPResultCode() == 52) {
            DSUtil.showErrorDialog((Component)frame, (String)"fetching-server-unavailable", (String)"");
        } else {
            DSUtil.showLDAPErrorDialog((Component)frame, (LDAPException)lde, (String)"fetching-directory");
        }
        Debug.println((String)("BlankPanel.processReadErrors: " + (Object)((Object)lde)));
        return false;
    }

    public void resetCallback() {
        if (this.isDirty() && this.refresh()) {
            this.clearDirtyFlag();
        }
    }

    public void helpCallback() {
        DSUtil.help((String)this._helpToken);
    }

    protected void setDirtyFlag() {
        this._dirtyFlag = true;
        if (this._parent != null) {
            this._parent.setDirtyFlag((JPanel)this);
        }
    }

    public void setParent(ContainerPanel parent) {
        this._parent = parent;
    }

    protected ContainerPanel getParentPanel() {
        return this._parent;
    }

    protected DSTabbedPanel getTabbedPanel() {
        return (DSTabbedPanel)this._parent;
    }

    protected void clearDirtyFlag() {
        this._dirtyFlag = false;
        Enumeration values = this._componentMapDSEntryTable.elements();
        while (values.hasMoreElements()) {
            Vector v = (Vector)values.nextElement();
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                DSEntry entry = (DSEntry)en.nextElement();
                this.resetColor(entry.getView(entry.getViewCount() - 1));
            }
        }
        if (this._parent != null) {
            this._parent.clearDirtyFlag((JPanel)this);
        }
    }

    protected void clearDirtyFlagNoRepaint() {
        this._dirtyFlag = false;
        if (this._parent != null) {
            this._parent.clearDirtyFlag((JPanel)this);
        }
    }

    protected void setValidFlag() {
        this._validFlag = true;
        if (this._parent != null) {
            this._parent.setValidFlag((JPanel)this);
        }
    }

    protected void clearValidFlag() {
        this._validFlag = false;
        if (this._parent != null) {
            this._parent.clearValidFlag((JPanel)this);
        }
    }

    protected void setIconExist(boolean b) {
        this._iconExist = b;
    }

    protected boolean getIconExist() {
        return this._iconExist;
    }

    public void select(IResourceObject parent, IPage viewInstance) {
        if (!this._isInitialized) {
            this.getModel().setWaitCursor(true);
            this.init();
            this.prepareDisabledComponents();
            this.getModel().setWaitCursor(false);
            this._isInitialized = true;
            this.clearDirtyFlag();
        } else if (this.isDirty()) {
            return;
        }
        if (this.refresh()) {
            this.clearDirtyFlag();
        }
    }

    public void init() {
    }

    public void unselect(IResourceObject parent, IPage viewInstance) {
    }

    public void setDialog(DSDialog dialog) {
        this._dlg = dialog;
    }

    public boolean refresh() {
        DSEntrySet set = this.getDSEntrySet();
        boolean status = true;
        if (this._disabled) {
            this.disableAll((Container)((Object)this));
        }
        if (set != null) {
            try {
                try {
                    this.getModel().setWaitCursor(true);
                    set.show(this._dsModel);
                    this.clearDirtyFlag();
                }
                catch (LDAPException lde) {
                    Debug.println((String)("BlankPanel.refresh: could not get attributes from directory for " + set.getConfigDN() + ": " + (Object)((Object)lde)));
                    status = this.processReadErrors(lde);
                }
                Object var4_4 = null;
                this.disableAttributes();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.disableAttributes();
                this.getModel().setWaitCursor(false);
                throw throwable;
            }
            this.getModel().setWaitCursor(false);
        }
        return status;
    }

    protected JPanel layoutHorizontalComponents(JComponent[] components) {
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout((LayoutManager)new BoxLayout((Container)boxPanel, 0));
        boxPanel.setAlignmentX(0.0f);
        boxPanel.setAlignmentY(0.0f);
        int i = 0;
        while (i < components.length) {
            boxPanel.add((Component)components[i]);
            if (i < components.length - 1) {
                boxPanel.add(Box.createHorizontalStrut((int)6));
            }
            ++i;
        }
        boxPanel.add(Box.createGlue());
        return boxPanel;
    }

    protected void addEntryField(JPanel panel, JComponent label, JComponent field, JLabel label2) {
        Component endGlue;
        Component lastItem = endGlue = Box.createGlue();
        GridBagConstraints gbc = this.getGBC();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.anchor = 13;
        int space = UIFactory.getComponentSpace();
        gbc.insets = new Insets(space, space, 0, space / 2);
        panel.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        gbc.insets = new Insets(space, 0, 0, 0);
        gbc.gridwidth = lastItem == field ? 0 : 1;
        panel.add((Component)field, gbc);
        if (label2 != null) {
            ++gbc.gridx;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(space, space / 2, 0, 0);
            gbc.gridwidth = lastItem == label2 ? 0 : 1;
            panel.add((Component)label2, gbc);
        }
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        panel.add(endGlue, gbc);
    }

    protected void addEntryField(JPanel panel, JComponent label, JComponent field) {
        this.addEntryField(panel, label, field, null);
    }

    protected void setDSEntrySet(DSEntrySet set) {
        this._dsEntrySet = set;
    }

    protected DSEntrySet getDSEntrySet() {
        return this._dsEntrySet;
    }

    protected IDSModel getModel() {
        return this._dsModel;
    }

    public void setComponentTable(Object key, Object value) {
        if (value instanceof DSEntry) {
            DSEntry entry = (DSEntry)value;
            JComponent comp = entry.getView(entry.getViewCount() - 1);
            if (comp == null) {
                Debug.println((String)("BlankPanel.setComponentTable: no view for " + entry));
                return;
            }
            Vector<Object> v = (Vector<Object>)this._componentMapDSEntryTable.get(comp);
            if (v == null) {
                v = new Vector<Object>();
            }
            if (!v.contains(value)) {
                v.addElement(value);
            }
            this._componentMapDSEntryTable.put(comp, v);
        }
    }

    protected DSDialog getDialog() {
        if (this._dlg == null) {
            Container p = ((Component)((Object)this)).getParent();
            while (p != null) {
                if (p instanceof DSDialog) {
                    this._dlg = (DSDialog)p;
                    break;
                }
                p = p.getParent();
            }
        }
        return this._dlg;
    }

    protected void hideDialog() {
        DSDialog d = this.getDialog();
        if (d != null) {
            d.setVisible(false);
            d.dispose();
        } else {
            this.hideAbstractDialog();
        }
    }

    protected AbstractDialog getAbstractDialog() {
        if (this._abstractDlg == null) {
            Container p = ((Component)((Object)this)).getParent();
            while (p != null) {
                if (p instanceof AbstractDialog) {
                    this._abstractDlg = (AbstractDialog)p;
                    break;
                }
                Debug.println((int)8, (String)("BlankPanel.getAbstractDialog: class of p = " + p.getClass()));
                p = p.getParent();
            }
        }
        return this._abstractDlg;
    }

    protected void hideAbstractDialog() {
        AbstractDialog d = this.getAbstractDialog();
        if (d != null) {
            d.setVisible(false);
            d.dispose();
        }
    }

    protected GridBagConstraints getGBC() {
        this.resetGBC();
        return this._gbc;
    }

    protected void resetGBC() {
        if (this._gbc == null) {
            this._gbc = new GridBagConstraints();
        }
        this._gbc.gridwidth = 1;
        this._gbc.gridheight = 1;
        this._gbc.fill = 0;
        this._gbc.ipady = 0;
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 0.0;
        this._gbc.insets = this.getComponentInsets();
        this._gbc.insets.bottom = 0;
        this._gbc.insets.right = 0;
        this._gbc.anchor = 17;
        this._gbc.gridx = -1;
        this._gbc.gridy = -1;
    }

    protected boolean isLocal() {
        if (this._local == -1) {
            String host = this.getModel().getServerInfo().getHost();
            try {
                this._local = 0;
                InetAddress hostAddress = InetAddress.getByName(host);
                InetAddress clientAddress = InetAddress.getLocalHost();
                byte[] hostIP = hostAddress.getAddress();
                byte[] clientIP = clientAddress.getAddress();
                if (hostAddress.equals(clientAddress) || host.equals("localhost")) {
                    this._local = 1;
                }
            }
            catch (UnknownHostException uhe) {
                Debug.println((String)("Unkown host for: " + host + " uhe: " + uhe.toString()));
            }
        }
        return this._local == 1;
    }

    protected boolean isValidSchemaSyntax(String tok) {
        StringCharacterIterator iter = new StringCharacterIterator(tok, 0);
        char c = iter.first();
        while (c != '\uffff') {
            if (_validsyntax.indexOf(Character.toLowerCase(c)) == -1) {
                return false;
            }
            c = iter.next();
        }
        return true;
    }

    protected String getInstanceDirectory() {
        return (String)this.getModel().getServerInfo().get("serverroot");
    }

    protected static boolean requiresConfirmation(String item) {
        return DSUtil.requiresConfirmation((String)item);
    }

    protected static SimpleDialog createDialog(JComponent comp, BlankPanel child) {
        SimpleDialog dlg = new SimpleDialog(null, child.getTitle(), 1, child);
        dlg.setComponent((Component)comp);
        dlg.setDefaultButton(1);
        dlg.pack();
        dlg.setLocation(200, 200);
        return dlg;
    }

    protected static SimpleDialog createDialog(BlankPanel child) {
        return BlankPanel.createDialog((JComponent)child, child);
    }

    protected JLabel makeJLabel(Icon i, String s, int a) {
        return UIFactory.makeJLabel((Icon)i, (String)s, (int)a);
    }

    protected JLabel makeJLabel() {
        return this.makeJLabel(null, null, -1);
    }

    protected JLabel makeJLabel(Icon i) {
        return this.makeJLabel(i, null, -1);
    }

    protected JLabel makeJLabel(Icon i, int a) {
        return this.makeJLabel(i, null, a);
    }

    protected JLabel makeJLabel(String s) {
        return this.makeJLabel(null, s, -1);
    }

    protected JLabel makeJLabel(String s, int a) {
        return this.makeJLabel(null, s, a);
    }

    protected JLabel makeJLabel(String panelname, String keyword, int a, ResourceSet resource) {
        return UIFactory.makeJLabel((String)panelname, (String)keyword, (int)a, (ResourceSet)resource);
    }

    protected JLabel makeJLabel(String panelname, String keyword, ResourceSet resource) {
        return this.makeJLabel(panelname, keyword, -1, resource);
    }

    protected JLabel makeJLabel(String panelname, String keyword) {
        return this.makeJLabel(panelname, keyword, -1, null);
    }

    protected JTextArea makeMultiLineLabel(int rows, int cols) {
        return UIFactory.makeMultiLineLabel((int)rows, (int)cols);
    }

    protected JTextArea makeMultiLineLabel(int rows, int cols, String text) {
        return UIFactory.makeMultiLineLabel((int)rows, (int)cols, (String)text);
    }

    protected JTextField makeJTextField(Document d, String s, int len) {
        return UIFactory.makeJTextField((Object)this, (Document)d, (String)s, (int)len);
    }

    protected JTextField makeJTextField() {
        return this.makeJTextField(null, null, -1);
    }

    protected JTextField makeJTextField(int len) {
        return this.makeJTextField(null, null, len);
    }

    protected JTextField makeJTextField(String s) {
        return this.makeJTextField(null, s, -1);
    }

    protected JTextField makeJTextField(String s, int len) {
        return this.makeJTextField(null, s, len);
    }

    protected JTextField makeJTextField(String panelname, String keyword, String defval, int defcols, ResourceSet resource) {
        return UIFactory.makeJTextField((Object)this, (String)panelname, (String)keyword, (String)defval, (int)defcols, (ResourceSet)resource);
    }

    protected JTextField makeJTextField(String panelname, String keyword, String defval, int defcols) {
        return this.makeJTextField(panelname, keyword, defval, defcols, null);
    }

    protected JTextField makeJTextField(String panelname, String keyword, ResourceSet resource) {
        return this.makeJTextField(panelname, keyword, null, -1, resource);
    }

    protected JTextField makeJTextField(String panelname, String keyword) {
        return this.makeJTextField(panelname, keyword, null);
    }

    protected JTextField makeNumericalJTextField(Document d, String s, int len) {
        return UIFactory.makeNumericalJTextField((Object)this, (Document)d, (String)s, (int)len);
    }

    protected JTextField makeNumericalJTextField() {
        return this.makeNumericalJTextField(null, null, -1);
    }

    protected JTextField makeNumericalJTextField(int len) {
        return this.makeNumericalJTextField(null, null, len);
    }

    protected JTextField makeNumericalJTextField(String s) {
        return this.makeNumericalJTextField(null, s, -1);
    }

    protected JTextField makeNumericalJTextField(String s, int len) {
        return this.makeNumericalJTextField(null, s, len);
    }

    protected JTextField makeNumericalJTextField(String panelname, String keyword, String defval, int defcols, ResourceSet resource) {
        return UIFactory.makeNumericalJTextField((Object)this, (String)panelname, (String)keyword, (String)defval, (int)defcols, (ResourceSet)resource);
    }

    protected JTextField makeNumericalJTextField(String panelname, String keyword, String defval, int defcols) {
        return this.makeNumericalJTextField(panelname, keyword, defval, defcols, null);
    }

    protected JTextField makeNumericalJTextField(String panelname, String keyword, ResourceSet resource) {
        return this.makeNumericalJTextField(panelname, keyword, null, -1, resource);
    }

    protected JTextField makeNumericalJTextField(String panelname, String keyword) {
        return this.makeNumericalJTextField(panelname, keyword, null);
    }

    protected JPasswordField makeJPasswordField() {
        return this.makeJPasswordField(null, null, -1);
    }

    protected JPasswordField makeJPasswordField(Document d, String s, int len) {
        return UIFactory.makeJPasswordField((Object)this, (Document)d, (String)s, (int)len);
    }

    protected JPasswordField makeJPasswordField(int len) {
        return this.makeJPasswordField(null, null, len);
    }

    protected JPasswordField makeJPasswordField(String s) {
        return this.makeJPasswordField(null, s, -1);
    }

    protected JPasswordField makeJPasswordField(String s, int len) {
        return this.makeJPasswordField(null, s, len);
    }

    protected JPasswordField makeJPasswordField(String panelname, String keyword, String defval, int defcols, ResourceSet resource) {
        return UIFactory.makeJPasswordField((Object)this, (String)panelname, (String)keyword, (String)defval, (int)defcols, (ResourceSet)resource);
    }

    protected JPasswordField makeJPasswordField(String panelname, String keyword, String defval, int defcols) {
        return this.makeJPasswordField(panelname, keyword, defval, defcols, null);
    }

    protected JButton makeJButton(String s, Icon i) {
        return UIFactory.makeJButton((Object)this, (String)s, (Icon)i);
    }

    protected JButton makeJButton() {
        return this.makeJButton((String)null, (Icon)null);
    }

    protected JButton makeJButton(String s) {
        return this.makeJButton(s, (Icon)null);
    }

    protected JButton makeJButton(Icon i) {
        return this.makeJButton(null, i);
    }

    protected JButton makeJButton(String panelname, String keyword, ResourceSet resource) {
        return UIFactory.makeJButton((Object)this, (String)panelname, (String)keyword, (ResourceSet)resource);
    }

    protected JButton makeJButton(String panelname, String keyword) {
        return this.makeJButton(panelname, keyword, null);
    }

    protected JCheckBox makeJCheckBox(String s, Icon i, boolean b) {
        return UIFactory.makeJCheckBox((Object)this, (String)s, (Icon)i, (boolean)b);
    }

    protected JCheckBox makeJCheckBox() {
        return this.makeJCheckBox((String)null, (Icon)null, false);
    }

    protected JCheckBox makeJCheckBox(Icon i) {
        return this.makeJCheckBox(null, i, false);
    }

    protected JCheckBox makeJCheckBox(Icon i, boolean b) {
        return this.makeJCheckBox(null, i, b);
    }

    protected JCheckBox makeJCheckBox(String s) {
        return this.makeJCheckBox(s, (Icon)null, false);
    }

    protected JCheckBox makeJCheckBox(String s, boolean b) {
        return this.makeJCheckBox(s, (Icon)null, b);
    }

    protected JCheckBox makeJCheckBox(String s, Icon i) {
        return this.makeJCheckBox(s, i, false);
    }

    protected JCheckBox makeJCheckBox(String panelname, String keyword, boolean defval, ResourceSet resource) {
        return UIFactory.makeJCheckBox((Object)this, (String)panelname, (String)keyword, (boolean)defval, (ResourceSet)resource);
    }

    protected JCheckBox makeJCheckBox(String panelname, String keyword, boolean defval) {
        return this.makeJCheckBox(panelname, keyword, defval, null);
    }

    protected JCheckBox makeJCheckBox(String panelname, String keyword) {
        return this.makeJCheckBox(panelname, keyword, false);
    }

    protected JComboBox makeJComboBox(ComboBoxModel cbm) {
        return UIFactory.makeJComboBox((Object)this, (ComboBoxModel)cbm);
    }

    protected JComboBox makeJComboBox() {
        return this.makeJComboBox(null);
    }

    protected JComboBox makeJComboBox(String panelname, String keyword, String defval, ResourceSet resource) {
        return UIFactory.makeJComboBox((Object)this, (String)panelname, (String)keyword, (String)defval, (ResourceSet)resource);
    }

    protected JComboBox makeJComboBox(String panelname, String keyword, String defval) {
        return this.makeJComboBox(panelname, keyword, defval, null);
    }

    protected JList makeJList(Vector listData) {
        return UIFactory.makeJList((Object)this, (Vector)listData);
    }

    protected JList makeJList(String panelname, String keyword, String defval, ResourceSet resource) {
        return UIFactory.makeJList((Object)this, (String)panelname, (String)keyword, (String)defval, (ResourceSet)resource);
    }

    protected JList makeJList(String panelname, String keyword, String defval) {
        return this.makeJList(panelname, keyword, defval, null);
    }

    protected JRadioButton makeJRadioButton(String s, Icon i, boolean b) {
        return UIFactory.makeJRadioButton((Object)this, (String)s, (Icon)i, (boolean)b);
    }

    protected JRadioButton makeJRadioButton() {
        return this.makeJRadioButton((String)null, (Icon)null, false);
    }

    protected JRadioButton makeJRadioButton(Icon i) {
        return this.makeJRadioButton(null, i, false);
    }

    protected JRadioButton makeJRadioButton(Icon i, boolean b) {
        return this.makeJRadioButton(null, i, b);
    }

    protected JRadioButton makeJRadioButton(String s) {
        return this.makeJRadioButton(s, (Icon)null, false);
    }

    protected JRadioButton makeJRadioButton(String s, boolean b) {
        return this.makeJRadioButton(s, (Icon)null, b);
    }

    protected JRadioButton makeJRadioButton(String panelname, String keyword, boolean defvalue, ResourceSet resource) {
        return UIFactory.makeJRadioButton((Object)this, (String)panelname, (String)keyword, (boolean)defvalue, (ResourceSet)resource);
    }

    protected JRadioButton makeJRadioButton(String panelname, String keyword) {
        return this.makeJRadioButton(panelname, keyword, false);
    }

    protected JRadioButton makeJRadioButton(String panelname, String keyword, boolean defvalue) {
        return this.makeJRadioButton(panelname, keyword, defvalue, null);
    }

    protected JRadioButton makeJRadioButton(String s, Icon i) {
        return this.makeJRadioButton(s, i, false);
    }

    protected JToolTip makeJToolTip(String s) {
        return UIFactory.makeJToolTip((String)s);
    }

    protected void setToolTip(String panelname, String keyword, JComponent w, ResourceSet resource) {
        UIFactory.setToolTip((String)panelname, (String)keyword, (JComponent)w, (ResourceSet)resource);
    }

    protected void setToolTip(String panelname, String keyword, JComponent w) {
        this.setToolTip(panelname, keyword, w, null);
    }

    protected JToolTip makeJToolTip() {
        return this.makeJToolTip(null);
    }

    protected Insets getStdInsets() {
        return UIFactory.getStdInsets();
    }

    protected Insets getBorderInsets() {
        return UIFactory.getBorderInsets();
    }

    protected Insets getComponentInsets() {
        return UIFactory.getComponentInsets();
    }

    protected Insets getTextInsets() {
        return UIFactory.getTextInsets();
    }
}

