/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.simpleadapter.memory;

import com.sun.database.simpleadapter.memory.MemoryBTree;
import com.sun.database.simpleadapter.memory.MemoryObjectStore;
import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.NoSuchObjectException;
import com.sun.database.simpledatabase.SimpleDatabasePrtl;
import com.sun.database.util.HierarchicalField;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class MemoryAdapter
extends SimpleDatabasePrtl
implements Serializable {
    private static final String sccs_id = "1.6";
    int fieldCount = 0;
    MemoryObjectStore objectStore;

    public MemoryAdapter() {
    }

    public MemoryAdapter(Class clazz, String[] stringArray) throws NoSuchFieldException, SecurityException {
        this.initializeDatabase(clazz, stringArray);
    }

    public void initializeDatabase(Class clazz, String[] stringArray) throws NoSuchFieldException, SecurityException {
        this.keyFieldStrings = stringArray;
        this.fieldCount = stringArray.length;
        if (this.fieldCount == 0) {
            throw new NoSuchFieldException("No key fields specified. Use a Vector.");
        }
        this.objectStore = new MemoryObjectStore(clazz);
        this.keyFields = new HierarchicalField[this.fieldCount];
        this.keyTree = new MemoryBTree[this.fieldCount];
        int n = 0;
        while (n < this.fieldCount) {
            try {
                this.keyFields[n] = new HierarchicalField(stringArray[n], clazz);
                this.keyTree[n] = new MemoryBTree(this.objectStore, this.keyFields[n]);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NoSuchFieldException("Invalid key field.");
            }
            ++n;
        }
    }

    public void destroyDatabase() throws IllegalAccessException {
        this.objectStore.destroyObjectStore();
        this.objectStore = null;
        int n = 0;
        while (n < this.keyTree.length) {
            try {
                this.keyTree[n].destroyAccessMethod();
                this.keyTree[n] = null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new DatabaseError(arrayIndexOutOfBoundsException, "MemoryDatabase.destroyDatabase: field array miscalculation.");
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int addObject(Object var1_1) throws DuplicateEntryException, IllegalAccessException {
        var2_2 = this.objectStore.insertObject(var1_1);
        var3_3 = 0;
        while (var3_3 < this.keyTree.length) {
            try {
                this.keyTree[var3_3].insertLink(var2_2);
            }
            catch (ArrayIndexOutOfBoundsException var4_7) {
                throw new DatabaseError(var4_7, "MemoryDatabase.addObject: field array miscalculation.");
            }
            catch (DuplicateEntryException var5_8) {
                ** while (--var3_3 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.keyTree[var3_3].removeLink(var2_2);
                }
                catch (NoSuchObjectException var6_6) {
                    // empty catch block
                }
                continue;
            }
lbl17:
            // 1 sources

            this.objectStore.removeObject(var2_2);
            throw new DuplicateEntryException();
            catch (Exception var6_4) {
                // empty catch block
            }
            ++var3_3;
        }
        return var2_2;
    }

    public synchronized void deleteObject(int n) throws NoSuchObjectException, IllegalAccessException {
        try {
            int n2 = 0;
            while (n2 < this.keyTree.length) {
                this.keyTree[n2].removeLink(n);
                ++n2;
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.objectStore.removeObject(n);
    }

    public Object findObject(int n, Object object) throws NoSuchObjectException {
        int n2 = this.keyTree[n].findLink(object);
        return this.objectStore.getObject(n2);
    }

    public Object findObject(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findObject(this.findMatchingKeyfield(string, this.keyFieldStrings), object);
    }

    public int findObjectHandle(int n, Object object) throws ArrayIndexOutOfBoundsException, NoSuchObjectException {
        return this.keyTree[n].findLink(object);
    }

    public int findObjectHandle(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findObjectHandle(this.findMatchingKeyfield(string, this.keyFieldStrings), object);
    }

    public Enumeration findList(int n, Object object) throws ArrayIndexOutOfBoundsException, NoSuchObjectException {
        return this.keyTree[n].findEnumeration(object);
    }

    public Enumeration findList(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findList(this.findMatchingKeyfield(string, this.keyFieldStrings), object);
    }

    public Object getObject(int n) {
        return this.objectStore.getObject(n);
    }

    public Enumeration elements() {
        return this.objectStore.elements();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = 0;
        while (n < this.keyFieldStrings.length) {
            objectOutputStream.writeObject(this.keyFieldStrings[n]);
            ++n;
        }
        n = 0;
        while (n < this.keyTree.length) {
            objectOutputStream.writeObject(this.keyTree[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.keyFieldStrings = new String[this.fieldCount];
        this.keyFields = new HierarchicalField[this.fieldCount];
        this.keyTree = new MemoryBTree[this.fieldCount];
        int n = 0;
        while (n < this.fieldCount) {
            this.keyFieldStrings[n] = (String)objectInputStream.readObject();
            ++n;
        }
        Class clazz = this.objectStore.getClassInStore();
        int n2 = 0;
        while (n2 < this.fieldCount) {
            try {
                this.keyFields[n2] = new HierarchicalField(this.keyFieldStrings[n2], clazz);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            ++n2;
        }
        n = 0;
        while (n < this.fieldCount) {
            this.keyTree[n] = (MemoryBTree)objectInputStream.readObject();
            ++n;
        }
    }
}

