/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class ServletOutputStream
extends OutputStream {
    private static final String LSTRING_FILE = "javax.servlet.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.LocalStrings");

    protected ServletOutputStream() {
    }

    public void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ((c & 0xFF00) != 0) {
                String string2 = lStrings.getString("err.not_iso8859_1");
                Object[] objectArray = new Object[]{new Character(c)};
                string2 = MessageFormat.format(string2, objectArray);
                throw new CharConversionException(string2);
            }
            this.write(c);
        }
    }

    public void print(boolean bl) throws IOException {
        String string = bl ? lStrings.getString("value.true") : lStrings.getString("value.false");
        this.print(string);
    }

    public void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    public void print(int n) throws IOException {
        this.print(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }
}

