/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.Content;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.VHostMgr;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HostRenameDialog
extends AdminDialog {
    private HostData originalHostObj;
    private JLabel oldNameLabel;
    private JLabel newNameLabel;
    private JLabel ipAddressLabel;
    private JLabel ipAddress;
    private JLabel descriptionLabel;
    private JTextArea description;
    private ISOLatinField hostName;
    private ResourceBundle bundle;
    private VHostMgr theApp;
    private Boolean applyInProgress = new Boolean(false);

    public HostRenameDialog(VHostMgr vHostMgr, JFrame jFrame, HostData hostData) {
        super((Frame)jFrame, "", true);
        this.theApp = vHostMgr;
        this.bundle = vHostMgr.getResourceBundle();
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"RenameHost"));
        GenInfoPanel genInfoPanel = this.getInfoPanel();
        Vector vector = new Vector(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(this.bundle, "OldHostName");
        this.oldNameLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)jPanel, (Component)this.oldNameLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)20, (int)5, (int)10, (int)5);
        this.oldNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.oldNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        JLabel jLabel = new JLabel(hostData.getHostName());
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)1, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)20, (int)0, (int)10, (int)5);
        jLabel.setForeground(Constants.PROPS_RO_VALUE_COLOR);
        jLabel.setFont(Constants.PROPS_RO_VALUE_FONT);
        actionString = new ActionString(this.bundle, "NewHostName");
        this.newNameLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)jPanel, (Component)this.newNameLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        this.newNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.newNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.hostName = new ISOLatinField(24, "", 16);
        Constraints.constrain((Container)jPanel, (Component)this.hostName, (int)1, (int)-1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        this.hostName.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.hostName.addFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_rename_name")));
        this.hostName.requestFocus();
        this.newNameLabel.setLabelFor((Component)this.hostName);
        this.newNameLabel.setDisplayedMnemonic(actionString.getMnemonic());
        actionString = new ActionString(this.bundle, "GenPropsNetAddr");
        this.ipAddressLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)jPanel, (Component)this.ipAddressLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        this.ipAddressLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.ipAddressLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.ipAddressLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.ipAddress = new JLabel(hostData.getNetworkAddress());
        Constraints.constrain((Container)jPanel, (Component)this.ipAddress, (int)1, (int)-1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        this.ipAddress.setFont(Constants.PROPS_RO_VALUE_FONT);
        this.ipAddress.setForeground(Constants.PROPS_RO_VALUE_COLOR);
        this.ipAddressLabel.setLabelFor(this.ipAddress);
        actionString = new ActionString(this.bundle, "GenPropsDescription");
        this.descriptionLabel = new JLabel(actionString.getString());
        Constraints.constrain((Container)jPanel, (Component)this.descriptionLabel, (int)0, (int)-1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)5, (int)10, (int)5);
        this.descriptionLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.descriptionLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.descriptionLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.description = new JTextArea(hostData.getDescription(), 3, 24);
        this.description.setLineWrap(true);
        this.description.setEditable(false);
        this.description.setFont(Constants.PROPS_RO_VALUE_FONT);
        this.description.setForeground(Constants.PROPS_RO_VALUE_COLOR);
        this.description.setBackground(this.getBackground());
        this.descriptionLabel.setLabelFor(this.description);
        JScrollPane jScrollPane = new JScrollPane(this.description, 20, 31);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)jScrollPane, (int)1, (int)-1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)10, (int)5);
        Constraints.constrain((Container)jPanel, (Component)new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), (int)0, (int)-1, (int)1, (int)0, (int)3, (int)18, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        Font font = jPanel.getFont();
        FontMetrics fontMetrics = jPanel.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        this.getRightPanel().add("Center", jPanel);
        JButton jButton = this.getOKBtn();
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Boolean bl = HostRenameDialog.this.applyInProgress;
                synchronized (bl) {
                    if (HostRenameDialog.this.applyInProgress.booleanValue()) {
                        return;
                    }
                    HostRenameDialog.this.applyInProgress = Boolean.TRUE;
                }
                Thread thread = new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            1.access$100(this.this$1).onApply();
                            1.access$100(this.this$1).dispose();
                        }
                        catch (HostException hostException) {
                            // empty catch block
                        }
                        Boolean bl = HostRenameDialog.access$000(1.access$100(this.this$1));
                        synchronized (bl) {
                            HostRenameDialog.access$002(1.access$100(this.this$1), Boolean.FALSE);
                        }
                    }
                };
                thread.start();
            }

            static /* synthetic */ HostRenameDialog access$100(1 var0) {
                return var0.HostRenameDialog.this;
            }
        });
        JButton jButton2 = this.getCancelBtn();
        jButton2.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Boolean bl = HostRenameDialog.this.applyInProgress;
                synchronized (bl) {
                    if (HostRenameDialog.this.applyInProgress.booleanValue()) {
                        return;
                    }
                }
                HostRenameDialog.this.dispose();
            }
        });
        this.getbuttonPanel().remove(this.getApplyBtn());
        this.pack();
        this.setDefaultFocusListener((FocusListener)((Object)new HostMgrContextHelpListener(vHostMgr, vector, genInfoPanel, "dlg_rename_overview")), true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        this.originalHostObj = hostData;
    }

    public void onApply() throws HostException {
        HostData hostData = new HostData();
        hostData.setHostName(this.hostName.getText());
        hostData.setDescription(this.originalHostObj.getDescription());
        hostData.setNetworkAddress(this.originalHostObj.getNetworkAddress());
        hostData.setAliases(this.originalHostObj.getAliases());
        hostData.setEthernetAddress(this.originalHostObj.getEthernetAddress());
        Vector vector = this.theApp.getTree().getCurrentContent().getDataCache();
        ProgressPanel progressPanel = new ProgressPanel(this.theApp.getFrame(), 3, 30, false);
        if (hostData.getHostName().length() == 0) {
            this.hostName.requestFocus();
            HostException hostException = new HostException("EXM_HST_GUI_MISSING_PROPS_VALUE", this.newNameLabel.getText().substring(0, this.newNameLabel.getText().length() - 1));
            this.theApp.reportErrorException((Exception)((Object)hostException));
            throw hostException;
        }
        try {
            HostData.validateHostName(this.hostName.getText());
        }
        catch (HostException hostException) {
            this.hostName.requestFocus();
            this.theApp.reportErrorException((Exception)((Object)hostException));
            throw hostException;
        }
        try {
            Object object;
            Object object2;
            progressPanel.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"RenameHostTitle"));
            progressPanel.setVisible(true);
            String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"RenamingHost");
            Object[] objectArray = new Object[]{hostData.getHostName()};
            progressPanel.setText(MessageFormat.format(string, objectArray));
            int n = this.theApp.getHostMgr().renameHost(this.originalHostObj, hostData.getHostName(), new Integer(0));
            if (n > 1) {
                object2 = new Object[]{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OptionRenameYes"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OptionRenameNo"), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Cancel")};
                String string2 = "\n";
                string2 = string2 + ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OptionRenameMessage");
                int n2 = new MyJOptionPane().showOptionDialog(string2 = string2 + "\n\n", (String)(object = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OptionRenameTitle")), (Object[])object2);
                if (n2 == 2 || n2 == -1) {
                    throw new HostException("");
                }
                if (n2 == 0) {
                    this.theApp.getHostMgr().renameHost(this.originalHostObj, hostData.getHostName(), new Integer(n));
                }
                if (n2 == 1) {
                    this.theApp.getHostMgr().renameHost(this.originalHostObj, hostData.getHostName(), new Integer(1));
                    n = 1;
                }
            }
            progressPanel.appendText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"UpdatingOtherViews"));
            Content.broadcastUpdate(this.theApp.getContentInstances(), this.originalHostObj, hostData, false);
            if (n > 1) {
                object2 = new Vector();
                int n3 = 0;
                while (n3 < vector.size()) {
                    object = (HostData)vector.elementAt(n3);
                    if (((HostData)object).getHostName().compareTo(this.originalHostObj.getHostName()) == 0) {
                        ((Vector)object2).addElement(object);
                    }
                    ++n3;
                }
                int n4 = 0;
                while (n4 < ((Vector)object2).size()) {
                    HostData hostData2 = (HostData)((Vector)object2).elementAt(n4);
                    Content.broadcastUpdate(this.theApp.getContentInstances(), hostData2, hostData, false);
                    ++n4;
                }
            }
            progressPanel.appendText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"RepaintingCurrentView"));
            progressPanel.setVisible(false);
            progressPanel.dispose();
        }
        catch (HostException hostException) {
            progressPanel.setVisible(false);
            progressPanel.dispose();
            this.hostName.requestFocus();
            if (hostException.getLocalizedMessage().length() > 0) {
                this.theApp.reportErrorException((Exception)((Object)hostException));
            }
            throw hostException;
        }
        catch (Exception exception) {
            progressPanel.setVisible(false);
            progressPanel.dispose();
            this.hostName.requestFocus();
            this.theApp.reportErrorException(exception);
            throw new HostException(exception.getMessage());
        }
    }

    private class MyJOptionPane {
        int result = 2;

        private MyJOptionPane() {
        }

        public int showOptionDialog(String string, String string2, Object[] objectArray) {
            try {
                EventQueue.invokeAndWait(new Runnable(this, string, string2, objectArray){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ String val$title;
                    private final /* synthetic */ Object[] val$options;
                    private final /* synthetic */ MyJOptionPane this$1;
                    {
                        this.this$1 = myJOptionPane;
                        this.val$message = string;
                        this.val$title = string2;
                        this.val$options = objectArray;
                    }

                    public void run() {
                        this.this$1.result = JOptionPane.showOptionDialog(null, this.val$message, this.val$title, -1, 3, null, this.val$options, this.val$options[0]);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.result;
        }
    }
}

