/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleBytePasswordField;
import com.netscape.management.client.util.SingleByteTextField;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class AccessConfigPanel
extends PluginConfigPanel
implements SuiConstants {
    IConfigDataModel _configData;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nUID;
    static String _i18nPWD;
    static String _i18nConfirmPWD;
    static String _i18nAdmSuperuser;
    static String _i18nAllowDSGW;
    static String _i18nMsgEnterUID;
    static String _i18nMsgEnterPWD;
    static String _i18nMsgPWDMismatch;
    Help _help;
    JCheckBox _cbDSGW;
    SingleByteTextField _txtUserName;
    SingleBytePasswordField _txtPassword;
    SingleBytePasswordField _txtConfirm;

    public AccessConfigPanel(String title, IConfigDataModel data) {
        super(title);
        this._configData = data;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("accessHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel data) {
        this._configData = data;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws RemoteRequestException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        this.setPanelContent(this._configData);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ValidationException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor((JTextComponent)this._txtUserName);
        editMonitor.monitor((JTextComponent)this._txtPassword);
        editMonitor.monitor((JTextComponent)this._txtConfirm);
        editMonitor.monitor(this._cbDSGW);
    }

    public void setPanelContent(IConfigDataModel data) {
        String dsgw = data.getAttribute("configuration.nsadminenabledsgw");
        this.setDSGW(!dsgw.equalsIgnoreCase("off"));
        this.setUserName(data.getAttribute("admpw.uid"));
        this._txtPassword.setText("");
        this._txtConfirm.setText("");
    }

    public void getPanelContent(IConfigDataModel data) throws ValidationException {
        String dsgw = this._cbDSGW.isSelected() ? "on" : "off";
        data.setAttribute("configuration.nsadminenabledsgw", dsgw);
        String newuid = this._txtUserName.getText();
        String newpw1 = this._txtPassword.getText();
        String newpw2 = this._txtConfirm.getText();
        String olduid = this._configData.getAttribute("admpw.uid");
        if (newuid.length() == 0) {
            throw new ValidationException("", _i18nMsgEnterUID);
        }
        if (!olduid.equals(newuid)) {
            if (newpw1.length() == 0) {
                throw new ValidationException("", _i18nMsgEnterPWD);
            }
            if (!newpw1.equals(newpw2)) {
                throw new ValidationException("", _i18nMsgPWDMismatch);
            }
        } else if (newpw1.length() != 0 && !newpw1.equals(newpw2)) {
            throw new ValidationException("", _i18nMsgPWDMismatch);
        }
        if (!newuid.equals(olduid)) {
            Debug.println((String)("CHANGE UID TO " + newuid));
            this._configData.setAttribute("admpw.uid", newuid);
        }
        if (newpw1.length() > 0) {
            Debug.println((String)"CHANGE PWD ");
            this._configData.setAttribute("admpw.pw", newpw1);
        }
    }

    private void setUserName(String name) {
        this._txtUserName.setText(name == null ? "" : name);
    }

    void setDSGW(boolean flag) {
        this._cbDSGW.setSelected(flag);
    }

    private JPanel makeConfigPanel() {
        JPanel p = new JPanel();
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this.createSuperuserGroup(), gbc);
        this._cbDSGW = new JCheckBox(_i18nAllowDSGW, true);
        gbc.setInsets(6, 0, 0, 0);
        gbc.setGrid(0, 2, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 0);
        p.add((Component)this._cbDSGW, gbc);
        return p;
    }

    private JPanel createSuperuserGroup() {
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        JPanel group = new JPanel(gbl);
        group.setBorder(BaseConfigPanel.createGroupBorder(_i18nAdmSuperuser));
        JLabel uidLabel = new JLabel(_i18nUID);
        gbc.setInsets(0, 0, 0, 0);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        group.add((Component)uidLabel, gbc);
        this._txtUserName = new SingleByteTextField(16);
        gbc.setInsets(0, 9, 0, 0);
        gbc.setGrid(1, 0, 1, 1);
        gbc.setSpace(0.0, 0.0, 17, 2);
        group.add((Component)this._txtUserName, gbc);
        uidLabel.setLabelFor((Component)this._txtUserName);
        JLabel pwdLabel = new JLabel(_i18nPWD);
        gbc.setInsets(6, 0, 0, 0);
        gbc.setGrid(0, 1, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        group.add((Component)pwdLabel, gbc);
        this._txtPassword = new SingleBytePasswordField(16);
        gbc.setInsets(6, 9, 0, 0);
        gbc.setGrid(1, 1, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        group.add((Component)this._txtPassword, gbc);
        pwdLabel.setLabelFor((Component)this._txtPassword);
        JLabel pwd2Label = new JLabel(_i18nConfirmPWD);
        gbc.setInsets(9, 0, 0, 0);
        gbc.setGrid(0, 2, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        group.add((Component)pwd2Label, gbc);
        this._txtConfirm = new SingleBytePasswordField(16);
        gbc.setInsets(6, 9, 0, 0);
        gbc.setGrid(1, 2, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        group.add((Component)this._txtConfirm, gbc);
        pwd2Label.setLabelFor((Component)this._txtConfirm);
        return group;
    }

    static {
        _i18nAdmSuperuser = _resource.getString("access", "AdmSuperuser");
        _i18nUID = _resource.getString("access", "UID");
        _i18nPWD = _resource.getString("access", "PWD");
        _i18nConfirmPWD = _resource.getString("access", "ConfirmPWD");
        _i18nAllowDSGW = _resource.getString("access", "AllowDSGW");
        _i18nMsgEnterUID = _resource.getString("access", "MsgEnterUID");
        _i18nMsgEnterPWD = _resource.getString("access", "MsgEnterPWD");
        _i18nMsgPWDMismatch = _resource.getString("access", "MsgPWDMismatch");
    }
}

