/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.config;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ConfigErrorDialog;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.IPluginConfigPanel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.nmclf.SecondaryTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class TabbedConfigPanel
extends PluginConfigPanel {
    public static final int IMMEDIATE_CREATE = 0;
    public static final int LAZY_CREATE = 1;
    int _createMode = 0;
    Vector _tabs = new Vector();
    SecondaryTabbedPane _tabbedPane;
    public static Object _notCreatedTab;
    EditMonitor _editMonitor;
    ChangeListener _tabListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            TabbedConfigPanel.this.tabSelected(TabbedConfigPanel.this._tabbedPane.getSelectedIndex());
        }
    };

    public TabbedConfigPanel() {
        this(0);
    }

    public TabbedConfigPanel(int createMode) {
        this._createMode = createMode;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._tabbedPane = new SecondaryTabbedPane();
        this.add((Component)this._tabbedPane, "Center");
        if (this._createMode == 1) {
            this._tabbedPane.addChangeListener(this._tabListener);
        }
    }

    public Vector getTabs() {
        return this._tabs;
    }

    protected void tabSelected(int idx) {
        if (this._tabs.elementAt(idx) == _notCreatedTab) {
            BaseConfigPanel bcp = BaseConfigPanel.getInstance((Component)this._tabbedPane);
            if (bcp != null) {
                bcp.monitorLongAction(new CreateTabAction(idx));
            } else {
                new CreateTabAction(idx).run();
            }
        } else {
            this.enableHelpButton(true);
        }
    }

    public void addTab(String title, ImageIcon icon, IPluginConfigPanel tab) {
        this._tabs.addElement(tab);
        JPanel p = tab.getPanel();
        int insetH = 9;
        int insetV = 9;
        p.setBorder(new EmptyBorder(insetV, insetH, insetV, insetH));
        JScrollPane scrollPane = new JScrollPane(p);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._tabbedPane.addTab(title, icon, scrollPane);
    }

    public int lazyModeReserveTab(String title, ImageIcon icon) {
        this._tabbedPane.addTab(title, icon, new JLabel(" "));
        this._tabs.addElement(_notCreatedTab);
        return this._tabs.size() - 1;
    }

    public IPluginConfigPanel lazyModeCreateTab(int idx) {
        throw new Error("Not implemented");
    }

    public String getTitleText() {
        return null;
    }

    public void initialize() throws ConfigPanelException {
        int i = 0;
        while (i < this._tabs.size()) {
            if (this._tabs.elementAt(i) != _notCreatedTab) {
                IPluginConfigPanel tab = (IPluginConfigPanel)this._tabs.elementAt(i);
                tab.initialize();
            }
            ++i;
        }
        this._tabbedPane.setSelectedIndex(0);
        this._tabbedPane.validate();
        this._tabbedPane.repaint();
    }

    public void setDataModel(IConfigDataModel dataModel) throws ConfigPanelException {
        int i = 0;
        while (i < this._tabs.size()) {
            if (this._tabs.elementAt(i) != _notCreatedTab) {
                IPluginConfigPanel tab = (IPluginConfigPanel)this._tabs.elementAt(i);
                tab.setDataModel(dataModel);
            }
            ++i;
        }
    }

    public void registerEditComponents(EditMonitor monitor) {
        this._editMonitor = monitor;
        int i = 0;
        while (i < this._tabs.size()) {
            if (this._tabs.elementAt(i) != _notCreatedTab) {
                IPluginConfigPanel tab = (IPluginConfigPanel)this._tabs.elementAt(i);
                tab.registerEditComponents(monitor);
            }
            ++i;
        }
    }

    public void resetContent() throws ConfigPanelException {
        int i = 0;
        while (i < this._tabs.size()) {
            if (this._tabs.elementAt(i) != _notCreatedTab) {
                IPluginConfigPanel tab = (IPluginConfigPanel)this._tabs.elementAt(i);
                tab.resetContent();
            }
            ++i;
        }
    }

    public void applyChanges() throws ConfigPanelException {
        int i = 0;
        while (i < this._tabs.size()) {
            if (this._tabs.elementAt(i) != _notCreatedTab) {
                IPluginConfigPanel tab = (IPluginConfigPanel)this._tabs.elementAt(i);
                tab.applyChanges();
            }
            ++i;
        }
    }

    public void showHelp() {
        IPluginConfigPanel tab = (IPluginConfigPanel)this._tabs.elementAt(this._tabbedPane.getSelectedIndex());
        if (tab != _notCreatedTab) {
            tab.showHelp();
        }
    }

    protected void setActionCursor(Cursor cursor) {
        Object c = this._tabbedPane;
        while (c != null && !(c instanceof JFrame) && !(c instanceof JDialog)) {
            c = c.getParent();
        }
        if (c != null) {
            c.setCursor(cursor);
        }
    }

    protected void enableHelpButton(boolean flag) {
        BaseConfigPanel bcp = BaseConfigPanel.getInstance((Component)this._tabbedPane);
        if (bcp != null && bcp.getCommandButtonBar() != null) {
            JButton helpButton = bcp.getCommandButtonBar().getButton("help");
            helpButton.setEnabled(flag);
        }
    }

    class CreateTabAction
    implements Runnable {
        int idx;

        public CreateTabAction(int idx) {
            this.idx = idx;
        }

        public void run() {
            TabbedConfigPanel.this.setActionCursor(Cursor.getPredefinedCursor(3));
            TabbedConfigPanel.this.enableHelpButton(false);
            IPluginConfigPanel tab = TabbedConfigPanel.this.lazyModeCreateTab(this.idx);
            try {
                try {
                    tab.initialize();
                }
                catch (ConfigPanelException e) {
                    ConfigErrorDialog.showDialog((Component)TabbedConfigPanel.this._tabbedPane, e);
                    Object var4_3 = null;
                    TabbedConfigPanel.this.setActionCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                Object var4_2 = null;
                TabbedConfigPanel.this.setActionCursor(Cursor.getPredefinedCursor(0));
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                TabbedConfigPanel.this.setActionCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            tab.registerEditComponents(TabbedConfigPanel.this._editMonitor);
            TabbedConfigPanel.this._tabs.setElementAt(tab, this.idx);
            TabbedConfigPanel.this.enableHelpButton(true);
            JPanel p = tab.getPanel();
            int insetH = 9;
            int insetV = 9;
            p.setBorder(new EmptyBorder(insetV, insetH, insetV, insetH));
            JScrollPane scrollPane = new JScrollPane(tab.getPanel());
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            TabbedConfigPanel.this._tabbedPane.setComponentAt(this.idx, scrollPane);
        }
    }
}

