/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.config;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;

public class EditMonitor
implements ActionListener,
ChangeListener,
DocumentListener,
ItemListener,
ListDataListener {
    boolean _isDirty = false;
    boolean _isRunning = false;
    Vector _listeners;
    Vector _enableComponents = new Vector(5);
    Vector _disableComponents = new Vector(5);

    public EditMonitor() {
        this._listeners = new Vector(5);
    }

    void start() {
        this._isRunning = true;
    }

    void stop() {
        this._isRunning = false;
    }

    public void addChangeListener(ChangeListener l) {
        this._listeners.addElement(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._listeners.removeElement(l);
    }

    protected void fireChangeEvent() {
        int i = 0;
        while (i < this._listeners.size()) {
            ChangeListener l = (ChangeListener)this._listeners.elementAt(i);
            l.stateChanged(new ChangeEvent(new Boolean(this._isDirty)));
            ++i;
        }
    }

    public void setEnableComponets(Vector enableComponents) {
        this._enableComponents = new Vector();
    }

    public void setDisableComponets(Vector disableComponents) {
        this._disableComponents = new Vector();
    }

    public void addEnableComponent(Component c) {
        this._enableComponents.addElement(c);
        c.setEnabled(this._isDirty);
    }

    public void addDisableComponent(Component c) {
        this._disableComponents.addElement(c);
        c.setEnabled(!this._isDirty);
    }

    private void setComponentsEnabledState(boolean flag) {
        int i = 0;
        while (i < this._enableComponents.size()) {
            Component c = (Component)this._enableComponents.elementAt(i);
            c.setEnabled(flag);
            ++i;
        }
        int i2 = 0;
        while (i2 < this._disableComponents.size()) {
            Component c = (Component)this._disableComponents.elementAt(i2);
            c.setEnabled(!flag);
            ++i2;
        }
    }

    public void setDirtyFlag(boolean flag) {
        if (this._isRunning) {
            boolean modified = flag != this._isDirty;
            this._isDirty = flag;
            this.setComponentsEnabledState(this._isDirty);
            if (modified) {
                this.fireChangeEvent();
            }
        }
    }

    public boolean getDirtyFlag() {
        return this._isDirty;
    }

    public void monitor(JTextComponent text) {
        text.getDocument().addDocumentListener(this);
    }

    public void monitor(JList list) {
        list.getModel().addListDataListener(this);
    }

    public void monitor(ListModel model) {
        model.addListDataListener(this);
    }

    public void monitor(JToggleButton toggle) {
        toggle.addActionListener(this);
    }

    public void monitor(JComboBox comboChoice) {
        comboChoice.addItemListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Component) {
            Component c = (Component)e.getSource();
            if (c.isEnabled()) {
                this.setDirtyFlag(true);
            }
        } else {
            this.setDirtyFlag(true);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.setDirtyFlag(true);
    }

    public void changedUpdate(DocumentEvent e) {
        this.setDirtyFlag(true);
    }

    public void insertUpdate(DocumentEvent e) {
        this.setDirtyFlag(true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.setDirtyFlag(true);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof Component) {
            Component c = (Component)e.getSource();
            if (c.isEnabled()) {
                this.setDirtyFlag(true);
            }
        } else {
            this.setDirtyFlag(true);
        }
    }

    public void contentsChanged(ListDataEvent e) {
        this.setDirtyFlag(true);
    }

    public void intervalAdded(ListDataEvent e) {
        this.setDirtyFlag(true);
    }

    public void intervalRemoved(ListDataEvent e) {
        this.setDirtyFlag(true);
    }

    public String toString() {
        return "EditMonitor[dirty=" + this._isDirty + ", running=" + this._isRunning + "]";
    }
}

