/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv;

import com.netscape.management.admserv.AdminFrameworkInitializer;
import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFrameworkInitializer;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.StatusItemSecureMode;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.AbstractServerObject;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.ServerNode;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JFrame;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class AdminServer
extends AbstractServerObject
implements SuiConstants {
    public static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.admserv");
    ConsoleInfo _consoleInfo;
    int _serverStatus;
    private int adminUrlNodeDataIndex = -1;
    protected boolean _needsAutoRestart = false;
    protected boolean _canRestartFromConsole;
    protected String _postRestartURL = null;
    protected boolean _isShutdown = false;
    private IRestartControl _restartControl = new IRestartControl(){

        public void setNeedsAutoRestart(boolean flag) {
            AdminServer.this._needsAutoRestart = flag;
        }

        public boolean needsAutoRestart() {
            return AdminServer.this._needsAutoRestart;
        }

        public void setCanRestartFromConsole(boolean flag) {
            AdminServer.this._canRestartFromConsole = flag;
        }

        public boolean canRestartFromConsole() {
            return AdminServer.this._canRestartFromConsole;
        }

        public void setPostRestartURL(String url) {
            AdminServer.this._postRestartURL = url;
        }

        public String getPostRestartURL() {
            return AdminServer.this._postRestartURL;
        }

        public void setServerShutdown(boolean flag) {
            AdminServer.this._isShutdown = flag;
        }

        public boolean isServerShutdown() {
            return AdminServer.this._isShutdown;
        }
    };
    private URL _serverURL = null;
    private URLConnection _serverConnection = null;

    public void initialize(ConsoleInfo info) {
        super.initialize(info);
        this._consoleInfo = info;
        this.setIcon((Icon)new RemoteImage(_resource.getString("admin", "smallIcon")));
        this._canRestartFromConsole = !info.getAdminURL().startsWith("https");
    }

    private boolean run(IPage viewInstance) {
        if (this.getServerStatus() == 2) {
            JFrame frame = viewInstance.getFramework().getJFrame();
            String title = _resource.getString("error", "OpenServerTitle");
            String msg = MessageFormat.format(_resource.getString("error", "CanNotOpenServer"), this.getName());
            BaseConfigPanel.clearProgressIndicator((Component)viewInstance);
            SuiOptionPane.showMessageDialog((Component)frame, (Object)msg, (String)title, (int)0);
            return false;
        }
        this._consoleInfo.put("SIE", this.getSIE());
        this._consoleInfo.put("SIE_VERSION", this.getProductVersion());
        this._consoleInfo.put("SERVER_NAME", this.getName());
        this._consoleInfo.put("HOST_NAME", this.getHostName());
        this._consoleInfo.put("RESTART_CONTROL", this._restartControl);
        this.createFramework();
        return true;
    }

    public boolean run(IPage viewInstance, IResourceObject[] selectionList) {
        if (selectionList.length == 1) {
            return this.run(viewInstance);
        }
        if (this.getServerStatus() == 2) {
            JFrame frame = viewInstance.getFramework().getJFrame();
            String title = _resource.getString("error", "OpenServerTitle");
            String msg = MessageFormat.format(_resource.getString("error", "CanNotOpenServer"), this.getName());
            BaseConfigPanel.clearProgressIndicator((Component)viewInstance);
            SuiOptionPane.showMessageDialog((Component)frame, (Object)msg, (String)title, (int)0);
            return false;
        }
        int i = 0;
        while (i < selectionList.length) {
            if (!(selectionList[i] instanceof ServerNode)) {
                Debug.println((String)("can't run, selection is " + selectionList[i].getClass().getName()));
                return false;
            }
            ServerNode node = (ServerNode)selectionList[i];
            if (!(node.getServerObject() instanceof AdminServer)) {
                Debug.println((String)("can't run, server is " + node.getServerObject().getClass().getName()));
                return false;
            }
            ++i;
        }
        this.createFramework();
        return true;
    }

    protected void createFramework() {
        Framework frame = new Framework((IFrameworkInitializer)new AdminFrameworkInitializer(this._consoleInfo));
        StatusItemSecureMode _statusSecureMode = new StatusItemSecureMode("StatusItemSecureMode");
        _statusSecureMode.setSecureMode(this._consoleInfo.getAdminURL().startsWith("https"));
        frame.addStatusItem((IStatusItem)_statusSecureMode, "LF");
        _statusSecureMode.setToolTipText(this._consoleInfo.getAdminURL());
    }

    protected String getHostName() {
        return (String)this._nodeDataTable.get("serverHostName");
    }

    protected String getSIE() {
        return (String)this._nodeDataTable.get("cn");
    }

    protected String getProductVersion() {
        return (String)this._nodeDataTable.get("nsProductVersion");
    }

    public ConsoleInfo getConsoleInfo() {
        return this._consoleInfo;
    }

    public synchronized int getServerStatus() {
        if (this._consoleInfo == null) {
            return 0;
        }
        try {
            String adminURL = this._consoleInfo.getAdminURL() + "admin-serv/tasks/operation/StatusPing";
            AdmTask task = new AdmTask(new URL(adminURL), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            task.exec();
            int status = task.getStatus();
            this._serverStatus = status == 0 ? 1 : (task.getException() != null && task.getException() instanceof SocketException ? 2 : 0);
            return this._serverStatus;
        }
        catch (MalformedURLException ex) {
            Debug.println((String)("ERROR AdminConfigData.isRunning: bad URL " + this._consoleInfo.getAdminURL()));
            this._serverStatus = 0;
            return 0;
        }
    }

    public void cloneFrom(String referenceDN) {
        String configDN = "cn=configuration," + referenceDN;
        String configURL = null;
        try {
            LDAPConnection ldc = this._consoleInfo.getLDAPConnection();
            if (ldc == null) {
                ldc = new LDAPConnection();
            }
            if (!ldc.isConnected()) {
                ldc.connect(this._consoleInfo.getHost(), this._consoleInfo.getPort(), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            }
            LDAPEntry entry = ldc.read(configDN);
            String addresses = LDAPUtil.flatting((LDAPAttribute)entry.getAttribute("nsadminaccessaddresses", LDAPUtil.getLDAPAttributeLocale()));
            String hosts = LDAPUtil.flatting((LDAPAttribute)entry.getAttribute("nsadminaccesshosts", LDAPUtil.getLDAPAttributeLocale()));
            String cache = LDAPUtil.flatting((LDAPAttribute)entry.getAttribute("nsadmincachelifetime", LDAPUtil.getLDAPAttributeLocale()));
            String dsgw = LDAPUtil.flatting((LDAPAttribute)entry.getAttribute("nsadminenabledsgw", LDAPUtil.getLDAPAttributeLocale()));
            String endUser = LDAPUtil.flatting((LDAPAttribute)entry.getAttribute("nsadminenableenduser", LDAPUtil.getLDAPAttributeLocale()));
            String oneAclDir = LDAPUtil.flatting((LDAPAttribute)entry.getAttribute("nsadminoneacldir", LDAPUtil.getLDAPAttributeLocale()));
            String defaultAccLang = LDAPUtil.flatting((LDAPAttribute)entry.getAttribute("nsdefaultacceptlanguage", LDAPUtil.getLDAPAttributeLocale()));
            boolean enableDSGW = dsgw == null || !dsgw.equalsIgnoreCase("off");
            boolean enableEndUser = endUser == null || !endUser.equalsIgnoreCase("off");
            configURL = new String(this._consoleInfo.getAdminURL() + "admin-serv/tasks/Configuration/ServerSetup?op=force_set" + "&configuration.nsadminaccessaddresses=" + addresses + "&configuration.nsadminaccesshosts=" + hosts + "&configuration.nsadmincachelifetime=" + cache + "&configuration.nsadminoneacldir=" + oneAclDir + "&configuration.nsdefaultacceptlanguage=" + defaultAccLang);
            configURL = enableDSGW ? configURL + "&configuration.nsadminenabledsgw=" : configURL + "&configuration.nsadminenabledsgw=off";
            configURL = enableEndUser ? configURL + "&configuration.nsadminenableenduser=" : configURL + "&configuration.nsadminenableenduser=off";
            Debug.println((String)("TRACE AdminServer.cloneFrom: configURL = " + configURL));
            URL configAdminURL = new URL(configURL);
            AdmTask task = new AdmTask(configAdminURL, this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            int execStatus = task.exec();
            int taskStatus = task.getStatus();
            String title = _resource.getString("status", "cloneTitle");
            if (execStatus == 0 && taskStatus == 0) {
                Debug.println((String)"TRACE AdminServer.cloneFrom: config CGI succeeded!");
                String msg = MessageFormat.format(_resource.getString("status", "cloneSucceeded"), this.getName());
                SuiOptionPane.showMessageDialog(null, (Object)msg, (String)title, (int)1);
            } else {
                Debug.println((String)("ERROR AdminServer.cloneFrom: config CGI status = " + (execStatus == 0 ? taskStatus : execStatus)));
                String msg = MessageFormat.format(_resource.getString("status", "cloneFailed"), this.getName());
                SuiOptionPane.showMessageDialog(null, (Object)msg, (String)title, (int)0);
            }
        }
        catch (LDAPException e) {
            Debug.println((String)("ERROR AdminServer.cloneFrom: LDAP read failed: " + configDN));
        }
        catch (MalformedURLException e) {
            Debug.println((String)("ERROR AdminServer.cloneFrom: Bad URL: " + configURL));
        }
    }

    public boolean isMigrationEnabled() {
        return !this.getProductVersion().equals("4.0");
    }

    public int getNodeDataCount() {
        this.adminUrlNodeDataIndex = super.getNodeDataCount();
        return this.adminUrlNodeDataIndex + 1;
    }

    public NodeData getNodeData(int index) {
        if (index == this.adminUrlNodeDataIndex) {
            String port = null;
            String url = this._consoleInfo.getAdminURL();
            int portIndex = url.lastIndexOf(58);
            if (portIndex != -1) {
                port = url.substring(portIndex + 1).replace('/', ' ').trim();
            }
            return new NodeData("", _resource.getString("infopanel", "Port"), (Object)port, false);
        }
        return super.getNodeData(index);
    }
}

