/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.services.Log;
import com.sun.management.viperimpl.services.authentication.AuthenticationUtil;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.SecurityContext;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;

public abstract class ServerSecurityContext
extends SecurityContext {
    private boolean msgVerify = false;
    private long clientVers = 0L;
    private String clientHost = null;
    private String clientVMID = null;
    private String userPswd = null;
    private Log logsvc = null;
    private int maxRetries;
    private int uid = -1;
    private int gid = -1;
    private String home = null;
    private String shell = null;
    private long htbtTime;
    protected static final String AUTH_SERVICE_RESOURCES = "com.sun.management.viperimpl.services.authentication.server.AuthenticationServiceResources";

    public ServerSecurityContext(AuthenticationFlavor authenticationFlavor) throws AuthenticationException {
        super(authenticationFlavor);
        try {
            this.maxRetries = Integer.parseInt("5");
        }
        catch (NumberFormatException numberFormatException) {
            this.maxRetries = 5;
        }
        this.setHeartbeatTime();
        this.setAuthState(0);
    }

    public abstract ServerSecurityContext newCopy() throws AuthenticationException;

    public abstract boolean verifyAuthFlavor(AuthenticationFlavor var1) throws AuthenticationException;

    public abstract ResponseSecurityToken verifyRequestToken(RequestSecurityToken var1) throws AuthenticationException;

    public abstract ConfirmSecurityToken verifyAuthenticatorToken(AuthenticatorSecurityToken var1) throws AuthenticationException;

    public abstract void verifyMessageToken(MessageSecurityToken var1, Object[] var2) throws AuthenticationException;

    public abstract String decryptPassword(byte[] var1) throws AuthenticationException;

    public long getClientVersion() {
        return this.clientVers;
    }

    public void setClientVersion(long l) {
        this.clientVers = l;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String string) {
        this.clientHost = string;
    }

    public String getClientVMID() {
        return this.clientVMID;
    }

    public void setClientVMID(String string) {
        this.clientVMID = string;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public String getUserPassword() {
        return AuthenticationUtil.unhashPassword(this.userPswd);
    }

    public void setUserPassword(String string) {
        this.userPswd = AuthenticationUtil.hashPassword(string);
    }

    public boolean isVerify() {
        return this.msgVerify;
    }

    public void setVerify(boolean bl) {
        this.msgVerify = bl;
    }

    public void disableVerify() {
        this.msgVerify = false;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int n) {
        this.uid = n;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGid(int n) {
        this.gid = n;
    }

    public String getShell() {
        return this.shell;
    }

    public void setShell(String string) {
        this.shell = string;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String string) {
        this.home = string;
    }

    public long getHeartbeatTime() {
        return this.htbtTime;
    }

    public void setHeartbeatTime() {
        this.htbtTime = System.currentTimeMillis();
    }

    public void setLogService(Log log) {
        this.logsvc = log;
    }

    protected void writeLog(int n, String string, String string2) {
        this.writeLog(n, string, string2, (String[])null);
    }

    protected void writeLog(int n, String string, String string2, String string3) {
        this.writeLog(n, string, string2, new String[]{string3});
    }

    protected void writeLog(int n, String string, String string2, String string3, String string4) {
        this.writeLog(n, string, string2, new String[]{string3, string4});
    }

    protected void writeLog(int n, String string, String string2, String string3, String string4, String string5) {
        this.writeLog(n, string, string2, new String[]{string3, string4, string5});
    }

    protected void writeLog(int n, String string, String string2, String[] stringArray) {
        if (this.logsvc != null) {
            try {
                this.logsvc.writeLog("LMS_AuthSvcName", "security", n, string, string2, stringArray, AUTH_SERVICE_RESOURCES, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void auditBadUser(String string, String string2) {
        try {
            AuthenticationLibrary.auditLogin(string, string2, -1, 0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void auditBadPasswd(String string, String string2) {
        try {
            AuthenticationLibrary.auditLogin(string, string2, -2, 0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void auditAuthSuccess(String string, String string2, long l) {
        try {
            AuthenticationLibrary.auditLogin(string, string2, 0, l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void copyAttrs(ServerSecurityContext serverSecurityContext) throws AuthenticationException {
        super.copyAttrs(serverSecurityContext);
        serverSecurityContext.setVerify(this.msgVerify);
        serverSecurityContext.setClientVersion(this.clientVers);
        if (this.clientHost != null) {
            serverSecurityContext.setClientHost(new String(this.clientHost));
        }
        if (this.clientVMID != null) {
            serverSecurityContext.setClientVMID(new String(this.clientVMID));
        }
        if (this.userPswd != null) {
            serverSecurityContext.setUserPassword(this.getUserPassword());
        }
        serverSecurityContext.setLogService(this.logsvc);
        serverSecurityContext.setMaxRetries(this.maxRetries);
    }
}

