/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ChangeAppState;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.sysinfo.client.AppContent;
import com.sun.admin.sysinfo.client.ApplicationContext;
import com.sun.admin.sysinfo.client.Content;
import com.sun.admin.sysinfo.client.MainMenuBar;
import com.sun.admin.sysinfo.client.MainToolBar;
import com.sun.admin.sysinfo.client.ServiceWrapper;
import com.sun.admin.sysinfo.client.SysInfoActionsListener;
import com.sun.admin.sysinfo.client.SysInfoContextHelpListener;
import com.sun.admin.sysinfo.client.SysInfoWidget;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VAboutBox;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class VSysInfo
implements Tool,
PropertyChangeListener,
VConsoleActionListener {
    public static final int PROGRESS_WAIT = 3000;
    private ServiceWrapper systemInfo;
    private VConsoleProperties properties = null;
    private ApplicationContext applicationContext = null;
    private ToolInfrastructure infrastructure = null;
    private boolean bRunning = false;
    private AdminException shutdownException = null;
    private boolean isCriticalStop = false;
    private Vector consoleListeners = new Vector();
    private JFrame consoleFrame = null;
    private VDisplayModel displayModel;
    private AppContent appContent = null;
    private MainMenuBar menuBar = null;
    private MainToolBar toolBar = null;
    private ResourceBundle bundle = null;
    private int busyCount = 0;
    private VBusyPanel busyPanel = null;
    private JFrame frame = null;
    private VScopeNode appNode;
    public ImageIcon smallAppIcon;
    public ImageIcon largeAppIcon;
    private SysInfoWidget sysInfoWidget;
    private String origViewSetting = "";
    private boolean bDateTimeEnabled = false;

    public VSysInfo() {
        try {
            this.bundle = ResourceManager.getBundle((String)"com.sun.admin.sysinfo.client.resources.Resources", this.getClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bundle = null;
        }
        this.menuBar = new MainMenuBar(this);
        this.toolBar = new MainToolBar(this);
        this.smallAppIcon = this.loadImageIcon("smallProgram.gif");
        this.largeAppIcon = this.loadImageIcon("largeProgram.gif");
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DESCRIPTION");
        this.sysInfoWidget = new SysInfoWidget(this);
        this.appNode = new VScopeNode((Component)this.sysInfoWidget, null, null, (JMenuBar)this.menuBar, (JToolBar)this.toolBar, null, this.smallAppIcon, this.largeAppIcon, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"BEANNAME"), string, null, -1, null);
        String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FetchSysInfo");
        this.busyPanel = new VBusyPanel(string2);
        this.getScopeNode().setResultPane((Component)this.busyPanel);
        this.appNode.setToolTipText(string);
        String string3 = ResourceManager.getLocalizedTextFile((String)"html/sysinfo_overview.html", this.getClass());
        this.appNode.setHTMLText(string3);
        this.appNode.setTool((Tool)this);
        this.fireConsoleAction(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)this.getScopeNode()));
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        try {
            this.systemInfo = this.applicationContext.getServiceWrapper(toolInfrastructure);
        }
        catch (AdminException adminException) {
            this.shutDown(adminException, 30, "LoadFailure", "LoadFailure");
            return;
        }
    }

    public void shutDown(AdminException adminException, int n, String string, String string2) {
        this.shutdownException = adminException;
        String string3 = "<HTML><BODY>";
        string3 = string3 + ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DESCRIPTION");
        string3 = string3 + "</p><p>" + adminException.getLocalizedMessage() + "</p>";
        string3 = string3 + "</BODY></HTML>";
        if (n == 30) {
            ChangeAppState.setErrorState((VScopeNode)this.getScopeNode(), (String)string3);
        } else {
            ChangeAppState.setWarningState((VScopeNode)this.getScopeNode(), (String)string3);
        }
        VLogEvent vLogEvent = new VLogEvent((Object)this, n, new Date(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)string), ResourceStrings.getString((ResourceBundle)this.bundle, (String)string2), adminException.getLocalizedMessage(), (Throwable)adminException, null);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
        this.fireConsoleAction(vConsoleEvent);
        this.getScopeNode().setResultPane(null);
        this.fireConsoleAction(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)this.getScopeNode()));
    }

    public void start() throws CriticalStopException {
        if (this.appContent == null) {
            this.appContent = new AppContent(this);
        }
        if (this.shutdownException != null) {
            if (this.isCriticalStop) {
                return;
            }
            this.reportErrorException((Exception)((Object)this.shutdownException));
            this.isCriticalStop = true;
            throw new CriticalStopException(this.shutdownException.getLocalizedMessage());
        }
        this.bRunning = true;
        this.origViewSetting = this.properties.getProperty("vconsole.iconstyle");
        this.setDateTimeEnabled(this.getSystemInfo().hasWriteAuthorization());
        this.properties.setProperty("vconsole.iconviewsenabled", "false");
        ActionEvent actionEvent = new ActionEvent(this.getScopeNode(), 1001, "Refresh");
        SysInfoActionsListener sysInfoActionsListener = new SysInfoActionsListener(this, false);
        sysInfoActionsListener.actionPerformed(actionEvent);
    }

    public void stop() throws CriticalStopException {
        if (!this.bRunning) {
            return;
        }
        this.bRunning = false;
        this.properties.setProperty("vconsole.iconstyle", this.origViewSetting);
    }

    public void destroy() {
        try {
            this.applicationContext.closeConnection(this.infrastructure);
        }
        catch (AdminException adminException) {
            // empty catch block
        }
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return -1;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            this.frame = (JFrame)vConsoleProperties.getPropertyObject("vconsole.frame");
            this.displayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setToolContext(ToolContext toolContext) {
        this.applicationContext = new ApplicationContext(this, toolContext);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public SysInfoWidget getSysInfoWidget() {
        return this.sysInfoWidget;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public VDisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.displaymodel")) {
            this.displayModel = (VDisplayModel)propertyChangeEvent.getNewValue();
        } else if (string.equals("vconsole.frame")) {
            this.consoleFrame = (JFrame)propertyChangeEvent.getNewValue();
        }
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener != null) {
            this.consoleListeners.addElement(vConsoleActionListener);
        }
    }

    public void fireConsoleAction(VConsoleEvent vConsoleEvent) {
        Enumeration enumeration = this.consoleListeners.elements();
        while (enumeration.hasMoreElements()) {
            VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)enumeration.nextElement();
            vConsoleActionListener.consoleAction(vConsoleEvent);
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (!this.bRunning) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.refresh")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Refresh");
            SysInfoActionsListener sysInfoActionsListener = new SysInfoActionsListener(this, false);
            sysInfoActionsListener.actionPerformed(actionEvent);
        } else if (!string.equals("vconsole.sechelpselection")) {
            if (string.equals("vconsole.scopechildopened")) {
                this.getContent().onDoubleClick();
            } else if (string.equals("vconsole.displayproperties")) {
                // empty if block
            }
        }
    }

    public Content getContent() {
        return this.appContent;
    }

    public void aboutTool() {
        VAboutBox vAboutBox = new VAboutBox();
        vAboutBox.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"AboutBoxBanner"));
        vAboutBox.setDescription(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Copyright"));
        Dimension dimension = vAboutBox.getMinimumSize();
        FontMetrics fontMetrics = vAboutBox.getFontMetrics(vAboutBox.getFont());
        dimension.height += 2 * fontMetrics.getHeight();
        vAboutBox.setMinimumSize(dimension);
        VDialog vDialog = new VDialog((Frame)this.consoleFrame, true);
        vAboutBox.setContainer((VContainer)vDialog);
        vDialog.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"AboutBoxTitle"));
        vDialog.getContentPane().setLayout(new BorderLayout());
        vDialog.getContentPane().add((Component)vAboutBox, "Center");
        vDialog.pack();
        vDialog.showCenter((Component)this.consoleFrame);
    }

    public VScopeNode getScopeNode() {
        return this.appNode;
    }

    public ServiceWrapper getSystemInfo() {
        return this.systemInfo;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public MainMenuBar getMenuBar() {
        return this.menuBar;
    }

    public MainToolBar getToolBar() {
        return this.toolBar;
    }

    public void setInfoBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updateselinfo", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void setStatusBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updateselinfo", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public ImageIcon loadImageIcon(String string) {
        String string2 = "images/" + string;
        return ConsoleUtility.loadImageIcon((String)string2, this.getClass());
    }

    public void reportErrorException(Exception exception) {
        AdminException adminException;
        String string = "";
        while (exception != null) {
            if (exception instanceof AdminException) {
                adminException = (AdminException)((Object)exception);
                string = string + "\n" + adminException.getLocalizedMessage();
                if (adminException.isEmbeddedException()) {
                    exception = adminException.getEmbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = string + "\n" + exception.getLocalizedMessage();
            exception = null;
        }
        adminException = new ErrorDialog(this.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ErrorTitle"), string);
    }

    public void waitOn() {
        this.setBusy(true);
    }

    public void waitOff() {
        this.setBusy(false);
    }

    public boolean isWaitOn() {
        return this.busyCount > 0;
    }

    private synchronized void setBusy(boolean bl) {
        if (bl) {
            ++this.busyCount;
            if (this.busyCount == 1) {
                this.properties.setProperty("vconsole.working", "true");
            }
        } else {
            --this.busyCount;
            this.busyCount = Math.max(0, this.busyCount);
            if (this.busyCount == 0) {
                this.properties.setProperty("vconsole.working", "false");
            }
        }
    }

    public void addHelpListener(SysInfoContextHelpListener sysInfoContextHelpListener, Component component) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(sysInfoContextHelpListener, componentArray[n]);
                ++n;
            }
        }
        component.addFocusListener((FocusListener)((Object)sysInfoContextHelpListener));
    }

    public synchronized boolean getDateTimeEnabled() {
        return this.bDateTimeEnabled;
    }

    public synchronized void setDateTimeEnabled(boolean bl) {
        if (bl && !this.bDateTimeEnabled && !this.getSystemInfo().hasWriteAuthorization()) {
            return;
        }
        this.bDateTimeEnabled = bl;
        this.sysInfoWidget.setDateTimeEnabled(this.bDateTimeEnabled);
        this.menuBar.setDateTimeEnabled(this.bDateTimeEnabled);
    }
}

