/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.sysinfo.client.ServiceWrapper;
import com.sun.admin.sysinfo.client.VSysInfo;
import com.sun.admin.sysinfo.client.WbemServiceWrapper;
import com.sun.admin.sysinfo.common.SysInfoException;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.client.ExternalClientList;
import java.util.ResourceBundle;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClient;

public class ApplicationContext {
    private static final String NAME_SPACE = new String("root\\cimv2");
    private VSysInfo theApp;
    private ToolContext toolContext;
    private AdminMgmtScope scope;

    public ApplicationContext(VSysInfo vSysInfo, ToolContext toolContext) {
        this.theApp = vSysInfo;
        this.toolContext = toolContext;
        this.scope = (AdminMgmtScope)toolContext.getParameter("ToolContext.MGMTSCOPE");
    }

    private String getServiceType() {
        String string = "Wbem";
        try {
            String string2 = System.getProperty("sysinfo.serviceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {
            this.theApp.reportErrorException(exception);
        }
        return string;
    }

    public ServiceWrapper getServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME");
        String string2 = this.getServiceType();
        String string3 = "com.sun.admin.sysinfo.client." + string2 + "ServiceWrapper";
        ServiceWrapper serviceWrapper = null;
        try {
            serviceWrapper = (ServiceWrapper)Class.forName(string3).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SysInfoException("SERVICE_NOT_REACHABLE", (Object)string2, (Object)string, string3);
        }
        catch (Exception exception) {
            SysInfoException sysInfoException = new SysInfoException("CANT_GET_SERVICE_WRAPPER", (Object)string2, (Object)string, string3);
            sysInfoException.addArg(exception.getLocalizedMessage());
            throw sysInfoException;
        }
        int n = 2;
        int n2 = 1;
        while (n2 <= n) {
            block8: {
                try {
                    if (serviceWrapper instanceof WbemServiceWrapper) {
                        CIMNameSpace cIMNameSpace = new CIMNameSpace(this.getMgmtServer(), NAME_SPACE);
                        Object[] objectArray = new Object[]{cIMNameSpace, new String("cim-rmi")};
                        CIMClient cIMClient = (CIMClient)toolInfrastructure.getExternalClient(ExternalClientList.JAVAXWBEM, objectArray);
                        serviceWrapper.init(cIMClient, toolInfrastructure);
                        break;
                    }
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("TIMED_OUT") && n2 <= n) break block8;
                    if (exception.getMessage().equals("NO_CIMOM")) {
                        throw new SysInfoException("CANT_CONNECT_NO_CIMOM", string);
                    }
                    throw new SysInfoException("CANT_CONNECT_TO_SERVER", exception.getLocalizedMessage());
                }
            }
            ++n2;
        }
        return serviceWrapper;
    }

    public void closeConnection(ToolInfrastructure toolInfrastructure) throws AdminException {
        try {
            String string = this.scope.getMgmtServerName();
            CIMNameSpace cIMNameSpace = new CIMNameSpace(string, "root\\cimv2");
            Object[] objectArray = new Object[]{cIMNameSpace, new String("cim-rmi")};
            toolInfrastructure.releaseExternalClient(ExternalClientList.JAVAXWBEM, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMgmtServer() {
        return this.scope.getMgmtServerName();
    }
}

