/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMPreeditListener;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.io.IOException;
import java.text.AttributedString;
import java.util.Locale;
import java.util.Vector;
import sun.awt.im.iiimp.FeedbackChar;
import sun.awt.im.iiimp.IIIMCommittedListener;
import sun.awt.im.iiimp.IMServer;
import sun.awt.im.iiimp.Manager;
import sun.awt.im.iiimp.ProtocolDriver;

class InputContext {
    private int id = 0;
    private Locale locale = null;
    private boolean active = false;
    private boolean connected = false;
    private boolean convMode = false;
    private boolean isForwardEvent = false;
    private IMServer im = null;
    private ProtocolDriver client = ProtocolDriver.getInstance();
    private java.awt.im.InputContext ic;
    private IIIMPreeditListener preeditListener;
    private IIIMCommittedListener committedListener;
    private Vector composedText = new Vector();
    private boolean beingProcessed = false;

    InputContext(java.awt.im.InputContext inputContext, ProtocolDriver protocolDriver) {
        this.ic = inputContext;
        this.client = protocolDriver;
    }

    void setPreeditListener(IIIMPreeditListener iIIMPreeditListener) {
        this.preeditListener = iIIMPreeditListener;
    }

    void setCommittedListener(IIIMCommittedListener iIIMCommittedListener) {
        this.committedListener = iIIMCommittedListener;
    }

    IIIMPreeditListener getPreeditListener() {
        return this.preeditListener;
    }

    IIIMCommittedListener getCommittedListener() {
        return this.committedListener;
    }

    public IMServer getIMServer() {
        return this.im;
    }

    void create(IMServer iMServer, Locale locale) {
        this.im = iMServer;
        this.locale = locale;
        this.active = false;
        try {
            this.client.createIC(iMServer.getID(), this.locale);
        }
        catch (Exception exception) {
            this.debug("InputContext createIC: " + exception);
        }
    }

    public void activate() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.setFocus(true);
    }

    public void dispose() {
        block2: {
            try {
                this.client.destroyIC(this.im.getID(), this.id);
            }
            catch (Exception exception) {
                if (!Manager.DEBUG) break block2;
                exception.printStackTrace();
            }
        }
        this.im.removeInputContextHandler(this);
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.setFocus(false);
    }

    public void dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.beingProcessed && (keyEvent.getID() == 400 || keyEvent.getID() == 402)) {
            keyEvent.consume();
            return;
        }
        this.beingProcessed = this.dispatchKeyEventImpl(keyEvent);
        if (this.beingProcessed) {
            keyEvent.consume();
        }
    }

    private boolean isUninterestingModifiers(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 157: {
                return true;
            }
        }
        return false;
    }

    private boolean dispatchKeyEventImpl(KeyEvent keyEvent) {
        if (this.isConversionMode()) {
            if (this.isUninterestingModifiers(keyEvent)) {
                return true;
            }
            if (keyEvent.getID() == 400) {
                return !this.isForwardEvent;
            }
            if (keyEvent.getID() == 402) {
                return !this.isForwardEvent;
            }
        } else if (this.isUninterestingModifiers(keyEvent)) {
            return false;
        }
        if (!this.connected) {
            if (this.im.isConversionOnKey(keyEvent)) {
                if (this.im.reopen(this.locale) && this.reconnect()) {
                    this.activate();
                    this.setConversionMode(true);
                }
                return true;
            }
            return false;
        }
        if (this.isForwardEvent) {
            this.isForwardEvent = false;
        }
        if (this.im.isDynamicEventFlow()) {
            if (this.isConversionMode()) {
                if (this.im.isConversionOffKey(keyEvent)) {
                    this.setConversionMode(false);
                    return true;
                }
                return this.deliverKeyEvent(keyEvent);
            }
            if (this.im.isConversionOnKey(keyEvent)) {
                this.setConversionMode(true);
                return true;
            }
            return false;
        }
        return this.deliverKeyEvent(keyEvent);
    }

    void setForward() {
        this.isForwardEvent = true;
    }

    private boolean deliverKeyEvent(KeyEvent keyEvent) {
        try {
            this.client.processKeyEvent(this.im.getID(), this.id, keyEvent);
            return !this.isForwardEvent;
        }
        catch (Exception exception) {
            if (Manager.DEBUG) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    void deliverStringEvent(String string, String string2) throws IOException {
        this.client.forwardEventWithOperation(this.im.getID(), this.id, string, string2);
    }

    public void reset(boolean bl) {
        block3: {
            try {
                this.client.resetIC(this.im.getID(), this.id);
            }
            catch (Exception exception) {
                if (!Manager.DEBUG) break block3;
                exception.printStackTrace();
            }
        }
        if (!bl) {
            this.setConversionMode(false);
        }
    }

    void setID(int n) {
        this.id = n;
        this.connected = true;
    }

    int getID() {
        return this.id;
    }

    private void setConversionMode(boolean bl) {
        block2: {
            try {
                this.client.notifyTrigger(this.im.getID(), this.id, bl);
            }
            catch (Exception exception) {
                if (!Manager.DEBUG) break block2;
                exception.printStackTrace();
            }
        }
        this.convMode = bl;
    }

    void setConversionModeOff() {
        this.convMode = false;
    }

    private boolean reconnect() {
        if (this.connected) {
            return true;
        }
        try {
            this.client.createIC(this.im.getID(), this.locale);
        }
        catch (Exception exception) {
            if (Manager.DEBUG) {
                exception.printStackTrace();
            }
            return false;
        }
        this.connected = true;
        return true;
    }

    private void setFocus(boolean bl) {
        block2: {
            try {
                this.client.setFocus(this.im.getID(), this.id, bl);
            }
            catch (Exception exception) {
                if (!Manager.DEBUG) break block2;
                exception.printStackTrace();
            }
        }
    }

    private boolean isConversionMode() {
        return !this.connected ? false : this.convMode;
    }

    public boolean isIn(java.awt.im.InputContext inputContext) {
        return this.ic == inputContext;
    }

    public void removeContentAt(int n) {
        if (this.composedText.size() > n) {
            this.composedText.removeElementAt(n);
        }
    }

    public void insertContentAt(FeedbackChar feedbackChar, int n) {
        ComposedChar composedChar = new ComposedChar();
        composedChar.c = feedbackChar.c;
        composedChar.attr = this.convertVisualFeedbackToHighlight(feedbackChar.fd[0].value);
        this.composedText.insertElementAt(composedChar, n);
    }

    AttributedString getAttributedString() {
        if (this.composedText.isEmpty()) {
            return new AttributedString("");
        }
        Object[] objectArray = new ComposedChar[this.composedText.size()];
        this.composedText.copyInto(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(((ComposedChar)objectArray[n]).c);
            ++n;
        }
        AttributedString attributedString = new AttributedString(stringBuffer.toString());
        int n2 = 0;
        int n3 = 0;
        InputMethodHighlight inputMethodHighlight = ((ComposedChar)objectArray[0]).attr;
        while (n3 < objectArray.length) {
            InputMethodHighlight inputMethodHighlight2 = ((ComposedChar)objectArray[n3]).attr;
            if (inputMethodHighlight2 != inputMethodHighlight) {
                if (inputMethodHighlight != null) {
                    attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, n2, n3);
                }
                inputMethodHighlight = inputMethodHighlight2;
                n2 = n3;
            }
            ++n3;
        }
        if (inputMethodHighlight != null) {
            attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, n2, n3);
        }
        return attributedString;
    }

    private InputMethodHighlight convertVisualFeedbackToHighlight(int n) {
        InputMethodHighlight inputMethodHighlight;
        switch (n) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 1: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 32: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 64: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        return inputMethodHighlight;
    }

    public void done() {
        this.active = false;
        this.convMode = false;
        this.isForwardEvent = false;
        this.composedText = new Vector();
    }

    private void debug(String string) {
        if (Manager.DEBUG) {
            System.err.println(string);
        }
    }

    private class ComposedChar {
        char c;
        InputMethodHighlight attr;

        private ComposedChar() {
        }
    }
}

