/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import sun.awt.im.iiimp.AnnotationValue;
import sun.awt.im.iiimp.FeedbackChar;
import sun.awt.im.iiimp.IIIMProtocol;
import sun.awt.im.iiimp.Manager;
import sun.awt.im.iiimp.ProtocolData;

class FeedbackText
implements IIIMProtocol {
    int count = 0;
    FeedbackChar[] value = new FeedbackChar[8];
    private AnnotationValue[] annotations = null;

    public String toString() {
        if (this.count == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.count) {
            stringBuffer.append(this.value[n].c);
            ++n;
        }
        return stringBuffer.toString();
    }

    FeedbackText() {
    }

    void append(FeedbackChar feedbackChar) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = feedbackChar;
    }

    void ensureCapacity(int n) {
        int n2 = this.value.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            FeedbackChar[] feedbackCharArray = new FeedbackChar[n3];
            System.arraycopy(this.value, 0, feedbackCharArray, 0, this.count);
            this.value = feedbackCharArray;
        }
    }

    static FeedbackText toFeedbackText(ProtocolData protocolData) throws IOException {
        int n = protocolData.read4();
        if (n == 0) {
            return null;
        }
        return FeedbackText.toFeedbackTextImpl(protocolData, n);
    }

    static AttributedCharacterIterator toACIterator(FeedbackText feedbackText) {
        AnnotationValue[] annotationValueArray;
        int n;
        AttributedString attributedString = new AttributedString(feedbackText.toString());
        if (Manager.COLOR_SUPPORT) {
            int n2 = 0;
            while (n2 < feedbackText.count) {
                n = 0;
                while (n < feedbackText.value[n2].fd.length) {
                    switch (feedbackText.value[n2].fd[n].id) {
                        case 0: {
                            switch (feedbackText.value[n2].fd[n].value) {
                                case 1: {
                                    attributedString.addAttribute(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON, n2, n2 + 1);
                                    break;
                                }
                                case 2: {
                                    attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, n2, n2 + 1);
                                }
                            }
                            break;
                        }
                        case 1: {
                            attributedString.addAttribute(TextAttribute.FOREGROUND, new Color(feedbackText.value[n2].fd[n].value), n2, n2 + 1);
                            break;
                        }
                        case 2: {
                            attributedString.addAttribute(TextAttribute.BACKGROUND, new Color(feedbackText.value[n2].fd[n].value), n2, n2 + 1);
                            break;
                        }
                        case 3: {
                            attributedString.addAttribute(TextAttribute.FOREGROUND, new Color(feedbackText.value[n2].fd[n].value), n2, n2 + 1);
                            break;
                        }
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if ((annotationValueArray = feedbackText.getAnnotation()) != null) {
            n = 0;
            while (n < annotationValueArray.length) {
                attributedString.addAttribute(annotationValueArray[n].getAttribute(), annotationValueArray[n].getValue(), annotationValueArray[n].getStart(), annotationValueArray[n].getEnd());
                ++n;
            }
        }
        return attributedString.getIterator();
    }

    private static FeedbackText toFeedbackTextImpl(ProtocolData protocolData, int n) throws IOException {
        int n2;
        int n3;
        FeedbackText feedbackText = new FeedbackText();
        int n4 = protocolData.pos + n;
        while (protocolData.pos < n4) {
            FeedbackChar feedbackChar = new FeedbackChar();
            feedbackChar.c = (char)protocolData.read2();
            n3 = protocolData.read2();
            n2 = 0;
            while (n2 < n3) {
                int n5 = protocolData.read4();
                int n6 = protocolData.read4();
                feedbackChar.addFeedbackType(n5, n6);
                n2 += 8;
            }
            feedbackText.append(feedbackChar);
        }
        int n7 = protocolData.read4();
        if (n7 != 0) {
            while (protocolData.available() > 0) {
                n3 = protocolData.read4();
                n2 = 0;
                AnnotationValue[] annotationValueArray = null;
                switch (n3) {
                    case 0: {
                        n2 = protocolData.read4();
                        protocolData.skipBytes(n2);
                        break;
                    }
                    case 1: {
                        annotationValueArray = protocolData.readTextAnnotationValues(AttributedCharacterIterator.Attribute.READING);
                        feedbackText.setAnnotation(annotationValueArray);
                        break;
                    }
                    case 2: {
                        n2 = protocolData.read4();
                        protocolData.skipBytes(n2);
                        break;
                    }
                    case 3: {
                        annotationValueArray = protocolData.readStringAnnotationValues(AttributedCharacterIterator.Attribute.INPUT_METHOD_SEGMENT);
                        feedbackText.setAnnotation(annotationValueArray);
                        protocolData.skipBytes(n2);
                        break;
                    }
                }
            }
        }
        return feedbackText;
    }

    static FeedbackText[] toListOfFeedbackText(ProtocolData protocolData) throws IOException {
        int n;
        int n2 = 26;
        FeedbackText[] feedbackTextArray = new FeedbackText[26];
        int n3 = 0;
        while (protocolData.available() != 0 && (n = protocolData.read4()) != 0) {
            if (n3 == n2) {
                FeedbackText[] feedbackTextArray2 = new FeedbackText[n2 + 26];
                System.arraycopy(feedbackTextArray, 0, feedbackTextArray2, 0, n2);
                feedbackTextArray = feedbackTextArray2;
                n2 += 26;
            }
            feedbackTextArray[n3] = FeedbackText.toFeedbackTextImpl(protocolData, n);
            ++n3;
        }
        if (n3 > 0) {
            FeedbackText[] feedbackTextArray3 = new FeedbackText[n3];
            System.arraycopy(feedbackTextArray, 0, feedbackTextArray3, 0, n3);
            return feedbackTextArray3;
        }
        return null;
    }

    void setAnnotation(AnnotationValue[] annotationValueArray) {
        this.annotations = annotationValueArray;
    }

    AnnotationValue[] getAnnotation() {
        return this.annotations;
    }
}

