/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BaseJspListener;
import org.apache.jasper.compiler.BeanEndGenerator;
import org.apache.jasper.compiler.BeanGenerator;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.CharDataGenerator;
import org.apache.jasper.compiler.ClassDeclarationPhase;
import org.apache.jasper.compiler.CommentGenerator;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.DeclarationGenerator;
import org.apache.jasper.compiler.ExpressionGenerator;
import org.apache.jasper.compiler.FileDeclarationPhase;
import org.apache.jasper.compiler.ForwardGenerator;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.GetPropertyGenerator;
import org.apache.jasper.compiler.IncludeGenerator;
import org.apache.jasper.compiler.InfoGenerator;
import org.apache.jasper.compiler.InitMethodPhase;
import org.apache.jasper.compiler.JakartaCommentGenerator;
import org.apache.jasper.compiler.MappedCharDataGenerator;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.PluginGenerator;
import org.apache.jasper.compiler.ScriptletGenerator;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SetPropertyGenerator;
import org.apache.jasper.compiler.StaticInitializerPhase;
import org.apache.jasper.compiler.StoredCharDataGenerator;
import org.apache.jasper.compiler.TagBeginGenerator;
import org.apache.jasper.compiler.TagEndGenerator;
import org.apache.jasper.compiler.TagLibraries;
import org.apache.jasper.compiler.TagLibraryInfoImpl;

public class JspParseEventListener
extends BaseJspListener {
    private static CommentGenerator commentGenerator = new JakartaCommentGenerator();
    JspCompilationContext ctxt;
    String jspServletBase = "HttpJspBase";
    String serviceMethodName = "_jspService";
    String servletContentType = "text/html";
    String extendsClass = "";
    Vector interfaces = new Vector();
    Vector imports = new Vector();
    String error = "";
    boolean genSessionVariable = true;
    boolean singleThreaded = false;
    boolean autoFlush = true;
    Vector generators = new Vector();
    BeanRepository beanInfo;
    int bufferSize = 8192;
    boolean languageDir = false;
    boolean extendsDir = false;
    boolean sessionDir = false;
    boolean bufferDir = false;
    boolean threadsafeDir = false;
    boolean errorpageDir = false;
    boolean iserrorpageDir = false;
    boolean infoDir = false;
    boolean autoFlushDir = false;
    boolean contentTypeDir = false;
    int stringId = 0;
    Vector vector = new Vector();
    String dataFile;
    TagLibraries libraries;
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;
    static final String languageStr = "language";
    static final String extendsStr = "extends";
    static final String importStr = "import";
    static final String sessionStr = "session";
    static final String bufferStr = "buffer";
    static final String autoFlushStr = "autoFlush";
    static final String isThreadSafeStr = "isThreadSafe";
    static final String infoStr = "info";
    static final String errorPageStr = "errorPage";
    static final String isErrorPageStr = "isErrorPage";
    static final String contentTypeStr = "contentType";
    PageDirectiveHandlerInfo[] pdhis = new PageDirectiveHandlerInfo[]{new PageDirectiveHandlerInfo("language", new LanguageHandler()), new PageDirectiveHandlerInfo("extends", new ExtendsHandler()), new PageDirectiveHandlerInfo("import", new ImportsHandler()), new PageDirectiveHandlerInfo("session", new SessionHandler()), new PageDirectiveHandlerInfo("buffer", new BufferHandler()), new PageDirectiveHandlerInfo("autoFlush", new AutoFlushHandler()), new PageDirectiveHandlerInfo("isThreadSafe", new IsThreadSafeHandler()), new PageDirectiveHandlerInfo("info", new InfoHandler()), new PageDirectiveHandlerInfo("isErrorPage", new IsErrorPageHandler()), new PageDirectiveHandlerInfo("contentType", new ContentTypeHandler()), new PageDirectiveHandlerInfo("errorPage", new ErrorPageHandler())};
    static /* synthetic */ Class class$org$apache$jasper$compiler$ServiceMethodPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$FileDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$ClassDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$StaticInitializerPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$InitMethodPhase;

    JspParseEventListener(JspCompilationContext jspCompilationContext) {
        super(jspCompilationContext.getReader(), jspCompilationContext.getWriter());
        String string;
        int n;
        this.ctxt = jspCompilationContext;
        this.beanInfo = new BeanRepository(jspCompilationContext.getClassLoader());
        this.libraries = new TagLibraries(jspCompilationContext.getClassLoader());
        if (jspCompilationContext.getOptions().getLargeFile() && (n = (string = jspCompilationContext.getServletJavaFileName()).lastIndexOf(".java")) > 0) {
            this.dataFile = String.valueOf(string.substring(0, n)) + ".dat";
        }
    }

    final void addGenerator(Generator generator) throws JasperException {
        generator.init(this.ctxt);
        this.generators.addElement(generator);
    }

    public void beginPageProcessing() throws JasperException {
        int n = 0;
        while (n < Constants.STANDARD_IMPORTS.length) {
            this.imports.addElement(Constants.STANDARD_IMPORTS[n]);
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void endPageProcessing() throws JasperException {
        this.generateHeader();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ServiceMethodPhase != null ? class$org$apache$jasper$compiler$ServiceMethodPhase : (class$org$apache$jasper$compiler$ServiceMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ServiceMethodPhase")));
        this.writer.println();
        this.generateFooter();
        if (this.ctxt.getOptions().getLargeFile()) {
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.dataFile));
                char[][] cArray = new char[this.vector.size()][];
                this.vector.copyInto((Object[])cArray);
                objectOutputStream.writeObject(cArray);
                objectOutputStream.close();
                this.writer.close();
            }
            catch (IOException iOException) {
                throw new JasperException(Constants.getString("jsp.error.data.file.write"), iOException);
            }
        }
        this.ctxt.setContentType(this.servletContentType);
    }

    private void generateAll(Class clazz) throws JasperException {
        int n = 0;
        while (n < this.generators.size()) {
            Generator generator = (Generator)this.generators.elementAt(n);
            if (clazz.isInstance(generator)) {
                generator.generate(this.writer, clazz);
            }
            ++n;
        }
    }

    private void generateFooter() throws JasperException {
        this.writer.popIndent();
        this.writer.println("} catch (Exception ex) {");
        this.writer.pushIndent();
        this.writer.println("if (out != null && out.getBufferSize() != 0)");
        this.writer.pushIndent();
        this.writer.println("out.clearBuffer();");
        this.writer.popIndent();
        this.writer.println("if (pageContext != null) pageContext.handlePageException(ex);");
        this.writer.popIndent();
        this.writer.println("} finally {");
        this.writer.pushIndent();
        this.writer.println("if (out != null) out.flush();");
        this.writer.println("if (_jspxFactory != null) _jspxFactory.releasePageContext(pageContext);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
    }

    private void generateHeader() throws JasperException {
        String string = this.ctxt.getServletPackageName();
        String string2 = this.ctxt.getServletClassName();
        if (!"".equals(string) && string != null) {
            this.writer.println("package " + string + ";");
            this.writer.println();
        }
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            this.writer.println("import " + (String)enumeration.nextElement() + ";");
        }
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$FileDeclarationPhase != null ? class$org$apache$jasper$compiler$FileDeclarationPhase : (class$org$apache$jasper$compiler$FileDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.FileDeclarationPhase")));
        this.writer.println();
        this.writer.print("public class " + string2 + " extends ");
        this.writer.print(this.extendsClass.equals("") ? this.jspServletBase : this.extendsClass);
        if (this.singleThreaded) {
            this.interfaces.addElement("SingleThreadModel");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.println("     implements ");
            int n = 0;
            while (n < this.interfaces.size() - 1) {
                this.writer.println(" " + this.interfaces.elementAt(n) + ",");
                ++n;
            }
            this.writer.println(" " + this.interfaces.elementAt(this.interfaces.size() - 1));
        }
        this.writer.println(" {");
        this.writer.pushIndent();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ClassDeclarationPhase != null ? class$org$apache$jasper$compiler$ClassDeclarationPhase : (class$org$apache$jasper$compiler$ClassDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ClassDeclarationPhase")));
        this.writer.println();
        this.writer.println("static {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$StaticInitializerPhase != null ? class$org$apache$jasper$compiler$StaticInitializerPhase : (class$org$apache$jasper$compiler$StaticInitializerPhase = JspParseEventListener.class$("org.apache.jasper.compiler.StaticInitializerPhase")));
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("public " + string2 + "( ) {");
        this.writer.println("}");
        this.writer.println();
        this.writer.println("private static boolean _jspx_inited = false;");
        this.writer.println();
        this.writer.println("public final void _jspx_init() throws JasperException {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$InitMethodPhase != null ? class$org$apache$jasper$compiler$InitMethodPhase : (class$org$apache$jasper$compiler$InitMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.InitMethodPhase")));
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public void " + this.serviceMethodName + "(" + "HttpServletRequest request, " + "HttpServletResponse  response)");
        this.writer.println("    throws IOException, ServletException {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("JspFactory _jspxFactory = null;");
        this.writer.println("PageContext pageContext = null;");
        if (this.genSessionVariable) {
            this.writer.println("HttpSession session = null;");
        }
        if (this.ctxt.isErrorPage()) {
            this.writer.println("Throwable exception = (Throwable) request.getAttribute(\"javax.servlet.jsp.jspException\");");
        }
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("JspWriter out = null;");
        this.writer.println("Object page = this;");
        this.writer.println("String  _value = null;");
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("if (_jspx_inited == false) {");
        this.writer.pushIndent();
        this.writer.println("_jspx_init();");
        this.writer.println("_jspx_inited = true;");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("_jspxFactory = JspFactory.getDefaultFactory();");
        if (this.contentTypeDir) {
            this.writer.println("response.setContentType(" + this.writer.quoteString(this.servletContentType) + ");");
        } else {
            this.writer.println("response.setContentType(\"" + this.servletContentType + ";charset=ISO-8859-1\");");
        }
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response,\n\t\t\t" + this.writer.quoteString(this.error) + ", " + this.genSessionVariable + ", " + this.bufferSize + ", " + this.autoFlush + ");");
        this.writer.println();
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        if (this.genSessionVariable) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("out = pageContext.getOut();");
    }

    private Stack getTagHandlerStack() {
        if (this.tagHandlerStack == null) {
            this.tagHandlerStack = new Stack();
        }
        return this.tagHandlerStack;
    }

    public TagLibraries getTagLibraries() {
        return this.libraries;
    }

    private Hashtable getTagVarNumbers() {
        if (this.tagVarNumbers == null) {
            this.tagVarNumbers = new Hashtable();
        }
        return this.tagVarNumbers;
    }

    public void handleBean(Mark mark, Mark mark2, Hashtable hashtable) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new BeanGenerator(mark, hashtable, this.beanInfo, this.genSessionVariable), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleBeanEnd(Mark mark, Mark mark2, Hashtable hashtable) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new BeanEndGenerator(), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleCharData(Mark mark, Mark mark2, char[] cArray) throws JasperException {
        GeneratorBase generatorBase = this.ctxt.getOptions().getLargeFile() ? new StoredCharDataGenerator(this.vector, this.dataFile, this.stringId++, cArray) : (this.ctxt.getOptions().getMappedFile() ? new MappedCharDataGenerator(cArray) : new CharDataGenerator(cArray));
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(generatorBase, mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleComment(Mark mark, Mark mark2) throws JasperException {
        Constants.message("jsp.message.htmlcomment", new Object[]{this.reader.getChars(mark, mark2)}, 4);
    }

    public void handleDeclaration(Mark mark, Mark mark2, Hashtable hashtable) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new DeclarationGenerator(this.reader.getChars(mark, mark2)), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleDirective(String string, Mark mark, Mark mark2, Hashtable hashtable) throws JasperException {
        Object[] objectArray;
        String string2;
        Object object;
        Constants.message("jsp.message.handling_directive", new Object[]{string, hashtable}, 4);
        if (string.equals("page")) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                string2 = (String)object.nextElement();
                int n = 0;
                while (n < this.pdhis.length) {
                    objectArray = this.pdhis[n];
                    if (string2.equals(objectArray.attribute)) {
                        String string3 = (String)hashtable.get(objectArray.attribute);
                        objectArray.handler.handlePageDirectiveAttribute(this, string3, mark, mark2);
                    }
                    ++n;
                }
            }
        }
        if (this.bufferSize == 0 && !this.autoFlush) {
            throw new CompileException(mark, Constants.getString("jsp.error.page.bad_b_and_a_combo"));
        }
        if (string.equals("taglib")) {
            object = (String)hashtable.get("uri");
            string2 = (String)hashtable.get("prefix");
            try {
                TagLibraryInfoImpl tagLibraryInfoImpl = new TagLibraryInfoImpl(this.ctxt, string2, (String)object);
                this.libraries.addTagLibrary(string2, tagLibraryInfoImpl);
            }
            catch (Exception exception) {
                objectArray = new Object[]{object, exception.getMessage()};
                throw new CompileException(mark, Constants.getString("jsp.error.badtaglib", objectArray));
            }
        }
        if (string.equals("include")) {
            object = (String)hashtable.get("file");
            if (object == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.include.missing.file"));
            }
            try {
                this.reader.pushFile((String)object, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CompileException(mark, Constants.getString("jsp.error.include.bad.file"));
            }
        }
    }

    public void handleExpression(Mark mark, Mark mark2, Hashtable hashtable) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new ExpressionGenerator(this.reader.getChars(mark, mark2)), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleForward(Mark mark, Mark mark2, Hashtable hashtable, Hashtable hashtable2) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new ForwardGenerator(mark, hashtable, hashtable2), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleGetProperty(Mark mark, Mark mark2, Hashtable hashtable) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new GetPropertyGenerator(mark, mark2, hashtable, this.beanInfo), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleInclude(Mark mark, Mark mark2, Hashtable hashtable, Hashtable hashtable2) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new IncludeGenerator(mark, hashtable, hashtable2), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handlePlugin(Mark mark, Mark mark2, Hashtable hashtable, Hashtable hashtable2, String string) throws JasperException {
        Constants.message("jsp.message.handling_plugin", new Object[]{hashtable}, 4);
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new PluginGenerator(mark, hashtable, hashtable2, string), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleScriptlet(Mark mark, Mark mark2, Hashtable hashtable) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new ScriptletGenerator(this.reader.getChars(mark, mark2)), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleSetProperty(Mark mark, Mark mark2, Hashtable hashtable) throws JasperException {
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(new SetPropertyGenerator(mark, mark2, hashtable, this.beanInfo), mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleTagBegin(Mark mark, Mark mark2, Hashtable hashtable, String string, String string2, TagLibraryInfo tagLibraryInfo, TagInfo tagInfo) throws JasperException {
        TagBeginGenerator tagBeginGenerator = new TagBeginGenerator(mark, string, string2, hashtable, tagLibraryInfo, tagInfo, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers());
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(tagBeginGenerator, mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public void handleTagEnd(Mark mark, Mark mark2, String string, String string2, Hashtable hashtable, TagLibraryInfo tagLibraryInfo, TagInfo tagInfo) throws JasperException {
        TagEndGenerator tagEndGenerator = new TagEndGenerator(string, string2, hashtable, tagLibraryInfo, tagInfo, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers());
        GeneratorWrapper generatorWrapper = new GeneratorWrapper(tagEndGenerator, mark, mark2);
        this.addGenerator(generatorWrapper);
    }

    public static void setCommentGenerator(CommentGenerator commentGenerator) {
        if (JspParseEventListener.commentGenerator == null) {
            throw new IllegalArgumentException("null == generator");
        }
        JspParseEventListener.commentGenerator = commentGenerator;
    }

    static interface PageDirectiveHandler {
        public void handlePageDirectiveAttribute(JspParseEventListener var1, String var2, Mark var3, Mark var4) throws JasperException;
    }

    static final class PageDirectiveHandlerInfo {
        String attribute;
        PageDirectiveHandler handler;

        PageDirectiveHandlerInfo(String string, PageDirectiveHandler pageDirectiveHandler) {
            this.attribute = string;
            this.handler = pageDirectiveHandler;
        }
    }

    static final class ContentTypeHandler
    implements PageDirectiveHandler {
        ContentTypeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.contentTypeDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.contenttypes"));
            }
            jspParseEventListener.contentTypeDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.contenttype"));
            }
            jspParseEventListener.servletContentType = string;
        }
    }

    static final class SessionHandler
    implements PageDirectiveHandler {
        SessionHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.sessionDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.session"));
            }
            jspParseEventListener.sessionDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.session"));
            }
            if (string.equalsIgnoreCase("true")) {
                jspParseEventListener.genSessionVariable = true;
            } else if (string.equalsIgnoreCase("false")) {
                jspParseEventListener.genSessionVariable = false;
            } else {
                throw new CompileException(mark, "Invalid value for session");
            }
        }
    }

    static final class BufferHandler
    implements PageDirectiveHandler {
        BufferHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.bufferDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.buffer"));
            }
            jspParseEventListener.bufferDir = true;
            if (string != null) {
                if (string.equalsIgnoreCase("none")) {
                    jspParseEventListener.bufferSize = 0;
                } else {
                    Integer n = null;
                    try {
                        int n2 = string.indexOf("k");
                        String string2 = n2 == -1 ? string : string.substring(0, n2);
                        n = new Integer(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.buffer"));
                    }
                    jspParseEventListener.bufferSize = n * 1024;
                }
            } else {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.buffer"));
            }
        }
    }

    static final class AutoFlushHandler
    implements PageDirectiveHandler {
        AutoFlushHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.autoFlushDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.autoflush"));
            }
            jspParseEventListener.autoFlushDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.autoflush"));
            }
            if (string.equalsIgnoreCase("true")) {
                jspParseEventListener.autoFlush = true;
            } else if (string.equalsIgnoreCase("false")) {
                jspParseEventListener.autoFlush = false;
            } else {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.autoflush"));
            }
        }
    }

    static final class IsThreadSafeHandler
    implements PageDirectiveHandler {
        IsThreadSafeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.threadsafeDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.threadsafe"));
            }
            jspParseEventListener.threadsafeDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
            if (string.equalsIgnoreCase("true")) {
                jspParseEventListener.singleThreaded = false;
            } else if (string.equalsIgnoreCase("false")) {
                jspParseEventListener.singleThreaded = true;
            } else {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.threadsafe"));
            }
        }
    }

    static final class InfoHandler
    implements PageDirectiveHandler {
        InfoHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.infoDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.info"));
            }
            jspParseEventListener.infoDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.info"));
            }
            JspParseEventListener jspParseEventListener2 = jspParseEventListener;
            jspParseEventListener2.getClass();
            GeneratorWrapper generatorWrapper = jspParseEventListener2.new GeneratorWrapper(new InfoGenerator(string), mark, mark2);
            jspParseEventListener.addGenerator(generatorWrapper);
        }
    }

    static final class IsErrorPageHandler
    implements PageDirectiveHandler {
        IsErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.iserrorpageDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.iserrorpage"));
            }
            jspParseEventListener.iserrorpageDir = true;
            if (string == null) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
            if (string.equalsIgnoreCase("true")) {
                jspParseEventListener.ctxt.setErrorPage(true);
            } else if (string.equalsIgnoreCase("false")) {
                jspParseEventListener.ctxt.setErrorPage(false);
            } else {
                throw new CompileException(mark, Constants.getString("jsp.error.page.invalid.iserrorpage"));
            }
        }
    }

    static final class ErrorPageHandler
    implements PageDirectiveHandler {
        ErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.errorpageDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.errorpage"));
            }
            jspParseEventListener.errorpageDir = true;
            if (string != null) {
                jspParseEventListener.error = string;
            }
        }
    }

    static final class LanguageHandler
    implements PageDirectiveHandler {
        LanguageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.languageDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.language"));
            }
            jspParseEventListener.languageDir = true;
            if (string != null && !string.equalsIgnoreCase("java")) {
                throw new CompileException(mark, String.valueOf(Constants.getString("jsp.error.page.nomapping.language")) + string);
            }
        }
    }

    static final class ImportsHandler
    implements PageDirectiveHandler {
        ImportsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    jspParseEventListener.imports.addElement(stringTokenizer.nextToken());
                }
            }
        }
    }

    static final class ExtendsHandler
    implements PageDirectiveHandler {
        ExtendsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener jspParseEventListener, String string, Mark mark, Mark mark2) throws JasperException {
            if (jspParseEventListener.extendsDir) {
                throw new CompileException(mark, Constants.getString("jsp.error.page.multiple.extends"));
            }
            jspParseEventListener.extendsDir = true;
            if (string != null) {
                jspParseEventListener.extendsClass = string;
                if (string.indexOf(".") == -1) {
                    jspParseEventListener.imports.addElement(string);
                }
            }
        }
    }

    class GeneratorWrapper
    implements Generator,
    ClassDeclarationPhase,
    FileDeclarationPhase,
    ServiceMethodPhase,
    InitMethodPhase,
    StaticInitializerPhase {
        Generator generator;
        Mark start;
        Mark stop;

        GeneratorWrapper(Generator generator, Mark mark, Mark mark2) {
            this.generator = generator;
            this.start = mark;
            this.stop = mark2;
        }

        public void generate(ServletWriter servletWriter, Class clazz) throws JasperException {
            if (clazz.isInstance(this.generator)) {
                boolean bl = this.generator.generateCoordinates(clazz);
                if (bl) {
                    commentGenerator.generateStartComment(this.generator, servletWriter, this.start, this.stop);
                }
                this.generator.generate(servletWriter, clazz);
                if (bl) {
                    commentGenerator.generateEndComment(this.generator, servletWriter, this.start, this.stop);
                }
            }
        }

        public boolean generateCoordinates(Class clazz) {
            return this.generator.generateCoordinates(clazz);
        }

        public void init(JspCompilationContext jspCompilationContext) throws JasperException {
            this.generator.init(jspCompilationContext);
        }
    }
}

