/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import tyrex.util.Messages;

public final class XidHashtable {
    private Entry[] _table;
    private int _size;
    private static final int TABLE_SIZE = 4049;

    public XidHashtable() {
        this(4049);
    }

    public XidHashtable(int n) {
        this._table = new Entry[n];
    }

    public Enumeration elements() {
        return new XidHashtableEnumeration(this._table, true);
    }

    private boolean equals(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < 12) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object get(byte[] byArray) {
        int n = (this.hashCode(byArray) & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._table[n];
        while (entry != null && entry.gxid != byArray && !this.equals(entry.gxid, byArray)) {
            entry = entry.next;
        }
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    private int hashCode(byte[] byArray) {
        int n = 0;
        int n2 = 8;
        while (n2-- > 0) {
            n = (n << 4) + byArray[n2];
        }
        return n;
    }

    public Enumeration keys() {
        return new XidHashtableEnumeration(this._table, false);
    }

    public Object put(byte[] byArray, Object object) {
        int n = (this.hashCode(byArray) & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._table[n];
        while (entry != null && entry.gxid != byArray && !this.equals(entry.gxid, byArray)) {
            entry = entry.next;
        }
        if (entry != null) {
            Object object2 = entry.value;
            entry.value = object;
            if (object == null) {
                --this._size;
            }
            return object2;
        }
        entry = new Entry();
        entry.value = object;
        entry.gxid = byArray;
        Entry[] entryArray = this._table;
        synchronized (entryArray) {
            entry.next = this._table[n];
            this._table[n] = entry;
            ++this._size;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object remove(byte[] byArray) {
        Entry entry;
        int n = (this.hashCode(byArray) & Integer.MAX_VALUE) % this._table.length;
        Entry[] entryArray = this._table;
        synchronized (entryArray) {
            entry = this._table[n];
            if (entry == null) {
                return null;
            }
            if (entry.gxid == byArray || this.equals(entry.gxid, byArray)) {
                this._table[n] = entry.next;
                --this._size;
                return entry.value;
            }
        }
        while (true) {
            if (entry.next == null || entry.next.gxid == byArray || this.equals(entry.next.gxid, byArray)) {
                if (entry.next == null) return null;
                Object object = entry.next.value;
                entry.next = entry.next.next;
                --this._size;
                return object;
            }
            entry = entry.next;
        }
    }

    public int size() {
        return this._size;
    }

    static class Entry {
        Object value;
        Entry next;
        byte[] gxid;

        Entry() {
        }
    }

    static class XidHashtableEnumeration
    implements Enumeration {
        private Entry[] _table;
        private Entry _entry;
        private int _index;
        private boolean _element;

        XidHashtableEnumeration(Entry[] entryArray, boolean bl) {
            this._table = entryArray;
            this._index = 0;
            this._element = bl;
            this._entry = this._table[0];
        }

        public boolean hasMoreElements() {
            while (this._entry == null && this._index < this._table.length - 1) {
                ++this._index;
                this._entry = this._table[this._index];
            }
            return this._entry != null;
        }

        public Object nextElement() {
            while (this._entry == null && this._index < this._table.length - 1) {
                ++this._index;
                this._entry = this._table[this._index];
            }
            if (this._entry != null) {
                Object object = this._element ? this._entry.value : (Object)this._entry.gxid;
                this._entry = this._entry.next;
                return object;
            }
            throw new NoSuchElementException(Messages.message("tyrex.misc.noMoreXid"));
        }
    }
}

