/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.GetThreadPoolAction;

abstract class Request {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final int UNUSED = 0;
    private static final int OPEN = 1;
    private static final int EOF = 2;
    private static final int CLOSED = 3;
    private static final int INVALID = 4;
    private Object stateLock = new Object();
    private boolean aborted = false;
    private ContentOutputStream out;
    private int outState = 0;
    private Object outLock = new Object();
    private IOException outException;
    private ContentInputStream in;
    private int inState = 0;
    private Object inLock = new Object();
    private IOException inException;

    Request() {
        this.out = new ContentOutputStream();
        this.in = new ContentInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDeliveryStatus() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = this.outState > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.aborted || this.outState >= 3 && this.inState >= 2) {
                return;
            }
            this.aborted = true;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Request.this.finish();
            }
        };
        systemThreadPool.execute(runnable, "Request reaper");
    }

    void finish() {
        try {
            this.out.close(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.in.close(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    InputStream getInputStream() {
        return this.in;
    }

    abstract void startOutput() throws IOException;

    abstract void write(byte[] var1, int var2, int var3) throws IOException;

    abstract void endOutput() throws IOException;

    abstract boolean startInput() throws IOException;

    abstract int read(byte[] var1, int var2, int var3) throws IOException;

    abstract int available() throws IOException;

    abstract void endInput() throws IOException;

    abstract void done(boolean var1);

    private final class ContentInputStream
    extends InputStream {
        private ContentInputStream() {
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, 1) != -1 ? byArray[0] & 0xFF : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            Object object = Request.this.inLock;
            synchronized (object) {
                if (!this.checkOpen()) {
                    return -1;
                }
                try {
                    int n3 = Request.this.read(byArray, n, n2);
                    if (n3 != -1) return n3;
                    Request.this.endInput();
                    Object object2 = Request.this.stateLock;
                    synchronized (object2) {
                        Request.this.inState = 2;
                        if (Request.this.outState < 3) return n3;
                        Request.this.done(Request.this.outState == 4);
                        return n3;
                    }
                }
                catch (Throwable throwable) {
                    this.invalidate(throwable);
                    throw new InternalError();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int available() throws IOException {
            Object object = Request.this.inLock;
            synchronized (object) {
                if (!this.checkOpen()) {
                    return 0;
                }
                try {
                    return Request.this.available();
                }
                catch (Throwable throwable) {
                    this.invalidate(throwable);
                    throw new InternalError();
                }
            }
        }

        public void close() throws IOException {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean checkOpen() throws IOException {
            Object object = Request.this.stateLock;
            synchronized (object) {
                if (Request.this.aborted) {
                    throw new IOException("request aborted");
                }
                switch (Request.this.inState) {
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        throw new IOException("stream closed");
                    }
                    case 4: {
                        if (Request.this.inException != null) throw Request.this.inException;
                        Request.this.inException = new IOException("stream invalid");
                        throw Request.this.inException;
                    }
                }
                Request.this.inState = 1;
            }
            try {
                if (Request.this.startInput()) {
                    return true;
                }
                Request.this.endInput();
                Object object2 = Request.this.stateLock;
                synchronized (object2) {
                    Request.this.inState = 2;
                    if (Request.this.outState < 3) return false;
                    Request.this.done(Request.this.outState == 4);
                    return false;
                }
            }
            catch (Throwable throwable) {
                this.invalidate(throwable);
                throw new InternalError();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean bl) throws IOException {
            Object object = Request.this.inLock;
            synchronized (object) {
                Object object2 = Request.this.stateLock;
                synchronized (object2) {
                    if (bl && Request.this.aborted) {
                        throw new IOException("request aborted");
                    }
                    switch (Request.this.inState) {
                        case 2: {
                            Request.this.inState = 3;
                        }
                        case 3: {
                            return;
                        }
                        case 4: {
                            if (Request.this.inException == null) {
                                Request.this.inException = new IOException("stream invalid");
                            }
                            throw Request.this.inException;
                        }
                    }
                }
                try {
                    if (Request.this.inState == 0) {
                        Request.this.startInput();
                    }
                    Request.this.endInput();
                }
                catch (Throwable throwable) {
                    this.invalidate(throwable);
                }
                Object object3 = Request.this.stateLock;
                synchronized (object3) {
                    Request.this.inState = 3;
                    if (Request.this.outState >= 3) {
                        Request.this.done(Request.this.outState == 4);
                    }
                }
            }
        }

        private void invalidate(Throwable throwable) throws IOException {
            Object object = Request.this.stateLock;
            synchronized (object) {
                if (Request.this.inState != 4) {
                    if (Request.this.inState <= 1 && Request.this.outState >= 3) {
                        Request.this.done(true);
                    }
                    Request.this.inState = 4;
                    Request.this.inException = new IOException("stream invalid");
                }
                throw Request.this.inException;
            }
        }
    }

    private final class ContentOutputStream
    extends OutputStream {
        private ContentOutputStream() {
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Object object = Request.this.outLock;
            synchronized (object) {
                this.checkOpen();
                try {
                    Request.this.write(byArray, n, n2);
                }
                catch (Throwable throwable) {
                    this.invalidate(throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object = Request.this.outLock;
            synchronized (object) {
                this.checkOpen();
            }
        }

        public void close() throws IOException {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkOpen() throws IOException {
            Object object = Request.this.stateLock;
            synchronized (object) {
                if (Request.this.aborted) {
                    throw new IOException("request aborted");
                }
                switch (Request.this.outState) {
                    case 1: {
                        return;
                    }
                    case 3: {
                        throw new IOException("stream closed");
                    }
                    case 4: {
                        if (Request.this.outException == null) {
                            Request.this.outException = new IOException("stream invalid");
                        }
                        throw Request.this.outException;
                    }
                }
                Request.this.outState = 1;
            }
            try {
                Request.this.startOutput();
            }
            catch (Throwable throwable) {
                this.invalidate(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean bl) throws IOException {
            Object object = Request.this.outLock;
            synchronized (object) {
                Object object2 = Request.this.stateLock;
                synchronized (object2) {
                    if (bl && Request.this.aborted) {
                        throw new IOException("request aborted");
                    }
                    if (Request.this.outState == 3) {
                        return;
                    }
                    if (Request.this.outState == 4) {
                        if (Request.this.outException == null) {
                            Request.this.outException = new IOException("stream invalid");
                        }
                        throw Request.this.outException;
                    }
                }
                try {
                    if (Request.this.outState == 0) {
                        Request.this.startOutput();
                    }
                    Request.this.endOutput();
                }
                catch (Throwable throwable) {
                    this.invalidate(throwable);
                }
                Object object3 = Request.this.stateLock;
                synchronized (object3) {
                    Request.this.outState = 3;
                    if (Request.this.inState >= 2) {
                        Request.this.done(Request.this.inState == 4);
                    }
                }
            }
        }

        private void invalidate(Throwable throwable) throws IOException {
            Object object = Request.this.stateLock;
            synchronized (object) {
                if (Request.this.outState != 4) {
                    if (Request.this.outState <= 1 && Request.this.inState >= 2) {
                        Request.this.done(true);
                    }
                    Request.this.outState = 4;
                    Request.this.outException = new IOException("stream invalid");
                }
                throw Request.this.outException;
            }
        }
    }
}

