/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLInputStream;
import org.mozilla.jss.ssl.SSLOutputStream;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SocketBase;
import org.mozilla.jss.ssl.SocketProxy;

public class SSLSocket
extends Socket {
    private Vector handshakeCompletedListeners = new Vector();
    private InetAddress inetAddress;
    private int port;
    private SocketProxy sockProxy;
    private boolean open = false;
    private boolean handshakeAsClient = true;
    private SocketBase base = new SocketBase();
    public static final int SSL2_RC4_128_WITH_MD5 = 65281;
    public static final int SSL2_RC4_128_EXPORT40_WITH_MD5 = 65282;
    public static final int SSL2_RC2_128_CBC_WITH_MD5 = 65283;
    public static final int SSL2_RC2_128_CBC_EXPORT40_WITH_MD5 = 65284;
    public static final int SSL2_DES_64_CBC_WITH_MD5 = 65286;
    public static final int SSL2_DES_192_EDE3_CBC_WITH_MD5 = 65287;
    public static final int SSL3_RSA_WITH_NULL_MD5 = 1;
    public static final int SSL3_RSA_EXPORT_WITH_RC4_40_MD5 = 3;
    public static final int SSL3_RSA_WITH_RC4_128_MD5 = 4;
    public static final int SSL3_RSA_WITH_RC4_128_SHA = 5;
    public static final int SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6;
    public static final int SSL3_RSA_WITH_DES_CBC_SHA = 9;
    public static final int SSL3_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    public static final int SSL3_FORTEZZA_DMS_WITH_NULL_SHA = 28;
    public static final int SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA = 29;
    public static final int SSL3_FORTEZZA_DMS_WITH_RC4_128_SHA = 30;
    public static final int SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA = 65279;
    public static final int SSL_RSA_FIPS_WITH_DES_CBC_SHA = 65278;
    public static final int TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA = 98;
    public static final int TLS_RSA_EXPORT1024_WITH_RC4_56_SHA = 100;
    public static final int TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 99;
    public static final int TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 101;
    public static final int TLS_DHE_DSS_WITH_RC4_128_SHA = 102;

    SSLSocket() throws IOException {
    }

    public SSLSocket(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n, null, 0);
    }

    public SSLSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(InetAddress.getByName(string), n, inetAddress, n2);
    }

    public SSLSocket(String string, int n, InetAddress inetAddress, int n2, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this(InetAddress.getByName(string), n, inetAddress, n2, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback);
    }

    public SSLSocket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, null, 0);
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(inetAddress, n, inetAddress2, n2, null, null);
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this(inetAddress, inetAddress.getHostName(), n, inetAddress2, n2, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback);
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, boolean bl, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this(inetAddress, n, inetAddress2, n2, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback);
    }

    private SSLSocket(InetAddress inetAddress, String string, int n, InetAddress inetAddress2, int n2, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this.sockProxy = new SocketProxy(this.base.socketCreate(this, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback));
        this.base.setProxy(this.sockProxy);
        if (inetAddress2 != null || n2 > 0) {
            byte[] byArray = null;
            if (inetAddress2 != null) {
                byArray = inetAddress2.getAddress();
            }
            this.base.socketBind(byArray, n2);
        }
        this.socketConnect(inetAddress.getAddress(), string, n);
    }

    public void addHandshakeCompletedListener(SSLHandshakeCompletedListener sSLHandshakeCompletedListener) {
        this.handshakeCompletedListeners.addElement(sSLHandshakeCompletedListener);
    }

    public void close() throws IOException {
        if (this.sockProxy != null) {
            this.base.close();
            this.sockProxy = null;
        }
    }

    public void enableSSL2(boolean bl) throws SocketException {
        this.base.enableSSL2(bl);
    }

    public static void enableSSL2Default(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(0, bl);
    }

    public void enableSSL3(boolean bl) throws SocketException {
        this.base.enableSSL3(bl);
    }

    public static void enableSSL3Default(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(1, bl);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public native void forceHandshake() throws SocketException;

    public InetAddress getInetAddress() {
        return this.base.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return new SSLInputStream(this);
    }

    public native boolean getKeepAlive() throws SocketException;

    public InetAddress getLocalAddress() {
        try {
            InetAddress inetAddress;
            int n = this.getLocalAddressNative();
            byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
            try {
                inetAddress = InetAddress.getByName(String.valueOf(byArray[0]) + "." + byArray[1] + "." + byArray[2] + "." + byArray[3]);
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress = null;
            }
            return inetAddress;
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            return null;
        }
    }

    private native int getLocalAddressNative() throws SocketException;

    public int getLocalPort() {
        return this.base.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        return new SSLOutputStream(this);
    }

    public native int getPort();

    public native int getReceiveBufferSize() throws SocketException;

    public native int getSendBufferSize() throws SocketException;

    public native int getSoLinger() throws SocketException;

    public int getSoTimeout() throws SocketException {
        return this.base.getTimeout();
    }

    public native SSLSecurityStatus getStatus() throws SocketException;

    public native boolean getTcpNoDelay() throws SocketException;

    public boolean getUseClientMode() {
        return this.handshakeAsClient;
    }

    public native void invalidateSession() throws SocketException;

    private void notifyAllHandshakeListeners() {
        SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent = new SSLHandshakeCompletedEvent(this);
        int n = 0;
        while (n < this.handshakeCompletedListeners.size()) {
            SSLHandshakeCompletedListener sSLHandshakeCompletedListener = (SSLHandshakeCompletedListener)this.handshakeCompletedListeners.elementAt(n);
            sSLHandshakeCompletedListener.handshakeCompleted(sSLHandshakeCompletedEvent);
            ++n;
        }
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        return this.socketRead(byArray, n, n2, this.base.getTimeout());
    }

    public void redoHandshake() throws SocketException {
        this.redoHandshake(false);
    }

    public native void redoHandshake(boolean var1) throws SocketException;

    public void removeHandshakeCompletedListener(SSLHandshakeCompletedListener sSLHandshakeCompletedListener) {
        this.handshakeCompletedListeners.removeElement(sSLHandshakeCompletedListener);
    }

    public void requestClientAuth(boolean bl) throws SocketException {
        this.base.requestClientAuth(bl);
    }

    public void requireClientAuth(boolean bl, boolean bl2) throws SocketException {
        this.base.requireClientAuth(bl, bl2);
    }

    public void requireClientAuthDefault(boolean bl, boolean bl2) throws SocketException {
        SSLSocket.setSSLDefaultOption(6, bl ? (bl2 ? 1 : 2) : 0);
    }

    public void resetHandshake() throws SocketException {
        this.resetHandshakeNative(this.handshakeAsClient);
    }

    private native void resetHandshakeNative(boolean var1) throws SocketException;

    public static void setCipherPolicy(CipherPolicy cipherPolicy) throws SocketException {
        SSLSocket.setCipherPolicyNative(cipherPolicy.getEnum());
    }

    private static native void setCipherPolicyNative(int var0) throws SocketException;

    public static native void setCipherPreference(int var0, boolean var1);

    public void setClientCertNickname(String string) throws SocketException {
        this.base.setClientCertNickname(string);
    }

    public native void setKeepAlive(boolean var1) throws SocketException;

    public void setNeedClientAuth(boolean bl) throws SocketException {
        this.base.requestClientAuth(bl);
    }

    public void setNeedClientAuthNoExpiryCheck(boolean bl) throws SocketException {
        this.base.requestClientAuthNoExpiryCheck(bl);
    }

    public native void setReceiveBufferSize(int var1) throws SocketException;

    private static native void setSSLDefaultOption(int var0, int var1) throws SocketException;

    private static void setSSLDefaultOption(int n, boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(n, bl ? 1 : 0);
    }

    public native void setSendBufferSize(int var1) throws SocketException;

    public native void setSoLinger(boolean var1, int var2) throws SocketException;

    public void setSoTimeout(int n) throws SocketException {
        this.base.setTimeout(n);
    }

    void setSockProxy(SocketProxy socketProxy) {
        this.sockProxy = socketProxy;
        this.base.setProxy(socketProxy);
    }

    public native void setTcpNoDelay(boolean var1) throws SocketException;

    public void setUseClientMode(boolean bl) {
        this.handshakeAsClient = bl;
    }

    public void shutdownInput() throws IOException {
        this.shutdownNative(4);
    }

    private native void shutdownNative(int var1) throws IOException;

    public void shutdownOutput() throws IOException {
        this.shutdownNative(5);
    }

    native int socketAvailable() throws IOException;

    private native void socketConnect(byte[] var1, String var2, int var3) throws SocketException;

    private native int socketRead(byte[] var1, int var2, int var3, int var4) throws IOException;

    private native void socketWrite(byte[] var1, int var2, int var3, int var4) throws IOException;

    public void useCache(boolean bl) throws SocketException {
        this.base.useCache(bl);
    }

    public void useCacheDefault(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(8, bl ^ true);
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        this.socketWrite(byArray, n, n2, this.base.getTimeout());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class CipherPolicy {
        private int enum;
        public static final CipherPolicy DOMESTIC = new CipherPolicy(9);
        public static final CipherPolicy EXPORT = new CipherPolicy(10);
        public static final CipherPolicy FRANCE = new CipherPolicy(11);

        private CipherPolicy(int n) {
        }

        int getEnum() {
            return this.enum;
        }
    }
}

