/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SocketBase;
import org.mozilla.jss.ssl.SocketProxy;

public class SSLServerSocket
extends ServerSocket {
    public static final int DEFAULT_BACKLOG = 50;
    private SocketProxy sockProxy;
    private boolean handshakeAsClient = false;
    private SocketBase base = new SocketBase();
    private static InetAddress anyLocalAddr;
    private static final String UNIX_TEMP_DIR = "/tmp";
    private static final String WINDOWS_TEMP_DIR = "\\temp";

    static {
        try {
            anyLocalAddr = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public SSLServerSocket(int n) throws IOException {
        this(n, 50, null);
    }

    public SSLServerSocket(int n, int n2) throws IOException {
        this(n, n2, null);
    }

    public SSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this(n, n2, inetAddress, null);
    }

    public SSLServerSocket(int n, int n2, InetAddress inetAddress, SSLCertificateApprovalCallback sSLCertificateApprovalCallback) throws IOException {
        this(n, n2, inetAddress, sSLCertificateApprovalCallback, false);
    }

    public SSLServerSocket(int n, int n2, InetAddress inetAddress, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, boolean bl) throws IOException {
        super(0);
        super.close();
        this.sockProxy = new SocketProxy(this.base.socketCreate(this, sSLCertificateApprovalCallback, null));
        this.base.setProxy(this.sockProxy);
        this.setReuseAddress(bl);
        if (inetAddress == null) {
            inetAddress = anyLocalAddr;
        }
        byte[] byArray = null;
        if (inetAddress != null) {
            byArray = inetAddress.getAddress();
        }
        this.base.socketBind(byArray, n);
        this.socketListen(n2);
    }

    public Socket accept() throws IOException {
        SSLSocket sSLSocket = new SSLSocket();
        sSLSocket.setSockProxy(new SocketProxy(this.socketAccept(sSLSocket, this.base.getTimeout(), this.handshakeAsClient)));
        return sSLSocket;
    }

    public static native void clearSessionCache();

    public void close() throws IOException {
        if (this.sockProxy != null) {
            this.base.close();
            this.sockProxy = null;
        }
    }

    public static native void configServerSessionIDCache(int var0, int var1, int var2, String var3);

    public void enableSSL2(boolean bl) throws SocketException {
        this.base.enableSSL2(bl);
    }

    public void enableSSL3(boolean bl) throws SocketException {
        this.base.enableSSL3(bl);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public InetAddress getInetAddress() {
        return this.base.getInetAddress();
    }

    protected native boolean getReuseAddress() throws SocketException;

    public int getSoTimeout() {
        return this.base.getTimeout();
    }

    public void requestClientAuth(boolean bl) throws SocketException {
        this.base.requestClientAuth(bl);
    }

    public void requireClientAuth(boolean bl, boolean bl2) throws SocketException {
        this.base.requireClientAuth(bl, bl2);
    }

    public void setClientCertNickname(String string) throws SocketException {
        this.base.setClientCertNickname(string);
    }

    public void setNeedClientAuth(boolean bl) throws SocketException {
        this.base.requestClientAuth(bl);
    }

    public void setNeedClientAuthNoExpiryCheck(boolean bl) throws SocketException {
        this.base.requestClientAuthNoExpiryCheck(bl);
    }

    protected native void setReuseAddress(boolean var1) throws SocketException;

    public native void setServerCertNickname(String var1) throws SocketException;

    public void setSoTimeout(int n) {
        this.base.setTimeout(n);
    }

    public void setUseClientMode(boolean bl) {
        this.handshakeAsClient = bl;
    }

    private native byte[] socketAccept(SSLSocket var1, int var2, boolean var3) throws SocketException;

    private native void socketListen(int var1) throws SocketException;

    public void useCache(boolean bl) throws SocketException {
        this.base.useCache(bl);
    }
}

