/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;

public class RecipientInfo
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private INTEGER version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier keyEncryptionAlgorithmID;
    private OCTET_STRING encryptedKey;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Template templateInstance = new Template();

    private RecipientInfo() {
    }

    public RecipientInfo(INTEGER iNTEGER, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier algorithmIdentifier, OCTET_STRING oCTET_STRING) {
        Assert.assert(issuerAndSerialNumber != null);
        Assert.assert(algorithmIdentifier != null);
        Assert.assert(oCTET_STRING != null);
        this.version = iNTEGER;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.keyEncryptionAlgorithmID = algorithmIdentifier;
        this.encryptedKey = oCTET_STRING;
        this.sequence.addElement(iNTEGER);
        this.sequence.addElement(issuerAndSerialNumber);
        this.sequence.addElement(algorithmIdentifier);
        this.sequence.addElement(oCTET_STRING);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public OCTET_STRING getEncryptedKey() {
        return this.encryptedKey;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithmID() {
        return this.keyEncryptionAlgorithmID;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getissuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE.Template template = new SEQUENCE.Template();
            template.addElement(new INTEGER.Template());
            template.addElement(new IssuerAndSerialNumber.Template());
            template.addElement(new AlgorithmIdentifier.Template());
            template.addElement(new OCTET_STRING.Template());
            SEQUENCE sEQUENCE = (SEQUENCE)template.decode(tag, inputStream);
            Assert.assert(sEQUENCE.size() == 4);
            return new RecipientInfo((INTEGER)sEQUENCE.elementAt(0), (IssuerAndSerialNumber)sEQUENCE.elementAt(1), (AlgorithmIdentifier)sEQUENCE.elementAt(2), (OCTET_STRING)sEQUENCE.elementAt(3));
        }

        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }
    }
}

