/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.PublicKey;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Key;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.PublicKeyProxy;
import org.mozilla.jss.util.Assert;

public class PK11PubKey
extends PK11Key
implements PublicKey {
    protected PK11PubKey(byte[] byArray) {
        Assert.assert(byArray != null);
        this.keyProxy = new PublicKeyProxy(byArray);
    }

    private static native PK11PubKey DSAFromRaw(byte[] var0);

    private static native PK11PubKey RSAFromRaw(byte[] var0);

    public static PK11PubKey fromRaw(PrivateKey.Type type, byte[] byArray) throws InvalidKeyFormatException {
        if (type == PrivateKey.RSA) {
            return PK11PubKey.RSAFromRaw(byArray);
        }
        Assert.assert(type == PrivateKey.DSA);
        return PK11PubKey.DSAFromRaw(byArray);
    }

    public native byte[] getEncoded();

    public String getFormat() {
        return "X.509";
    }

    public native KeyType getKeyType();

    public native void verifyKeyIsOnToken(PK11Token var1) throws NoSuchItemOnTokenException;
}

