/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.BackoutPanel;
import com.sun.admin.patchmgr.client.ServiceWrapper;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.RemoteFileData;
import com.sun.management.viper.console.gui.wizard.VWizard;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CommonBackoutCard
extends VWizardCard {
    protected VPatchMgr theApp;
    protected ResourceBundle bundle;
    protected ActionString actionString;
    protected BackoutPanel bp;
    protected VWizard wiz;

    public CommonBackoutCard(VPatchMgr vPatchMgr) {
        this.theApp = vPatchMgr;
        this.bundle = vPatchMgr.getResourceBundle();
        this.constructStep();
    }

    public void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.bp = new BackoutPanel(this.theApp);
        this.bp.setBackoutFieldListener(new BackoutFieldListener());
        this.bp.setRadioBtnListeners(new RadioBListener());
        Constraints.constrain((Container)((Object)this), (Component)this.bp, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)((Object)this), (Component)new JPanel(), (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    protected void updateStatus() {
        if (this.bp.isDefaultSelected()) {
            this.setProperty("vwp.canmoveforward", "vwp.true");
        } else {
            String string = this.bp.getBackoutDir();
            if (string != null && string.length() > 0) {
                this.setProperty("vwp.canmoveforward", "vwp.true");
            } else {
                this.setProperty("vwp.canmoveforward", "vwp.false");
            }
        }
    }

    public void start() {
        this.updateStatus();
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
    }

    public boolean isDataOK() {
        if (this.bp.isDefaultSelected()) {
            return true;
        }
        String string = this.bp.getBackoutDir();
        if (string == null || string.length() <= 0) {
            new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"cmn_backout_bad_dir"));
            this.setProperty("vwp.canmoveforward", "vwp.false");
            return false;
        }
        ServiceWrapper serviceWrapper = this.theApp.getpatchM();
        try {
            RemoteFileData remoteFileData = serviceWrapper.getDirInfo(string);
            if (!remoteFileData.isDirectory()) {
                String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"aa_wiz_bad_dirname");
                new ErrorDialog(null, string2);
                return false;
            }
        }
        catch (AdminException adminException) {
            this.theApp.reportErrorException((Exception)((Object)adminException));
            return false;
        }
        return true;
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        return this.isDataOK();
    }

    public void reset() {
    }

    public boolean isSubStep() {
        return false;
    }

    class RadioBListener
    implements ActionListener {
        RadioBListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommonBackoutCard.this.updateStatus();
        }
    }

    class BackoutFieldListener
    implements DocumentListener {
        BackoutFieldListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CommonBackoutCard.this.updateStatus();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

