/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.IProgressListener;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.LocalJarClassLoader;
import com.netscape.management.client.util.ResourceSet;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class ClassLoaderUtil {
    private static final String debugTag = "ClassLoader: ";
    public static Hashtable loaderHashtable = new Hashtable();
    static ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");

    public static boolean isAlreadyDownload(String string) {
        String[] stringArray = LocalJarClassLoader.getLocalJarList();
        if (stringArray == null) {
            return false;
        }
        if (Debug.getTraceLevel() >= 7) {
            Debug.println((int)7, (String)("ClassLoader:  Search <" + string + "> in java/jars "));
            String string2 = "";
            int n = 0;
            while (n < stringArray.length) {
                string2 = string2 + "<" + stringArray[n] + ">";
                ++n;
            }
            Debug.println((int)7, (String)("ClassLoader:  java/jars content: " + string2));
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                Debug.println((int)7, (String)(debugTag + string + " is already downloaded"));
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Class getClass(ConsoleInfo consoleInfo, String string) {
        try {
            return ClassLoaderUtil.getClass(consoleInfo, string, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class getClass(ConsoleInfo consoleInfo, String string, IProgressListener iProgressListener) throws Exception {
        if (string == null || string.equals("")) {
            Debug.println((int)0, (String)"ClassLoader: getClass:invalid class name argument <null>");
            return null;
        }
        String string2 = "";
        String string3 = "";
        try {
            int n = string.indexOf("@");
            if (n < 0) {
                return Class.forName(string);
            }
            if (Debug.isEnabled()) {
                Debug.println((int)1, (String)("ClassLoaderUtil.getClass(" + string + ")"));
            }
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            LocalJarClassLoader localJarClassLoader = ClassLoaderUtil.getClassLoader(consoleInfo, string3, iProgressListener);
            return localJarClassLoader.loadClass(string2, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println((int)0, (String)("ClassLoader: Cannot load: " + string));
            Debug.println((int)0, (String)(debugTag + classNotFoundException.getMessage()));
            throw new Exception(MessageFormat.format(_resource.getString("error", "ClassNotFound"), string2));
        }
    }

    public static byte[] getResource(ConsoleInfo consoleInfo, String string) {
        try {
            InputStream inputStream = ClassLoaderUtil.getResourceAsStream(consoleInfo, string, null);
            if (inputStream == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = -1;
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(ConsoleInfo consoleInfo, String string, IProgressListener iProgressListener) throws Exception {
        if (string == null || string.equals("")) {
            Debug.println((int)0, (String)"ClassLoader: getClass:invalid class name argument <null>");
            return null;
        }
        String string2 = "";
        String string3 = "";
        int n = string.indexOf("@");
        if (n < 0) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        if (Debug.isEnabled()) {
            Debug.println((int)1, (String)("ClassLoaderUtil.getResource(" + string + ")"));
        }
        string2 = string.substring(0, n);
        string3 = string.substring(n + 1);
        LocalJarClassLoader localJarClassLoader = ClassLoaderUtil.getClassLoader(consoleInfo, string3, iProgressListener);
        return localJarClassLoader.getResourceAsStream(string2);
    }

    static LocalJarClassLoader getClassLoader(ConsoleInfo consoleInfo, String string, IProgressListener iProgressListener) throws Exception {
        String string2 = "";
        String string3 = string;
        String string4 = null;
        try {
            int n = string.indexOf("@");
            if (n > 0) {
                string2 = string.substring(n + 1);
                string3 = string.substring(0, n);
                string4 = LocalJarClassLoader.checkForNewerVersion(string3);
                if (string4 != null) {
                    Debug.println((int)5, (String)("ClassLoader: getClass: use " + string4 + " instead of " + string3 + " (newer backward compatible version)"));
                    string3 = string4;
                } else {
                    ClassLoaderUtil.checkJarAvailability(consoleInfo, string3, string2, iProgressListener);
                }
            } else {
                string4 = LocalJarClassLoader.checkForNewerVersion(string3);
                if (string4 != null) {
                    Debug.println((int)5, (String)("ClassLoader: getClass: use " + string4 + " instead of " + string3 + " (newer backward compatible version)"));
                    string3 = string4;
                }
            }
            LocalJarClassLoader localJarClassLoader = (LocalJarClassLoader)loaderHashtable.get(string3.toLowerCase());
            if (localJarClassLoader == null) {
                localJarClassLoader = new LocalJarClassLoader(string3);
                loaderHashtable.put(string3.toLowerCase(), localJarClassLoader);
                if (Debug.isEnabled()) {
                    Debug.println((int)1, (String)("ClassLoader: Create loader " + string3));
                }
            } else if (Debug.isEnabled()) {
                Debug.println((int)1, (String)("ClassLoader: Loader " + string3 + " found in cache"));
            }
            return localJarClassLoader;
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((int)0, (String)("ClassLoader:  Invalid location specifier for " + string3 + ": " + string2));
            Debug.println((int)0, (String)(debugTag + malformedURLException.getMessage()));
            throw new Exception(MessageFormat.format(_resource.getString("error", "InstallError"), string3) + "\n" + malformedURLException.getMessage());
        }
        catch (LDAPException lDAPException) {
            Debug.println((int)0, (String)("ClassLoader: Invalid location specifier for " + string3 + ": " + string2));
            Debug.println((int)0, (String)(debugTag + lDAPException.getMessage()));
            throw new Exception(MessageFormat.format(_resource.getString("error", "InstallError"), string3) + "\n" + lDAPException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.println((int)0, (String)("ClassLoader: Cannot create LocalJarClassLoader for " + string3));
            Debug.println((int)0, (String)(debugTag + fileNotFoundException.getMessage()));
            throw new Exception(MessageFormat.format(_resource.getString("error", "InstallError"), string3) + "\n" + fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            Debug.println((int)0, (String)("ClassLoader: Cannot create LocalJarClassLoader for " + string3));
            Debug.println((int)0, (String)(debugTag + exception.getMessage()));
            throw new Exception(MessageFormat.format(_resource.getString("error", "InstallError"), string3) + "\n" + exception.getMessage());
        }
    }

    public static void checkJarAvailability(ConsoleInfo consoleInfo, String string, String string2, IProgressListener iProgressListener) throws Exception {
        if (ClassLoaderUtil.isAlreadyDownload(string)) {
            return;
        }
        String string3 = null;
        int n = 0;
        boolean bl = false;
        String string4 = null;
        if (string2.startsWith("http")) {
            string4 = string2;
        } else {
            Object object;
            Debug.println((int)9, (String)("ClassLoader: checkJarAvailability():sie is " + string2));
            LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
            String[] stringArray = new String[]{"nsserverport", "nsserveraddress", "nsserversecurity"};
            String string5 = "cn=Configuration," + string2;
            Debug.println((int)9, (String)("ClassLoader: checkJarAvailability():reading " + string5));
            LDAPEntry lDAPEntry = ClassLoaderUtil.readEntry(lDAPConnection, string5, stringArray);
            if (lDAPEntry == null) {
                throw new LDAPException(_resource.getString("error", "UnableToRead") + string5);
            }
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsserveraddress");
            if (lDAPAttribute != null) {
                string3 = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
            }
            if (string3 == null || string3.trim().length() == 0) {
                object = ClassLoaderUtil.readEntry(lDAPConnection, string2, new String[]{"serverhostname"});
                if (object == null) {
                    throw new LDAPException(_resource.getString("error", "UnableToRead") + string2);
                }
                string3 = LDAPUtil.flatting((LDAPAttribute)object.getAttribute("serverhostname"));
            }
            if (string3 == null || string3.length() == 0) {
                throw new LDAPException(_resource.getString("error", "NoServerHostName") + string2);
            }
            lDAPAttribute = lDAPEntry.getAttribute("nsserverport");
            if (lDAPAttribute == null) {
                throw new LDAPException(_resource.getString("error", "NoServerPortName") + string5);
            }
            n = Integer.parseInt(LDAPUtil.flatting((LDAPAttribute)lDAPAttribute));
            lDAPAttribute = lDAPEntry.getAttribute("nsserversecurity");
            if (lDAPAttribute != null && !((String)(object = LDAPUtil.flatting((LDAPAttribute)lDAPAttribute))).equals("")) {
                bl = ((String)object).toLowerCase().equals("on");
            }
            string4 = (bl ? "https" : "http") + "://" + string3 + ":" + n + "/";
        }
        LocalJarClassLoader.getJarFile(consoleInfo, string4, string, iProgressListener);
    }

    private static LDAPEntry readEntry(LDAPConnection lDAPConnection, String string, String[] stringArray) throws LDAPException {
        String string2 = "(" + stringArray[0] + "=*)";
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 0, string2, stringArray, false);
        return lDAPSearchResults == null ? null : lDAPSearchResults.next();
    }
}

