/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.server.http.session;

import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.netscape.server.http.session.SimpleSessionManager;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class SimpleSession
implements HttpSession {
    private String _id = null;
    private SimpleSessionManager _mgr = null;
    private long _creationTime = 0L;
    private long _lastAccessedTime = 0L;
    private boolean _isNew = false;
    private long _maxInactiveInterval;
    private boolean _isValid = true;
    private Hashtable _values = new Hashtable();
    private int _numObjectsToBeUnbound = 0;
    private boolean _timingOut = false;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    public SimpleSession(String string, int n, SimpleSessionManager simpleSessionManager, ResUtil resUtil) {
        this._id = string;
        this._maxInactiveInterval = n * 1000;
        this._mgr = simpleSessionManager;
        this._lastAccessedTime = this._creationTime = System.currentTimeMillis();
    }

    private boolean _isInvalid() {
        if (!this._isValid) {
            return true;
        }
        if (System.currentTimeMillis() - this._lastAccessedTime >= this._maxInactiveInterval) {
            this._isValid = false;
            this._timingOut = true;
            return true;
        }
        return false;
    }

    public Object getAttribute(String string) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        if (string == null) {
            return null;
        }
        return this._values.get(string);
    }

    public Enumeration getAttributeNames() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._values.keys();
    }

    public long getCreationTime() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._creationTime;
    }

    public String getId() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._id;
    }

    protected String getIdWithoutExceptions() {
        return this._id;
    }

    public long getLastAccessedTime() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return (int)(this._maxInactiveInterval / 1000L);
    }

    public HttpSessionContext getSessionContext() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._mgr.getContext();
    }

    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    public String[] getValueNames() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        String[] stringArray = null;
        Hashtable hashtable = this._values;
        synchronized (hashtable) {
            stringArray = new String[this._values.size()];
            int n = 0;
            Enumeration enumeration = this._values.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
        }
        return stringArray;
    }

    public void invalidate() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        this._mgr.deleteSession(this);
        this._isValid = false;
    }

    protected boolean isFormLoginSession() {
        return false;
    }

    public boolean isNew() {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        return this._isNew;
    }

    public void putValue(String string, Object object) {
        this.setAttribute(string, object);
    }

    protected synchronized void removeAllObjects() {
        if (this._numObjectsToBeUnbound > 0) {
            Enumeration enumeration = this._values.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this._values.get(string);
                if (v == null) continue;
                try {
                    this.unbindObject(string, v);
                }
                catch (Exception exception) {
                    LogUtil.logWarning((String)_res.getProp("session.SimpleSessionManager.msg_simpleSessionManagerUnbindError", (Object)string, (Object)LogUtil.getStackTrace((Throwable)exception)));
                }
                if (this._numObjectsToBeUnbound == 0) break;
            }
        }
        this._values = null;
    }

    public void removeAttribute(String string) {
        if (this._isInvalid() && !this._timingOut) {
            throw new IllegalStateException();
        }
        if (string == null) {
            return;
        }
        Object v = this._values.remove(string);
        if (v != null) {
            this.unbindObject(string, v);
        }
    }

    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        if (string == null) {
            return;
        }
        Object v = this._values.remove(string);
        if (v != null) {
            this.unbindObject(string, v);
        }
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
            ++this._numObjectsToBeUnbound;
        }
        this._values.put(string, object);
    }

    protected void setFormLoginSession() {
    }

    public void setMaxInactiveInterval(int n) {
        if (this._isInvalid()) {
            throw new IllegalStateException();
        }
        this._maxInactiveInterval = n * 1000;
        if (n <= 0) {
            this._mgr.deleteSession(this);
            this._isValid = false;
        }
    }

    protected void setNew() {
        this._isNew = true;
    }

    private void unbindObject(String string, Object object) {
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
            --this._numObjectsToBeUnbound;
        }
    }

    protected void unsetNew() {
        this._isNew = false;
        this._lastAccessedTime = System.currentTimeMillis();
    }
}

