/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletLoader;
import com.iplanet.server.http.servlet.NSServletRunner;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.SlashUtil;
import com.iplanet.server.http.util.XmlNode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletException;

public class WebAppConfig {
    public static HashMap commonAppElements;
    public static HashMap webAppElements;
    public static HashMap vsAppElements;
    private static ResUtil _res;

    static {
        _res = ResUtil.getDefaultResUtil();
        commonAppElements = new HashMap();
        commonAppElements.put("auth-native", "auth-native");
        commonAppElements.put("auth-manager", "auth-manager");
        commonAppElements.put("class-loader", "class-loader");
        commonAppElements.put("directory-index", "directory-index");
        commonAppElements.put("include-transparency", "include-transparency");
        vsAppElements = (HashMap)commonAppElements.clone();
        vsAppElements.put("javac", "javac");
        webAppElements = (HashMap)commonAppElements.clone();
        webAppElements.put("icon", "icon");
    }

    private WebAppConfig() {
    }

    public static ServletException configException(XmlNode xmlNode, String string) {
        return new ServletException(String.valueOf(xmlNode.getXmlFile()) + ":" + xmlNode.getLineNo() + ":" + string);
    }

    public static ServletException configException(XmlNode xmlNode, String string, Exception exception) {
        return new ServletException(String.valueOf(xmlNode.getXmlFile()) + ":" + xmlNode.getLineNo() + ":" + string, (Throwable)exception);
    }

    public static NSServletLoader createServletLoader(XmlNode xmlNode, String string, String string2, ClassLoader classLoader) {
        String string3 = null;
        boolean bl = false;
        if (xmlNode != null) {
            string3 = xmlNode.getString("classpath", null);
            boolean bl2 = xmlNode.getBoolean("check-aggressive", false);
            boolean bl3 = xmlNode.getBoolean("auto-compile", false);
            String string4 = xmlNode.getString("class-source", null);
            bl = xmlNode.getBoolean("delegate", false);
        }
        if (string2 != null) {
            string3 = string3 == null ? string2 : String.valueOf(string3) + SlashUtil.getClassPathDelimiter() + string2;
        }
        return WebAppConfig.createServletLoader(string, string3, classLoader, bl);
    }

    public static NSServletLoader createServletLoader(String string, String string2, ClassLoader classLoader, boolean bl) {
        if (string == null && string2 == null) {
            return null;
        }
        ArrayList<String> arrayList = null;
        if (string != null) {
            arrayList = new ArrayList<String>();
            arrayList.add(SlashUtil.resolveNativePath((String)string, (String)"WEB-INF/classes"));
            File file = new File(SlashUtil.resolveNativePath((String)string, (String)"WEB-INF/lib"));
            String[] stringArray = file.list();
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                if (stringArray[n].endsWith(".jar") || stringArray[n].endsWith(".zip")) {
                    String string3 = SlashUtil.resolveNativePath((String)file.getAbsolutePath(), (String)stringArray[n]);
                    arrayList.add(string3);
                }
                ++n;
            }
        }
        return new NSServletLoader(classLoader, arrayList, string2, bl);
    }

    public static IWSHttpSessionManager createSessionManager(NSServletRunner nSServletRunner, XmlNode xmlNode, Properties properties) {
        Object object;
        Object object2;
        Object v = null;
        if (properties == null) {
            properties = new Properties();
        } else {
            v = ((Hashtable)properties).get("timeOut");
        }
        Iterator iterator = xmlNode.iterate();
        boolean bl = false;
        while (iterator.hasNext()) {
            object2 = (XmlNode)iterator.next();
            object = object2.getName();
            if (((String)object).equals("init-param")) {
                WebAppConfig.setParams((XmlNode)object2, properties);
                bl = true;
                continue;
            }
            if (((String)object).equals("class")) continue;
            LogUtil.logWarning((String)(String.valueOf(object2.getXmlFile()) + ":" + object2.getLineNo() + _res.getProp("servlet.WebAppConfig.msg_unknownElementInSessionManager", object)));
        }
        if (!bl) {
            LogUtil.logInfo((String)(String.valueOf(_res.getProp("servlet.WebAppConfig.msg_defaultInitParam")) + xmlNode.getXmlFile() + ":" + xmlNode.getLineNo() + ")"));
        }
        if (v != null) {
            ((Hashtable)properties).put("timeOut", v);
        }
        object2 = xmlNode.getString("class", null);
        object = null;
        if (object2 != null && ((String)object2).length() > 0) {
            object = nSServletRunner.createSessionManager((String)object2, properties);
        }
        if (object == null) {
            String string = nSServletRunner.getDefaultSessionManagerName();
            object = nSServletRunner.createSessionManager(string, properties);
        }
        return object;
    }

    public static void setParams(XmlNode xmlNode, HashMap hashMap) {
        Iterator iterator = xmlNode.iterate();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string;
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (xmlNode2.getName().equals("param-name")) {
                XmlNode xmlNode3;
                string = xmlNode2.getValue();
                if (string == null || !iterator.hasNext() || !(xmlNode3 = (XmlNode)iterator.next()).getName().equals("param-value")) continue;
                String string2 = xmlNode3.getValue();
                if (string2 == null) {
                    string2 = "";
                }
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("WebAppConfig:setParams " + string + ":" + string2));
                }
                bl = true;
                hashMap.put(string, string2);
                continue;
            }
            if (xmlNode2.getName().equals("param-value") || xmlNode2.getName() == null) continue;
            string = xmlNode2.getValue();
            if (string == null) {
                string = "";
            }
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("WebAppConfig:setParams " + xmlNode2.getName() + ":" + xmlNode2.getValue()));
            }
            bl = true;
            hashMap.put(xmlNode2.getName(), string);
        }
        if (!bl) {
            LogUtil.logWarning((String)(String.valueOf(xmlNode.getXmlFile()) + ":" + xmlNode.getLineNo() + " Incorrectly formatted " + xmlNode.getName() + " element (param-name or param-value may be missing)"));
        }
    }

    public static void setParams(XmlNode xmlNode, Properties properties) {
        Iterator iterator = xmlNode.iterate();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string;
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (xmlNode2.getName().equals("param-name")) {
                XmlNode xmlNode3;
                string = xmlNode2.getValue();
                if (string == null || !iterator.hasNext() || !(xmlNode3 = (XmlNode)iterator.next()).getName().equals("param-value")) continue;
                String string2 = xmlNode3.getValue();
                if (string2 == null) {
                    string2 = "";
                }
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)5, (String)("WebAppConfig:setParams " + string + ":" + string2));
                }
                bl = true;
                ((Hashtable)properties).put(string, string2);
                continue;
            }
            if (xmlNode2.getName().equals("param-value") || xmlNode2.getName() == null) continue;
            string = xmlNode2.getValue();
            if (string == null) {
                string = "";
            }
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)5, (String)("WebAppConfig:setParams " + xmlNode2.getName() + ":" + xmlNode2.getValue()));
            }
            bl = true;
            ((Hashtable)properties).put(xmlNode2.getName(), string);
        }
        if (!bl) {
            LogUtil.logWarning((String)(String.valueOf(xmlNode.getXmlFile()) + ":" + xmlNode.getLineNo() + " Incorrectly formatted " + xmlNode.getName() + " element (param-name or param-value may be missing)"));
        }
    }

    public static void validateXmlTags(XmlNode xmlNode, String string) throws ServletException {
        Iterator iterator = xmlNode.iterate();
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            if (!string.equals("web-app") || webAppElements.get(xmlNode2.getName()) != null) continue;
            throw WebAppConfig.configException(xmlNode2, "`" + xmlNode2.getName() + "':" + _res.getProp("servlet.WebAppConfig.msg_unknownElement"));
        }
    }
}

