/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.CWebAppSupport;
import com.iplanet.server.http.servlet.NSServletLoader;
import com.iplanet.server.http.servlet.NSServletRunner;
import com.iplanet.server.http.servlet.WSAXErrorHandler;
import com.iplanet.server.http.servlet.WServletContext;
import com.iplanet.server.http.servlet.WebAppConfig;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.SlashUtil;
import com.iplanet.server.http.util.XmlConfig;
import com.iplanet.server.http.util.XmlNode;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class VirtualServer {
    private long cws;
    private String _vsID;
    private boolean _isDefaultVS;
    private String webAppsXml;
    private XmlConfig vsConfig;
    private long configUpdateInterval;
    private ClassLoader parentLoader;
    private NSServletLoader servletLoader;
    private IWSHttpSessionManager sm;
    private IWSHttpSessionManager smFormLogin;
    private File tempDir;
    public static final String SESSION_DATA_DIR = "session-data-dir";
    public static final String SESSION_CONTEXT_NAME = "session-context-name";
    public static final String IWS_WEBAPPS_PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.; iPlanet//DTD Virtual Server Web Applications 6.0//EN";
    public static final String IWS_WEBAPPS_DTD_RESOURCE = "/com/iplanet/server/http/iws-webapps_6_0.dtd";
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    HashMap webApps;
    private int appCount = 0;
    WServletContext defaultContext;
    private boolean hasDefaultApp = false;
    private NSServletRunner runner;
    private boolean isClosed;

    private VirtualServer(NSServletRunner nSServletRunner, String string, long l) throws ServletException {
        XmlNode xmlNode;
        String string2;
        this.cws = l;
        this.webAppsXml = string;
        this.runner = nSServletRunner;
        this._vsID = CWebAppSupport.getVSId(l);
        this._isDefaultVS = CWebAppSupport.isDefaultVS(l);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(IWS_WEBAPPS_PUBLIC_DTD_ID, IWS_WEBAPPS_DTD_RESOURCE);
        WSAXErrorHandler wSAXErrorHandler = WSAXErrorHandler.getErrorHandler(this._vsID);
        try {
            try {
                this.vsConfig = new XmlConfig(string, hashMap);
                this.vsConfig.parseConfig((ErrorHandler)wSAXErrorHandler);
                wSAXErrorHandler.checkParserErrors();
            }
            catch (Exception exception) {
                LogUtil.logFailure((String)this._vsID, (String)_res.getProp("servlet.VirtualServer.msg_errorParsingWebApps", (Object)string, (Object)exception.getMessage()));
                ServletException servletException = new ServletException((Throwable)exception);
                throw servletException;
            }
            string2 = null;
            wSAXErrorHandler.reset();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            wSAXErrorHandler.reset();
            throw throwable;
        }
        this.configUpdateInterval = this.vsConfig.getInt("/vs/config/update-interval", 3600) * 1000;
        this.setupClassLoaders();
        this.setupSessionManager();
        this.setupFormLoginSessionManager();
        this.webApps = new HashMap();
        String string3 = CWebAppSupport.getDocRoot(l);
        if (string3 == null) {
            LogUtil.logFailure((String)this._vsID, (String)_res.getProp("servlet.VirtualServer.msg_errorNoDocRoot"));
            string2 = new ServletException(_res.getProp("servlet.VirtualServer.msg_noDocRoot"));
            throw string2;
        }
        string2 = this.vsConfig.getString("/vs/tempdir/dir", null);
        if (string2 != null) {
            this.tempDir = new File(string2);
        }
        Iterator iterator = this.vsConfig.findConfig("vs").iterate("web-app");
        while (iterator.hasNext()) {
            xmlNode = (XmlNode)iterator.next();
            this.setupWebApp(xmlNode, string3);
        }
        if (!this.hasDefaultApp) {
            if (this._isDefaultVS) {
                this.defaultContext = nSServletRunner.findContext("/");
            }
            if (this.defaultContext == null) {
                xmlNode = new XmlNode();
                XmlNode xmlNode2 = new XmlNode(null, "uri", "/", "<default>", 0);
                xmlNode.addChild(xmlNode2);
                this.defaultContext = this.setupWebApp(xmlNode, string3, true);
            }
        }
        CWebAppSupport.applyConfig(l);
    }

    public boolean Authenticate(String string, String string2, String string3) {
        return CWebAppSupport.Authenticate(this.cws, string, string2, string3);
    }

    public void addErrorPage(String string, int n, String string2) {
        CWebAppSupport.addErrorPage(this.cws, string, n, string2);
    }

    public void addIndexFileList(String string, String string2) {
        CWebAppSupport.addIndexFileList(this.cws, string, string2);
    }

    public void addMimeMap(String string, String string2, String string3) {
        CWebAppSupport.addMimeMap(this.cws, string, string2, string3);
    }

    public void addServletMap(String string, String string2, String string3) {
        CWebAppSupport.addServletMap(this.cws, string, string2, string3);
    }

    public WebApplication checkWebApp(WebApplication webApplication, String string) {
        if (webApplication != null && webApplication.isModified()) {
            WebApplication webApplication2 = webApplication;
            synchronized (webApplication2) {
                if (webApplication != null && webApplication.isModified()) {
                    webApplication.reload();
                }
            }
        }
        return webApplication;
    }

    public void close() {
        HashMap hashMap = this.webApps;
        synchronized (hashMap) {
            if (this.isClosed) {
                Object var2_2 = null;
                return;
            }
            LogUtil.logInfo((String)this._vsID, (String)_res.getProp("servlet.VirtualServer.msg_closingWebapp"));
            this.isClosed = true;
            Iterator iterator = this.webApps.values().iterator();
            while (iterator.hasNext()) {
                WebApplication webApplication = (WebApplication)iterator.next();
                webApplication.terminate();
                --this.appCount;
            }
        }
        this.tempDir = null;
        this.servletLoader = null;
        this.parentLoader = null;
        if (this.sm != null) {
            this.sm.close();
            this.sm = null;
        }
        if (this.smFormLogin != null) {
            this.smFormLogin.close();
            this.smFormLogin = null;
        }
        this.defaultContext = null;
        this.runner = null;
    }

    public void configWebAppAcl(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        CWebAppSupport.configWebAppAcl(this.cws, string, string2, string3, string4, string5, string6, string7);
    }

    public void configWebAppAuthentication(String string, String string2, String string3, String string4) {
        CWebAppSupport.configWebAppAuthentication(this.cws, string, string2, string3, string4);
    }

    private IWSHttpSessionManager createSessionManager(XmlNode xmlNode) {
        String string = xmlNode.getString(SESSION_DATA_DIR, null);
        if (string == null) {
            string = SlashUtil.resolveNativePath((String)this.runner.getServletServer().getSessionDataDir(), (String)this._vsID);
        }
        Properties properties = new Properties();
        ((Hashtable)properties).put(SESSION_DATA_DIR, string);
        ((Hashtable)properties).put(SESSION_CONTEXT_NAME, this._vsID);
        return WebAppConfig.createSessionManager(this.runner, xmlNode, properties);
    }

    public static VirtualServer createVirtualServer(NSServletRunner nSServletRunner, String string, long l) {
        VirtualServer virtualServer = null;
        try {
            virtualServer = new VirtualServer(nSServletRunner, string, l);
        }
        catch (ServletException servletException) {
            LogUtil.logFailure((String)CWebAppSupport.getVSId(l), (String)_res.getProp("servlet.VirtualServer.msg_cannotCreateWebappVSEnv"));
            return null;
        }
        return virtualServer;
    }

    public void getAuthManager() {
    }

    public ClassLoader getClassLoader() {
        return this.servletLoader == null ? this.parentLoader : this.servletLoader;
    }

    public XmlConfig getConfig() {
        return this.vsConfig;
    }

    public long getConfigUpdateInterval() {
        return this.configUpdateInterval;
    }

    public WServletContext getDefaultContext() {
        return this.defaultContext;
    }

    IWSHttpSessionManager getFormLoginSessionManager() {
        return this.smFormLogin;
    }

    public IWSHttpSessionManager getHttpSessionManager() {
        return this.sm;
    }

    public String getMimeType(String string) {
        return CWebAppSupport.getMimeType(this.cws, string);
    }

    public ClassLoader getParentLoader() {
        return this.parentLoader;
    }

    public String getRealPath(String string) {
        return CWebAppSupport.translateUri(this.cws, string);
    }

    public NSServletLoader getServletLoader() {
        return this.servletLoader;
    }

    public NSServletRunner getServletRunner() {
        return this.runner;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public String getVSId() {
        return this._vsID;
    }

    public WebApplication getWebAppObject(String string) {
        return (WebApplication)CWebAppSupport.getJWebAppObject(this.cws, string);
    }

    void init() {
        Iterator iterator = this.webApps.values().iterator();
        while (iterator.hasNext()) {
            WebApplication webApplication = (WebApplication)iterator.next();
            webApplication.init();
        }
    }

    public boolean isDefaultVS() {
        return this._isDefaultVS;
    }

    public boolean isModified() {
        if (this.vsConfig.isModified()) {
            return true;
        }
        HashMap hashMap = this.webApps;
        synchronized (hashMap) {
            Iterator iterator = this.webApps.values().iterator();
            while (iterator.hasNext()) {
                WebApplication webApplication = (WebApplication)iterator.next();
                XmlConfig xmlConfig = webApplication.getWebXmlConfig();
                if (!xmlConfig.isModified()) continue;
                boolean bl = true;
                Object var3_6 = null;
                return bl;
            }
        }
        return false;
    }

    public boolean isUserDBValid(String string) {
        return CWebAppSupport.isUserDBValid(this.cws, string);
    }

    private void setupAuthManager() {
    }

    private void setupClassLoaders() {
        XmlNode xmlNode;
        this.parentLoader = Thread.currentThread().getContextClassLoader();
        if (this.parentLoader == null) {
            this.parentLoader = this.getClass().getClassLoader();
        }
        if ((xmlNode = this.vsConfig.findConfig("/vs/class-loader")) != null) {
            this.servletLoader = WebAppConfig.createServletLoader(xmlNode, null, null, this.parentLoader);
        }
    }

    private void setupFormLoginSessionManager() {
        if (this.smFormLogin != null) {
            return;
        }
        XmlNode xmlNode = this.vsConfig.findConfig("/vs/form-login-session");
        if (xmlNode != null) {
            XmlNode xmlNode2 = xmlNode.findChildNode("session-manager");
            if (xmlNode2 == null) {
                xmlNode2 = new XmlNode();
            }
            this.smFormLogin = this.createSessionManager(xmlNode2);
            this.smFormLogin.setHandleFormLoginSessions(true);
        }
    }

    private void setupSessionManager() {
        XmlNode xmlNode = this.vsConfig.findConfig("/vs/session-manager");
        if (xmlNode != null) {
            this.sm = this.createSessionManager(xmlNode);
        }
    }

    private WebApplication setupWebApp(XmlNode xmlNode, String string) throws ServletException {
        return this.setupWebApp(xmlNode, string, false);
    }

    private WebApplication setupWebApp(XmlNode xmlNode, String string, boolean bl) throws ServletException {
        File file;
        WebApplication webApplication;
        String string2;
        WebApplication webApplication2 = null;
        boolean bl2 = xmlNode.getBoolean("enable", true);
        if (!bl2) {
            return null;
        }
        String string3 = xmlNode.getString("uri", null);
        if (string3 == null) {
            LogUtil.logFailure((String)this._vsID, (String)_res.getProp("servlet.VirtualServer.msg_uriAttrRequired", (Object)xmlNode.getXmlFile(), (Object)new Integer(xmlNode.getLineNo())));
            throw new ServletException(_res.getProp("servlet.VirtualServer.msg_uriRequired"));
        }
        String string4 = xmlNode.getString("dir", null);
        boolean bl3 = false;
        if (string3.equals("") || string3.equals("/") || string3.equals("/*")) {
            bl3 = true;
            string3 = "";
        }
        if ((string2 = SlashUtil.normalizeUriValue((String)string3)) == null) {
            string2 = "";
        }
        if ((webApplication = (WebApplication)this.webApps.get(string2)) != null) {
            LogUtil.logWarning((String)this._vsID, (String)_res.getProp("servlet.VirtualServer.msg_webAppAlreadyPresent", (Object)string2, (Object)new Integer(xmlNode.getLineNo()), (Object)xmlNode.getXmlFile()));
            return webApplication;
        }
        if (string4 == null) {
            string4 = SlashUtil.resolveNativePath((String)string, (String)string2);
        }
        if (!(file = new File(string4)).exists()) {
            LogUtil.logFailure((String)this._vsID, (String)_res.getProp("servlet.VirtualServer.msg_webAppDirNotFound", (Object)string4));
            throw new ServletException(_res.getProp("servlet.VirtualServer.msg_dirNotFound"));
        }
        webApplication2 = new WebApplication(this.runner, this, string2, string4);
        if (!bl && !CWebAppSupport.addWebAppObject(this.cws, string2, string4, webApplication2)) {
            LogUtil.logFailure((String)this._vsID, (String)_res.getProp("servlet.VirtualServer.msg_cannotCreateWebApp", (Object)string2, (Object)string4, null));
            throw new ServletException(_res.getProp("servlet.VirtualServer.msg_cannotCreateApp"));
        }
        try {
            webApplication2.setup(xmlNode, bl);
            this.webApps.put(string2, webApplication2);
            if (bl3) {
                this.defaultContext = webApplication2;
                this.hasDefaultApp = true;
            }
            ++this.appCount;
        }
        catch (ServletException servletException) {
            if (!bl) {
                CWebAppSupport.removeWebAppObject(this.cws, string2);
            }
            webApplication2 = null;
            Throwable throwable = servletException.getRootCause();
            if (throwable == null) {
                throwable = servletException;
            }
            String string5 = "";
            if (!(throwable instanceof SAXParseException)) {
                string5 = LogUtil.getStackTrace((Throwable)throwable);
            }
            LogUtil.logFailure((String)this._vsID, (String)_res.getProp("servlet.VirtualServer.msg_cannotCreateWebApp", (Object)string2, (Object)string4, (Object)string5));
        }
        return webApplication2;
    }
}

