/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletConfig;
import com.iplanet.server.http.servlet.NSServletEntity;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.Servlet;

public class NSServletWrapper {
    protected WebApplication _app;
    protected Servlet _servlet;
    protected NSServletConfig _sc;
    protected String _servletName;
    protected boolean _destroyed = false;
    protected boolean _marked_for_destroy = false;
    private String _errorUri;
    private NSServletEntity se;
    protected static ResUtil _res = ResUtil.getDefaultResUtil();
    protected int _counter = 0;

    public NSServletWrapper(WebApplication webApplication, Servlet servlet, String string) {
        this._app = webApplication;
        this._servlet = servlet;
        this._servletName = string;
    }

    public NSServletWrapper(Servlet servlet, String string, String string2) {
        this(null, servlet, string);
        this._errorUri = string2;
        if (this._errorUri != null) {
            this._errorUri = this._errorUri.trim();
            if (this._errorUri.length() == 0) {
                this._errorUri = null;
            }
        }
    }

    void acquire() {
        ++this._counter;
    }

    private void call_destroy() {
        if (!this._destroyed) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    if (this._servlet != null) {
                        Thread.currentThread().setContextClassLoader(this._servlet.getClass().getClassLoader());
                        this._servlet.destroy();
                    }
                }
                catch (Exception exception) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    printWriter.close();
                    LogUtil.logFailure((String)_res.getProp("servlet.NSServletWrapper.msg_exceptionDestroyFunc", (Object)this._servlet.getClass().getName(), (Object)exception.toString(), (Object)stringWriter.toString()));
                }
                Object var3_5 = null;
                this._destroyed = true;
                this._servlet = null;
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this._destroyed = true;
                this._servlet = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
        }
    }

    protected void destroy() {
        NSServletWrapper nSServletWrapper = this;
        synchronized (nSServletWrapper) {
            if (!this._destroyed) {
                if (this._counter <= 0) {
                    this.call_destroy();
                } else {
                    this._marked_for_destroy = true;
                }
            }
        }
    }

    protected void finalize() {
        this.call_destroy();
    }

    void forget() {
        this._destroyed = true;
        this._servlet = null;
        this._sc = null;
        this._servletName = null;
        this._app = null;
    }

    protected String getErrorURI(String string) {
        if (this._app == null) {
            return this._errorUri;
        }
        return this._app.getExceptionPage(string);
    }

    Servlet getServlet() {
        return this._servlet;
    }

    NSServletConfig getServletConfig() {
        return this._sc;
    }

    String getServletName() {
        return this._servletName;
    }

    void release() {
        --this._counter;
        if (this._counter <= 0 && this._marked_for_destroy) {
            this.call_destroy();
        }
    }

    void setServletConfig(NSServletConfig nSServletConfig) {
        this._sc = nSServletConfig;
    }
}

