/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.iplanet.server.http.util.SlashUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class NSServletLoader
extends ClassLoader {
    private static final int chunk_size = 4096;
    protected ClassLoader _parentLoader;
    protected String _classDir;
    protected String _classPath;
    private ArrayList _classpathList = null;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private HashMap _classCache;
    private boolean _security;
    private boolean _delegate = false;

    public NSServletLoader(ClassLoader classLoader, String string, ArrayList arrayList, boolean bl, boolean bl2) {
        super(classLoader);
        this._parentLoader = classLoader;
        if (this._parentLoader == null) {
            this._parentLoader = Thread.currentThread().getContextClassLoader();
            if (this._parentLoader == null) {
                this._parentLoader = this.getClass().getClassLoader();
            }
        }
        this._classCache = new HashMap();
        this._classDir = string;
        this._classPath = null;
        this._security = bl;
        this._classpathList = arrayList;
        if (this._classDir != null) {
            this.tokenizePath(this._classDir);
        }
        this._delegate = bl2;
    }

    public NSServletLoader(ClassLoader classLoader, ArrayList arrayList, String string, boolean bl) {
        this(classLoader, string, arrayList, false, bl);
    }

    public NSServletLoader(String string, boolean bl) {
        this(null, string, null, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz = null;
        HashMap hashMap = this._classCache;
        synchronized (hashMap) {
            block19: {
                int n;
                ClassCacheEntry classCacheEntry = (ClassCacheEntry)this._classCache.get(string);
                if (classCacheEntry != null) {
                    return classCacheEntry.loadedClass;
                }
                if (this._security && string.startsWith("com.iplanet.server.http")) {
                    LogUtil.logInfo((String)_res.getProp("servlet.NSServletLoader.msg_classSecurity", (Object)string));
                    throw new ClassNotFoundException(string);
                }
                try {
                    return this.findSystemClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (this._delegate) {
                        try {
                            if (this._parentLoader != null) {
                                return this._parentLoader.loadClass(string);
                            }
                            if (this.getParent() != null) {
                                return this.getParent().loadClass(string);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException2) {}
                    }
                    if (this._classpathList == null) break block19;
                    n = 0;
                }
                while (n < this._classpathList.size() && (clazz = this.loadClass(string, (String)this._classpathList.get(n))) == null) {
                    ++n;
                }
                if (clazz != null) {
                    return clazz;
                }
            }
            if (!this._delegate) {
                try {
                    if (this._parentLoader != null) {
                        return this._parentLoader.loadClass(string);
                    }
                    if (this.getParent() != null) {
                        return this.getParent().loadClass(string);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if ((clazz = this.findLoadedClass(string)) != null) return clazz;
            throw new ClassNotFoundException(string);
        }
    }

    File getClassFile(String string) {
        File file = null;
        HashMap hashMap = this._classCache;
        synchronized (hashMap) {
            ClassCacheEntry classCacheEntry = (ClassCacheEntry)this._classCache.get(string);
            if (classCacheEntry != null) {
                file = classCacheEntry.classOriginFile != null ? classCacheEntry.classOriginFile : classCacheEntry.classPathFile;
            }
        }
        return file;
    }

    public String getClassPath() {
        if (this._classPath != null) {
            return this._classPath;
        }
        if (this._classpathList == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._classpathList.size()) {
            stringBuffer.append(this._classpathList.get(n));
            stringBuffer.append(SlashUtil.getClassPathDelimiter());
            ++n;
        }
        this._classPath = stringBuffer.toString();
        return this._classPath;
    }

    public URL getResource(String string) {
        if (this._delegate && this._parentLoader != null) {
            return this._parentLoader.getResource(string);
        }
        if (this._classpathList != null) {
            int n = 0;
            while (n < this._classpathList.size()) {
                byte[] byArray = null;
                byArray = (byte[])this.loadResource(string, (String)this._classpathList.get(n), false);
                if (byArray != null) {
                    try {
                        File file = new File((String)this._classpathList.get(n));
                        if (file.isDirectory()) {
                            return new URL("file", null, String.valueOf((String)this._classpathList.get(n)) + "/" + string);
                        }
                        String string2 = (String)this._classpathList.get(n);
                        StringBuffer stringBuffer = new StringBuffer("jar:file:");
                        if (string2 != null && string2.length() != 0 && string2.charAt(0) != '/') {
                            stringBuffer.append('/');
                        }
                        stringBuffer.append(string2);
                        stringBuffer.append("!/");
                        stringBuffer.append(string);
                        return new URL(stringBuffer.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
                ++n;
            }
        }
        if (!this._delegate && this._parentLoader != null) {
            return this._parentLoader.getResource(string);
        }
        return ClassLoader.getSystemResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        byte[] byArray = null;
        if (this._delegate && this._parentLoader != null) {
            return this._parentLoader.getResourceAsStream(string);
        }
        if (this._classpathList != null) {
            int n = 0;
            while (n < this._classpathList.size()) {
                byArray = (byte[])this.loadResource(string, (String)this._classpathList.get(n), false);
                if (byArray != null) break;
                ++n;
            }
            if (byArray != null) {
                return new ByteArrayInputStream(byArray);
            }
        }
        if (!this._delegate && this._parentLoader != null) {
            return this._parentLoader.getResourceAsStream(string);
        }
        return ClassLoader.getSystemResourceAsStream(string);
    }

    void invalidate(String string) {
        HashMap hashMap = this._classCache;
        synchronized (hashMap) {
            this._classCache.remove(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isModified() {
        HashMap hashMap = this._classCache;
        synchronized (hashMap) {
            if (this._classCache == null) {
                return false;
            }
            Iterator iterator = this._classCache.values().iterator();
            while (iterator.hasNext()) {
                ClassCacheEntry classCacheEntry = (ClassCacheEntry)iterator.next();
                if (!classCacheEntry.isModified()) continue;
                if (!LogUtil.enableTrace) return true;
                LogUtil.TRACE((int)5, (String)("`" + classCacheEntry.loadedClass + "' is modified."));
                return true;
            }
            return false;
        }
    }

    private Class loadClass(String string, String string2) {
        return (Class)this.loadResource(string, string2, true);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object loadResource(String string, String string2, boolean bl) {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ZipFile zipFile = null;
        File file = null;
        File file2 = null;
        byte[] byArray = null;
        String string3 = bl ? ".class" : "";
        try {
            block48: {
                try {
                    int n;
                    Object object;
                    int n2;
                    try {
                        int n3;
                        URL uRL = new URL(String.valueOf(string2) + '/' + string + string3);
                        try {
                            inputStream = uRL.openStream();
                        }
                        catch (IOException iOException) {
                            Object var13_12 = null;
                            Object var15_19 = null;
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (byteArrayOutputStream != null) {
                                    byteArrayOutputStream.close();
                                }
                                if (zipFile == null) return var13_12;
                                zipFile.close();
                                return var13_12;
                            }
                            catch (IOException iOException2) {}
                            return var13_12;
                        }
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        byArray = new byte[4096];
                        while ((n3 = inputStream.read(byArray)) > 0) {
                            byteArrayOutputStream.write(byArray, 0, n3);
                        }
                        byArray = byteArrayOutputStream.toByteArray();
                        break block48;
                    }
                    catch (MalformedURLException malformedURLException) {
                        block50: {
                            n2 = 0;
                            String string4 = string;
                            string4 = bl ? String.valueOf(string.replace('.', File.separatorChar)) + string3 : String.valueOf(string) + string3;
                            file2 = new File(string2);
                            if (file2.isDirectory()) {
                                file = new File(string2, string4);
                                try {
                                    inputStream = new FileInputStream(file);
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    Object var13_13 = null;
                                    Object var15_20 = null;
                                    try {}
                                    catch (IOException iOException) {}
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                    if (byteArrayOutputStream != null) {
                                        byteArrayOutputStream.close();
                                    }
                                    if (zipFile == null) return var13_13;
                                    zipFile.close();
                                    return var13_13;
                                }
                                n2 = (int)file.length();
                            } else {
                                Object var13_14;
                                block49: {
                                    try {
                                        zipFile = new ZipFile(file2);
                                        String string5 = null;
                                        string5 = File.separatorChar == '/' ? string4 : string4.replace(File.separatorChar, '/');
                                        object = zipFile.getEntry(string5);
                                        if (object == null) {
                                            var13_14 = null;
                                            Object var15_21 = null;
                                            break block49;
                                        }
                                        n2 = (int)((ZipEntry)object).getSize();
                                        inputStream = zipFile.getInputStream((ZipEntry)object);
                                        break block50;
                                    }
                                    catch (ZipException zipException) {
                                        Object var13_15 = null;
                                        Object var15_22 = null;
                                        try {}
                                        catch (IOException iOException) {}
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                        if (byteArrayOutputStream != null) {
                                            byteArrayOutputStream.close();
                                        }
                                        if (zipFile == null) return var13_15;
                                        zipFile.close();
                                        return var13_15;
                                    }
                                }
                                try {}
                                catch (IOException iOException) {}
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                if (byteArrayOutputStream != null) {
                                    byteArrayOutputStream.close();
                                }
                                if (zipFile == null) return var13_14;
                                zipFile.close();
                                return var13_14;
                            }
                        }
                        byArray = new byte[n2];
                        n = 0;
                    }
                    while (true) {
                        if (n >= n2) {
                            if (byArray != null && bl) {
                                break;
                            }
                            break block48;
                        }
                        int n4 = inputStream.read(byArray, n, n2 - n);
                        if (n4 == -1) {
                            Object var13_16 = null;
                            Object var15_23 = null;
                            try {}
                            catch (IOException iOException) {}
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (byteArrayOutputStream != null) {
                                byteArrayOutputStream.close();
                            }
                            if (zipFile == null) return var13_16;
                            zipFile.close();
                            return var13_16;
                        }
                        n += n4;
                    }
                    object = this.defineClass(string, byArray, 0, byArray.length);
                    ClassCacheEntry classCacheEntry = new ClassCacheEntry((Class)object, file, file2);
                    this._classCache.put(string, classCacheEntry);
                    Object object2 = object;
                    Object var15_24 = null;
                    try {}
                    catch (IOException iOException) {}
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                    if (zipFile == null) return object2;
                    zipFile.close();
                    return object2;
                }
                catch (IOException iOException) {
                    Object var13_18 = null;
                    Object var15_25 = null;
                    try {}
                    catch (IOException iOException3) {}
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                    if (zipFile == null) return var13_18;
                    zipFile.close();
                    return var13_18;
                }
            }
            Object var15_26 = null;
        }
        catch (Throwable throwable) {
            Object var15_27 = null;
            try {}
            catch (IOException iOException) {}
            if (inputStream != null) {
                inputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (zipFile == null) throw throwable;
            zipFile.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return byArray;
        }
        if (inputStream != null) {
            inputStream.close();
        }
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        if (zipFile == null) return byArray;
        zipFile.close();
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    private void tokenizePath(String var1_1) {
        block4: {
            if (this._classpathList == null) {
                this._classpathList = new ArrayList<E>();
            }
            try {
                var2_2 = new URL(var1_1);
                this._classpathList.add(var1_1);
                break block4;
            }
            catch (Exception v0) {
                var2_3 = new StringTokenizer(var1_1, SlashUtil.getClassPathDelimiter());
                var3_4 = var2_3.countTokens();
                var4_5 = 0;
                ** while (var4_5 < var3_4)
            }
lbl-1000:
            // 1 sources

            {
                this._classpathList.add(var2_3.nextToken());
                ++var4_5;
                continue;
            }
        }
    }

    public synchronized void unloadAll() {
        HashMap hashMap = this._classCache;
        synchronized (hashMap) {
            if (this._classCache == null) {
                Object var2_2 = null;
                return;
            }
            Iterator iterator = this._classCache.values().iterator();
            while (iterator.hasNext()) {
                ClassCacheEntry classCacheEntry = (ClassCacheEntry)iterator.next();
                classCacheEntry.clear();
            }
            this._classCache.clear();
            this._classCache = null;
        }
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File classOriginFile;
        long classLastModified;
        File classPathFile;
        long classPathLastModified;

        public ClassCacheEntry(Class clazz, File file, File file2) {
            this.loadedClass = clazz;
            this.classOriginFile = file;
            this.classPathFile = file2;
            if (file != null) {
                this.classLastModified = file.lastModified();
            }
            if (file2 != null) {
                this.classPathLastModified = file2.lastModified();
            }
        }

        public void clear() {
            this.loadedClass = null;
            this.classPathFile = null;
            this.classOriginFile = null;
        }

        public boolean isModified() {
            return this.classOriginFile != null && this.classOriginFile.lastModified() != this.classLastModified || this.classPathFile != null && this.classPathFile.lastModified() != this.classPathLastModified;
        }
    }
}

