/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.common.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.usermgr.common.ExtAttrObj;
import com.sun.admin.usermgr.common.SolAccountAttr;
import com.sun.admin.usermgr.common.SolGroupAttr;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.SolPasswordAttr;
import com.sun.admin.usermgr.common.SolProjectAttr;
import com.sun.admin.usermgr.common.SolServicesAttr;
import com.sun.admin.usermgr.common.UserAttrObj;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.admin.usermgr.common.WBEMClient.ClientProxyDupNameException;
import com.sun.admin.usermgr.common.WBEMClient.ClientProxyException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMSecurityException;

public class UserClientProxy
implements WbemClientProxy {
    private static final String COMPLETE_CLASS = "Solaris_UserAccount";
    private static final String SUPER_CLASS = "CIM_Account";
    private static String CAPTION = "Caption";
    private static String DESCRIPTION = "Description";
    private static String INSTALL_DATE = "InstallDate";
    private static String STATUS = "Status";
    private static String DOMAIN_TYPE = "SystemCreationClassName";
    private static String DOMAIN_NAME = "SystemName";
    private static String CREATION_NAME = "CreationClassName";
    private static String NAME = "Name";
    private static String USER_ID = "UserID";
    private static String DESCRIPTONS = "Descriptions";
    private static String HOSTS = "Host";
    private static String LOCALITIES = "LocalityName";
    private static String ORGAN_NAMES = "OrganizationalName";
    private static String OUS = "OU";
    private static String SEE_ALSOS = "SeeAlso";
    private static String USER_CERT = "UserCertificate";
    private static String PASSWORDS = "UserPassword";
    private static String USER_UID = "userUID";
    private static String USER_PSWD = "loginPassword";
    private static String FULL_NAME = "fullName";
    private static String USER_DESCR = "userDescr";
    private static String USER_TYPE = "userType";
    private static String PRIM_GROUP = "primaryGroup";
    private static String SEC_GROUPS = "secondaryGroups";
    private static String ACCNT_EXPIRE = "accountExpireDate";
    private static String ACCNT_LOCKED = "isAccountLocked";
    private static String MUST_CHNG_PWD = "mustChangePasswdInDays";
    private static String DO_NOT_REUSE_PWD = "doNotReusePwdForDays";
    private static String WARN_PWD = "warnBeforePwdExpiresDays";
    private static String PWD_INACTIVE = "pwdInactiveDays";
    private static String CHANGE_PWD = "changePasswd";
    private static String HAS_PWD = "hasPasswd";
    private static String PWD_FRC_MOD = "pwdForceModify";
    private static String HOME_DIR_SERVER = "homeDirServer";
    private static String HOME_DIR_PATH = "homeDirPathName";
    private static String AUTOMOUNT = "autoMountHomeDir";
    private static String HOME_DIR_FRC_MOD = "homeDirForceModify";
    private static String HOME_DIR_ALLOW_MOD = "homeDirAllowModifyServer";
    private static String OWNER_PERMS = "ownerPerms";
    private static String GROUP_PERMS = "groupPerms";
    private static String WORLD_PERMS = "worldPerms";
    private static String INIT_FILE_PATH = "initFilePath";
    private static String MAIL_SERVER = "mailServer";
    private static String MBOX_ALLOW_MOD = "mailBoxAllowModifyServer";
    private static String MBOX_FRC_MOD = "mailBoxForceModify";
    private static String INIT_SHELL = "initialShell";
    private static String TEMPLATE_NAME = "templateName";
    private static String NEW_NAME = "newName";
    private static String ATTR_KEY = "SolarisAttrKeyValue";
    private static String PRIMARY_PROJECT = "primaryProject";
    private static String SECONDARY_PROJECTS = "secondaryProjects";
    private CIMNameSpace cimNameSpace = null;
    private CIMClient cimClient = null;
    private WbemMgmtScope wScope;
    private CIMClass cimClass = null;
    private String GMT_TIMEZONE = "GMT";
    TimeZone tz = TimeZone.getDefault();

    public void init(CIMClient cIMClient, WbemMgmtScope wbemMgmtScope) {
        this.cimClient = cIMClient;
        this.wScope = wbemMgmtScope;
    }

    public void deleteUser(UserObj userObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(COMPLETE_CLASS);
        if (this.wScope == null) {
            throw new ClientProxyException("EXM_USER_BAD_SCOPE");
        }
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        cIMObjectPath.addKey(CREATION_NAME, new CIMValue((Object)COMPLETE_CLASS));
        if (userObj.getUserName() == null || userObj.getUserName().equals("")) {
            throw new ClientProxyException("EXM_USER_DEL_BAD_NAME");
        }
        cIMObjectPath.addKey(NAME, new CIMValue((Object)userObj.getUserName()));
        try {
            this.cimClient.deleteInstance(cIMObjectPath);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_USER_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_USER_DEL_UNEXP", userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_USER_DEL_UNEXP", userObj.getUserName(), exception.getMessage());
        }
    }

    public void addUser(UserObj userObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(COMPLETE_CLASS);
        if (userObj.getUserName() == null) {
            throw new ClientProxyException("EXM_USER_ADD_BAD_NAME");
        }
        if (userObj.getUserName().trim().length() == 0) {
            throw new ClientProxyException("EXM_USER_ADD_BAD_NAME");
        }
        if (this.wScope == null) {
            throw new ClientProxyException("EXM_USER_BAD_SCOPE");
        }
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        try {
            if (this.cimClass == null) {
                this.cimClass = this.cimClient.getClass(cIMObjectPath, false, true, true);
            }
            CIMInstance cIMInstance = this.convertUserObjToInstance(this.cimClass, userObj);
            this.cimClient.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_USER_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                throw new ClientProxyDupNameException("EXM_USER_DUP_NAME", userObj.getUserName());
            }
            throw new ClientProxyException("EXM_USER_ADD_UNEXP", userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_USER_ADD_UNEXP", userObj.getUserName(), exception.getMessage());
        }
    }

    public UserObj getFullAttributes(UserObj userObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(COMPLETE_CLASS);
        if (this.wScope == null) {
            throw new ClientProxyException("EXM_USER_BAD_SCOPE");
        }
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        cIMObjectPath.addKey(CREATION_NAME, new CIMValue((Object)COMPLETE_CLASS));
        if (userObj.getUserName() == null || userObj.getUserName().trim().length() == 0) {
            throw new ClientProxyException("EXM_USER_GET_BAD_NAME");
        }
        cIMObjectPath.addKey(NAME, new CIMValue((Object)userObj.getUserName()));
        CIMInstance cIMInstance = null;
        try {
            if (this.cimClient == null) {
                throw new ClientProxyException("EXM_USER_BAD_CLIENT");
            }
            cIMInstance = this.cimClient.getInstance(cIMObjectPath, false);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_USER_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_USER_GET_UNEXP", userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_USER_GET_UNEXP", userObj.getUserName(), exception.getMessage());
        }
        if (cIMInstance == null) {
            throw new ClientProxyException("EXM_USER_GET_PROV_ERR");
        }
        UserObj userObj2 = this.stuffFullUserObj(cIMInstance);
        return userObj2;
    }

    public void modifyUser(UserObj userObj, String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(COMPLETE_CLASS);
        if (string == null) {
            throw new ClientProxyException("EXM_USER_MOD_BAD_NAME");
        }
        if (string.trim().length() == 0) {
            throw new ClientProxyException("EXM_USER_MOD_BAD_NAME");
        }
        if (this.wScope == null) {
            throw new ClientProxyException("EXM_USER_BAD_SCOPE");
        }
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        try {
            if (this.cimClass == null) {
                this.cimClass = this.cimClient.getClass(cIMObjectPath, false, true, true);
            }
            CIMInstance cIMInstance = this.convertUserObjToInstance(this.cimClass, userObj, string);
            cIMObjectPath.addKey(NAME, new CIMValue((Object)string));
            this.cimClient.setInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_USER_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_USER_MOD_UNEXP", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_USER_MOD_UNEXP", string, exception.getMessage());
        }
    }

    public Vector getAllUsers(String string) throws AdminException {
        return this.getAllLightSomething("normal", string);
    }

    public Vector getAllUsers() throws AdminException {
        return this.getAllLightSomething("normal", null);
    }

    public Vector getAllRoles(String string) throws AdminException {
        return this.getAllLightSomething("role", string);
    }

    public Vector getAllRoles() throws AdminException {
        return this.getAllLightSomething("role", null);
    }

    public String getNextAvailableUID() throws AdminException {
        String string = null;
        String string2 = "100";
        CIMObjectPath cIMObjectPath = new CIMObjectPath(COMPLETE_CLASS);
        if (this.wScope == null) {
            throw new ClientProxyException("EXM_USER_BAD_SCOPE");
        }
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        Vector<CIMValue> vector = new Vector<CIMValue>(1);
        Vector vector2 = new Vector();
        vector.addElement(new CIMValue((Object)string2));
        try {
            this.cimClient.invokeMethod(cIMObjectPath, "getNextUID", vector, vector2);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_USER_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string3 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string3);
            }
            throw new ClientProxyException("EXM_GET_NEXT_UID_ERR", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GET_NEXT_UID_ERR", exception.getMessage());
        }
        CIMValue cIMValue = null;
        try {
            cIMValue = (CIMValue)vector2.elementAt(0);
            string = (String)cIMValue.getValue();
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GET_NEXT_UID_ERR", exception.getMessage());
        }
        return string;
    }

    public String[] getUserRoles(String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(COMPLETE_CLASS);
        if (this.wScope == null) {
            throw new ClientProxyException("EXM_USER_BAD_SCOPE");
        }
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        cIMObjectPath.addKey(CREATION_NAME, new CIMValue((Object)COMPLETE_CLASS));
        cIMObjectPath.addKey(NAME, new CIMValue((Object)string));
        Vector<CIMValue> vector = new Vector<CIMValue>(1);
        Vector vector2 = new Vector();
        vector.addElement(new CIMValue((Object)string));
        try {
            this.cimClient.invokeMethod(cIMObjectPath, "getUserRoles", vector, vector2);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_USER_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_GET_USER_ROLES_ERR", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GET_USER_ROLES_ERR", string, exception.getMessage());
        }
        Vector vector3 = null;
        CIMValue cIMValue = null;
        try {
            cIMValue = (CIMValue)vector2.elementAt(0);
            vector3 = (Vector)cIMValue.getValue();
        }
        catch (Exception exception) {
            vector3 = new Vector(0);
        }
        Object[] objectArray = new String[vector3.size()];
        vector3.copyInto(objectArray);
        return objectArray;
    }

    public void printInst(CIMInstance cIMInstance) {
        System.out.println("CIMInstance = " + cIMInstance.toString());
    }

    private Vector getAcntList(Enumeration enumeration) {
        Vector<UserObj> vector = new Vector<UserObj>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                UserObj userObj = this.stuffLightUserObj(cIMInstance);
                vector.addElement(userObj);
            }
        }
        return vector;
    }

    private CIMInstance convertUserObjToInstance(CIMClass cIMClass, UserObj userObj) {
        CIMInstance cIMInstance = null;
        cIMInstance = this.convertUserObjToInstance(cIMClass, userObj, null);
        return cIMInstance;
    }

    private CIMInstance convertUserObjToInstance(CIMClass cIMClass, UserObj userObj, String string) {
        Vector<String> vector;
        Object object;
        Object object2;
        CIMInstance cIMInstance = cIMClass.newInstance();
        if (this.wScope != null) {
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        }
        cIMInstance.setProperty(CREATION_NAME, new CIMValue((Object)COMPLETE_CLASS));
        String string2 = userObj.getUserName();
        if (string != null) {
            cIMInstance.setProperty(NAME, new CIMValue((Object)string));
            cIMInstance.setProperty(USER_ID, new CIMValue((Object)string));
            if (string2 != null) {
                object2 = new CIMValue((Object)string2);
                cIMInstance.setProperty(NEW_NAME, (CIMValue)object2);
            }
        } else if (string2 != null) {
            cIMInstance.setProperty(NAME, new CIMValue((Object)string2));
            cIMInstance.setProperty(USER_ID, new CIMValue((Object)string2));
        }
        if (userObj.getUserID() != null) {
            cIMInstance.setProperty(USER_UID, new CIMValue((Object)userObj.getUserID()));
        }
        if (userObj.getUserDescription() != null) {
            cIMInstance.setProperty(USER_DESCR, new CIMValue((Object)userObj.getUserDescription()));
        }
        if (userObj.getUserType() != null) {
            cIMInstance.setProperty(USER_TYPE, new CIMValue((Object)userObj.getUserType()));
        }
        if (userObj.getUserFullName() != null) {
            cIMInstance.setProperty(FULL_NAME, new CIMValue((Object)userObj.getUserFullName()));
        }
        if (userObj.getTemplateName() != null) {
            cIMInstance.setProperty(TEMPLATE_NAME, new CIMValue((Object)userObj.getTemplateName()));
        }
        if (userObj.getSolAuthAttrs() != null && userObj.getSolAuthAttrs().getAttributeString() != null) {
            cIMInstance.setProperty(ATTR_KEY, new CIMValue((Object)userObj.getSolAuthAttrs().getAttributeString()));
        }
        if (userObj.getSolGroupAttr() != null) {
            object2 = userObj.getSolGroupAttr();
            if (((SolGroupAttr)object2).getPrimaryGroup() != null) {
                cIMInstance.setProperty(PRIM_GROUP, new CIMValue((Object)((SolGroupAttr)object2).getPrimaryGroup()));
            }
            if (((SolGroupAttr)object2).getSecondaryGroups() != null) {
                object = userObj.getSolGroupAttr().getSecondaryGroups();
                if (((String[])object).length > 0) {
                    vector = null;
                    String string3 = object[0];
                    string3 = string3.trim();
                    if (((String[])object).length != 1 || ((String[])object).length == 1 && !string3.equals("")) {
                        vector = new Vector();
                        int n = 0;
                        while (n < ((String[])object).length) {
                            vector.addElement(object[n]);
                            ++n;
                        }
                    }
                    cIMInstance.setProperty(SEC_GROUPS, new CIMValue(vector));
                }
            } else {
                object = null;
                cIMInstance.setProperty(SEC_GROUPS, new CIMValue(object));
            }
        }
        if (userObj.getSolAccountAttr() != null) {
            if (userObj.getSolAccountAttr().getAccountExpires() != null && ((String)(object2 = userObj.getSolAccountAttr().getAccountExpires())).trim().length() > 0) {
                object = this.setUpExpirationDate((String)object2);
                cIMInstance.setProperty(ACCNT_EXPIRE, new CIMValue((Object)new CIMDateTime((Date)object)));
            }
            cIMInstance.setProperty(ACCNT_LOCKED, new CIMValue((Object)new Boolean(userObj.getSolAccountAttr().isAccountLocked())));
        }
        if (userObj.getSolPasswordAttr() != null) {
            object2 = userObj.getSolPasswordAttr();
            cIMInstance.setProperty(MUST_CHNG_PWD, new CIMValue((Object)((SolPasswordAttr)object2).getMustChangeDays()));
            if (((SolPasswordAttr)object2).getUnixEPasswd() != null) {
                cIMInstance.setProperty(USER_PSWD, new CIMValue((Object)((SolPasswordAttr)object2).getUnixEPasswd()));
            }
            if (((SolPasswordAttr)object2).getCannotChangeDays() != null) {
                cIMInstance.setProperty(DO_NOT_REUSE_PWD, new CIMValue((Object)((SolPasswordAttr)object2).getCannotChangeDays()));
            }
            if (((SolPasswordAttr)object2).getAlertChangeDays() != null) {
                cIMInstance.setProperty(WARN_PWD, new CIMValue((Object)((SolPasswordAttr)object2).getAlertChangeDays()));
            }
            if (((SolPasswordAttr)object2).getInactiveDays() != null) {
                cIMInstance.setProperty(PWD_INACTIVE, new CIMValue((Object)((SolPasswordAttr)object2).getInactiveDays()));
            }
            cIMInstance.setProperty(CHANGE_PWD, new CIMValue((Object)new Boolean(((SolPasswordAttr)object2).hasPasswordChanged())));
            cIMInstance.setProperty(HAS_PWD, new CIMValue((Object)new Boolean(((SolPasswordAttr)object2).isThereAPassword())));
            cIMInstance.setProperty(PWD_FRC_MOD, new CIMValue((Object)new Boolean(((SolPasswordAttr)object2).requireModify())));
        }
        if (userObj.getSolHomedirAttr() != null) {
            object2 = userObj.getSolHomedirAttr();
            if (((SolHomedirAttr)object2).getServer() != null) {
                cIMInstance.setProperty(HOME_DIR_SERVER, new CIMValue((Object)((SolHomedirAttr)object2).getServer()));
            }
            if (((SolHomedirAttr)object2).getPathname() != null) {
                cIMInstance.setProperty(HOME_DIR_PATH, new CIMValue((Object)((SolHomedirAttr)object2).getPathname()));
            }
            cIMInstance.setProperty(AUTOMOUNT, new CIMValue((Object)new Boolean(((SolHomedirAttr)object2).getAutomount())));
        }
        if (userObj.getSolServicesAttr() != null) {
            object2 = userObj.getSolServicesAttr();
            if (((SolServicesAttr)object2).getMailServer() != null) {
                cIMInstance.setProperty(MAIL_SERVER, new CIMValue((Object)((SolServicesAttr)object2).getMailServer()));
            }
            cIMInstance.setProperty(MBOX_ALLOW_MOD, new CIMValue((Object)new Boolean(((SolServicesAttr)object2).getModifyMailServer())));
            cIMInstance.setProperty(MBOX_FRC_MOD, new CIMValue((Object)new Boolean(((SolServicesAttr)object2).requireModify())));
            if (((SolServicesAttr)object2).getInitialShell() != null) {
                cIMInstance.setProperty(INIT_SHELL, new CIMValue((Object)((SolServicesAttr)object2).getInitialShell()));
            }
        }
        if (userObj.getSolProjectAttr() != null) {
            object2 = userObj.getSolProjectAttr();
            if (((SolProjectAttr)object2).getPrimaryProject() != null) {
                cIMInstance.setProperty(PRIMARY_PROJECT, new CIMValue((Object)((SolProjectAttr)object2).getPrimaryProject()));
            }
            if ((object = ((SolProjectAttr)object2).getSecondaryProjects()) != null) {
                vector = new Vector<String>(((String[])object).length);
                int n = 0;
                while (n < ((String[])object).length) {
                    vector.add(object[n]);
                    ++n;
                }
                cIMInstance.setProperty(SECONDARY_PROJECTS, new CIMValue(vector));
            }
        }
        return cIMInstance;
    }

    private Vector getAllLightSomething(String string, String string2) throws AdminException {
        Vector<UserObj> vector = new Vector<UserObj>();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(COMPLETE_CLASS);
        if (this.wScope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        }
        cIMObjectPath.addKey(CREATION_NAME, new CIMValue((Object)COMPLETE_CLASS));
        Vector<CIMValue> vector2 = new Vector<CIMValue>(2);
        Vector vector3 = new Vector();
        vector2.addElement(new CIMValue((Object)string));
        vector2.addElement(new CIMValue((Object)string2));
        try {
            this.cimClient.invokeMethod(cIMObjectPath, "bulkData", vector2, vector3);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_USER_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string3 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string3);
            }
            throw new ClientProxyException("EXM_USER_READNAMES_UNEXP", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_USER_READNAMES_UNEXP", exception.getMessage());
        }
        CIMValue cIMValue = null;
        Vector vector4 = new Vector();
        try {
            cIMValue = (CIMValue)vector3.elementAt(0);
            vector4 = (Vector)cIMValue.getValue();
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_USER_READNAMES_UNEXP", exception.getLocalizedMessage());
        }
        String[] stringArray = new String[vector4.size()];
        stringArray = vector4.toArray(stringArray);
        int n = 0;
        int n2 = stringArray.length / 4;
        vector = new Vector(n2);
        UserObj userObj = null;
        int n3 = 0;
        while (n3 < n2) {
            try {
                userObj = new UserObj(stringArray[n++]);
                userObj.setUserType(string);
                userObj.setUserID(stringArray[n++]);
                userObj.setUserFullName(stringArray[n++]);
                userObj.setUserDescription(stringArray[n++]);
                vector.addElement(userObj);
            }
            catch (Exception exception) {
                throw new ClientProxyException("EXM_USER_READNAMES_UNEXP", exception.getLocalizedMessage());
            }
            ++n3;
        }
        return vector;
    }

    private String getStringValue(CIMInstance cIMInstance, String string) {
        String string2 = null;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            string2 = (String)cIMValue.getValue();
        }
        return string2;
    }

    private CIMDateTime getDateValue(CIMInstance cIMInstance, String string) {
        CIMDateTime cIMDateTime = null;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            cIMDateTime = (CIMDateTime)cIMValue.getValue();
        }
        return cIMDateTime;
    }

    private boolean getBooleanValue(CIMInstance cIMInstance, String string) {
        boolean bl = false;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            bl = (Boolean)cIMValue.getValue();
        }
        return bl;
    }

    private Vector getVectorValue(CIMInstance cIMInstance, String string) {
        Vector vector = null;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            vector = (Vector)cIMValue.getValue();
        }
        return vector;
    }

    private UserObj stuffLightUserObj(CIMInstance cIMInstance) {
        UserObj userObj = new UserObj();
        String string = null;
        try {
            string = this.getStringValue(cIMInstance, NAME);
            if (string != null) {
                userObj.setUserName(string);
            }
            if ((string = this.getStringValue(cIMInstance, USER_UID)) != null) {
                userObj.setUserID(string);
            }
            if ((string = this.getStringValue(cIMInstance, USER_DESCR)) != null) {
                userObj.setUserDescription(string);
            }
            if ((string = this.getStringValue(cIMInstance, USER_TYPE)) != null) {
                userObj.setUserType(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return userObj;
    }

    private UserObj stuffFullUserObj(CIMInstance cIMInstance) {
        UserObj userObj = new UserObj();
        String string = null;
        Vector vector = null;
        boolean bl = false;
        try {
            Cloneable cloneable;
            Cloneable cloneable2;
            Object object;
            String[] stringArray;
            Vector vector2;
            Cloneable cloneable3;
            string = this.getStringValue(cIMInstance, NAME);
            if (string != null) {
                userObj.setUserName(string);
            }
            if ((string = this.getStringValue(cIMInstance, USER_UID)) != null) {
                userObj.setUserID(string);
            }
            if ((string = this.getStringValue(cIMInstance, USER_DESCR)) != null) {
                userObj.setUserDescription(string);
            }
            if ((string = this.getStringValue(cIMInstance, USER_TYPE)) != null) {
                userObj.setUserType(string);
            }
            if ((string = this.getStringValue(cIMInstance, FULL_NAME)) != null) {
                userObj.setUserFullName(string);
            }
            if (!userObj.getUserName().equals("") && userObj.getUserName() != null) {
                cloneable3 = new UserAttrObj(userObj.getUserName());
                string = this.getStringValue(cIMInstance, ATTR_KEY);
                if (string != null) {
                    ((ExtAttrObj)cloneable3).putAttributeString(string);
                    userObj.setSolAuthAttrs((UserAttrObj)cloneable3);
                }
            }
            cloneable3 = new SolProjectAttr();
            string = this.getStringValue(cIMInstance, PRIMARY_PROJECT);
            if (string != null) {
                ((SolProjectAttr)cloneable3).setPrimaryProject(string);
            }
            if ((vector2 = this.getVectorValue(cIMInstance, SECONDARY_PROJECTS)) != null && vector2.size() != 0) {
                stringArray = this.VectorToStrArray(vector2);
                ((SolProjectAttr)cloneable3).setSecondaryProjects(stringArray);
            }
            userObj.setSolProjectAttr((SolProjectAttr)cloneable3);
            stringArray = new SolGroupAttr();
            string = this.getStringValue(cIMInstance, PRIM_GROUP);
            if (string != null) {
                stringArray.setPrimaryGroup(string);
            }
            vector = null;
            vector = this.getVectorValue(cIMInstance, SEC_GROUPS);
            if (vector != null && vector.size() != 0) {
                object = this.VectorToStrArray(vector);
                stringArray.setSecondaryGroups((String[])object);
                stringArray.setNumberSecondaryGroups(vector.size());
            } else {
                stringArray.setNumberSecondaryGroups(0);
            }
            userObj.setSolGroupAttr((SolGroupAttr)stringArray);
            object = new SolAccountAttr();
            CIMDateTime cIMDateTime = null;
            cIMDateTime = this.getDateValue(cIMInstance, ACCNT_EXPIRE);
            String string2 = null;
            if (cIMDateTime != null) {
                cloneable2 = cIMDateTime.getCalendar();
                cloneable = ((Calendar)cloneable2).getTime();
                string2 = this.convertDateToString((Date)cloneable);
            }
            if (string2 != null) {
                ((SolAccountAttr)object).setAccountExpires(string2);
            }
            bl = this.getBooleanValue(cIMInstance, ACCNT_LOCKED);
            ((SolAccountAttr)object).setAccountIsLocked(bl);
            userObj.setSolAccountAttr((SolAccountAttr)object);
            cloneable2 = new SolPasswordAttr();
            string = this.getStringValue(cIMInstance, MUST_CHNG_PWD);
            if (string != null) {
                ((SolPasswordAttr)cloneable2).setMustChangeDays(string);
            }
            if ((string = this.getStringValue(cIMInstance, DO_NOT_REUSE_PWD)) != null) {
                ((SolPasswordAttr)cloneable2).setCannotChangeDays(string);
            }
            if ((string = this.getStringValue(cIMInstance, WARN_PWD)) != null) {
                ((SolPasswordAttr)cloneable2).setAlertChangeDays(string);
            }
            if ((string = this.getStringValue(cIMInstance, PWD_INACTIVE)) != null) {
                ((SolPasswordAttr)cloneable2).setInactiveDays(string);
            }
            bl = this.getBooleanValue(cIMInstance, CHANGE_PWD);
            ((SolPasswordAttr)cloneable2).setChangePassword(bl);
            bl = this.getBooleanValue(cIMInstance, HAS_PWD);
            ((SolPasswordAttr)cloneable2).setHasPassword(bl);
            bl = this.getBooleanValue(cIMInstance, PWD_FRC_MOD);
            ((SolPasswordAttr)cloneable2).setForceModify(bl);
            userObj.setSolPasswordAttr((SolPasswordAttr)cloneable2);
            cloneable = new SolServicesAttr();
            string = this.getStringValue(cIMInstance, MAIL_SERVER);
            if (string != null) {
                ((SolServicesAttr)cloneable).setMailServer(string);
            }
            if ((string = this.getStringValue(cIMInstance, INIT_SHELL)) != null) {
                ((SolServicesAttr)cloneable).setInitialShell(string);
            }
            bl = this.getBooleanValue(cIMInstance, MBOX_ALLOW_MOD);
            ((SolServicesAttr)cloneable).setModifyMailServer(bl);
            bl = this.getBooleanValue(cIMInstance, MBOX_FRC_MOD);
            ((SolServicesAttr)cloneable).setForceModify(bl);
            userObj.setSolServicesAttr((SolServicesAttr)cloneable);
            SolHomedirAttr solHomedirAttr = new SolHomedirAttr();
            string = this.getStringValue(cIMInstance, HOME_DIR_SERVER);
            if (string != null) {
                solHomedirAttr.setServer(string);
            }
            if ((string = this.getStringValue(cIMInstance, HOME_DIR_PATH)) != null) {
                solHomedirAttr.setPathname(string);
            }
            bl = this.getBooleanValue(cIMInstance, AUTOMOUNT);
            if (string != null) {
                solHomedirAttr.setAutomount(bl);
            }
            userObj.setSolHomedirAttr(solHomedirAttr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return userObj;
    }

    private String[] VectorToStrArray(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    private Date setUpExpirationDate(String string) {
        Date date = new Date();
        if (string == null || string.equals("")) {
            return date;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    private String convertDateToString(Date date) {
        String string = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        try {
            string = simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

