/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.common.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.WBEMClient.ClientProxyException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.BatchCIMClient;
import javax.wbem.client.BatchHandle;
import javax.wbem.client.BatchResult;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMSecurityException;

public class ProjectProxy
implements WbemClientProxy {
    public static final String USER_DEF_PROJ_PREFIX = "user.";
    public static final String GROUP_DEF_PROJ_PREFIX = "group.";
    public static final String DEFAULT_PROJECT_NAME = "default";
    private static final String PROJ_MOF_CLASS = "Solaris_Project";
    private static final String USER_MOF_CLASS = "Solaris_UserAccount";
    private static final String GROUP_MOF_CLASS = "Solaris_UserGroup";
    private static final String PROJECT_USER_CLASS = "Solaris_ProjectGroup";
    private static final String PROJ_NAME = "ProjectName";
    private static final String GROUP_NAME = "GroupName";
    private static final String PROJ_ID = "ProjectID";
    private static final String DESCRIPTION = "Description";
    private static final String DEFAULT_DELIMITER = ",";
    private static final String GET_USERS_METHOD = "getProjectUsers";
    private static final String GET_GROUPS_METHOD = "getProjectGroups";
    private static final String SET_USERS_METHOD = "setProjectUsers";
    private static final String SET_GROUPS_METHOD = "setProjectGroups";
    private static final String ADD_ACTION = "add";
    private static final String DEL_ACTION = "del";
    private CIMClient cimClient = null;
    private String path = null;
    private WbemMgmtScope scope = null;
    private CIMClass profClass = null;
    private static final String USER = "User";
    private static final String GROUP = "Group";

    public void init(CIMClient cIMClient, WbemMgmtScope wbemMgmtScope) throws AdminException {
        this.cimClient = cIMClient;
        this.scope = wbemMgmtScope;
        this.path = PROJ_MOF_CLASS;
    }

    public Vector getProjectNames() throws AdminException {
        try {
            Vector<String> vector = new Vector<String>(1);
            vector.add(" ");
            CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJ_MOF_CLASS);
            cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
            Enumeration enumeration = this.cimClient.enumerateInstanceNames(cIMObjectPath);
            if (enumeration != null) {
                vector = new Vector(30);
                String string = null;
                while (enumeration.hasMoreElements()) {
                    string = this.getStringKeyValue(PROJ_NAME, (CIMObjectPath)enumeration.nextElement());
                    if (string == null || string.equals(DEFAULT_PROJECT_NAME)) continue;
                    vector.add(string);
                }
                vector.trimToSize();
                if (vector.size() > 0) {
                    return vector;
                }
            }
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJPROXY_SCTY_GETNAMES");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_PROJPROXY_CIM_READNAMES", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN_READNAMES", exception.getMessage());
        }
        return null;
    }

    public String[] getGroupMembershipProjects(String string) throws AdminException {
        return this.getMembershipProjects(string, GROUP);
    }

    public boolean addGroupToProjects(String string, String[] stringArray) throws AdminException {
        return this.modMemberProjects(string, stringArray, GROUP, ADD_ACTION);
    }

    public boolean delGroupFromProjects(String string, String[] stringArray) throws AdminException {
        return this.modMemberProjects(string, stringArray, GROUP, DEL_ACTION);
    }

    public boolean setGroupPrimaryProject(String string, String string2) throws AdminException {
        try {
            if (!this.isDefaultProjectName(string2)) {
                String string3 = null;
                CIMInstance cIMInstance = this.getProjectInstance(string2);
                if (cIMInstance == null) {
                    return false;
                }
                string3 = this.getValue(PROJ_ID, cIMInstance);
                CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJ_MOF_CLASS);
                cIMObjectPath.addKey(PROJ_NAME, new CIMValue((Object)(GROUP_DEF_PROJ_PREFIX + string)));
                cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
                CIMInstance cIMInstance2 = this.getProjectInstance(GROUP_DEF_PROJ_PREFIX + string);
                if (cIMInstance2 == null) {
                    CIMInstance cIMInstance3 = this.buildProjectInstance(cIMObjectPath, GROUP_DEF_PROJ_PREFIX + string, string3);
                    this.cimClient.createInstance(cIMObjectPath, cIMInstance3);
                    return true;
                }
                cIMInstance2.setProperty(PROJ_ID, new CIMValue((Object)string3));
                this.cimClient.setInstance(cIMObjectPath, cIMInstance2);
                return true;
            }
            return false;
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJPROXY_SCTY_SET_GPRIM");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string4 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string4);
            }
            throw new ClientProxyException("EXM_PROJPROXY_CIM_SET_GPRIM", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN_SET_GPRIM", exception.getMessage());
        }
    }

    public String getGroupPrimaryProjectName(String string) throws AdminException {
        try {
            String string2 = new String(GROUP_DEF_PROJ_PREFIX + string);
            if (this.projectExists(string2)) {
                return string2;
            }
            return null;
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN_GET_GPRIM", exception.getMessage());
        }
    }

    public boolean delGroupPrimaryProject(String string) throws AdminException {
        try {
            if (this.projectExists(GROUP_DEF_PROJ_PREFIX + string)) {
                CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJ_MOF_CLASS);
                cIMObjectPath.addKey(PROJ_NAME, new CIMValue((Object)(GROUP_DEF_PROJ_PREFIX + string)));
                cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
                this.cimClient.deleteInstance(cIMObjectPath);
                return true;
            }
            return true;
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJPROXY_SCTY_DEL_GPRIM");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_PROJPROXY_CIM_DEL_GPRIM", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN_DEL_GPRIM", exception.getMessage());
        }
    }

    public boolean projectExists(String string) throws AdminException {
        try {
            CIMInstance cIMInstance = this.getProjectInstance(string);
            if (cIMInstance != null) {
                return true;
            }
        }
        catch (ClientProxyException clientProxyException) {
            return false;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        return false;
    }

    public boolean deleteGroupProjects(GroupObj groupObj) throws AdminException {
        String[] stringArray;
        if (groupObj.getPrimProject() != null) {
            this.delGroupPrimaryProject(groupObj.getGroupName());
        }
        if ((stringArray = groupObj.getSecProjects()) != null && stringArray.length > 0) {
            this.delGroupFromProjects(groupObj.getGroupName(), stringArray);
        }
        return true;
    }

    public boolean createGroupProjects(GroupObj groupObj) throws AdminException {
        String[] stringArray;
        if (groupObj.getPrimProject() != null) {
            this.setGroupPrimaryProject(groupObj.getGroupName(), groupObj.getPrimProject());
        }
        if ((stringArray = groupObj.getSecProjects()) != null && stringArray.length > 0) {
            this.addGroupToProjects(groupObj.getGroupName(), stringArray);
        }
        return true;
    }

    public boolean modifyGroupProjects(GroupObj groupObj) throws AdminException {
        this.setGroupPrimaryProject(groupObj.getGroupName(), groupObj.getPrimProject());
        String[] stringArray = this.getGroupMembershipProjects(groupObj.getGroupName());
        String[] stringArray2 = this.buildDelArray(groupObj.getSecProjects(), stringArray);
        if (groupObj.getSecProjects() != null) {
            this.addGroupToProjects(groupObj.getGroupName(), groupObj.getSecProjects());
        }
        if (stringArray2 != null) {
            this.delGroupFromProjects(groupObj.getGroupName(), stringArray2);
        }
        return true;
    }

    public boolean MOFContainsProject() {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(USER_MOF_CLASS);
            cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
            CIMClass cIMClass = this.cimClient.getClass(cIMObjectPath, false, true);
            if (cIMClass != null) {
                CIMQualifier cIMQualifier = cIMClass.getQualifier("Version");
                CIMQualifier cIMQualifier2 = cIMClass.getQualifier("Revision");
                if (cIMQualifier != null && cIMQualifier2 != null && cIMQualifier.hasValue() && cIMQualifier2.hasValue()) {
                    CIMValue cIMValue = cIMQualifier.getValue();
                    CIMValue cIMValue2 = cIMQualifier2.getValue();
                    if (cIMValue != null && cIMValue2 != null) {
                        String string = (String)cIMValue.getValue();
                        String string2 = (String)cIMValue2.getValue();
                        if (Integer.parseInt(string) >= 1 && Integer.parseInt(string2) >= 1) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        catch (CIMException cIMException) {
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (AdminException adminException) {
            return false;
        }
    }

    private String[] getMembershipProjects(String string, String string2) throws ClientProxyException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = null;
            if (string == null) {
                // empty if block
            }
            if (!string2.equals(USER)) {
                return this.getGroupProjects(string);
            }
            string3 = GET_USERS_METHOD;
            String[] stringArray = this.VtoSA(this.getProjectNames());
            if (stringArray != null) {
                Object object;
                CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJ_MOF_CLASS);
                cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
                CIMValue cIMValue = null;
                Vector vector = new Vector(1);
                Vector vector2 = new Vector(1);
                int n = 0;
                while (n < stringArray.length) {
                    cIMObjectPath.addKey(PROJ_NAME, new CIMValue((Object)stringArray[n]));
                    cIMValue = this.cimClient.invokeMethod(cIMObjectPath, string3, vector, vector2);
                    if (cIMValue != null) {
                        object = (String)cIMValue.getValue();
                        if (((String)object).startsWith("\"")) {
                            object = ((String)object).substring(1);
                        }
                        if (((String)object).endsWith("\"")) {
                            object = ((String)object).substring(0, ((String)object).length() - 1);
                        }
                        if (this.isMember((String)object, string)) {
                            arrayList.add(stringArray[n]);
                        }
                    }
                    ++n;
                }
                arrayList.trimToSize();
                if (arrayList.size() > 0) {
                    object = new String[arrayList.size()];
                    int n2 = 0;
                    while (n2 < arrayList.size()) {
                        object[n2] = (String)arrayList.get(n2);
                        ++n2;
                    }
                    return object;
                }
                return null;
            }
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJPROXY_SCTY_GET_GSEC");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string4 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string4);
            }
            throw new ClientProxyException("EXM_PROJPROXY_CIM_GET_GSEC", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN_GET_GSEC", exception.getMessage());
        }
        return null;
    }

    private String[] getGroupProjects(String string) throws ClientProxyException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(GROUP_MOF_CLASS);
        String string2 = PROJECT_USER_CLASS;
        if (string != null) {
            String[] stringArray;
            Vector<String> vector = new Vector<String>();
            try {
                cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
                cIMObjectPath.addKey(GROUP_NAME, new CIMValue((Object)string));
                Enumeration enumeration = this.cimClient.associatorNames(cIMObjectPath, string2, null, null, null);
                while (enumeration.hasMoreElements()) {
                    CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                    stringArray = cIMObjectPath2.getKeys().elements();
                    while (stringArray.hasMoreElements()) {
                        CIMProperty cIMProperty = (CIMProperty)stringArray.nextElement();
                        if (!cIMProperty.getName().equalsIgnoreCase(PROJ_NAME)) continue;
                        vector.add((String)cIMProperty.getValue().getValue());
                    }
                }
            }
            catch (CIMSecurityException cIMSecurityException) {
                if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                    throw new ClientProxyException("EXM_PROJPROXY_SCTY_GET_GSEC");
                }
                throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
            }
            catch (CIMException cIMException) {
                if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                    Object[] objectArray = cIMException.getParams();
                    String string3 = (String)objectArray[0];
                    throw new ClientProxyException("EXM_REMOTE", string3);
                }
                throw new ClientProxyException("EXM_PROJPROXY_CIM_GET_GSEC", cIMException.getID());
            }
            catch (Exception exception) {
                throw new ClientProxyException("EXM_PROJPROXY_GEN_GET_GSEC", exception.getMessage());
            }
            stringArray = new String[vector.size()];
            vector.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    private boolean modMemberProjects(String string, String[] stringArray, String string2, String string3) throws ClientProxyException {
        try {
            String string4 = null;
            String string5 = null;
            if (stringArray == null || stringArray.length == 0) {
                return false;
            }
            if (string2.equals(USER)) {
                string4 = GET_USERS_METHOD;
                string5 = SET_USERS_METHOD;
            } else {
                string4 = GET_GROUPS_METHOD;
                string5 = SET_GROUPS_METHOD;
            }
            Vector vector = new Vector(1);
            Vector vector2 = new Vector(1);
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[stringArray.length];
            CIMValue cIMValue = null;
            BatchCIMClient batchCIMClient = new BatchCIMClient();
            int[] nArray = new int[stringArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] == null) break;
                cIMObjectPathArray[n2] = new CIMObjectPath(PROJ_MOF_CLASS);
                cIMObjectPathArray[n2] = this.addMgmtKeys(cIMObjectPathArray[n2]);
                cIMObjectPathArray[n2].addKey(PROJ_NAME, new CIMValue((Object)stringArray[n2]));
                nArray[n2] = batchCIMClient.invokeMethod(cIMObjectPathArray[n2], string4, vector, vector2);
                ++n;
                ++n2;
            }
            BatchResult batchResult = this.cimClient.performBatchOperations((BatchHandle)batchCIMClient);
            batchCIMClient = new BatchCIMClient();
            int n3 = 0;
            while (n3 < n) {
                cIMValue = (CIMValue)batchResult.getResult(nArray[n3]);
                if (cIMValue != null) {
                    String string6 = (String)cIMValue.getValue();
                    if (string6.startsWith("\"")) {
                        string6 = string6.substring(1);
                    }
                    if (string6.endsWith("\"")) {
                        string6 = string6.substring(0, string6.length() - 1);
                    }
                    Vector<CIMValue> vector3 = new Vector<CIMValue>(1);
                    string6 = this.buildMemberList(string6, string, string3);
                    vector3.add(new CIMValue((Object)string6));
                    nArray[n3] = batchCIMClient.invokeMethod(cIMObjectPathArray[n3], string5, vector3, vector2);
                }
                ++n3;
            }
            batchResult = this.cimClient.performBatchOperations((BatchHandle)batchCIMClient);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJPROXY_SCTY_SET_GSEC");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string7 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string7);
            }
            throw new ClientProxyException("EXM_PROJPROXY_CIM_SET_GSEC", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN_SET_GSEC", exception.getMessage());
        }
        return true;
    }

    private CIMObjectPath addMgmtKeys(CIMObjectPath cIMObjectPath) throws AdminException {
        if (this.scope == null) {
            throw new ClientProxyException("EXM_PROJPROXY_BAD_SCOPE");
        }
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        return cIMObjectPath;
    }

    private CIMInstance addMgmtKeys(CIMInstance cIMInstance) throws AdminException {
        if (this.scope == null) {
            throw new ClientProxyException("EXM_PROJPROXY_BAD_SCOPE");
        }
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        return cIMInstance;
    }

    private boolean isDefaultProjectName(String string) {
        return string != null && (string.startsWith(USER_DEF_PROJ_PREFIX) || string.startsWith(GROUP_DEF_PROJ_PREFIX) || string.equals(DEFAULT_PROJECT_NAME));
    }

    private boolean isMember(String string, String string2) {
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    private CIMInstance getProjectInstance(String string) throws ClientProxyException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJ_MOF_CLASS);
            cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
            if (string != null) {
                cIMObjectPath.addKey(PROJ_NAME, new CIMValue((Object)string));
                return this.cimClient.getInstance(cIMObjectPath, false);
            }
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJPROXY_SCTY_GET_PROJ");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (!cIMException.getID().equals("GENERAL_EXCEPTION")) {
                throw new ClientProxyException("EXM_REMOTE", cIMException.getID());
            }
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN_GET_PROJ", exception.getMessage());
        }
        return null;
    }

    private CIMInstance buildProjectInstance(CIMObjectPath cIMObjectPath, String string, String string2) throws ClientProxyException {
        try {
            CIMClass cIMClass = this.cimClient.getClass(cIMObjectPath, false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty(PROJ_NAME, new CIMValue((Object)string));
            cIMInstance.setProperty(PROJ_ID, new CIMValue((Object)string2));
            cIMInstance = this.addMgmtKeys(cIMInstance);
            return cIMInstance;
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN", exception.getMessage());
        }
    }

    private String getValue(String string, CIMInstance cIMInstance) throws AdminException {
        try {
            CIMValue cIMValue = cIMInstance.getProperty(string).getValue();
            if (cIMValue != null) {
                return cIMValue.getValue().toString();
            }
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN", exception.getMessage());
        }
        return null;
    }

    private String getStringKeyValue(String string, CIMObjectPath cIMObjectPath) throws AdminException {
        try {
            String string2 = null;
            Vector vector = cIMObjectPath.getKeys();
            if (vector == null) {
                return null;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (cIMProperty == null || (string2 = cIMProperty.getName()) == null || !string.equalsIgnoreCase(string2)) continue;
                CIMValue cIMValue = cIMProperty.getValue();
                if (cIMValue != null) {
                    return (String)cIMValue.getValue();
                }
                return null;
            }
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN", exception.getMessage());
        }
        return null;
    }

    private String buildMemberList(String string, String string2, String string3) throws AdminException {
        try {
            if (!string3.equals(ADD_ACTION) || !string3.equals(DEL_ACTION)) {
                // empty if block
            }
            String string4 = ",;";
            String string5 = null;
            String string6 = new String();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string4);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
                if (!string2.equals(string5)) {
                    string6 = string6.concat(string5 + " ");
                    continue;
                }
                bl = true;
                if (!string3.equals(ADD_ACTION)) continue;
                string6 = string6.concat(string5 + " ");
            }
            if (string3.equals(ADD_ACTION) && !bl) {
                string6 = string6.concat(string2);
            }
            string6.trim();
            return string6;
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN", exception.getMessage());
        }
    }

    private String[] VtoSA(Vector vector) throws ClientProxyException {
        try {
            String[] stringArray = new String[vector.size()];
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
            return stringArray;
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN", exception.getMessage());
        }
    }

    private Vector SAtoV(String[] stringArray) throws ClientProxyException {
        try {
            Vector<String> vector = new Vector<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                vector.add(stringArray[n]);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJPROXY_GEN", exception.getMessage());
        }
    }

    private String[] buildDelArray(String[] stringArray, String[] stringArray2) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray2.length);
            boolean bl = false;
            int n = 0;
            while (n < stringArray2.length) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray2[n].equals(stringArray[n2])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    arrayList.add(stringArray2[n]);
                } else {
                    bl = false;
                }
                ++n;
            }
            arrayList.trimToSize();
            String[] stringArray3 = new String[arrayList.size()];
            arrayList.toArray(stringArray3);
            return stringArray3;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

