/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.common.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.usermgr.common.ExecAttrObj;
import com.sun.admin.usermgr.common.ProfAttrObj;
import com.sun.admin.usermgr.common.RightObj;
import com.sun.admin.usermgr.common.WBEMClient.ClientProxyException;
import com.sun.admin.usermgr.common.WBEMClient.ExecAttrProxy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMSecurityException;

public class ProfileAttrProxy
implements WbemClientProxy {
    private static final String PROF_MOF_CLASS = "Solaris_ProfileAttribute";
    private static final String PROF_NAME = "ProfileName";
    private static final String LONG_DESC = "LongDescription";
    private static final String HELP_FILE = "HelpFile";
    private static final String ALL_PROFS = "ProfNames";
    private static final String ALL_AUTHS = "AuthNames";
    private static final String KEY_VALUE = "SolarisAttrKeyValue";
    private CIMClient cc = null;
    private String path = null;
    private WbemMgmtScope scope = null;
    private ExecAttrProxy execProxy = null;
    private CIMClass profClass = null;

    public void init(CIMClient cIMClient, WbemMgmtScope wbemMgmtScope) throws AdminException {
        this.cc = cIMClient;
        this.scope = wbemMgmtScope;
        this.path = PROF_MOF_CLASS;
        this.execProxy = new ExecAttrProxy();
        this.execProxy.init(cIMClient, wbemMgmtScope);
    }

    public String[] getProfileNames() throws AdminException {
        Vector<String> vector = null;
        String[] stringArray = null;
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.path);
        if (this.scope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        try {
            Enumeration enumeration = this.cc.enumerateInstanceNames(cIMObjectPath);
            while (enumeration != null && enumeration.hasMoreElements()) {
                vector = new Vector<String>();
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                Enumeration enumeration2 = (Enumeration)((Object)cIMObjectPath2.getKeys());
                while (enumeration2.hasMoreElements()) {
                    CIMProperty cIMProperty = (CIMProperty)enumeration2.nextElement();
                    if (!cIMProperty.getName().equalsIgnoreCase(PROF_NAME)) continue;
                    String string = (String)cIMProperty.getValue().getValue();
                    vector.addElement(string);
                }
            }
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_GEN_SCTY_READ");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_GEN_CIM_READ", null, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", exception.getMessage());
        }
        if (vector != null) {
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
        return stringArray;
    }

    public ProfAttrObj[] getProfileObjs() throws AdminException {
        ProfAttrObj[] profAttrObjArray;
        Vector<ProfAttrObj> vector = new Vector<ProfAttrObj>();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.path);
        if (this.scope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        try {
            profAttrObjArray = this.cc.enumerateInstances(cIMObjectPath, true, false, false, false, null);
            while (profAttrObjArray != null && profAttrObjArray.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)profAttrObjArray.nextElement();
                ProfAttrObj profAttrObj = this.cimToProf(cIMInstance);
                vector.addElement(profAttrObj);
            }
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_GEN_SCTY_READ");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_GEN_CIM_READ", null, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", exception.getMessage());
        }
        profAttrObjArray = null;
        if (vector != null) {
            profAttrObjArray = new ProfAttrObj[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                profAttrObjArray[n] = (ProfAttrObj)vector.elementAt(n);
                ++n;
            }
        }
        return profAttrObjArray;
    }

    public String[] getProfileAuths(String string) throws AdminException {
        ProfAttrObj profAttrObj = this.readProfAttr(string);
        if (profAttrObj == null) {
            throw new ClientProxyException("EXM_PROF_NOT_FOUND");
        }
        return profAttrObj.getAuthNames();
    }

    public String[] getSubProfiles(String string) throws AdminException {
        ProfAttrObj profAttrObj = this.readProfAttr(string);
        if (profAttrObj == null) {
            throw new ClientProxyException("EXM_PROF_NOT_FOUND");
        }
        return profAttrObj.getProfNames();
    }

    public String[] getAssignedProfiles(String string) throws AdminException {
        if (string == null || string.trim().length() == 0) {
            throw new AdminException("EXM_PROF_NO_USER");
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.path);
        if (this.scope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        cIMObjectPath.addKey("PROF_NAME", new CIMValue((Object)"invalid!"));
        Vector<CIMValue> vector = new Vector<CIMValue>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMValue((Object)string));
        CIMValue cIMValue = null;
        try {
            cIMValue = this.cc.invokeMethod(cIMObjectPath, "getUserProfs", vector, vector2);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_GEN_SCTY_READ");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_GEN_CIM_READ", null, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", exception.getMessage());
        }
        Vector vector3 = (Vector)((CIMValue)vector2.elementAt(0)).getValue();
        String[] stringArray = null;
        if (vector3 != null) {
            stringArray = new String[vector3.size()];
            int n = 0;
            while (n < vector3.size()) {
                stringArray[n] = (String)vector3.elementAt(n);
                ++n;
            }
        }
        return stringArray;
    }

    public ProfAttrObj readProfAttr(String string) throws AdminException {
        Vector vector = new Vector();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.path);
        if (this.scope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        cIMObjectPath.addKey(PROF_NAME, new CIMValue((Object)string));
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = this.cc.getInstance(cIMObjectPath, false);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_GEN_SCTY_READATTR");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_GEN_CIM_READATTR", null, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", exception.getMessage());
        }
        if (cIMInstance == null) {
            throw new AdminException("EXM_PROF_NOT_FOUND");
        }
        return this.cimToProf(cIMInstance);
    }

    public void createProfAttr(ProfAttrObj profAttrObj) throws AdminException {
        if (this.profClass == null) {
            try {
                this.profClass = this.cc.getClass(new CIMObjectPath(this.path), false);
            }
            catch (CIMException cIMException) {
                throw new ClientProxyException("EXM_GPROXY_UNEX", cIMException.getID());
            }
        }
        CIMInstance cIMInstance = this.profToCim(profAttrObj, this.profClass);
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.path);
        if (this.scope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        cIMObjectPath.addKey(PROF_NAME, new CIMValue((Object)profAttrObj.getProfName()));
        try {
            this.cc.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_GEN_SCTY_ADD");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_PROF_DUP", profAttrObj.getProfName(), string);
            }
            throw new ClientProxyException("EXM_GEN_CIM_ADD", null, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", exception.getMessage());
        }
    }

    public void modifyProfAttr(ProfAttrObj profAttrObj) throws AdminException {
        if (this.profClass == null) {
            try {
                this.profClass = this.cc.getClass(new CIMObjectPath(this.path), false);
            }
            catch (CIMException cIMException) {
                throw new ClientProxyException("EXM_GPROXY_UNEX", cIMException.getID());
            }
        }
        CIMInstance cIMInstance = this.profToCim(profAttrObj, this.profClass);
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.path);
        if (this.scope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        cIMObjectPath.addKey(PROF_NAME, new CIMValue((Object)profAttrObj.getProfName()));
        try {
            this.cc.setInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_GEN_SCTY_MOD");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_GEN_CIM_MOD", null, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", exception.getMessage());
        }
    }

    public void deleteProfAttr(String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.path);
        if (this.scope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        cIMObjectPath.addKey(PROF_NAME, new CIMValue((Object)string));
        try {
            this.cc.deleteInstance(cIMObjectPath);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_GEN_SCTY_DEL");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_GEN_CIM_DEL", null, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", exception.getMessage());
        }
    }

    public Vector getAllRights() throws AdminException {
        Vector<RightObj> vector = new Vector<RightObj>();
        ProfAttrObj[] profAttrObjArray = this.getProfileObjs();
        ExecAttrObj[] execAttrObjArray = this.execProxy.getExecAttrObjs();
        ArrayList<ExecAttrObj> arrayList = new ArrayList<ExecAttrObj>();
        int n = 0;
        while (execAttrObjArray != null && n < execAttrObjArray.length) {
            arrayList.add(execAttrObjArray[n]);
            ++n;
        }
        int n2 = 0;
        while (profAttrObjArray != null && n2 < profAttrObjArray.length) {
            String string = profAttrObjArray[n2].getProfName();
            RightObj rightObj = new RightObj(string);
            rightObj.setRightDescription(profAttrObjArray[n2].getLongDesc());
            rightObj.setProfAttr(profAttrObjArray[n2]);
            ArrayList<ExecAttrObj> arrayList2 = new ArrayList<ExecAttrObj>();
            int n3 = 0;
            while (n3 < arrayList.size()) {
                ExecAttrObj execAttrObj = (ExecAttrObj)arrayList.get(n3);
                String string2 = execAttrObj.getProfName();
                if (string.equalsIgnoreCase(string2)) {
                    arrayList2.add(execAttrObj);
                }
                ++n3;
            }
            if (arrayList2.size() != 0) {
                rightObj.setExecAttrs(arrayList2);
            }
            vector.addElement(rightObj);
            ++n2;
        }
        return vector;
    }

    public Vector getRightProfs() throws AdminException {
        Vector<RightObj> vector = new Vector<RightObj>();
        ProfAttrObj[] profAttrObjArray = this.getProfileObjs();
        int n = 0;
        while (profAttrObjArray != null && n < profAttrObjArray.length) {
            String string = profAttrObjArray[n].getProfName();
            RightObj rightObj = new RightObj(string);
            rightObj.setRightDescription(profAttrObjArray[n].getLongDesc());
            rightObj.setProfAttr(profAttrObjArray[n]);
            rightObj.setExecAttrs(null);
            vector.addElement(rightObj);
            ++n;
        }
        return vector;
    }

    public RightObj readRight(String string) throws AdminException {
        if (string == null) {
            throw new ClientProxyException("EXM_PROF_NOT_FOUND");
        }
        RightObj rightObj = new RightObj(string);
        ProfAttrObj profAttrObj = this.readProfAttr(string);
        ExecAttrObj[] execAttrObjArray = this.execProxy.getExecAttrObjs();
        ArrayList<ExecAttrObj> arrayList = new ArrayList<ExecAttrObj>();
        int n = 0;
        while (execAttrObjArray != null && n < execAttrObjArray.length) {
            arrayList.add(execAttrObjArray[n]);
            ++n;
        }
        rightObj.setRightDescription(profAttrObj.getLongDesc());
        rightObj.setProfAttr(profAttrObj);
        ArrayList<ExecAttrObj> arrayList2 = new ArrayList<ExecAttrObj>();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            ExecAttrObj execAttrObj = (ExecAttrObj)arrayList.get(n2);
            String string2 = execAttrObj.getProfName();
            if (string.equalsIgnoreCase(string2)) {
                arrayList2.add(execAttrObj);
            }
            ++n2;
        }
        if (arrayList2.size() != 0) {
            rightObj.setExecAttrs(arrayList2);
        }
        return rightObj;
    }

    public void addRight(RightObj rightObj) throws AdminException {
        if (rightObj == null) {
            throw new ClientProxyException("EXM_PROF_NO_INFO");
        }
        ProfAttrObj profAttrObj = rightObj.getProfAttr();
        ArrayList arrayList = rightObj.getExecAttrs();
        if (profAttrObj != null) {
            if (profAttrObj.getProfName() != null) {
                this.createProfAttr(profAttrObj);
            } else {
                throw new ClientProxyException("EXM_PROF_NO_INFO");
            }
        }
        int n = 0;
        while (arrayList != null && n < arrayList.size()) {
            ExecAttrObj execAttrObj = (ExecAttrObj)arrayList.get(n);
            this.execProxy.createExecAttr(execAttrObj);
            ++n;
        }
    }

    public void deleteRight(RightObj rightObj) throws AdminException {
        if (rightObj == null) {
            throw new ClientProxyException("EXM_PROF_NO_INFO");
        }
        String string = rightObj.getRightName();
        if (string == null) {
            throw new ClientProxyException("EXM_PROF_NOT_FOUND");
        }
        ExecAttrObj[] execAttrObjArray = this.execProxy.getExecAttrObjs();
        ArrayList<ExecAttrObj> arrayList = new ArrayList<ExecAttrObj>();
        int n = 0;
        while (execAttrObjArray != null && n < execAttrObjArray.length) {
            arrayList.add(execAttrObjArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            ExecAttrObj execAttrObj = (ExecAttrObj)arrayList.get(n2);
            String string2 = execAttrObj.getProfName();
            String string3 = execAttrObj.getId();
            String string4 = execAttrObj.getType();
            String string5 = execAttrObj.getPolicy();
            if (string.equalsIgnoreCase(string2)) {
                this.execProxy.deleteExecAttr(string2, string3, string4, string5);
            }
            ++n2;
        }
        this.deleteProfAttr(string);
    }

    public void modifyRight(RightObj rightObj) throws AdminException {
        if (rightObj == null) {
            throw new AdminException("EXM_PROF_NO_INFO");
        }
        ProfAttrObj profAttrObj = rightObj.getProfAttr();
        this.modifyProfAttr(profAttrObj);
    }

    public void deleteExecAttrEntry(String string, String string2, String string3) throws AdminException {
        if (string == null || string2 == null || string3 == null) {
            throw new AdminException("EXM_PROF_NO_INFO");
        }
        this.execProxy.deleteExecAttr(string, string3, string2, "suser");
    }

    public void deleteExecAttrEntry(String string, String string2, String string3, String string4) throws AdminException {
        if (string == null || string2 == null || string3 == null) {
            throw new AdminException("EXM_PROF_NO_INFO");
        }
        this.execProxy.deleteExecAttr(string, string3, string2, string4);
    }

    public void modifyRightEntries(RightObj rightObj) throws AdminException {
        String string;
        String string2;
        String string3;
        Object object;
        Object object2;
        if (rightObj == null) {
            throw new AdminException("EXM_PROF_NO_INFO");
        }
        ArrayList arrayList = rightObj.getExecAttrs();
        ArrayList<ExecAttrObj> arrayList2 = new ArrayList<ExecAttrObj>();
        if (arrayList == null) {
            return;
        }
        if (arrayList.size() == 0) {
            object2 = this.execProxy.getExecAttrObjs();
            int n = 0;
            while (object2 != null && ((Object)object2).length > 0 && n < ((Object)object2).length) {
                object = ((ExecAttrObj)object2[n]).getProfName();
                if (object.equalsIgnoreCase(rightObj.getRightName())) {
                    string3 = ((ExecAttrObj)object2[n]).getId();
                    string2 = ((ExecAttrObj)object2[n]).getType();
                    string = ((ExecAttrObj)object2[n]).getPolicy();
                    this.execProxy.deleteExecAttr((String)object, string3, string2, string);
                }
                ++n;
            }
        } else {
            object2 = (ExecAttrObj)arrayList.get(0);
            String string4 = ((ExecAttrObj)object2).getProfName();
            object = this.execProxy.getExecAttrObjs();
            if (object != null && ((ExecAttrObj[])object).length != 0) {
                int n = 0;
                while (n < ((ExecAttrObj[])object).length) {
                    string2 = object[n].getProfName();
                    if (string4.equalsIgnoreCase(string2)) {
                        arrayList2.add(object[n]);
                    }
                    ++n;
                }
            }
        }
        int n = 0;
        while (n < arrayList2.size()) {
            ExecAttrObj execAttrObj = (ExecAttrObj)arrayList2.get(n);
            object = execAttrObj.getProfName();
            string3 = execAttrObj.getId();
            string2 = execAttrObj.getType();
            string = execAttrObj.getPolicy();
            this.execProxy.deleteExecAttr((String)object, string3, string2, string);
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            object = null;
            object = (ExecAttrObj)arrayList.get(n2);
            this.execProxy.createExecAttr((ExecAttrObj)object);
            ++n2;
        }
    }

    public String[] getExecutables(String string) throws AdminException {
        if (string == null) {
            throw new AdminException("EXM_PROF_NO_DIR");
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.path);
        if (this.scope != null) {
            cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        Vector<CIMValue> vector = new Vector<CIMValue>();
        Vector vector2 = new Vector();
        CIMValue cIMValue = new CIMValue((Object)string);
        vector.addElement(cIMValue);
        try {
            this.cc.invokeMethod(cIMObjectPath, "getExecutables", vector, vector2);
        }
        catch (CIMSecurityException cIMSecurityException) {
            throw new ClientProxyException("EXM_PROF_NO_ACCESS");
        }
        catch (CIMException cIMException) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GPROXY_UNEX", exception.getMessage());
        }
        Vector vector3 = (Vector)((CIMValue)vector2.elementAt(0)).getValue();
        String[] stringArray = null;
        if (vector3 != null) {
            stringArray = new String[vector3.size()];
            Enumeration enumeration = vector3.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n] = (String)enumeration.nextElement();
                ++n;
            }
        }
        return stringArray;
    }

    private ProfAttrObj cimToProf(CIMInstance cIMInstance) throws AdminException {
        if (cIMInstance == null) {
            throw new ClientProxyException("EXM_PROF_NOT_FOUND");
        }
        ProfAttrObj profAttrObj = null;
        try {
            String string = null;
            try {
                string = (String)cIMInstance.getProperty(PROF_NAME).getValue().getValue();
            }
            catch (Exception exception) {
                throw new ClientProxyException("EXM_PROF_NOT_FOUND");
            }
            if (string == null) {
                throw new ClientProxyException("EXM_PROF_NOT_FOUND");
            }
            profAttrObj = new ProfAttrObj(string);
            String string2 = null;
            try {
                string2 = (String)cIMInstance.getProperty(LONG_DESC).getValue().getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null) {
                profAttrObj.setLongDesc(string2);
            }
            String string3 = null;
            try {
                string3 = (String)cIMInstance.getProperty(KEY_VALUE).getValue().getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 != null) {
                profAttrObj.putAttributeString(string3);
            }
            Vector vector = null;
            try {
                vector = (Vector)cIMInstance.getProperty(ALL_PROFS).getValue().getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray = null;
            if (vector != null) {
                stringArray = new String[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    stringArray[n] = (String)vector.elementAt(n);
                    ++n;
                }
                profAttrObj.setProfNames(stringArray);
            }
        }
        catch (Exception exception) {
            throw new ClientProxyException(exception.getMessage());
        }
        return profAttrObj;
    }

    private CIMInstance profToCim(ProfAttrObj profAttrObj, CIMClass cIMClass) throws AdminException {
        CIMInstance cIMInstance = null;
        cIMInstance = cIMClass.newInstance();
        if (this.scope != null) {
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)this.scope.getScopeClassType()));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)this.scope.getDomainName()));
        }
        cIMInstance.setProperty(PROF_NAME, new CIMValue((Object)profAttrObj.getProfName()));
        cIMInstance.setProperty(LONG_DESC, new CIMValue((Object)profAttrObj.getLongDesc()));
        cIMInstance.setProperty(KEY_VALUE, new CIMValue((Object)profAttrObj.getAttributeString()));
        return cIMInstance;
    }
}

