/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.common;

import com.sun.wbem.apps.common.LAYOUT_ALIGNMENT;
import com.sun.wbem.apps.common.RowLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ToolBarPanel
extends JPanel
implements MouseListener {
    private Vector icons;
    private Color bgColor;

    public ToolBarPanel() {
        this.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND));
        this.bgColor = this.getBackground();
        this.icons = new Vector();
        this.barLayout();
    }

    public void addComponent(Component component) {
        this.icons.addElement(component);
        this.barLayout();
    }

    public void setBackground(Color color) {
        this.bgColor = color;
        super.setBackground(color);
    }

    public void barLayout() {
        this.removeAll();
        this.add(Box.createVerticalStrut(30));
        Enumeration enumeration = this.icons.elements();
        while (enumeration.hasMoreElements()) {
            this.add((Component)enumeration.nextElement());
        }
        this.add(Box.createHorizontalGlue());
        this.invalidate();
        this.validate();
    }

    public JButton createButton(Icon icon, String string, ActionListener actionListener) {
        return this.createButton(icon, string, string, actionListener);
    }

    public JButton createButton(Icon icon, String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(icon);
        jButton.setToolTipText(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        this.addButton(jButton);
        return jButton;
    }

    public void addButton(JButton jButton) {
        jButton.setBorderPainted(false);
        jButton.setBackground(this.bgColor);
        jButton.addMouseListener(this);
        this.addComponent(jButton);
    }

    public JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        this.addLabel(jLabel);
        return jLabel;
    }

    public JLabel createLabel(Icon icon) {
        JLabel jLabel = new JLabel(icon);
        this.addLabel(jLabel);
        return jLabel;
    }

    public void addLabel(JLabel jLabel) {
        this.addComponent(jLabel);
    }

    public void createSpace(int n) {
        this.addComponent(Box.createHorizontalStrut(n));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof JButton) {
            ((JButton)component).setBorderPainted(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof JButton) {
            ((JButton)component).setBorderPainted(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

