/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.common;

import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.AdminDialog;
import com.sun.wbem.apps.common.ButtonPanel;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.ColumnLayout;
import com.sun.wbem.apps.common.ContextHelpListener;
import com.sun.wbem.apps.common.GenInfoPanel;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.LAYOUT_ALIGNMENT;
import com.sun.wbem.apps.common.Util;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;

public class NameSpaceDialog
extends AdminDialog
implements ItemSelectable {
    private JButton btnOK;
    private JButton btnCancel;
    private JButton btnAddNS;
    private JButton btnDeleteNS;
    private String selectedNameSpace;
    private EventListenerList listenerList;
    protected GenInfoPanel infoPanel = this.getInfoPanel();
    protected JList list;
    protected DefaultListModel listModel;
    protected CIMClient cimClient;
    protected AdminDialog thisDialog = this;
    protected CIMObjectPath currentNameSpace = new CIMObjectPath("", CIMClientObject.getNameSpace());
    protected JScrollPane scrollList;
    protected int cellWidth = 5;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public NameSpaceDialog(Frame frame) {
        super(frame, I18N.loadString("TTL_CHANGE_NAMESPACE"), false);
        this.cimClient = CIMClientObject.changeNameSpace("");
        this.listenerList = new EventListenerList();
        this.btnOK = this.getOKBtn();
        this.btnOK.addActionListener(new OKCancelButtonListener());
        this.btnCancel = this.getCancelBtn();
        this.btnCancel.addActionListener(new OKCancelButtonListener());
        JPanel jPanel = this.getRightPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel jPanel2 = new JPanel(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.getSelectionModel().setSelectionMode(0);
        ActionString actionString = new ActionString("LBL_NAMESPACE");
        JLabel jLabel = new JLabel(actionString.getString());
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        jLabel.setLabelFor(this.list);
        this.scrollList = new JScrollPane(this.list);
        this.scrollList.setPreferredSize(this.scrollList.getPreferredSize());
        jPanel2.add(jLabel);
        jPanel2.add(this.scrollList);
        ActionString actionString2 = new ActionString("LBL_ADD");
        ActionString actionString3 = new ActionString("LBL_DELETE");
        ButtonPanel buttonPanel = new ButtonPanel();
        this.btnAddNS = new JButton(actionString2.getString());
        this.btnAddNS.setMnemonic(actionString2.getMnemonic());
        this.btnAddNS.addActionListener(new NSButtonListener());
        this.btnDeleteNS = new JButton(actionString3.getString());
        this.btnDeleteNS.setMnemonic(actionString3.getMnemonic());
        this.btnDeleteNS.addActionListener(new NSButtonListener());
        buttonPanel.add(this.btnAddNS);
        buttonPanel.add(this.btnDeleteNS);
        jPanel2.add(buttonPanel);
        jPanel.add(jPanel2);
        this.setDefaultFocusListener(new ContextHelpListener(this.infoPanel, "cimadmin", "namsp_000.htm"), true);
        this.pack();
        Util.positionWindow(this, frame);
    }

    public void okClicked() {
        CIMObjectPath cIMObjectPath = (CIMObjectPath)this.listModel.elementAt(this.list.getSelectedIndex());
        this.selectedNameSpace = cIMObjectPath.getNameSpace();
        this.fireItemEvent(new ItemEvent(this, 0, "select name space", 701));
    }

    public void cancelClicked() {
        this.selectedNameSpace = null;
        this.setVisible(false);
        this.fireItemEvent(new ItemEvent(this, 0, "dialog cancel", 701));
    }

    public String getSelectedNameSpace() {
        return this.selectedNameSpace;
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new String[1];
        return objectArray;
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = NameSpaceDialog.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = NameSpaceDialog.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    protected void fireItemEvent(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener == null ? NameSpaceDialog.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent);
            }
            n -= 2;
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
        super.windowOpened(windowEvent);
        this.refreshList();
        this.list.setSelectedValue(this.currentNameSpace, true);
        this.list.requestFocus();
    }

    private void refreshList() {
        Util.setWaitCursor(this);
        this.listModel.removeAllElements();
        Enumeration enumeration = NameSpaceDialog.getAllNameSpaces();
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            this.cellWidth = Math.max(this.cellWidth, cIMObjectPath.toString().length());
            this.listModel.addElement(cIMObjectPath);
        }
        this.btnDeleteNS.setEnabled(this.listModel.size() > 0);
        this.setCellWidth();
        Util.setDefaultCursor(this);
    }

    private void setCellWidth() {
        String string = "";
        int n = 0;
        while (n < this.cellWidth) {
            string = string + "A";
            ++n;
        }
        this.list.setPrototypeCellValue(string);
    }

    private void setCellWidth(String string) {
        this.cellWidth = Math.max(this.cellWidth, string.length());
        this.setCellWidth();
    }

    public static Enumeration getAllNameSpaces() {
        CIMClient cIMClient = CIMClientObject.changeNameSpace("");
        try {
            Enumeration enumeration = cIMClient.enumNameSpace(new CIMObjectPath("", ""), true);
            cIMClient.close();
            return enumeration;
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(null, cIMException);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NSButtonListener
    implements ActionListener {
        NSButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == NameSpaceDialog.this.btnAddNS) {
                String string = JOptionPane.showInputDialog(NameSpaceDialog.this.thisDialog, I18N.loadString("ASK_CREATE_NAMESPACE"), I18N.loadString("TTL_NEW_NAMESPACE"), -1);
                if (string != null && !string.equals("")) {
                    string = Util.cleanNameSpaceString(string);
                    try {
                        NameSpaceDialog.this.cimClient.createNameSpace(new CIMNameSpace("", string));
                        NameSpaceDialog.this.listModel.addElement(new CIMObjectPath("", string));
                        NameSpaceDialog.this.setCellWidth(string);
                    }
                    catch (CIMException cIMException) {
                        CIMErrorDialog.display(NameSpaceDialog.this.thisDialog, cIMException);
                    }
                }
            } else if (actionEvent.getSource() == NameSpaceDialog.this.btnDeleteNS) {
                int n = NameSpaceDialog.this.list.getSelectedIndex();
                CIMObjectPath cIMObjectPath = (CIMObjectPath)NameSpaceDialog.this.listModel.elementAt(n);
                if (cIMObjectPath.getNameSpace().equals(NameSpaceDialog.this.currentNameSpace.getNameSpace())) {
                    JOptionPane.showMessageDialog(NameSpaceDialog.this.thisDialog, I18N.loadString("ERR_CURRENT_NAMESPACE"), I18N.loadString("TTL_CIM_ERROR"), 1);
                } else {
                    String string = cIMObjectPath.getNameSpace();
                    int n2 = JOptionPane.showConfirmDialog(NameSpaceDialog.this.thisDialog, I18N.loadStringFormat("ASK_DELETE_NAMESPACE", string), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 2, 3);
                    if (n2 == 0) {
                        try {
                            NameSpaceDialog.this.cimClient.deleteNameSpace(new CIMNameSpace("", string));
                            NameSpaceDialog.this.listModel.removeElement(cIMObjectPath);
                            if (n > 0) {
                                --n;
                            } else if (n >= NameSpaceDialog.this.listModel.size()) {
                                n = NameSpaceDialog.this.listModel.size() - 1;
                            }
                            NameSpaceDialog.this.list.setSelectedIndex(n);
                        }
                        catch (CIMException cIMException) {
                            CIMErrorDialog.display(NameSpaceDialog.this.thisDialog, cIMException);
                        }
                    }
                }
            }
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == NameSpaceDialog.this.btnCancel) {
                NameSpaceDialog.this.cancelClicked();
            } else if (actionEvent.getSource() == NameSpaceDialog.this.btnOK) {
                NameSpaceDialog.this.okClicked();
            }
        }
    }
}

