/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.BrowseHtmlDialog;
import com.netscape.management.client.util.Browser;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class IndexDialog
extends GenericDialog
implements DocumentListener,
ListSelectionListener,
HyperlinkListener {
    private JEditorPane _pane = null;
    private JTextField _typeInField = null;
    private JList _itemList = null;
    private Hashtable _topics = null;
    private CollationKey[] _keys = null;
    private Collator _collator = Collator.getInstance();
    private String _url = "";
    private String _indexUrl = "";
    private boolean _doBrowser = true;
    private boolean _closeOnSelect = false;
    private PropertyChangeSupport _propSupport = new PropertyChangeSupport(this);
    private static final int WIDTH = 400;
    private static final int LIST_HEIGHT = 185;
    private static final int TOPIC_HEIGHT = 100;
    private static final String _section = "IndexDialog";
    public static final String PROPERTY_NAME_URL = "URL";
    private static final ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");

    public IndexDialog(JFrame jFrame, String string) {
        super(jFrame, _resource.getString(_section, "title"), 4, 0);
        JList jList = this.populateIndex(string);
        this.init(jList);
    }

    public IndexDialog(JFrame jFrame, URL uRL) {
        super(jFrame, _resource.getString(_section, "title"), 4, 0);
        this._indexUrl = uRL.toExternalForm();
        JList jList = this.populateIndex(uRL);
        this.init(jList);
    }

    protected void init(JList jList) {
        this.prepareContentPane(jList);
        this.setDefaultCloseOperation(2);
    }

    protected void prepareContentPane(JList jList) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(_resource.getString(_section, "typeInLabel"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._typeInField = new JTextField();
        jLabel.setLabelFor(this._typeInField);
        this._typeInField.getDocument().addDocumentListener(this);
        this._typeInField.setRequestFocusEnabled(true);
        this._typeInField.requestFocus();
        jPanel.add((Component)this._typeInField, gridBagConstraints);
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        JLabel jLabel2 = new JLabel(_resource.getString(_section, "selectTopicLabel"));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this._itemList = jList;
        JScrollPane jScrollPane = new JScrollPane(this._itemList);
        jScrollPane.setPreferredSize(new Dimension(400, 185));
        this._pane = new JEditorPane();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel3 = new JLabel(_resource.getString(_section, "selectItemLabel"));
        jLabel3.setLabelFor(this._pane);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        JScrollPane jScrollPane2 = new JScrollPane(this._pane);
        jScrollPane2.setPreferredSize(new Dimension(400, 100));
        this._pane.setContentType("text/html");
        this._pane.setEditable(false);
        this._pane.setBackground(Color.white);
        this._pane.addHyperlinkListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jScrollPane2, gridBagConstraints);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel2);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jSplitPane, gridBagConstraints);
        this.getContentPane().add(jPanel);
    }

    protected JList populateIndex(String string) {
        try {
            return this.populateIndex(new BufferedReader(new FileReader(string)));
        }
        catch (IOException iOException) {
            System.err.println(string + ": " + iOException);
            return new JList();
        }
    }

    protected JList populateIndex(URL uRL) {
        try {
            AdmTask admTask = new AdmTask(uRL, Console.getConsoleInfo().getAuthenticationDN(), Console.getConsoleInfo().getAuthenticationPassword());
            admTask.exec();
            if (admTask.getException() != null) {
                throw admTask.getException();
            }
            return this.populateIndex(new BufferedReader(new StringReader(admTask.getResultString().toString())));
        }
        catch (Exception exception) {
            System.err.println(uRL + ": " + exception);
            return new JList();
        }
    }

    protected JList populateIndex(BufferedReader bufferedReader) {
        try {
            Object object;
            String string;
            Vector<String> vector = new Vector<String>();
            this._topics = new Hashtable();
            String string2 = "";
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                int n2 = string.indexOf(60);
                if (string.startsWith("<BASEURL")) {
                    string2 = "<BASE HREF=\"" + this.getBaseUrl(string) + "\">";
                    Debug.println("IndexDialog.populateIndex: base URL = " + string2);
                    continue;
                }
                if (n2 <= 0) continue;
                String string3 = string.substring(0, n2 - 1);
                object = string.substring(n2);
                int n3 = ((String)object).lastIndexOf("<BR>");
                if (n3 != -1) {
                    object = ((String)object).substring(0, n3);
                }
                if ((n = vector.indexOf(string3)) >= 0) {
                    String string4 = (String)this._topics.get(string3);
                    string4 = string4 + "<BR>\n" + (String)object;
                    this._topics.put(string3, string4);
                    continue;
                }
                vector.addElement(string3);
                this._topics.put(string3, string2 + (String)object);
            }
            this._keys = new CollationKey[vector.size()];
            Enumeration enumeration = vector.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                this._keys[n++] = this._collator.getCollationKey((String)enumeration.nextElement());
            }
            object = new JList(vector);
            ((JList)object).addListSelectionListener(this);
            ((JList)object).setSelectionMode(0);
            return object;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return new JList();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = (String)this._itemList.getSelectedValue();
        String string2 = (String)this._topics.get(string);
        String string3 = "<FONT FACE=\"sans-serif,helvetica,arial\" SIZE=\"2\">";
        String string4 = "</FONT>";
        this._pane.setText(string3 + string2 + string4);
        if (((HTMLDocument)this._pane.getDocument()).getBase() == null) {
            try {
                ((HTMLDocument)this._pane.getDocument()).setBase(new URL(this._indexUrl));
            }
            catch (Exception exception) {
                Debug.println("IndexDialog.valueChanged() - index url:" + this._indexUrl + ":" + exception);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.doTypedown();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.doTypedown();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.doTypedown();
    }

    private void doTypedown() {
        String string = this._typeInField.getText();
        int n = 0;
        int n2 = this._itemList.getModel().getSize();
        CollationKey collationKey = this._collator.getCollationKey(string);
        while (n < n2 && collationKey.compareTo(this._keys[n]) > 0) {
            ++n;
        }
        this._itemList.setSelectedIndex(n);
        this._itemList.ensureIndexIsVisible(n);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            if (uRL == null) {
                System.err.println("IndexDialog.hyperlinkUpdate: invalid URL - " + hyperlinkEvent.getEventType() + " - " + hyperlinkEvent.getDescription());
                return;
            }
            String string = uRL.toString();
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                Debug.println("Frame event for URL " + hyperlinkEvent.getURL());
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                Debug.println("Setting the URL to " + string);
                int n = BrowseHtmlDialog.getWindowContext(string);
                Debug.println("Window context: " + n);
                this._doBrowser = n == -1 || n == 0;
                this.firePropertyChange(PROPERTY_NAME_URL, "", string);
            }
        }
    }

    protected void closeInvoked() {
        super.closeInvoked();
        this.dispose();
        this.firePropertyChange(PROPERTY_NAME_URL, "", null);
    }

    public String getUrl() {
        return this._url;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport != null) {
            this._propSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport != null) {
            this._propSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (this._propSupport != null) {
            this._propSupport.firePropertyChange(string, object, object2);
            if (PROPERTY_NAME_URL.equals(string) && this._closeOnSelect) {
                this._url = (String)object2;
                ((Component)this).setVisible(false);
                this.dispose();
            }
        }
    }

    public boolean isBrowserSelected() {
        return this._doBrowser;
    }

    public void setCloseOnSelect(boolean bl) {
        this._closeOnSelect = bl;
    }

    public boolean getCloseOnSelect() {
        return this._closeOnSelect;
    }

    protected String getBaseUrl(String string) {
        int n = string.indexOf(32);
        int n2 = string.indexOf(62);
        String string2 = string.substring(n + 1, n2);
        n2 = this._indexUrl.lastIndexOf(47);
        string2 = this._indexUrl.substring(0, n2 + 1) + string2;
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: IndexDialog url");
            System.exit(1);
        }
        try {
            UIManager.setLookAndFeel("com.netscape.management.nmclf.SuiLookAndFeel");
        }
        catch (Exception exception) {
            Debug.println("Cannot load nmc look and feel.");
            System.exit(-1);
        }
        Debug.setTraceLevel(6);
        try {
            final IndexDialog indexDialog = new IndexDialog(null, new URL(stringArray[0]));
            indexDialog.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string;
                    if (propertyChangeEvent.getPropertyName().equals(IndexDialog.PROPERTY_NAME_URL) && (string = (String)propertyChangeEvent.getNewValue()) != null && string.length() > 0) {
                        System.out.println("Selected URL: " + string);
                        if (indexDialog.isBrowserSelected()) {
                            new Browser().open(string, 3);
                        } else {
                            new BrowseHtmlDialog(null, string, true).showModal();
                        }
                    }
                }
            });
            indexDialog.show();
            String string = indexDialog.getUrl();
            if (string != null && string.length() > 0) {
                System.out.println("Selected URL: " + string);
                if (indexDialog.isBrowserSelected()) {
                    new Browser().open(string, 3);
                } else {
                    new BrowseHtmlDialog(null, string, true).showModal();
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot load " + stringArray[0] + ": " + exception);
            exception.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }
}

