/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.DottedBorder;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

class DayPicker
extends JPanel
implements SuiConstants {
    Calendar calendar;
    DayLabel[][] dayLabelArray;
    FocusListener dayFocusListener = new DayFocusListener();
    MouseListener dayMouseListener = new DayMouseListener();
    Border emptyBorder = BorderFactory.createEmptyBorder(1, 6, 1, 6);
    DayLabel selectedDayLabel;
    DayKeyListener dayKeyListener = new DayKeyListener();
    private static final ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");
    private static final String MONDAY = _resource.getString("DayPicker", "Monday");
    private static final String TUESDAY = _resource.getString("DayPicker", "Tuesday");
    private static final String WEDNESDAY = _resource.getString("DayPicker", "Wednesday");
    private static final String THURSDAY = _resource.getString("DayPicker", "Thursday");
    private static final String FRIDAY = _resource.getString("DayPicker", "Friday");
    private static final String SATURDAY = _resource.getString("DayPicker", "Saturday");
    private static final String SUNDAY = _resource.getString("DayPicker", "Sunday");

    public DayPicker(Calendar calendar) {
        this.calendar = calendar;
        String[] stringArray = new String[]{SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY};
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.setBorder(UITools.createLoweredBorder());
        int n = 0;
        while (n < stringArray.length) {
            JLabel jLabel = new JLabel(stringArray[n]);
            jLabel.setBackground(Color.darkGray);
            jLabel.setForeground(Color.white);
            jLabel.setBorder(this.emptyBorder);
            jLabel.setOpaque(true);
            GridBagUtil.constrain(this, jLabel, n, 0, 1, 1, 0.0, 0.0, 18, 2, 0, 0, 6, 0);
            ++n;
        }
        int n2 = calendar.getMaximum(4);
        int n3 = calendar.getMaximum(7);
        this.dayLabelArray = new DayLabel[n2][n3];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                DayLabel dayLabel = new DayLabel();
                dayLabel.addKeyListener(this.dayKeyListener);
                this.dayLabelArray[n4][n5] = dayLabel;
                GridBagUtil.constrain(this, dayLabel, n5, n4 + 1, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 6, 0);
                ++n5;
            }
            ++n4;
        }
        this.updatePicker();
    }

    public JComponent getFocusComponent() {
        return this.selectedDayLabel;
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    int getIntFromString(String string) {
        Integer n = new Integer(string);
        return n;
    }

    public void updatePicker() {
        if (this.selectedDayLabel != null) {
            this.selectedDayLabel.setSelected(false);
        }
        boolean bl = false;
        int n = this.calendar.getMaximum(4);
        int n2 = this.calendar.getMaximum(7);
        int n3 = this.calendar.get(5);
        this.calendar.set(5, 1);
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.calendar.getMaximum(5);
            int n6 = 0;
            while (n6 < n2) {
                if (this.calendar.get(7) == n6 + 1 && !bl) {
                    int n7 = this.calendar.get(5);
                    DayLabel dayLabel = this.dayLabelArray[n4][n6];
                    if (n7 == n3) {
                        dayLabel.setSelected(true);
                        this.selectedDayLabel = dayLabel;
                    }
                    dayLabel.setText(String.valueOf(n7));
                    this.calendar.roll(5, true);
                    int n8 = this.calendar.get(5);
                    if (n8 < n7) {
                        bl = true;
                    }
                } else {
                    this.dayLabelArray[n4][n6].setText(" ");
                }
                ++n6;
            }
            ++n4;
        }
        this.calendar.set(5, n3);
        this.refreshUI();
    }

    void refreshUI() {
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
    }

    class DayMouseListener
    extends MouseAdapter {
        DayMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            jLabel.requestFocus();
        }
    }

    class DayKeyListener
    extends KeyAdapter {
        DayKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 38) {
                int n2 = DayPicker.this.calendar.getMinimum(5);
                int n3 = DayPicker.this.calendar.getMaximum(5);
                int n4 = DayPicker.this.calendar.getMaximum(7);
                int n5 = DayPicker.this.calendar.get(5);
                if (n5 - n4 >= n2) {
                    DayPicker.this.calendar.add(5, -n4);
                    DayPicker.this.updatePicker();
                    DayPicker.this.selectedDayLabel.requestFocus();
                    DayPicker.this.refreshUI();
                }
            } else if (n == 40) {
                int n6 = DayPicker.this.calendar.getMinimum(5);
                int n7 = DayPicker.this.calendar.getMaximum(5);
                int n8 = DayPicker.this.calendar.getMaximum(7);
                int n9 = DayPicker.this.calendar.get(5);
                if (n9 + n8 <= n7) {
                    DayPicker.this.calendar.add(5, n8);
                    DayPicker.this.updatePicker();
                    DayPicker.this.selectedDayLabel.requestFocus();
                    DayPicker.this.refreshUI();
                }
            } else if (n == 37) {
                DayPicker.this.calendar.roll(5, false);
                DayPicker.this.updatePicker();
                DayPicker.this.selectedDayLabel.requestFocus();
                DayPicker.this.refreshUI();
            } else if (n == 39) {
                DayPicker.this.calendar.roll(5, true);
                DayPicker.this.updatePicker();
                DayPicker.this.selectedDayLabel.requestFocus();
                DayPicker.this.refreshUI();
            }
        }
    }

    class DayFocusListener
    implements FocusListener {
        DottedBorder dottedBorder = new DottedBorder();

        DayFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            DayLabel dayLabel = (DayLabel)focusEvent.getComponent();
            dayLabel.setBackground(UIManager.getColor("textHighlight"));
            dayLabel.setForeground(UIManager.getColor("textHighlightText"));
            String string = dayLabel.getText();
            if (string.equals(" ")) {
                DayPicker.this.selectedDayLabel.requestFocus();
            } else {
                DayPicker.this.selectedDayLabel.setSelected(false);
                DayPicker.this.selectedDayLabel = dayLabel;
                DayPicker.this.selectedDayLabel.setSelected(true);
                DayPicker.this.calendar.set(5, DayPicker.this.getIntFromString(dayLabel.getText()));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            DayLabel dayLabel = (DayLabel)focusEvent.getComponent();
            if (dayLabel == DayPicker.this.selectedDayLabel) {
                dayLabel.setBackground(UIManager.getColor("text"));
                dayLabel.setForeground(UIManager.getColor("textText"));
            } else {
                dayLabel.setForeground(UIManager.getColor("controlText"));
                dayLabel.setBackground(UIManager.getColor("window"));
            }
            dayLabel.setText(dayLabel.getText());
        }
    }

    class DayLabel
    extends JLabel {
        public DayLabel() {
            this.addFocusListener(DayPicker.this.dayFocusListener);
            this.addMouseListener(DayPicker.this.dayMouseListener);
            this.setForeground(UIManager.getColor("controlText"));
            this.setBackground(UIManager.getColor("window"));
            this.setBorder(DayPicker.this.emptyBorder);
            this.setOpaque(true);
        }

        public boolean isFocusTraversable() {
            return this == DayPicker.this.selectedDayLabel;
        }

        public void setSelected(boolean bl) {
            if (!bl) {
                this.setForeground(UIManager.getColor("controlText"));
                this.setBackground(UIManager.getColor("window"));
            } else if (DayPicker.this.selectedDayLabel == this) {
                this.setForeground(UIManager.getColor("textHighlightText"));
                this.setBackground(UIManager.getColor("textHighlight"));
            } else {
                this.setForeground(UIManager.getColor("textText"));
                this.setBackground(UIManager.getColor("text"));
            }
            this.setText(this.getText());
        }
    }
}

