/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.BrowseHistoryListener;
import com.netscape.management.client.util.BrowseHtmlHistory;
import com.netscape.management.client.util.BrowseHtmlPane;
import com.netscape.management.client.util.Browser;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class BrowseHtmlDialog
extends AbstractDialog
implements BrowseHistoryListener,
ActionListener,
HyperlinkListener {
    static final int WC_BROWSER = 0;
    static final int WC_NEWWINDOW = 1;
    static final int WC_SAMEWINDOW = 2;
    static final int WC_NOCONTEXT = -1;
    private int _context = 0;
    static final String WC_KEY = "windowcontext";
    static final String WC_BROWSER_STRING = "browser";
    static final String WC_NEWWINDOW_STRING = "newwindow";
    static final String WC_SAMEWINDOW_STRING = "samewindow";
    private BrowseHtmlPane _pane = null;
    private BrowseHtmlHistory _history = null;
    private JPanel _contentPane = null;
    private boolean _doBrowser;
    private JButton _backButton = null;
    private JButton _nextButton = null;
    private int _defaultWindowContext = -1;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");

    public BrowseHtmlDialog(Frame frame, String string, boolean bl) {
        super(frame);
        this._doBrowser = bl;
        this.prepareContentPane(string, bl);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    protected void prepareContentPane(String string, boolean bl) {
        this._pane = new BrowseHtmlPane(string);
        this.monitorTitle(this._pane);
        this._pane.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane(this._pane);
        this._contentPane = new JPanel();
        this._contentPane.setLayout(new BorderLayout());
        this._contentPane.setBorder(UIManager.getBorder("TextField.border"));
        this._contentPane.add((Component)jScrollPane, "Center");
        Dimension dimension = new Dimension(600, 450);
        this._contentPane.setMinimumSize(dimension);
        this._contentPane.setPreferredSize(dimension);
        this.setContentPane(this._contentPane);
        if (!bl) {
            this.addNavigationPanel(string);
        }
        this.historyStateChanged(false, false);
        this._pane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 16: {
                        BrowseHtmlDialog.this._defaultWindowContext = 2;
                        break;
                    }
                    case 17: {
                        BrowseHtmlDialog.this._defaultWindowContext = 1;
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 16: {
                        if (BrowseHtmlDialog.this._defaultWindowContext != 2) break;
                        BrowseHtmlDialog.this._defaultWindowContext = -1;
                        break;
                    }
                    case 17: {
                        if (BrowseHtmlDialog.this._defaultWindowContext != 1) break;
                        BrowseHtmlDialog.this._defaultWindowContext = -1;
                    }
                }
            }
        });
    }

    protected void addNavigationPanel(String string) {
        if (this.hasNavigationPanel()) {
            return;
        }
        this._history = new BrowseHtmlHistory();
        this._history.addBrowseHistoryListener(this);
        this._history.setPage(string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 0, 0));
        jPanel.setBorder(new EmptyBorder(9, 9, 9, 9));
        this._backButton = JButtonFactory.create(_resource.getString(null, "BackButtonLabel"), this, "BACK");
        jPanel.add(this._backButton);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this._nextButton = JButtonFactory.create(_resource.getString(null, "ForwardButtonLabel"), this, "FORWARD");
        jPanel.add(this._nextButton);
        JButtonFactory.resizeGroup(this._nextButton, this._backButton);
        this._contentPane.add((Component)jPanel, "South");
        this.invalidate();
        this.validate();
    }

    static String getUrlParameter(String string, String string2) {
        String string3 = '?' + string2 + '=';
        int n = string.indexOf(string3);
        if (n < 0) {
            string3 = '&' + string2 + '=';
            n = string.indexOf(string3);
        }
        if (n < 0) {
            return null;
        }
        int n2 = (string = string.substring(n + string3.length())).indexOf(38);
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    static int getWindowContext(String string) {
        String string2 = BrowseHtmlDialog.getUrlParameter(string, WC_KEY);
        int n = -1;
        if (string2 != null) {
            if (string2.equals(WC_NEWWINDOW_STRING)) {
                n = 1;
            } else if (string2.equals(WC_SAMEWINDOW_STRING)) {
                n = 2;
            } else if (string2.equals(WC_BROWSER_STRING)) {
                n = 0;
            }
        }
        return n;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        this.hyperlinkUpdate(hyperlinkEvent, true);
    }

    protected void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent, boolean bl) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getURL().toString();
            BrowseHtmlPane browseHtmlPane = (BrowseHtmlPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                Debug.println("Frame event for URL " + hyperlinkEvent.getURL());
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)browseHtmlPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    Debug.println("Setting the URL to " + hyperlinkEvent.getURL());
                    int n = this._defaultWindowContext != -1 ? this._defaultWindowContext : (this.hasNavigationPanel() ? 2 : BrowseHtmlDialog.getWindowContext(string));
                    Debug.println("Window context: " + n);
                    if (n == -1) {
                        n = 0;
                    }
                    switch (n) {
                        case 2: {
                            this.addNavigationPanel(browseHtmlPane.getPage().toString());
                            if (bl) {
                                this._history.addPage(string);
                            }
                            browseHtmlPane.setPage(string);
                            this.monitorTitle(browseHtmlPane);
                            break;
                        }
                        case 1: {
                            new BrowseHtmlDialog(null, string, this._doBrowser);
                            break;
                        }
                        case 0: {
                            new Browser("Help").open(string, 3);
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public void previousPage() {
        this._history.previousPage();
        this.updateFromIndex();
    }

    public void nextPage() {
        this._history.nextPage();
        this.updateFromIndex();
    }

    protected void updateFromIndex() {
        String string = this._history.getCurrentPage();
        try {
            this.hyperlinkUpdate(new HyperlinkEvent(this._pane, HyperlinkEvent.EventType.ACTIVATED, new URL(string), string), false);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(string + ": " + malformedURLException);
            this._pane.setText(string + ": " + malformedURLException);
        }
    }

    protected void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        ((Component)this).setLocation(n2, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("BACK")) {
            this.previousPage();
        } else if (actionEvent.getActionCommand().equals("FORWARD")) {
            this.nextPage();
        }
    }

    public void historyStateChanged(boolean bl, boolean bl2) {
        if (this._backButton != null) {
            this._nextButton.setEnabled(bl2);
            this._backButton.setEnabled(bl);
        }
    }

    protected void monitorTitle(JEditorPane jEditorPane) {
        String string = (String)jEditorPane.getDocument().getProperty("title");
        if (string != null) {
            this.setTitle(string);
            return;
        }
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                String string = (String)document.getProperty("title");
                if (string != null) {
                    Debug.println("BrowseHtmlDialog.monitorTitle: document title = <" + string + ">");
                    BrowseHtmlDialog.this.setTitle(string);
                    document.removeDocumentListener(this);
                }
            }
        };
        jEditorPane.getDocument().addDocumentListener(documentListener);
        string = (String)jEditorPane.getDocument().getProperty("title");
        if (string != null) {
            this.setTitle(string);
            jEditorPane.getDocument().removeDocumentListener(documentListener);
        }
    }

    protected boolean hasNavigationPanel() {
        return this._backButton != null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: BrowseHtmlPane URL [-browser]");
            System.exit(1);
        }
        boolean bl = stringArray.length > 1 && stringArray[1].equals("-browser");
        String string = stringArray[0];
        new BrowseHtmlDialog(null, string, bl).show();
    }
}

