/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.ug;

import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.ug.EditUserGroupPane;
import com.netscape.management.client.topology.ug.IUGToolPlugin;
import com.netscape.management.client.topology.ug.toolsMenuItem;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JPanel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class UGPage
extends JPanel
implements IPage {
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    public static final String MENU_TOOLS = "TOOLS";
    public static final String MENU_USER = "USER";
    private boolean canEditUG = true;
    ConsoleInfo _info;
    IFramework _parent;
    EditUserGroupPane _editUserGroupPane;
    protected boolean _isPageSelected = false;
    MenuItemCategory _toolsMenu;
    MenuItemCategory _userMenu;
    MenuItemSeparator _separator;
    protected StatusItemProgress _statusItemProgress = new StatusItemProgress("StatusItemProgress", 0);

    public UGPage(ConsoleInfo consoleInfo, boolean bl) {
        this._info = (ConsoleInfo)consoleInfo.clone();
        this.canEditUG = bl;
    }

    public void initialize(IFramework iFramework) {
        this._parent = iFramework;
        Debug.println("rsptime", "Initialize U/G Page ...");
        this.setLayout(new BorderLayout());
        this._editUserGroupPane = new EditUserGroupPane(this._info, this, this.canEditUG);
        this.add("Center", this._editUserGroupPane);
        this.createUserMenu();
        this._toolsMenu = this.createToolsMenu();
        iFramework.addStatusItem((IStatusItem)this._statusItemProgress, "R");
        Debug.println("rsptime", "U/G Page shown");
    }

    public void setStatusText(String string) {
        if (this.isPageSelected()) {
            this.getFramework().changeStatusItemState("StatusItemText", (Object)string);
        }
    }

    public IFramework getFramework() {
        return this._parent;
    }

    public String getPageTitle() {
        return this._resource.getString("UGPage", "title");
    }

    public Object clone() {
        return null;
    }

    public boolean isPageSelected() {
        return this._isPageSelected;
    }

    public void pageSelected(IFramework iFramework) {
        this._isPageSelected = true;
        this.addMenuItems();
        this._editUserGroupPane.setFocus();
        iFramework.addStatusItem((IStatusItem)this._statusItemProgress, "R");
    }

    public void pageUnselected(IFramework iFramework) {
        this.setStatusText("");
        this.removeMenuItems();
        this._isPageSelected = false;
        iFramework.removeStatusItem((IStatusItem)this._statusItemProgress);
    }

    private void addMenuItems() {
        if (this._userMenu != null) {
            this._parent.addMenuItem("<top>", (IMenuItem)this._userMenu);
        }
        if (this._toolsMenu != null) {
            this._parent.addMenuItem("<top>", (IMenuItem)this._toolsMenu);
        }
    }

    private void removeMenuItems() {
        if (this._userMenu != null) {
            this._parent.removeMenuItem((IMenuItem)this._userMenu);
        }
        if (this._toolsMenu != null) {
            this._parent.removeMenuItem((IMenuItem)this._toolsMenu);
        }
    }

    public void actionViewClosing(IFramework iFramework) throws CloseVetoException {
    }

    void createUserMenu() {
        this._userMenu = new MenuItemCategory(MENU_USER, this._resource.getString("menuCategory", "User"));
        JComponent[] jComponentArray = this._editUserGroupPane.getUserMenuItems();
        int n = 0;
        while (n < jComponentArray.length) {
            this._userMenu.add(jComponentArray[n]);
            ++n;
        }
    }

    public MenuItemCategory createToolsMenu() {
        ConsoleInfo consoleInfo = Console.getConsoleInfo();
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        String string = "cn=UserGroupTools," + LDAPUtil.getAdminGlobalParameterEntry();
        MenuItemCategory menuItemCategory = new MenuItemCategory(MENU_TOOLS, Framework.i18n("menu", "Tools"));
        try {
            Enumeration enumeration;
            LDAPAttribute lDAPAttribute;
            LDAPEntry lDAPEntry = null;
            lDAPEntry = lDAPConnection.read(string, new String[]{"nsClassName"});
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("nsClassName")) != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)consoleInfo, (String)string2);
                if (clazz == null) {
                    Debug.println("Could not load tool: " + string2);
                } else {
                    try {
                        IUGToolPlugin iUGToolPlugin = null;
                        iUGToolPlugin = (IUGToolPlugin)clazz.newInstance();
                        iUGToolPlugin.initialize(this, lDAPConnection);
                        menuItemCategory.add(new toolsMenuItem(iUGToolPlugin));
                    }
                    catch (Exception exception) {
                        Debug.println("Could not create tool class " + string2);
                        Debug.println("    Exception: " + exception);
                    }
                }
            }
        }
        catch (LDAPException lDAPException) {
            switch (lDAPException.getLDAPResultCode()) {
                case 32: {
                    break;
                }
                default: {
                    Debug.println("Error reading entry: " + string);
                }
            }
        }
        if (menuItemCategory.getItemCount() <= 0) {
            return null;
        }
        return menuItemCategory;
    }
}

