/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;

public class ServiceLocator {
    LDAPConnection _ldc;
    ConsoleInfo _consoleInfo;
    LDAPSortControl _control;
    LDAPSearchConstraints _cons;
    static String[] _hostAttrNames = new String[]{"serverhostname"};

    public ServiceLocator(ConsoleInfo consoleInfo) {
        this._consoleInfo = consoleInfo;
        this._control = new LDAPSortControl(new LDAPSortKey("cn"), false);
        this._ldc = consoleInfo.getLDAPConnection();
        this._cons = (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone();
        this._cons.setServerControls((LDAPControl)this._control);
        this._cons.setBatchSize(1);
        this._cons.setMaxResults(0);
    }

    public LDAPConnection getConnection() {
        return this._ldc;
    }

    public int getHostCount(String string) {
        int n = -1;
        LDAPControl[] lDAPControlArray = new LDAPControl[2];
        LDAPSearchResults lDAPSearchResults = null;
        lDAPControlArray[0] = new LDAPSortControl(new LDAPSortKey("serverhostname"), true);
        lDAPControlArray[1] = new LDAPVirtualListControl(0, 0, 0, 0);
        try {
            if (this._ldc != null) {
                LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone();
                lDAPSearchConstraints.setBatchSize(0);
                lDAPSearchConstraints.setServerControls(lDAPControlArray);
                if (LDAPUtil.isVersion4(this._ldc)) {
                    lDAPSearchResults = this._ldc.search(string, 2, "(Objectclass=NsHost)", null, false, lDAPSearchConstraints);
                    while (lDAPSearchResults.hasMoreElements()) {
                        lDAPSearchResults.next();
                    }
                    lDAPControlArray = this._ldc.getResponseControls();
                    LDAPVirtualListResponse lDAPVirtualListResponse = LDAPVirtualListResponse.parseResponse((LDAPControl[])lDAPControlArray);
                    if (lDAPVirtualListResponse == null) {
                        Debug.println("LDAPVirtualListResponse.parseResponse(controls)== null !");
                    }
                    n = lDAPVirtualListResponse != null ? lDAPVirtualListResponse.getContentCount() : -1;
                } else {
                    n = -1;
                }
            }
        }
        catch (Exception exception) {
            Debug.println("getHostCount() failed: " + exception);
            return -1;
        }
        return n;
    }

    public Enumeration getDomains() {
        String[] stringArray = new String[]{"ou"};
        LDAPSearchResults lDAPSearchResults = null;
        try {
            if (this._ldc != null) {
                lDAPSearchResults = this._ldc.search("o=NetscapeRoot", 1, "(Objectclass=nsAdminDomain)", stringArray, false, this._cons);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ServiceLocator (getDomain): Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN());
        }
        return lDAPSearchResults;
    }

    public Enumeration getHosts(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            if (this._ldc != null) {
                lDAPSearchResults = this._ldc.search(string, 2, "(Objectclass=NsHost)", _hostAttrNames, false, this._cons);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ServiceLocator:getHosts: Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN());
        }
        return lDAPSearchResults;
    }

    public Enumeration getAdminGroup(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            if (this._ldc != null) {
                lDAPSearchResults = this._ldc.search(string, 1, "(Objectclass=nsAdminGroup)", null, false, this._cons);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ServiceLocator:getAdminGroup: Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN() + " " + this._consoleInfo.getAuthenticationPassword());
        }
        return lDAPSearchResults;
    }

    public String getAdminServer(String string) {
        String string2 = null;
        try {
            if (this._ldc != null) {
                String[] stringArray = new String[]{"nsAdminSIEDN"};
                LDAPEntry lDAPEntry = this._ldc.read(string, stringArray);
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute("nsAdminSIEDN");
                string2 = LDAPUtil.flatting(lDAPAttribute);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ServiceLocator:getAdminServer: Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN() + " " + this._consoleInfo.getAuthenticationPassword());
        }
        return string2;
    }

    public Enumeration getProductType(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            if (this._ldc != null) {
                lDAPSearchResults = this._ldc.search(string, 1, "(Objectclass=nsApplication)", null, false, this._cons);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ServiceLocator:getProductType: Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN() + " " + this._consoleInfo.getAuthenticationPassword());
        }
        return lDAPSearchResults;
    }

    public LDAPSearchResults getSIE(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            if (this._ldc != null) {
                lDAPSearchResults = this._ldc.search(string, 1, "(Objectclass=netscapeServer)", null, false, this._cons);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ServiceLocator:getSIE: Cannot connect to: " + this._consoleInfo.getHost() + " " + this._consoleInfo.getAuthenticationDN() + " " + this._consoleInfo.getAuthenticationPassword() + " " + string);
        }
        return lDAPSearchResults;
    }

    public ConsoleInfo getConsoleInfo() {
        return this._consoleInfo;
    }
}

