/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.DirModel;
import com.netscape.management.client.components.IDirModel;
import com.netscape.management.client.components.IDirNode;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPSortControl;

public class DirNode
extends DefaultMutableTreeNode
implements IDirNode,
Serializable {
    private static final int NOLIMIT_BACKLOG = 999999;
    protected static final String IMAGE_PATH = "com/netscape/management/client/images/";
    static ResourceSet _resource = new ResourceSet("com.netscape.management.client.components.components");
    private static final String _section = "dirBrowser";
    private static String _defaultImageName = DirNode.initDefaultIconName();
    private static String _defaultFolderImageName = DirNode.initDefaultFolderIconName();
    private String _dn;
    private String _sDisplayName;
    private String _sCn = null;
    protected boolean _fLoaded = false;
    protected int _iChildren = -1;
    protected boolean _fContainer = false;
    private long _objectCode = 0L;
    protected Hashtable _objectClasses = null;
    private IDirModel _model = null;
    protected LDAPEntry _entry = null;
    private Icon _icon = null;
    private boolean _isBogus = false;
    private static LDAPControl _manageDSAITControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
    protected static final String SUBORDINATE_ATTR = "numsubordinates";
    protected static final String _allFilter = "objectclass=*";
    protected static final String[] _baseAttrs = new String[]{"cn", "numsubordinates", "displayName", "objectclass"};
    private static final ImageIcon BOGUS_ICON = new RemoteImage("com/netscape/management/client/images/error16.gif");
    private static final String BOGUS_LABEL = _resource.getString("dirBrowser", "error-label");

    public DirNode() {
    }

    protected DirNode(boolean bl) {
        this._isBogus = bl;
    }

    public DirNode(IDirModel iDirModel, String string, String string2) {
        this.initialize(iDirModel, string, string2);
        Debug.println(9, "DirNode.DirNode(3): dn=" + string);
    }

    public DirNode(IDirModel iDirModel, String string) {
        Debug.println(9, "DirNode.DirNode(2): dn=" + string);
        String string2 = "";
        String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)true);
        if (stringArray != null && stringArray[0] != null) {
            string2 = stringArray[0];
        } else {
            string2 = string;
            Debug.println("DirNode: cannot explode " + this._sDisplayName);
        }
        this.initialize(iDirModel, string, string2);
    }

    public DirNode(String string) {
        this(null, string);
        Debug.println(9, "DirNode.DirNode(1): dn=" + string);
    }

    public DirNode(IDirModel iDirModel, LDAPEntry lDAPEntry) {
        this(iDirModel, lDAPEntry.getDN());
        Debug.println(9, "DirNode.DirNode(2a): dn=" + lDAPEntry.getDN());
        this._entry = lDAPEntry;
        this.initializeFromEntry(this._entry);
    }

    protected void initialize(IDirModel iDirModel, String string, String string2) {
        this._dn = string;
        this._model = iDirModel;
        this.setAllowsChildren(true);
        this.setName(string2);
        this.setIcon(new RemoteImage(IMAGE_PATH + _defaultImageName));
        Debug.println(9, "DirNode.initialize: (<" + this._dn + ">, " + string2 + ")");
    }

    public IDirModel getModel() {
        return this._model;
    }

    public void setModel(IDirModel iDirModel) {
        this._model = iDirModel;
    }

    public String getName() {
        return this._sDisplayName;
    }

    public void setName(String string) {
        this._sDisplayName = string;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    protected boolean getAllowLeafNodes() {
        return this.getModel().getAllowsLeafNodes();
    }

    public LDAPEntry getEntry() {
        Debug.println(9, "DirNode.getEntry: " + this.getDN());
        if (this._entry == null) {
            try {
                this._entry = this.readEntry(this.getDN(), _baseAttrs);
                this.initializeFromEntry(this._entry);
            }
            catch (Exception exception) {
                Debug.println("DirNode.getEntry <" + this.getDN() + "> " + exception);
            }
        }
        return this._entry;
    }

    public void setEntry(LDAPEntry lDAPEntry) {
        this._entry = lDAPEntry;
    }

    private static String initDefaultIconName() {
        String string = _resource.getString(_section, "default-icon");
        if (string == null) {
            string = "genobject.gif";
        }
        return string;
    }

    private static String initDefaultFolderIconName() {
        String string = _resource.getString(_section, "default-folder-icon");
        if (string == null) {
            string = "folder.gif";
        }
        return string;
    }

    public String getDN() {
        return this._dn;
    }

    public void setDN(String string) {
        this._dn = string;
    }

    protected LDAPConnection getLDAPConnection() {
        if (this._model != null) {
            return this._model.getLDAPConnection();
        }
        return null;
    }

    public void load() {
        String string = this.getDN();
        Debug.println(9, "DirNode.load <" + string + ">");
        this.removeAllChildren();
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println("DirNode.load: no LDAP connection");
            return;
        }
        LDAPEntry lDAPEntry = this.readEntry(string, _baseAttrs);
        if (lDAPEntry != null) {
            this.initializeFromEntry(lDAPEntry);
        }
        this._fLoaded = true;
    }

    /*
     * Unable to fully structure code
     */
    protected LDAPEntry readEntry(String var1_1, String[] var2_2) {
        block9: {
            Debug.println(9, "DirNode.readEntry: " + var1_1);
            try {
                var3_3 = this.getLDAPConnection();
                if (var3_3 == null) {
                    Debug.println("DirNode.readEntry: no LDAP connection");
                    return null;
                }
                var4_5 = var3_3.getSearchConstraints();
                var4_5.setMaxBacklog(999999);
                if (!this.getModel().getReferralsEnabled()) {
                    Debug.println(9, "DirNode.readEntry: no referrals");
                    var4_5.setServerControls(DirNode._manageDSAITControl);
                } else {
                    Debug.println(9, "DirNode.readEntry: referrals on");
                }
                var5_8 = var3_3.read(var1_1, var2_2, var4_5);
                if (var5_8 == null) {
                    Debug.println("DirNode.readEntry: unable to read <" + var1_1 + ">");
                } else {
                    Debug.println(9, "DirNode.readEntry of " + var1_1 + " returned " + var5_8);
                }
                return var5_8;
            }
            catch (LDAPReferralException var3_4) {
                Debug.println("DirNode.readEntry referral problem " + var1_1 + ": " + (Object)var3_4);
                var4_6 = var3_4.getURLs();
                var5_9 = 0;
                ** while (var5_9 < var4_6.length)
            }
lbl-1000:
            // 1 sources

            {
                Debug.println("DirNode.readEntry: url=" + var4_6[var5_9]);
                ++var5_9;
                continue;
lbl28:
                // 1 sources

                break block9;
            }
            catch (LDAPException var4_7) {
                Debug.println("DirNode.readEntry of " + var1_1 + ": " + (Object)var4_7);
            }
        }
        return null;
    }

    public boolean isContainer() {
        return this._fContainer;
    }

    public void reload() {
        Debug.println(9, "DirNode.reload: <" + this.getDN() + ">");
        this.getChildList();
    }

    protected Vector getChildList() {
        String string = this.getDN();
        Debug.println(9, "DirNode.getChildList: <" + string + ">, " + this.getChildFilter());
        Object var2_2 = null;
        this.removeAllChildren();
        try {
            LDAPControl[] lDAPControlArray;
            LDAPConnection lDAPConnection = this.getLDAPConnection();
            if (lDAPConnection == null) {
                Debug.println("DirNode.getChildList: no LDAP connection");
                return new Vector();
            }
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(0);
            lDAPSearchConstraints.setMaxBacklog(999999);
            if (!this.getModel().getReferralsEnabled()) {
                lDAPControlArray = new LDAPControl[2];
                lDAPControlArray[0] = _manageDSAITControl;
            } else {
                lDAPControlArray = new LDAPControl[1];
            }
            String[] stringArray = new String[]{"sn", "givenname", "cn", "ou", "o"};
            LDAPSortKey[] lDAPSortKeyArray = new LDAPSortKey[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                lDAPSortKeyArray[n] = new LDAPSortKey(stringArray[n]);
                ++n;
            }
            lDAPControlArray[lDAPControlArray.length - 1] = new LDAPSortControl(lDAPSortKeyArray, false);
            lDAPSearchConstraints.setServerControls(lDAPControlArray);
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, this.getChildFilter(), _baseAttrs, false, lDAPSearchConstraints);
            Debug.println(9, "DirNode.getChildList: <" + string + "> searching");
            int n2 = 0;
            while (lDAPSearchResults.hasMoreElements()) {
                try {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    Debug.println(7, "DirNode.getChildList: adding <" + lDAPEntry.getDN() + ">");
                    DirNode dirNode = new DirNode(this.getModel(), lDAPEntry);
                    this.insert(dirNode, super.getChildCount());
                    ++n2;
                }
                catch (LDAPException lDAPException) {
                    Debug.println("DirNode.getChildList: <" + string + ">: " + (Object)((Object)lDAPException));
                }
                if (n2 % 100 != 0) continue;
                Debug.println(5, "DirNode.getChildList: added " + n2);
            }
            this._iChildren = super.getChildCount();
            Debug.println(9, "DirNode.getChildList: <" + string + "> found " + n2);
        }
        catch (LDAPException lDAPException) {
            Debug.println("DirNode.getChildList: <" + string + "> " + (Object)((Object)lDAPException));
        }
        return this.children;
    }

    protected int countChildren(boolean bl) {
        String string = this.getDN();
        int n = 0;
        try {
            LDAPConnection lDAPConnection = this.getLDAPConnection();
            if (lDAPConnection == null) {
                Debug.println("DirNode.countChildren: no LDAP connection");
                return n;
            }
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(0);
            lDAPSearchConstraints.setMaxBacklog(999999);
            if (!this.getModel().getReferralsEnabled()) {
                lDAPSearchConstraints.setServerControls(_manageDSAITControl);
            }
            String[] stringArray = new String[]{"dn"};
            String string2 = bl ? _allFilter : this.getChildFilter();
            Debug.println(9, "DirNode.countChildren: <" + string + "> , " + string2);
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, string2, stringArray, false, lDAPSearchConstraints);
            while (lDAPSearchResults.hasMoreElements()) {
                try {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    Debug.println(9, "DirNode.countChildren: <" + lDAPEntry.getDN() + ">");
                    ++n;
                }
                catch (LDAPException lDAPException) {
                    Debug.println("DirNode.countChildren: <" + string + ">  " + (Object)((Object)lDAPException));
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("DirNode.countChildren: <" + string + ">: " + (Object)((Object)lDAPException));
        }
        return n;
    }

    public boolean isLoaded() {
        return this._fLoaded;
    }

    static int getCountFromEntry(LDAPEntry lDAPEntry) {
        int n = -1;
        return n;
    }

    protected int getCountFromEntry() {
        return DirNode.getCountFromEntry(this.getEntry());
    }

    public void initializeFromEntry(LDAPEntry lDAPEntry) {
        this._fLoaded = true;
        this._objectClasses = this.checkObjectClasses(lDAPEntry);
        this._fContainer = this.checkIfContainer();
        this.setIcon(((DirModel)this._model).checkIcon(this._objectClasses, !this.isContainer()));
        this._sCn = this.checkCn(lDAPEntry);
        if (this._sCn != null) {
            this.setName(this._sCn);
        }
    }

    protected boolean hasChildren() {
        return this._iChildren > 0;
    }

    protected boolean hasCheckedForChildren() {
        return this._iChildren >= 0;
    }

    protected Hashtable checkObjectClasses(LDAPEntry lDAPEntry) {
        if (this._objectClasses != null) {
            return this._objectClasses;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        String[] stringArray = new String[]{"top"};
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(string.toLowerCase(), string);
            }
        }
        return hashtable;
    }

    protected boolean checkIfContainer() {
        int n = this.getCountFromEntry();
        if (n > 0) {
            return true;
        }
        if (n < 0 && (n = this.countChildren(true)) > 0) {
            return true;
        }
        Hashtable hashtable = this.getModel().getContainers();
        Enumeration enumeration = this._objectClasses.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) == null) continue;
            return true;
        }
        return false;
    }

    protected static String getFirstValue(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute;
        if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(string)) != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return null;
    }

    protected String checkCn(LDAPEntry lDAPEntry) {
        String string = DirNode.getFirstValue(lDAPEntry, "displayName");
        if (string == null) {
            string = DirNode.getFirstValue(lDAPEntry, "cn");
        }
        return string;
    }

    public TreeNode getChildAt(int n) {
        TreeNode treeNode = null;
        Debug.println(9, "DirNode.getChildAt: <" + this.getDN() + "> index " + n);
        int n2 = this.getChildCount();
        if (n2 > super.getChildCount()) {
            this.reload();
        }
        try {
            treeNode = super.getChildAt(n);
        }
        catch (Exception exception) {
            Debug.println("DirNode.getChildAt: " + n2 + " children " + "available, number " + n + " requested: " + exception);
            treeNode = DirNode.getBogusEntryObject();
        }
        Debug.println(9, "DirNode.getChildAt: found <" + ((DirNode)treeNode).getDN() + ">");
        return treeNode;
    }

    public int getChildCount() {
        if (this._isBogus) {
            return 0;
        }
        if (!this.hasCheckedForChildren()) {
            int n;
            Debug.println(9, "DirNode.getChildCount: <" + this.getDN() + " > checking");
            if (!this.isLoaded()) {
                this.load();
            }
            this._iChildren = (n = this.getCountFromEntry()) == 0 ? 0 : (n < 0 || !this.getModel().getAllowsLeafNodes() ? this.countChildren(this.getModel().getAllowsLeafNodes()) : n);
        } else {
            Debug.println(9, "DirNode.getChildCount: <" + this.getDN() + " > already checked");
        }
        return this._iChildren;
    }

    public void removeAllChildren() {
        this._iChildren = 0;
        super.removeAllChildren();
    }

    public boolean isLeaf() {
        int n = this.getChildCount();
        Debug.println(9, "DirNode.isLeaf: <" + this.getDN() + ">  : " + n + " children");
        return n == 0;
    }

    public String toString() {
        return "DirNode for <" + this.getDN() + ">";
    }

    public boolean childExists(IDirNode iDirNode) {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DirNode dirNode = (DirNode)enumeration.nextElement();
            if (!dirNode.getDN().equals(iDirNode.getDN())) continue;
            return true;
        }
        return false;
    }

    public static DirNode getBogusEntryObject() {
        DirNode dirNode = new DirNode(true);
        dirNode.setDN(BOGUS_LABEL);
        dirNode.setName(BOGUS_LABEL);
        dirNode.setIcon(BOGUS_ICON);
        return dirNode;
    }

    protected static boolean isRootDSE(String string) {
        return string == null || string.equals("");
    }

    protected String getChildFilter() {
        return this.getModel().getChildFilter();
    }
}

