/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acl;

import com.netscape.management.client.acl.ACL;
import com.netscape.management.client.acl.LdapACLSelector;
import com.netscape.management.client.acl.LdapRule;
import com.netscape.management.client.acl.LdapWriter;
import com.netscape.management.client.acl.Rule;
import com.netscape.management.client.acl.booleanValue;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.KingpinLDAPConnection;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

public class LdapACL
extends ACL {
    public static final int QUOTE_CHAR = 34;
    public static final String LDAPPrefix = "ldap:///";
    public static final String TargetName = "target";
    public static final String AttributeName = "targetattr";
    public static final String FilterName = "targetfilter";
    public static final String ACIAttributeName = "aci";
    public static final String SASLAttributeName = "supportedsaslmechanisms";
    public static final String SASLNameBase = "SASL ";
    protected String host;
    protected int port;
    protected boolean ssl;
    protected String dn;
    protected String pw;
    protected LdapACLSelector valueSelector = null;
    protected boolean entryFound = false;
    protected String oldValue = null;
    protected String entryDN = null;
    protected String target = null;
    protected booleanValue targetEq = new booleanValue(true);
    protected String targetAttr = null;
    protected booleanValue targetAttrEq = new booleanValue(true);
    protected String targetFilter = null;
    protected booleanValue targetFilterEq = new booleanValue(true);

    protected void copy(ACL aCL) {
        super.copy(aCL);
        LdapACL ldapACL = (LdapACL)aCL;
        this.host = ldapACL.host;
        this.port = ldapACL.port;
        this.ssl = ldapACL.ssl;
        this.dn = ldapACL.dn;
        this.pw = ldapACL.pw;
        this.valueSelector = ldapACL.valueSelector;
        this.entryFound = ldapACL.entryFound;
        this.oldValue = ldapACL.oldValue;
        this.entryDN = ldapACL.entryDN;
        this.target = ldapACL.target;
        this.targetEq = ldapACL.targetEq;
        this.targetAttr = ldapACL.targetAttr;
        this.targetAttrEq = ldapACL.targetAttrEq;
        this.targetFilter = ldapACL.targetFilter;
        this.targetFilterEq = ldapACL.targetFilterEq;
    }

    public LdapACL(String string, int n, String string2, String string3) {
        this(string, n, false, string2, string3, null);
    }

    public LdapACL(String string, int n, boolean bl, String string2, String string3) {
        this(string, n, bl, string2, string3, null);
    }

    public LdapACL(String string, int n, String string2, String string3, LdapACLSelector ldapACLSelector) {
        this(string, n, false, string2, string3, ldapACLSelector);
    }

    public LdapACL(String string, int n, boolean bl, String string2, String string3, LdapACLSelector ldapACLSelector) {
        this.host = string;
        this.port = n;
        this.ssl = bl;
        this.dn = string2;
        this.pw = string3;
        this.valueSelector = ldapACLSelector;
    }

    public LdapACL(LdapACL ldapACL) {
        this(ldapACL.host, ldapACL.port, ldapACL.ssl, ldapACL.dn, ldapACL.pw, ldapACL.valueSelector);
        this.entryFound = ldapACL.entryFound;
        this.oldValue = ldapACL.oldValue;
        this.entryDN = ldapACL.entryDN;
    }

    protected LDAPConnection newConnection() throws LDAPException {
        KingpinLDAPConnection kingpinLDAPConnection = null;
        kingpinLDAPConnection = this.ssl ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), this.dn, this.pw) : new KingpinLDAPConnection(this.dn, this.pw);
        kingpinLDAPConnection.connect(3, this.host, this.port, this.dn, this.pw);
        return kingpinLDAPConnection;
    }

    public void retrieveACL(Object object) {
        try {
            Reader reader = this.openACLReader(object);
            if (reader == null) {
                this.setDefaults();
                return;
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
            this.parse(streamTokenizer);
            reader.close();
        }
        catch (Exception exception) {
            System.err.println("LdapACL:retrieveACL():" + exception);
            if (this.valueSelector != null) {
                this.valueSelector.error(this, exception);
            }
            this.setDefaults();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Reader openACLReader(Object var1_1) throws IOException, LDAPException {
        this.entryDN = (String)var1_1;
        var2_2 = this.newConnection();
        Debug.println("LdapACL:openACLReader():connected to " + this.host + ":" + this.port);
        var3_3 = var2_2.read(this.entryDN);
        if (var3_3 != null) break block14;
        Debug.println("LdapACL:openACLReader():entry not found");
        if (this.valueSelector != null) {
            this.valueSelector.select(this, null);
        }
        var4_4 = null;
        var10_6 = null;
        if (var2_2 == null || !var2_2.isConnected()) ** GOTO lbl-1000
        try {
            var2_2.disconnect();
        }
        catch (Exception var11_13) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var4_4;
            }
            var4_5 = var3_3.getAttributeSet();
            if (var4_5.size() != 0) break block15;
            Debug.println("LdapACL:openACLReader():aci attribute not found");
            if (this.valueSelector != null) {
                this.valueSelector.select(this, null);
            }
            var5_20 = null;
        }
        var10_7 = null;
        if (var2_2 == null || !var2_2.isConnected()) ** GOTO lbl-1000
        try {
            var2_2.disconnect();
        }
        catch (Exception var11_14) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block15: {
                return var5_20;
            }
            var5_21 = var4_5.getAttribute("aci");
            if (var5_21 != null) break block16;
            Debug.println("LdapACL:openACLReader():aci attribute not found");
            if (this.valueSelector != null) {
                this.valueSelector.select(this, null);
            }
            var6_22 = null;
        }
        var10_8 = null;
        if (var2_2 == null || !var2_2.isConnected()) ** GOTO lbl-1000
        try {
            var2_2.disconnect();
        }
        catch (Exception var11_15) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block16: {
                return var6_22;
            }
            if (var5_21.size() != 0) break block17;
            Debug.println("LdapACL:openACLReader():aci attribute not found");
            if (this.valueSelector != null) {
                this.valueSelector.select(this, null);
            }
            var6_23 = null;
        }
        var10_9 = null;
        if (var2_2 == null || !var2_2.isConnected()) ** GOTO lbl-1000
        try {
            var2_2.disconnect();
        }
        catch (Exception var11_16) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block17: {
                return var6_23;
            }
            var6_24 = var5_21.getStringValues();
            if (this.valueSelector == null) break block18;
            Debug.println("LdapACL:openACLReader():calling LdapACLSelector for multi-valued aci");
            var7_25 = this.valueSelector.select(this, var6_24);
            if (var7_25 != null) break block19;
            Debug.println("LdapACL:openACLReader():create new acl value (no aci selected)");
            var8_26 = null;
        }
        var10_10 = null;
        if (var2_2 == null || !var2_2.isConnected()) ** GOTO lbl-1000
        try {
            var2_2.disconnect();
        }
        catch (Exception var11_17) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block20: {
                block18: {
                    block19: {
                        return var8_26;
                    }
                    this.oldValue = var7_25;
                    break block20;
                }
                Debug.println("LdapACL:openACLReader():no LdapACLSelector, using first value of multi-value aci");
                this.oldValue = (String)var6_24.nextElement();
            }
            Debug.println("LdapACL.aci: " + this.oldValue);
            this.entryFound = true;
            var7_25 = new StringReader(this.oldValue);
        }
        var10_11 = null;
        if (var2_2 == null || !var2_2.isConnected()) ** GOTO lbl106
        try {
            var2_2.disconnect();
        }
        catch (Exception var11_18) {
            // empty catch block
        }
lbl106:
        // 3 sources

        return var7_25;
        catch (Throwable var9_27) {
            block21: {
                var10_12 = null;
                if (var2_2 == null || !var2_2.isConnected()) break block21;
                try {
                    var2_2.disconnect();
                }
                catch (Exception var11_19) {}
            }
            throw var9_27;
        }
    }

    protected Writer openACLWriter(Object object) throws IOException {
        return new LdapWriter(this, object);
    }

    protected void setDefaults() {
        super.setDefaults();
        if (this.entryDN != null) {
            this.setTarget(LDAPPrefix + this.entryDN);
        }
        this.setTargetAttributes("*");
    }

    public void setSyntaxOverride(String string) {
        this.syntax = string;
    }

    public void setSyntax(String string) {
        try {
            LdapACL ldapACL = new LdapACL(this);
            ldapACL.parse(new StreamTokenizer(new StringReader(string)));
            this.copy(ldapACL);
            return;
        }
        catch (Exception exception) {
            Debug.println("LdapACL:setSyntax():invalid ACL syntax, using override:" + exception);
            this.syntax = string;
            return;
        }
    }

    protected void parse(StreamTokenizer streamTokenizer) throws Exception {
        int n;
        streamTokenizer.quoteChar(34);
        streamTokenizer.ordinaryChar(47);
        block6: while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case 40: {
                    Debug.println("Token type '('");
                    break;
                }
                case -3: {
                    Debug.println("Token type TT_WORD, sval = " + streamTokenizer.sval);
                    if (streamTokenizer.sval.equals(TargetName)) {
                        this.target = this.parseValue(streamTokenizer, this.targetEq);
                        Debug.println("target = " + this.target);
                        break;
                    }
                    if (streamTokenizer.sval.equals(AttributeName)) {
                        this.targetAttr = this.parseValue(streamTokenizer, this.targetAttrEq);
                        Debug.println("targetAttr = " + this.targetAttr);
                        break;
                    }
                    if (streamTokenizer.sval.equals(FilterName)) {
                        this.targetFilter = this.parseValue(streamTokenizer, this.targetFilterEq);
                        Debug.println("targetFilter = " + this.targetFilter);
                        break;
                    }
                    if (streamTokenizer.sval.equals("version")) {
                        this.parseHeader(streamTokenizer);
                        try {
                            while (true) {
                                this.appendRule(streamTokenizer);
                            }
                        }
                        catch (EOFException eOFException) {
                            if (eOFException.getMessage().equals("Clean EOF")) continue block6;
                            throw eOFException;
                        }
                    }
                }
                default: {
                    throw new IOException("Unrecognized token in ACL resource header");
                }
            }
        }
    }

    protected String parseValue(StreamTokenizer streamTokenizer, booleanValue booleanValue2) throws IOException {
        int n;
        String string = "";
        boolean bl = true;
        int n2 = 0;
        while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case 40: {
                    ++n2;
                    string = string + (char)n;
                    break;
                }
                case 41: {
                    if (--n2 < 0) {
                        return string;
                    }
                    string = string + (char)n;
                    break;
                }
                case 33: {
                    int n3 = streamTokenizer.nextToken();
                    if (n3 == 61) {
                        booleanValue2.setValue(false);
                        break;
                    }
                    streamTokenizer.pushBack();
                    break;
                }
                case 61: {
                    if (bl) {
                        bl = false;
                        break;
                    }
                }
                default: {
                    string = string + (char)n;
                    break;
                }
                case -3: 
                case 34: {
                    string = string + streamTokenizer.sval;
                    break;
                }
                case -2: {
                    string = string + streamTokenizer.nval;
                }
            }
        }
        throw new EOFException("Unexpected EOF while parsing ACL");
    }

    protected void write(Writer writer) throws IOException {
        this.writeHeader(writer);
        int n = 0;
        while (n < this.rules.size()) {
            ((Rule)this.rules.elementAt(n)).writeRule(writer);
            ++n;
        }
        writer.write(")");
    }

    protected void writeHeader(Writer writer) throws IOException {
        if (this.target != null) {
            writer.write("(target" + (this.targetEq.getValue() ? "" : "!") + "=\"" + this.target + "\")");
        }
        if (this.targetAttr != null) {
            writer.write("(targetattr" + (this.targetAttrEq.getValue() ? "" : "!") + "=\"" + this.targetAttr + "\")");
        }
        if (this.targetFilter != null) {
            writer.write("(targetfilter" + (this.targetFilterEq.getValue() ? "" : "!") + "=\"" + this.targetFilter + "\")");
        }
        writer.write("(version 3.0; acl \"" + this.resource + "\"; ");
    }

    public Rule newRule(StreamTokenizer streamTokenizer) throws Exception {
        return new LdapRule(streamTokenizer);
    }

    public Rule newRule() {
        return new LdapRule();
    }

    protected boolean wasEntryFound() {
        return this.entryFound;
    }

    protected String previousACLValue() {
        return this.oldValue;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = !string.startsWith(LDAPPrefix) ? LDAPPrefix + string : string;
    }

    public String getTargetFilter() {
        return this.targetFilter;
    }

    public void setTargetFilter(String string) {
        this.targetFilter = string;
    }

    public String getTargetAttributes() {
        return this.targetAttr;
    }

    public void setTargetAttributes(String string) {
        this.targetAttr = string;
    }

    public boolean getTargetEq() {
        return this.targetEq.getValue();
    }

    public void setTargetEq(boolean bl) {
        this.targetEq.setValue(bl);
    }

    public boolean getTargetFilterEq() {
        return this.targetFilterEq.getValue();
    }

    public void setTargetFilterEq(boolean bl) {
        this.targetFilterEq.setValue(bl);
    }

    public boolean getTargetAttributesEq() {
        return this.targetAttrEq.getValue();
    }

    public void setTargetAttributesEq(boolean bl) {
        this.targetAttrEq.setValue(bl);
    }

    public static String getACLName(String string) {
        int n = string.indexOf("version");
        if (n == -1) {
            return null;
        }
        if ((n = string.indexOf("acl", n)) == -1) {
            return null;
        }
        if ((n = string.indexOf(34, n)) == -1) {
            return null;
        }
        int n2 = string.indexOf(34, n + 1);
        if (n2 == -1) {
            return null;
        }
        return string.substring(n + 1, n2);
    }

    public void deleteACI(String string) throws LDAPException {
        LDAPConnection lDAPConnection = this.newConnection();
        try {
            LDAPAttribute lDAPAttribute = new LDAPAttribute(ACIAttributeName, string);
            lDAPConnection.modify(this.entryDN, new LDAPModification(1, lDAPAttribute));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (lDAPConnection != null && lDAPConnection.isConnected()) {
                try {
                    lDAPConnection.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            try {
                lDAPConnection.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public static String checkLDAPError(LDAPException lDAPException) {
        String string = lDAPException.getLDAPErrorMessage();
        if (string == null && (string = lDAPException.toString()).indexOf(":") != -1) {
            string = "LDAP Error:" + string.substring(string.indexOf(":") + 1);
        }
        if (string == null) {
            string = "Unknown LDAP Error";
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAuthMethodsSASL() {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            var1_1 = null;
                            var2_2 = null;
                            try {
                                try {
                                    var2_2 = this.newConnection();
                                    Debug.println("LdapACL:getAuthMethodsSASL():connected to " + this.host + ":" + this.port);
                                    var3_3 = var2_2.read("");
                                    if (var3_3 == null) {
                                        Debug.println("LdapACL:getAuthMethodsSASL():root entry not found");
                                        var4_5 = null;
                                        var9_8 = null;
                                        if (var2_2 == null) return var4_5;
                                        break block19;
                                    }
                                    var4_6 = var3_3.getAttributeSet();
                                    if (var4_6.size() == 0) {
                                        Debug.println("LdapACL:getAuthMethodsSASL():supportedsaslmechanisms attribute not found");
                                        var5_22 = null;
                                        break block20;
                                    }
                                    var5_23 = var4_6.getAttribute("supportedsaslmechanisms");
                                    if (var5_23 == null) {
                                        Debug.println("LdapACL:getAuthMethodsSASL():supportedsaslmechanisms attribute not found");
                                        var6_24 = null;
                                        break block21;
                                    }
                                    if (var5_23.size() == 0) {
                                        Debug.println("LdapACL:getAuthMethodsSASL():supportedsaslmechanisms has zero size");
                                        var6_25 = null;
                                        break block22;
                                    }
                                    var6_26 = var5_23.getStringValues();
                                    var1_1 = new String[var5_23.size()];
                                    var7_27 = 0;
                                    while (true) {
                                        if (!var6_26.hasMoreElements()) {
                                            Debug.println("LdapACL:getAuthMethodsSASL():found " + var5_23.size() + " SASL types");
                                            break block23;
                                        }
                                        var1_1[var7_27] = "SASL " + (String)var6_26.nextElement();
                                        ++var7_27;
                                    }
                                }
                                catch (LDAPException var3_4) {
                                    Debug.println("LdapACL:getAuthMethodsSASL():LDAPException:" + (Object)var3_4);
                                    var4_7 = null;
                                    var9_13 = null;
                                    if (var2_2 == null) return var4_7;
                                    if (var2_2.isConnected() == false) return var4_7;
                                    try {
                                        var2_2.disconnect();
                                        return var4_7;
                                    }
                                    catch (Exception var10_20) {
                                        // empty catch block
                                    }
                                    return var4_7;
                                }
                            }
                            catch (Throwable var8_28) {
                                var9_14 = null;
                                if (var2_2 == null) throw var8_28;
                                if (var2_2.isConnected() == false) throw var8_28;
                                ** try [egrp 2[TRYBLOCK] [2 : 306->313)] { 
lbl61:
                                // 1 sources

                                var2_2.disconnect();
                                throw var8_28;
lbl63:
                                // 1 sources

                                catch (Exception var10_21) {
                                    // empty catch block
                                }
                                throw var8_28;
                            }
                        }
                        if (var2_2.isConnected() == false) return var4_5;
                        ** try [egrp 2[TRYBLOCK] [2 : 306->313)] { 
lbl69:
                        // 1 sources

                        var2_2.disconnect();
                        return var4_5;
lbl71:
                        // 1 sources

                        catch (Exception var10_15) {
                            // empty catch block
                        }
                        return var4_5;
                    }
                    var9_9 = null;
                    if (var2_2 == null) return var5_22;
                    if (var2_2.isConnected() == false) return var5_22;
                    ** try [egrp 2[TRYBLOCK] [2 : 306->313)] { 
lbl79:
                    // 1 sources

                    var2_2.disconnect();
                    return var5_22;
lbl81:
                    // 1 sources

                    catch (Exception var10_16) {
                        // empty catch block
                    }
                    return var5_22;
                }
                var9_10 = null;
                if (var2_2 == null) return var6_24;
                if (var2_2.isConnected() == false) return var6_24;
                ** try [egrp 2[TRYBLOCK] [2 : 306->313)] { 
lbl89:
                // 1 sources

                var2_2.disconnect();
                return var6_24;
lbl91:
                // 1 sources

                catch (Exception var10_17) {
                    // empty catch block
                }
                return var6_24;
            }
            var9_11 = null;
            if (var2_2 == null) return var6_25;
            if (var2_2.isConnected() == false) return var6_25;
            ** try [egrp 2[TRYBLOCK] [2 : 306->313)] { 
lbl99:
            // 1 sources

            var2_2.disconnect();
            return var6_25;
lbl101:
            // 1 sources

            catch (Exception var10_18) {
                // empty catch block
            }
            return var6_25;
        }
        var9_12 = null;
        if (var2_2 == null) return var1_1;
        if (var2_2.isConnected() == false) return var1_1;
        try {}
        catch (Exception var10_19) {}
        var2_2.disconnect();
        return var1_1;
        return var1_1;
    }
}

