/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.Framework;
import com.netscape.management.client.IStatusItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class StatusItemProgress
extends JProgressBar
implements IStatusItem {
    private static final int MODE_PERCENT = 0;
    private static final int MODE_BUSY = 2;
    private static final int PONG_WIDTH = 15;
    private static final int INCREMENT = 3;
    private static final int DELAY = 30;
    int _percent = 0;
    int _mode = 0;
    public static Integer STATE_BUSY = new Integer(-1);
    protected String _id = null;
    private Timer busyTimer = null;
    private static final String I18N_IDLE = Framework.i18n("progress", "idle");
    private static final String I18N_BUSY = Framework.i18n("progress", "busy");

    public StatusItemProgress(String string) {
        this.setID(string);
        this.setMinimum(0);
        this.setMaximum(100);
        this.setMaximumSize(new Dimension(200, 11));
        this.busyTimer = new Timer(30, new BusyTimerActionListener());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public StatusItemProgress(String string, int n) {
        this(string);
        this.setValue(n);
    }

    public Component getComponent() {
        return this;
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public void setState(Object object) {
        if (object.equals(STATE_BUSY)) {
            this._mode = 2;
            this.busyTimer.start();
        } else {
            this._mode = 0;
            this.busyTimer.stop();
        }
        this.setValue((Integer)object);
    }

    public void start() {
        this.setState(STATE_BUSY);
    }

    public void stop() {
        this.setState(new Integer(0));
    }

    public Object getState() {
        return new Integer(this.getValue());
    }

    public String getToolTipText() {
        if (this.getValue() == this.getMinimum()) {
            return I18N_IDLE;
        }
        return I18N_BUSY;
    }

    class BusyTimerActionListener
    implements ActionListener {
        BusyTimerActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = StatusItemProgress.this.getValue();
            if ((n += 3) > 100) {
                n = 0;
            }
            StatusItemProgress.this.setValue(n);
        }
    }
}

