/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.config;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSBasePanel;
import com.netscape.admin.certsrv.CMSBaseResourceModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.config.JobsImplDataModel;
import com.netscape.admin.certsrv.config.JobsRegisterDialog;
import com.netscape.admin.certsrv.config.ViewDialog;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.CMSBaseUGTab;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class JobsImplTab
extends CMSBaseUGTab {
    private static final String IMPL_NAME = "NAME";
    private static final String IMPL_CLASS = "CLASS";
    private static final String IMPL_DESC = "DESC";
    private static final String PANEL_NAME = "JOBSIMPL";
    private static final String DIALOG_PREFIX = "JOBSREGISTERDIALOG";
    private AdminConnection mConnection;
    private String mDestination;
    protected JScrollPane mScrollPane;
    protected JTable mTable;
    protected JobsImplDataModel mDataModel;
    protected JobsRegisterDialog mEditor;
    protected ViewDialog mViewer;
    protected JButton mRefresh;
    protected JButton mAdd;
    protected JButton mDelete;
    protected JButton mView;
    protected JButton mHelp;
    private static final String HELPINDEX = "configuration-jobsplugin-help";

    public JobsImplTab(CMSBaseResourceModel model) {
        super(PANEL_NAME, model);
        this.mConnection = model.getServerInfo().getAdmin();
        this.mDataModel = new JobsImplDataModel();
        this.mDestination = "jobsScheduler";
        this.mHelpToken = HELPINDEX;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mRefresh)) {
            this.refresh();
        }
        if (e.getSource().equals(this.mAdd)) {
            if (this.mEditor == null) {
                this.mEditor = new JobsRegisterDialog(this.mModel.getFrame(), this.mConnection);
            }
            this.mEditor.showDialog(this.mDestination, "impl");
            this.refresh();
        }
        if (e.getSource().equals(this.mDelete)) {
            Debug.println((String)"Delete");
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            int i = this.showConfirmDialog("DELETE");
            if (i == 0) {
                this.delete();
                Debug.println((String)"Deleted");
            }
        }
        if (e.getSource().equals(this.mView)) {
            Debug.println((String)"View");
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            NameValuePairs obj = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
            if (this.mViewer == null) {
                this.mViewer = new ViewDialog(this.mModel.getFrame());
            }
            this.mViewer.showDialog(obj.getValue(IMPL_NAME), obj.getValue(IMPL_CLASS), obj.getValue(IMPL_DESC));
        }
        if (e.getSource().equals(this.mHelp)) {
            this.helpCallback();
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setButtons();
    }

    public void mouseReleased(MouseEvent e) {
        this.setButtons();
    }

    public void refresh() {
        this.mDataModel.removeAllRows();
        this.update();
        this.setButtons();
        this.mTable.invalidate();
        this.mTable.validate();
        this.mTable.repaint(1L);
    }

    protected JPanel createButtonPanel() {
        this.mAdd = this.makeJButton("ADD");
        this.mDelete = this.makeJButton("DELETE");
        this.mView = this.makeJButton("VIEW");
        JButton[] buttons = new JButton[]{this.mAdd, this.mDelete, this.mView};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    protected JPanel createActionPanel() {
        this.mRefresh = this.makeJButton("REFRESH");
        this.mHelp = this.makeJButton("HELP");
        JButton[] buttons = new JButton[]{this.mRefresh, this.mHelp};
        return CMSBasePanel.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    protected JPanel createListPanel() {
        this.mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.mListPanel.setLayout(gb);
        this.mTable = new JTable((TableModel)this.mDataModel);
        this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mTable.setAutoscrolls(true);
        this.mTable.sizeColumnsToFit(true);
        this.mTable.getSelectionModel().setSelectionMode(0);
        this.mTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
        this.mScrollPane.setBackground(Color.white);
        this.mTable.addMouseListener((MouseListener)((Object)this));
        this.setLabelCellRenderer(this.mTable, 0);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        this.mListPanel.add((Component)this.mScrollPane);
        JPanel buttonPanel = this.createButtonPanel();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gb.setConstraints((Component)buttonPanel, gbc);
        this.mListPanel.add((Component)buttonPanel);
        this.refresh();
        return this.mListPanel;
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(new JLabel()));
    }

    private void setButtons() {
        if (this.mTable.getSelectionModel().isSelectionEmpty()) {
            this.mDelete.setEnabled(false);
            this.mView.setEnabled(false);
            return;
        }
        if (this.mDataModel.getRowCount() <= 0) {
            this.mDelete.setEnabled(false);
            this.mView.setEnabled(false);
            return;
        }
        this.mDelete.setEnabled(true);
        this.mView.setEnabled(true);
    }

    private void update() {
        NameValuePairs response;
        this.mModel.progressStart();
        try {
            response = this.mConnection.search(this.mDestination, "impl", new NameValuePairs());
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        Debug.println((String)response.toString());
        int i = 0;
        String[] vals = new String[response.size()];
        Hashtable<String, NameValuePairs> data = new Hashtable<String, NameValuePairs>();
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            String entry = ((String)e.nextElement()).trim();
            String value = response.getValue(entry);
            Debug.println((String)("entry= " + entry));
            Debug.println((String)("value= " + value));
            int x = value.indexOf(",");
            Debug.println((String)("x = " + x));
            NameValuePairs obj = new NameValuePairs();
            obj.add(IMPL_NAME, entry);
            vals[i++] = entry;
            if (x != -1) {
                obj.add(IMPL_CLASS, value.substring(0, x));
                obj.add(IMPL_DESC, value.substring(x + 1));
            } else {
                obj.add(IMPL_CLASS, value);
            }
            data.put(entry, obj);
        }
        CMSAdminUtil.bubbleSort((String[])vals);
        int y = 0;
        while (y < vals.length) {
            this.mDataModel.processData(data.get(vals[y]));
            ++y;
        }
        data.clear();
        if (this.mDataModel.getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
        this.mModel.progressStop();
    }

    private void delete() {
        this.mModel.progressStart();
        NameValuePairs obj = (NameValuePairs)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        try {
            this.mConnection.delete(this.mDestination, "impl", obj.getValue(IMPL_NAME));
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        this.mModel.progressStop();
        this.refresh();
    }
}

