/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.config;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class PluginSelectionDialog
extends JDialog
implements ActionListener,
MouseListener {
    protected JFrame mParentFrame;
    protected AdminConnection mConnection;
    protected ResourceBundle mResource;
    protected DefaultListModel mDataModel;
    protected String mDestination;
    private JScrollPane mScrollPane;
    protected JList mList;
    protected JButton mOK;
    protected JButton mCancel;
    protected JButton mHelp;
    protected String mPrefix;
    protected String mScope;
    protected String mInstanceScope;
    protected String mImageName;
    protected String mHelpToken;
    static /* synthetic */ Class class$com$netscape$admin$certsrv$CMSAdminResources;

    public PluginSelectionDialog(String prefix, JFrame parent, AdminConnection conn, String dest) {
        super((Frame)parent, true);
        this.mParentFrame = parent;
        this.mConnection = conn;
        this.mDestination = dest;
        this.mResource = ResourceBundle.getBundle((class$com$netscape$admin$certsrv$CMSAdminResources != null ? class$com$netscape$admin$certsrv$CMSAdminResources : (class$com$netscape$admin$certsrv$CMSAdminResources = PluginSelectionDialog.class$("com.netscape.admin.certsrv.CMSAdminResources"))).getName());
        this.mDataModel = new DefaultListModel();
        this.mPrefix = prefix;
        ((Dialog)((Object)this)).setTitle(this.mResource.getString(String.valueOf(this.mPrefix) + "_TITLE"));
        ((Component)((Object)this)).setSize(360, 216);
        this.setLocationRelativeTo((Component)parent);
        this.getRootPane().setDoubleBuffered(true);
    }

    public void showDialog() {
        this.mDataModel.clear();
        if (!this.update()) {
            return;
        }
        this.refresh();
        this.setArrowButtons();
        ((Dialog)((Object)this)).show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.mCancel)) {
            ((Window)((Object)this)).dispose();
        }
        if (evt.getSource().equals(this.mHelp)) {
            CMSAdminUtil.help((String)this.mHelpToken);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setArrowButtons();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.setArrowButtons();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.setArrowButtons();
    }

    protected void setDisplay() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        center.setLayout(gb);
        JPanel content = this.makeContentPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)content, gbc);
        center.add((Component)content);
        JPanel action = this.makeActionPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gb.setConstraints((Component)action, gbc);
        center.add((Component)action);
        this.getContentPane().add("Center", (Component)center);
    }

    private JPanel makeActionPane() {
        this.mOK = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.mPrefix, (String)"OK", null, (ActionListener)this);
        this.mCancel = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.mPrefix, (String)"CANCEL", null, (ActionListener)this);
        this.mHelp = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.mPrefix, (String)"HELP", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mOK, this.mCancel, this.mHelp};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    private JPanel makeContentPane() {
        JPanel mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mListPanel.setLayout(gb);
        this.mList = CMSAdminUtil.makeJList((DefaultListModel)this.mDataModel, (int)9);
        this.mScrollPane = new JScrollPane((Component)this.mList, 22, 31);
        this.mList.setSelectionMode(0);
        this.mList.addMouseListener(this);
        this.mScrollPane.setBackground(Color.white);
        this.mScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        mListPanel.add((Component)this.mScrollPane);
        return mListPanel;
    }

    private void setArrowButtons() {
        if (this.mList.getSelectedIndex() < 0) {
            this.mOK.setEnabled(false);
            return;
        }
        this.mOK.setEnabled(true);
    }

    private void refresh() {
    }

    protected boolean update() {
        NameValuePairs response;
        try {
            response = this.mConnection.search(this.mDestination, this.mScope, new NameValuePairs());
        }
        catch (EAdminException e) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.getMessage(), (int)0);
            return false;
        }
        Debug.println((String)response.toString());
        String[] vals = new String[response.size()];
        int i = 0;
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            vals[i++] = ((String)e.nextElement()).trim();
        }
        CMSAdminUtil.bubbleSort((String[])vals);
        int y = 0;
        while (y < vals.length) {
            this.mDataModel.addElement((Object)new JLabel(vals[y], (Icon)CMSAdminUtil.getImage((String)this.mImageName), 2));
            ++y;
        }
        return true;
    }

    protected NameValuePairs getDefaultConfig() throws EAdminException {
        String id = ((JLabel)this.mDataModel.elementAt(this.mList.getSelectedIndex())).getText();
        NameValuePairs response = this.mConnection.read(this.mDestination, this.mScope, id, new NameValuePairs());
        Debug.println((String)response.toString());
        return response;
    }

    protected void addInstance(NameValuePairs config, String name) throws EAdminException {
        this.mConnection.add(this.mDestination, this.mInstanceScope, name, config);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

