/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.config;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSBaseResourceModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.config.CMSBaseConfigPanel;
import com.netscape.admin.certsrv.config.CMSBaseTab;
import com.netscape.admin.certsrv.config.CMSTabPanel;
import com.netscape.admin.certsrv.config.ConnectorEditor;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class CMSCAConnectorPanel
extends CMSBaseTab
implements MouseListener {
    private static final String PANEL_NAME = "CACONNECTOR";
    private static final String HELPINDEX = "configuration-ca-connector-help";
    private AdminConnection mAdmin;
    private CMSBaseResourceModel mModel;
    private CMSTabPanel mParent;
    private JList mList;
    private DefaultListModel mDataModel;
    private JScrollPane mScrollPane;
    private JButton mEdit;
    protected boolean mInit = false;

    public CMSCAConnectorPanel(CMSBaseResourceModel model, CMSTabPanel parent) {
        super(PANEL_NAME, parent);
        this.mModel = model;
        this.mParent = parent;
        this.mDataModel = new DefaultListModel();
        ((CMSBaseConfigPanel)this).mHelpToken = HELPINDEX;
        this.mDataModel.addElement((Object)"Data Recovery Manager Connector");
    }

    public void init() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).removeAll();
        JPanel mainPanel = new JPanel();
        Debug.println((String)"ConnectorPanel: init()");
        this.mAdmin = this.mModel.getServerInfo().getAdmin();
        GridBagLayout gb1 = new GridBagLayout();
        mainPanel.setLayout(gb1);
        GridBagConstraints gbc = new GridBagConstraints();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        JLabel listLabel = this.makeJLabel("CONNLIST");
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(9, 9, 0, 9);
        gb1.setConstraints((Component)listLabel, gbc);
        mainPanel.add((Component)listLabel);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        this.mList = this.makeJList(this.mDataModel, 3);
        this.mScrollPane = new JScrollPane((Component)this.mList, 22, 31);
        this.mList.addMouseListener(this);
        this.mScrollPane.setBackground(Color.white);
        this.mScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        gbc.anchor = 18;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(6, 9, 0, 9);
        gb1.setConstraints((Component)this.mScrollPane, gbc);
        mainPanel.add((Component)this.mScrollPane);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        this.mEdit = this.makeJButton("EDIT");
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 0.5;
        gbc.insets = new Insets(6, 0, 0, 9);
        gb1.setConstraints((Component)this.mEdit, gbc);
        mainPanel.add((Component)this.mEdit);
        ((Container)((Object)this)).add("Center", (Component)mainPanel);
        this.refresh();
    }

    public void refresh() {
    }

    public void actionPerformed(ActionEvent e) {
        block3: {
            if (!e.getSource().equals(this.mEdit)) break block3;
            JFrame frame = this.mModel.getFrame();
            String name = (String)this.mList.getSelectedValue();
            NameValuePairs nvps = new NameValuePairs();
            nvps.add("id", "");
            nvps.add("host", "");
            nvps.add("port", "");
            nvps.add("uri", "");
            nvps.add("local", "");
            nvps.add("enable", "");
            try {
                String val;
                NameValuePairs values = this.mAdmin.read("ca", "connector", name, nvps);
                NameValuePairs subsystems = this.mAdmin.search("server", "subsystem", new NameValuePairs());
                boolean colocated = false;
                if (name.equals("Data Recovery Manager Connector") && (val = values.getValue("id")) != null && val.equals("kra")) {
                    colocated = true;
                }
                ConnectorEditor editor = new ConnectorEditor(this.mAdmin, this.mModel.getFrame(), name, "ca", this.mModel.getServerInfo().getServerId(), colocated);
                editor.showDialog(values);
            }
            catch (EAdminException ex) {
                this.showErrorDialog(ex.toString());
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.mList) {
            if (this.mList.getSelectedIndex() < 0) {
                this.mEdit.setEnabled(false);
            } else {
                this.mEdit.setEnabled(true);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean applyCallback() {
        return true;
    }

    public boolean resetCallback() {
        this.refresh();
        return true;
    }

    private void populate(NameValuePairs nvps) {
    }
}

