/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;

public class ListCACerts {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println("Usage: java org.mozilla.jss.tests.ListCACerts <dbdir>");
            System.exit(1);
        }
        try {
            CryptoManager.initialize(stringArray[0]);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            X509Certificate[] x509CertificateArray = cryptoManager.getCACerts();
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                System.out.println(((Object)x509CertificateArray[i].getSubjectDN()).toString());
                InternalCertificate internalCertificate = (InternalCertificate)x509CertificateArray[i];
                System.out.println("SSL: " + internalCertificate.getSSLTrust() + ", Email: " + internalCertificate.getEmailTrust() + ", Object Signing: " + internalCertificate.getObjectSigningTrust());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

