/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLInputStream;
import org.mozilla.jss.ssl.SSLOutputStream;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SocketBase;
import org.mozilla.jss.ssl.SocketProxy;

public class SSLSocket
extends Socket {
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private boolean isClosed = false;
    private boolean inRead = false;
    private boolean inWrite = false;
    private InetAddress inetAddress;
    private int port;
    private SocketProxy sockProxy = null;
    private boolean open = false;
    private boolean handshakeAsClient = true;
    private SocketBase base = new SocketBase();
    public static final int SSL_REQUIRE_NEVER = 18;
    public static final int SSL_REQUIRE_ALWAYS = 19;
    public static final int SSL_REQUIRE_FIRST_HANDSHAKE = 20;
    public static final int SSL_REQUIRE_NO_ERROR = 21;
    private Vector handshakeCompletedListeners = new Vector();
    public static final int SSL2_RC4_128_WITH_MD5 = 65281;
    public static final int SSL2_RC4_128_EXPORT40_WITH_MD5 = 65282;
    public static final int SSL2_RC2_128_CBC_WITH_MD5 = 65283;
    public static final int SSL2_RC2_128_CBC_EXPORT40_WITH_MD5 = 65284;
    public static final int SSL2_IDEA_128_CBC_WITH_MD5 = 65285;
    public static final int SSL2_DES_64_CBC_WITH_MD5 = 65286;
    public static final int SSL2_DES_192_EDE3_CBC_WITH_MD5 = 65287;
    public static final int SSL3_RSA_WITH_NULL_MD5 = 1;
    public static final int SSL3_RSA_WITH_NULL_SHA = 2;
    public static final int SSL3_RSA_EXPORT_WITH_RC4_40_MD5 = 3;
    public static final int SSL3_RSA_WITH_RC4_128_MD5 = 4;
    public static final int SSL3_RSA_WITH_RC4_128_SHA = 5;
    public static final int SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6;
    public static final int SSL3_RSA_WITH_IDEA_CBC_SHA = 7;
    public static final int SSL3_RSA_EXPORT_WITH_DES40_CBC_SHA = 8;
    public static final int SSL3_RSA_WITH_DES_CBC_SHA = 9;
    public static final int SSL3_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    public static final int SSL3_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 11;
    public static final int SSL3_DH_DSS_WITH_DES_CBC_SHA = 12;
    public static final int SSL3_DH_DSS_WITH_3DES_EDE_CBC_SHA = 13;
    public static final int SSL3_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 14;
    public static final int SSL3_DH_RSA_WITH_DES_CBC_SHA = 15;
    public static final int SSL3_DH_RSA_WITH_3DES_EDE_CBC_SHA = 16;
    public static final int SSL3_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17;
    public static final int SSL3_DHE_DSS_WITH_DES_CBC_SHA = 18;
    public static final int SSL3_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    public static final int SSL3_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 20;
    public static final int SSL3_DHE_RSA_WITH_DES_CBC_SHA = 21;
    public static final int SSL3_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    public static final int SSL3_DH_ANON_EXPORT_WITH_RC4_40_MD5 = 23;
    public static final int SSL3_DH_ANON_WITH_RC4_128_MD5 = 24;
    public static final int SSL3_DH_ANON_EXPORT_WITH_DES40_CBC_SHA = 25;
    public static final int SSL3_DH_ANON_WITH_DES_CBC_SHA = 26;
    public static final int SSL3_DH_ANON_WITH_3DES_EDE_CBC_SHA = 27;
    public static final int SSL3_FORTEZZA_DMS_WITH_NULL_SHA = 28;
    public static final int SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA = 29;
    public static final int SSL3_FORTEZZA_DMS_WITH_RC4_128_SHA = 30;
    public static final int SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA = 65279;
    public static final int SSL_RSA_FIPS_WITH_DES_CBC_SHA = 65278;
    public static final int TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA = 98;
    public static final int TLS_RSA_EXPORT1024_WITH_RC4_56_SHA = 100;
    public static final int TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 99;
    public static final int TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 101;
    public static final int TLS_DHE_DSS_WITH_RC4_128_SHA = 102;
    public static final int TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    public static final int TLS_DH_DSS_WITH_AES_128_CBC_SHA = 48;
    public static final int TLS_DH_RSA_WITH_AES_128_CBC_SHA = 49;
    public static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    public static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    public static final int TLS_DH_ANON_WITH_AES_128_CBC_SHA = 52;
    public static final int TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    public static final int TLS_DH_DSS_WITH_AES_256_CBC_SHA = 54;
    public static final int TLS_DH_RSA_WITH_AES_256_CBC_SHA = 55;
    public static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    public static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;
    public static final int TLS_DH_ANON_WITH_AES_256_CBC_SHA = 58;
    public static final int TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = 65;
    public static final int TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 66;
    public static final int TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 67;
    public static final int TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 68;
    public static final int TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 69;
    public static final int TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA = 70;
    public static final int TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = 132;
    public static final int TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 133;
    public static final int TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 134;
    public static final int TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 135;
    public static final int TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 136;
    public static final int TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA = 137;
    public static final int TLS_ECDH_ECDSA_WITH_NULL_SHA = 49153;
    public static final int TLS_ECDH_ECDSA_WITH_RC4_128_SHA = 49154;
    public static final int TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = 49155;
    public static final int TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 49156;
    public static final int TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 49157;
    public static final int TLS_ECDHE_ECDSA_WITH_NULL_SHA = 49158;
    public static final int TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = 49159;
    public static final int TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = 49160;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 49161;
    public static final int TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 49162;
    public static final int TLS_ECDH_RSA_WITH_NULL_SHA = 49163;
    public static final int TLS_ECDH_RSA_WITH_RC4_128_SHA = 49164;
    public static final int TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = 49165;
    public static final int TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = 49166;
    public static final int TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = 49167;
    public static final int TLS_ECDHE_RSA_WITH_NULL_SHA = 49168;
    public static final int TLS_ECDHE_RSA_WITH_RC4_128_SHA = 49169;
    public static final int TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = 49170;
    public static final int TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 49171;
    public static final int TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 49172;
    public static final int TLS_ECDH_anon_WITH_NULL_SHA = 49173;
    public static final int TLS_ECDH_anon_WITH_RC4_128_SHA = 49174;
    public static final int TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA = 49175;
    public static final int TLS_ECDH_anon_WITH_AES_128_CBC_SHA = 49176;
    public static final int TLS_ECDH_anon_WITH_AES_256_CBC_SHA = 49177;

    SSLSocket() throws IOException {
    }

    void setSockProxy(SocketProxy socketProxy) {
        this.sockProxy = socketProxy;
        this.base.setProxy(socketProxy);
    }

    public SSLSocket(String string, int n) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n, null, 0);
    }

    public SSLSocket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, null, 0);
    }

    public SSLSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(InetAddress.getByName(string), n, inetAddress, n2);
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(inetAddress, n, inetAddress2, n2, null, null);
    }

    public SSLSocket(String string, int n, InetAddress inetAddress, int n2, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this(InetAddress.getByName(string), n, inetAddress, n2, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback);
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, boolean bl, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this(inetAddress, n, inetAddress2, n2, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback);
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this(inetAddress, inetAddress.getHostName(), n, inetAddress2, n2, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback);
    }

    private SSLSocket(InetAddress inetAddress, String string, int n, InetAddress inetAddress2, int n2, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this.sockProxy = new SocketProxy(this.base.socketCreate(this, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback));
        this.base.setProxy(this.sockProxy);
        if (inetAddress2 != null || n2 > 0) {
            byte[] byArray = null;
            if (inetAddress2 != null) {
                byArray = inetAddress2.getAddress();
            }
            this.base.socketBind(byArray, n2);
        }
        this.socketConnect(inetAddress.getAddress(), string, n);
    }

    public SSLSocket(Socket socket, String string, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws IOException {
        this.sockProxy = new SocketProxy(this.base.socketCreate(this, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback, socket, string));
        this.base.setProxy(this.sockProxy);
        this.resetHandshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getInetAddress() {
        SSLSocket sSLSocket = this;
        synchronized (sSLSocket) {
            if (this.isClosed) {
                return null;
            }
            return this.base.getInetAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getLocalAddress() {
        SSLSocket sSLSocket = this;
        synchronized (sSLSocket) {
            if (this.isClosed) {
                return null;
            }
            return this.base.getLocalAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalPort() {
        SSLSocket sSLSocket = this;
        synchronized (sSLSocket) {
            if (this.isClosed) {
                return -1;
            }
            return this.base.getLocalPort();
        }
    }

    public native int getPort();

    public InputStream getInputStream() throws IOException {
        return new SSLInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new SSLOutputStream(this);
    }

    public native void setTcpNoDelay(boolean var1) throws SocketException;

    public native boolean getTcpNoDelay() throws SocketException;

    public native void setKeepAlive(boolean var1) throws SocketException;

    public native boolean getKeepAlive() throws SocketException;

    public void shutdownInput() throws IOException {
        this.shutdownNative(5);
    }

    public void shutdownOutput() throws IOException {
        this.shutdownNative(6);
    }

    private native void shutdownNative(int var1) throws IOException;

    private native void abortReadWrite() throws IOException;

    public native void setSoLinger(boolean var1, int var2) throws SocketException;

    public native int getSoLinger() throws SocketException;

    public void setSoTimeout(int n) throws SocketException {
        this.base.setTimeout(n);
    }

    public int getSoTimeout() throws SocketException {
        return this.base.getTimeout();
    }

    public native void setSendBufferSize(int var1) throws SocketException;

    public native int getSendBufferSize() throws SocketException;

    public native void setReceiveBufferSize(int var1) throws SocketException;

    public native int getReceiveBufferSize() throws SocketException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.sockProxy == null) {
                return;
            }
            if (this.inRead || this.inWrite) {
                this.abortReadWrite();
            }
        }
        object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.base.close();
                this.sockProxy = null;
                this.base.setProxy(null);
            }
        }
    }

    private native void socketConnect(byte[] var1, String var2, int var3) throws SocketException;

    public void addHandshakeCompletedListener(SSLHandshakeCompletedListener sSLHandshakeCompletedListener) {
        this.handshakeCompletedListeners.addElement(sSLHandshakeCompletedListener);
    }

    public void removeHandshakeCompletedListener(SSLHandshakeCompletedListener sSLHandshakeCompletedListener) {
        this.handshakeCompletedListeners.removeElement(sSLHandshakeCompletedListener);
    }

    private void notifyAllHandshakeListeners() {
        SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent = new SSLHandshakeCompletedEvent(this);
        for (int i = 0; i < this.handshakeCompletedListeners.size(); ++i) {
            SSLHandshakeCompletedListener sSLHandshakeCompletedListener = (SSLHandshakeCompletedListener)this.handshakeCompletedListeners.elementAt(i);
            sSLHandshakeCompletedListener.handshakeCompleted(sSLHandshakeCompletedEvent);
        }
    }

    public void enableSSL2(boolean bl) throws SocketException {
        this.base.enableSSL2(bl);
    }

    public static void enableSSL2Default(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(0, bl);
    }

    public void enableSSL3(boolean bl) throws SocketException {
        this.base.enableSSL3(bl);
    }

    public static void enableSSL3Default(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(1, bl);
    }

    public void enableTLS(boolean bl) throws SocketException {
        this.base.enableTLS(bl);
    }

    public static void enableTLSDefault(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(2, bl);
    }

    public void bypassPKCS11(boolean bl) throws SocketException {
        this.base.bypassPKCS11(bl);
    }

    public static void bypassPKCS11Default(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(13, bl);
    }

    public void enableRollbackDetection(boolean bl) throws SocketException {
        this.base.enableRollbackDetection(bl);
    }

    static void enableRollbackDetectionDefault(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(14, bl);
    }

    public void enableStepDown(boolean bl) throws SocketException {
        this.base.enableStepDown(bl);
    }

    static void enableStepDownDefault(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(15, bl);
    }

    public void enableFDX(boolean bl) throws SocketException {
        this.base.enableFDX(bl);
    }

    static void enableFDXDefault(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(16, bl);
    }

    public void enableV2CompatibleHello(boolean bl) throws SocketException {
        this.base.enableV2CompatibleHello(bl);
    }

    static void enableV2CompatibleHelloDefault(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(17, bl);
    }

    public String getSSLOptions() {
        return this.base.getSSLOptions();
    }

    private static native int getSSLDefaultOption(int var0) throws SocketException;

    public static String getSSLDefaultOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("Default Options configured for all SSLSockets: ");
            stringBuffer.append("\nSSL_ENABLE_SSL2" + (SSLSocket.getSSLDefaultOption(0) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_ENABLE_SSL3" + (SSLSocket.getSSLDefaultOption(1) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_ENABLE_TLS" + (SSLSocket.getSSLDefaultOption(2) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_REQUIRE_CERTIFICATE");
            switch (SSLSocket.getSSLDefaultOption(7)) {
                case 0: {
                    stringBuffer.append("=Never");
                    break;
                }
                case 1: {
                    stringBuffer.append("=Always");
                    break;
                }
                case 2: {
                    stringBuffer.append("=First Handshake");
                    break;
                }
                case 3: {
                    stringBuffer.append("=No Error");
                    break;
                }
                default: {
                    stringBuffer.append("=Report JSS Bug this option has a status.");
                }
            }
            stringBuffer.append("\nSSL_REQUEST_CERTIFICATE" + (SSLSocket.getSSLDefaultOption(8) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_NO_CACHE" + (SSLSocket.getSSLDefaultOption(9) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_BYPASS_PKCS11" + (SSLSocket.getSSLDefaultOption(13) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_ROLLBACK_DETECTION" + (SSLSocket.getSSLDefaultOption(14) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_NO_STEP_DOWN" + (SSLSocket.getSSLDefaultOption(15) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_ENABLE_FDX" + (SSLSocket.getSSLDefaultOption(16) != 0 ? "=on" : "=off"));
            stringBuffer.append("\nSSL_V2_COMPATIBLE_HELLO" + (SSLSocket.getSSLDefaultOption(17) != 0 ? "=on" : "=off"));
        }
        catch (SocketException socketException) {
            stringBuffer.append("\ngetSSLDefaultOptions exception " + socketException.getMessage());
        }
        return stringBuffer.toString();
    }

    public void requireClientAuth(boolean bl, boolean bl2) throws SocketException {
        this.base.requireClientAuth(bl, bl2);
    }

    public void requireClientAuth(int n) throws SocketException {
        if (n < 18 || n > 21) {
            throw new SocketException("Incorrect input value.");
        }
        this.base.requireClientAuth(n);
    }

    public void requireClientAuthDefault(boolean bl, boolean bl2) throws SocketException {
        SSLSocket.setSSLDefaultOption(7, bl ? (bl2 ? 1 : 2) : 0);
    }

    public static void requireClientAuthDefault(int n) throws SocketException {
        if (n < 18 || n > 21) {
            throw new SocketException("Incorrect input value.");
        }
        SSLSocket.setSSLDefaultOption(8, true);
        SSLSocket.setSSLDefaultOptionMode(7, n);
    }

    public native void forceHandshake() throws SocketException;

    public void setUseClientMode(boolean bl) {
        this.handshakeAsClient = bl;
    }

    public boolean getUseClientMode() {
        return this.handshakeAsClient;
    }

    public void resetHandshake() throws SocketException {
        this.resetHandshakeNative(this.handshakeAsClient);
    }

    private native void resetHandshakeNative(boolean var1) throws SocketException;

    public native SSLSecurityStatus getStatus() throws SocketException;

    public void setClientCertNickname(String string) throws SocketException {
        this.base.setClientCertNickname(string);
    }

    public void setClientCert(X509Certificate x509Certificate) throws SocketException {
        this.base.setClientCert(x509Certificate);
    }

    public void requestClientAuth(boolean bl) throws SocketException {
        this.base.requestClientAuth(bl);
    }

    public void setNeedClientAuth(boolean bl) throws SocketException {
        this.base.requestClientAuth(bl);
    }

    public void setNeedClientAuthNoExpiryCheck(boolean bl) throws SocketException {
        this.base.requestClientAuthNoExpiryCheck(bl);
    }

    public void useCache(boolean bl) throws SocketException {
        this.base.useCache(bl);
    }

    public void useCacheDefault(boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(9, !bl);
    }

    private static void setSSLDefaultOption(int n, boolean bl) throws SocketException {
        SSLSocket.setSSLDefaultOption(n, bl ? 1 : 0);
    }

    private static native void setSSLDefaultOption(int var0, int var1) throws SocketException;

    private static native void setSSLDefaultOptionMode(int var0, int var1) throws SocketException;

    public native void setCipherPreference(int var1, boolean var2) throws SocketException;

    public native boolean getCipherPreference(int var1) throws SocketException;

    public static native void setCipherPreferenceDefault(int var0, boolean var1) throws SocketException;

    public static native boolean getCipherPreferenceDefault(int var0) throws SocketException;

    native int socketAvailable() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] byArray, int n, int n2) throws IOException, SocketTimeoutException {
        Object object = this.readLock;
        synchronized (object) {
            int n3;
            SSLSocket sSLSocket = this;
            synchronized (sSLSocket) {
                if (this.isClosed) {
                    throw new IOException("Socket has been closed, and cannot be reused.");
                }
                this.inRead = true;
            }
            try {
                n3 = this.socketRead(byArray, n, n2, this.base.getTimeout());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new SocketTimeoutException("SocketTimeoutException cannot read on socket");
            }
            catch (IOException iOException) {
                throw new IOException("SocketException cannot read on socket");
            }
            finally {
                SSLSocket sSLSocket2 = this;
                synchronized (sSLSocket2) {
                    this.inRead = false;
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] byArray, int n, int n2) throws IOException, SocketTimeoutException {
        Object object = this.writeLock;
        synchronized (object) {
            SSLSocket sSLSocket = this;
            synchronized (sSLSocket) {
                if (this.isClosed) {
                    throw new IOException("Socket has been closed, and cannot be reused.");
                }
                this.inWrite = true;
            }
            try {
                this.socketWrite(byArray, n, n2, this.base.getTimeout());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw new SocketTimeoutException("SocketTimeoutException cannot write on socket");
            }
            catch (IOException iOException) {
                throw new IOException("SocketException cannot write on socket");
            }
            finally {
                SSLSocket sSLSocket2 = this;
                synchronized (sSLSocket2) {
                    this.inWrite = false;
                }
            }
        }
    }

    private native int socketRead(byte[] var1, int var2, int var3, int var4) throws IOException;

    private native void socketWrite(byte[] var1, int var2, int var3, int var4) throws IOException;

    public native void invalidateSession() throws SocketException;

    public void redoHandshake() throws SocketException {
        this.redoHandshake(false);
    }

    public native void redoHandshake(boolean var1) throws SocketException;

    protected void finalize() throws Throwable {
        this.close();
    }

    public static void setCipherPolicy(CipherPolicy cipherPolicy) throws SocketException {
        SSLSocket.setCipherPolicyNative(cipherPolicy.getEnum());
    }

    private static native void setCipherPolicyNative(int var0) throws SocketException;

    public String toString() {
        try {
            InetAddress inetAddress = this.getInetAddress();
            InetAddress inetAddress2 = this.getLocalAddress();
            int n = this.getPort();
            int n2 = this.getLocalPort();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SSLSocket[addr=");
            stringBuffer.append(inetAddress);
            stringBuffer.append(",localaddr=");
            stringBuffer.append(inetAddress2);
            stringBuffer.append(",port=");
            stringBuffer.append(n);
            stringBuffer.append(",localport=");
            stringBuffer.append(n2);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Exception caught in toString(): " + exception.getMessage();
        }
    }

    public static boolean isFipsCipherSuite(int n) throws SocketException {
        return SSLSocket.isFipsCipherSuiteNative(n);
    }

    private static native boolean isFipsCipherSuiteNative(int var0) throws SocketException;

    public static native int[] getImplementedCipherSuites();

    public static class CipherPolicy {
        private int _enum;
        public static final CipherPolicy DOMESTIC = new CipherPolicy(10);
        public static final CipherPolicy EXPORT = new CipherPolicy(11);
        public static final CipherPolicy FRANCE = new CipherPolicy(12);

        private CipherPolicy(int n) {
        }

        int getEnum() {
            return this._enum;
        }
    }
}

