/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PBEParameter;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

public class EncryptedContentInfo
implements ASN1Value {
    private OBJECT_IDENTIFIER contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private OCTET_STRING encryptedContent;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public OCTET_STRING getEncryptedContent() {
        return this.encryptedContent;
    }

    public boolean hasEncryptedContent() {
        return this.encryptedContent != null;
    }

    private EncryptedContentInfo() {
    }

    public EncryptedContentInfo(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, AlgorithmIdentifier algorithmIdentifier, OCTET_STRING oCTET_STRING) {
        this(oBJECT_IDENTIFIER, algorithmIdentifier, oCTET_STRING, false);
    }

    public EncryptedContentInfo(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, AlgorithmIdentifier algorithmIdentifier, OCTET_STRING oCTET_STRING, boolean bl) {
        this.contentType = oBJECT_IDENTIFIER;
        this.contentEncryptionAlgorithm = algorithmIdentifier;
        this.encryptedContent = oCTET_STRING;
        this.sequence.addElement(oBJECT_IDENTIFIER);
        this.sequence.addElement(algorithmIdentifier);
        if (oCTET_STRING != null) {
            if (bl) {
                this.sequence.addElement(new EXPLICIT(new Tag(0L), oCTET_STRING));
            } else {
                this.sequence.addElement(new Tag(0L), oCTET_STRING);
            }
        }
    }

    public static EncryptedContentInfo createCRSCompatibleEncryptedContentInfo(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, AlgorithmIdentifier algorithmIdentifier, OCTET_STRING oCTET_STRING) {
        return new EncryptedContentInfo(oBJECT_IDENTIFIER, algorithmIdentifier, oCTET_STRING, true);
    }

    public static EncryptedContentInfo createPBE(PBEAlgorithm pBEAlgorithm, Password password, byte[] byArray, int n, KeyGenerator.CharToByteConverter charToByteConverter, byte[] byArray2) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, CharConversionException {
        try {
            if (!(pBEAlgorithm instanceof PBEAlgorithm)) {
                throw new NoSuchAlgorithmException("Key generation algorithm is not a PBE algorithm");
            }
            PBEAlgorithm pBEAlgorithm2 = pBEAlgorithm;
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
            KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(pBEAlgorithm);
            PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(password, byArray, n);
            if (charToByteConverter != null) {
                keyGenerator.setCharToByteConverter(charToByteConverter);
            }
            keyGenerator.initialize(pBEKeyGenParams);
            SymmetricKey symmetricKey = keyGenerator.generate();
            EncryptionAlgorithm encryptionAlgorithm = pBEAlgorithm2.getEncryptionAlg();
            IVParameterSpec iVParameterSpec = null;
            if (encryptionAlgorithm.getParameterClass().equals(IVParameterSpec.class)) {
                iVParameterSpec = new IVParameterSpec(keyGenerator.generatePBE_IV());
            }
            Cipher cipher = cryptoToken.getCipherContext(encryptionAlgorithm);
            cipher.initEncrypt(symmetricKey, iVParameterSpec);
            byte[] byArray3 = cipher.doFinal(Cipher.pad(byArray2, encryptionAlgorithm.getBlockSize()));
            PBEParameter pBEParameter = new PBEParameter(byArray, n);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(pBEAlgorithm.toOID(), pBEParameter);
            EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(ContentInfo.DATA, algorithmIdentifier, new OCTET_STRING(byArray3));
            return encryptedContentInfo;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            Assert.notReached("IllegalBlockSizeException in EncryptedContentInfo.createPBE");
        }
        catch (BadPaddingException badPaddingException) {
            Assert.notReached("BadPaddingException in EncryptedContentInfo.createPBE");
        }
        return null;
    }

    public byte[] decrypt(Password password, KeyGenerator.CharToByteConverter charToByteConverter) throws IllegalStateException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidBERException, IOException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, IllegalBlockSizeException, BadPaddingException {
        Object object;
        PBEParameter pBEParameter;
        if (this.encryptedContent == null) {
            return null;
        }
        AlgorithmIdentifier algorithmIdentifier = this.contentEncryptionAlgorithm;
        KeyGenAlgorithm keyGenAlgorithm = KeyGenAlgorithm.fromOID(algorithmIdentifier.getOID());
        if (!(keyGenAlgorithm instanceof PBEAlgorithm)) {
            throw new NoSuchAlgorithmException("KeyGenAlgorithm is not a PBE algorithm");
        }
        ASN1Value aSN1Value = algorithmIdentifier.getParameters();
        if (aSN1Value == null) {
            throw new InvalidAlgorithmParameterException("PBE algorithms require parameters");
        }
        if (aSN1Value instanceof PBEParameter) {
            pBEParameter = (PBEParameter)aSN1Value;
        } else {
            object = ASN1Util.encode(aSN1Value);
            pBEParameter = (PBEParameter)ASN1Util.decode(PBEParameter.getTemplate(), object);
        }
        object = new PBEKeyGenParams(password, pBEParameter.getSalt(), pBEParameter.getIterations());
        CryptoToken cryptoToken = CryptoManager.getInstance().getInternalCryptoToken();
        KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(keyGenAlgorithm);
        if (charToByteConverter != null) {
            keyGenerator.setCharToByteConverter(charToByteConverter);
        }
        keyGenerator.initialize((AlgorithmParameterSpec)object);
        SymmetricKey symmetricKey = keyGenerator.generate();
        EncryptionAlgorithm encryptionAlgorithm = ((PBEAlgorithm)keyGenAlgorithm).getEncryptionAlg();
        IVParameterSpec iVParameterSpec = encryptionAlgorithm.getParameterClass().equals(IVParameterSpec.class) ? new IVParameterSpec(keyGenerator.generatePBE_IV()) : null;
        Cipher cipher = cryptoToken.getCipherContext(encryptionAlgorithm);
        cipher.initDecrypt(symmetricKey, iVParameterSpec);
        return Cipher.unPad(cipher.doFinal(this.encryptedContent.toByteArray()));
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE.Template template = new SEQUENCE.Template();
            template.addElement(new OBJECT_IDENTIFIER.Template());
            template.addElement(new AlgorithmIdentifier.Template());
            template.addOptionalElement(new Tag(0L), new OCTET_STRING.Template());
            SEQUENCE sEQUENCE = (SEQUENCE)template.decode(tag, inputStream);
            Assert._assert(sEQUENCE.size() == 3);
            return new EncryptedContentInfo((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), (AlgorithmIdentifier)sEQUENCE.elementAt(1), (OCTET_STRING)sEQUENCE.elementAt(2));
        }
    }
}

